# -*- coding: utf-8 -*-

from gi.repository import Dee
from unittest import TestCase, main
from src import unity_sshsearch_daemon as scope

d = scope.Daemon()
searches = ['192']
mock_data = {'should_pass': 'tests/data/mock_sshsearch_pass',
             'should_fail': 'tests/data/mock_sshsearch_fail'}

class TestSshsearch(TestCase):

    def test_search(self):
        scope.KNOWN_HOSTS_EXPAND = mock_data['should_pass']
        model = Dee.SequenceModel.new()
        model.set_schema('s', 's', 'u', 'u', 's', 's', 's', 's')
        model.set_column_names('uri', 'icon_hint', 'category', 'result_type',
                               'mimetype', 'title', 'comment', 'dnd_uri')
        scope.Daemon.update_results_model(d, searches[0], model)
        self.assertEqual(model[0][0],
                         'ssh://config//192.168.1.2')
        self.assertEqual(model[0][1],
                         'gnome-terminal')
        self.assertEqual(model[0][5],
                         '192.168.1.2')
        self.assertEqual(model[0][6],
                         '192.168.1.2')

    def test_failing_search(self):
        scope.KNOWN_HOSTS_EXPAND = mock_data['should_fail']
        model = Dee.SequenceModel.new()
        model.set_schema('s', 's', 'u', 'u', 's', 's', 's', 's')
        model.set_column_names('uri', 'icon_hint', 'category', 'result_type',
                               'mimetype', 'title', 'comment', 'dnd_uri')
        scope.Daemon.update_results_model(d, searches[0], model)
        self.assertEqual(len(model), 0)

    def test_preview(self):
        scope.KNOWN_HOSTS_EXPAND = mock_data['should_pass']
        preview = d.on_preview_uri(None, "ssh://config//192.168.1.2")
        self.assertEqual(preview.props.title, "192.168.1.2")
        self.assertNotEqual(preview.props.image, None)
        self.assertEqual(preview.props.image.get_names(), ['gnome-terminal'])


if __name__ == '__main__':
    main()
