/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_MANAGEDSYSTEMELEMENT_H
#define __CIM_MANAGEDSYSTEMELEMENT_H
#include "CIM_ManagedElement.h"
namespace CimClassNamespace
{

	// Class CIM_ManagedSystemElement:
	// CIM_ManagedSystemElement is the base class for the System Element hierarchy. Any distinguishable component of a System is a candidate for inclusion in this class. Examples of system components include:
	// - software components such as application servers, databases, and applications
	// - operating system components such as files, processes, and threads
	// - device components such as disk drives, controllers, processors, and printers
	// - physical components such as chips and cards.
	class CIM_ManagedSystemElement  : public CIM_ManagedElement
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_ManagedSystemElement> CIM_ManagedSystemElementContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// A datetime value indicating when the object was installed. A lack of a value does not indicate that the object is not installed.
		DateTime InstallDate;

		// This field determines whether the InstallDate field is valid.
		bool InstallDateSpecified;

		// The Name property defines the label by which the object is known. When subclassed, the Name property can be overridden to be a Key property.
		string Name;

		// This field determines whether the Name field is valid.
		bool NameSpecified;

		// Indicates the current status(es) of the element. Various operational statuses are defined. Many of the enumeration's values are self- explanatory. However, a few are not and are described in more detail.
		// "Stressed" indicates that the element is functioning, but needs attention. Examples of "Stressed" states are overload, overheated, etc.
		// "Predictive Failure" indicates that an element is functioning nominally but predicting a failure in the near future.
		// "In Service" describes an element being configured, maintained, cleaned, or otherwise administered.
		// "No Contact" indicates that the monitoring system has knowledge of this element, but has never been able to establish communications with it.
		// "Lost Communication" indicates that the ManagedSystem Element is known to exist and has been contacted successfully in the past, but is currently unreachable.
		// "Stopped" and "Aborted" are similar, although the former implies a clean and orderly stop, while the latter implies an abrupt stop where the element's state and configuration may need to be updated.
		// "Dormant" indicates that the element is inactive or quiesced.
		// "Supporting Entity in Error" describes that this element may be "OK" but that another element, on which it is dependent, is in error. An example is a network service or endpoint that cannot function due to lower layer networking problems.
		// "Completed" indicates the element has completed its operation. This value should be combined with either OK, Error, or Degraded so that a client can till if the complete operation passed (Completed with OK), and failure (Completed with Error). Completed with Degraded would imply the operation finished, but did not complete OK or report an error.
		// "Power Mode" indicates the element has additional power model information contained in the Associated PowerManagementService association.
		// OperationalStatus replaces the Status property on ManagedSystemElement to provide a consistent approach to enumerations, to address implementation needs for an array property, and to provide a migration path from today's environment to the future. This change was not made earlier since it required the DEPRECATED qualifier. Due to the widespread use of the existing Status property in management applications, it is strongly RECOMMENDED that providers/instrumentation provide BOTH the Status and OperationalStatus properties. Further, the first value of OperationalStatus SHOULD contain the primary status for the element. When instrumented, Status (since it is single-valued) SHOULD also provide the primary status of the element.
		// Legal values:
		// Unknown: 0
		// Other: 1
		// OK: 2
		// Degraded: 3
		// Stressed: 4
		// Predictive Failure: 5
		// Error: 6
		// Non-Recoverable Error: 7
		// Starting: 8
		// Stopping: 9
		// Stopped: 10
		// In Service: 11
		// No Contact: 12
		// Lost Communication: 13
		// Aborted: 14
		// Dormant: 15
		// Supporting Entity in Error: 16
		// Completed: 17
		// Power Mode: 18
		// DMTF Reserved: ..
		// Vendor Reserved: 0x8000..
		vector<unsigned short> OperationalStatus;

		// Strings describing the various OperationalStatus array values. For example, if "Stopping" is the value assigned to OperationalStatus, then this property may contain an explanation as to why an object is being stopped. Note that entries in this array are correlated with those at the same array index in OperationalStatus.
		vector<string> StatusDescriptions;

		// A string indicating the current status of the object. Various operational and non-operational statuses are defined. This property is deprecated in lieu of OperationalStatus, which includes the same semantics in its enumeration. This change is made for 3 reasons: 1) Status is more correctly defined as an array. This overcomes the limitation of describing status via a single value, when it is really a multi-valued property (for example, an element may be OK AND Stopped. 2) A MaxLen of 10 is too restrictive and leads to unclear enumerated values. And, 3) The change to a uint16 data type was discussed when CIM V2.0 was defined. However, existing V1.0 implementations used the string property and did not want to modify their code. Therefore, Status was grandfathered into the Schema. Use of the Deprecated qualifier allows the maintenance of the existing property, but also permits an improved definition using OperationalStatus.
		string Status;

		// This field determines whether the Status field is valid.
		bool StatusSpecified;

		// Indicates the current health of the element. This attribute expresses the health of this element but not necessarily that of its subcomponents. The possible values are 0 to 30, where 5 means the element is entirely healthy and 30 means the element is completely non-functional. The following continuum is defined:
		// "Non-recoverable Error" (30) - The element has completed failed and recovery is not possible. All functionality provided by this element has been lost.
		// "Critical Failure" (25) - The element is non-functional and recovery MAY NOT be possible.
		// "Major Failure" (20) - The element is failing. It is possible the some or all of the functionality of this component is degraded or not working.
		// "Minor Failure" (15) - All functionality is available but some MAY be degraded.
		// "Degraded/Warning" (10) - The element is in working order and all functionality is provided. However, the element is not working to the best of its abilities. For example, the element may not be operating at optimal performance or it may be reporting recoverable errors.
		// "OK" (5) - The element is fully functional and is operating within normal operational parameters and without error.
		// "Unknown" (0) - The implementation can not report on HealthState at this time.
		// DMTF has reserved the unused portion of the continuum for additional HealthStates in the future.
		// Legal values:
		// Unknown: 0
		// OK: 5
		// Degraded/Warning: 10
		// Minor failure: 15
		// Major failure: 20
		// Critical failure: 25
		// Non-recoverable error: 30
		// DMTF Reserved: ..
		unsigned short HealthState;

		// This field determines whether the HealthState field is valid.
		bool HealthStateSpecified;

		// Class Constructor
		CIM_ManagedSystemElement(
			const string& objName = CIM_ManagedSystemElement::CLASS_NAME,
			const string& uri = CIM_ManagedSystemElement::CLASS_URI,
			const string& ns = CIM_ManagedSystemElement::CLASS_NS,
			const string& nsPrefix = CIM_ManagedSystemElement::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_ManagedSystemElement(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

	};
}
#endif
