/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef BOXES_H
#define BOXES_H
#include <vdk/widcontain.h>
#include <vdk/dlist.h>

/*! \class VDKBox
 *  \brief One of the most used widget containers.
 *
 *  This class provides boxes used as VDKObject containers
 */
class VDKBox: public VDKObjectContainer
{
 public:
  /*!
    Constructor
    \param owner the form that owns box
    \param mode either vertical (mode == v_box) or horizontal
    (mode == h_box)
   */
  VDKBox(VDKForm* owner = (VDKForm*) NULL,int mode = v_box);
  /*!
    Destructor
   */
  virtual ~VDKBox();
  /*!
    Adds an object to the box
    \param obj the object to be added
    \param justify how the object has to be packed into box,
    can be one of the following
    \arg l_justify will be appended to other objects
    \arg r_justify will be prepended to other objects
    \param expand object will expand
    \param fill object will fill all available space
    \param padding object with be padded with <padding> pixels
  */
  virtual void Add(VDKObject* obj, int justify = l_justify,
		   int expand = TRUE, int fill = TRUE , int padding = 0);
};
#endif




