/*---------------------------------------------------------------------------*\

    FILE....: MAPDEV.CPP
    TYPE....: WIN32 C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 6/11/97
    AUTHOR..: Ron Lee
    DATE....: 11/11/06

    Functions used to map the board and channel number to a handle and 
	vice versa.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2006 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include <assert.h>

#include "mapdev.h"
#include "apifunc.h"
#include "wobbly.h"

#ifdef _OPENPRI
 #include "openpri.h"
#endif

/*--------------------------------------------------------------------------*\

	FUNCTION.: mapdevtohndle
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Maps the board number and channel number to a handle, this function
	assumes four channels per board.

\*--------------------------------------------------------------------------*/
int mapdevtohndle(unsigned int board, unsigned int port)
{ //{{{
	VPBREG    *v = vpb_c->vpbreg(board);

	if( port >= v->handles.size() )
		v->handles.resize( port + 1, -1 );

	int handle = v->handles[port];

	if( handle == -1 )
		return v->handles[port] = vpb_c->NewHandle( board, port );

	return handle;
} //}}}

/*--------------------------------------------------------------------------*\

	FUNCTION.: maphndletodev
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Maps the handle to board number and channel number.  This function
	assumes four channels per board.

\*--------------------------------------------------------------------------*/
void maphndletodev(int handle, unsigned short *board, unsigned short *port)
{ //{{{
        const VPBHANDLE   &lookup = vpb_c->LookupHandle( handle );

        *board = lookup.board;
        *port  = lookup.channel;
} //}}}


#ifdef _OPENPRI
/*--------------------------------------------------------------------------*\

	FUNCTION.: get_idx_from_ch()
	AUTHOR...: Ben Kramer
	DATE.....: xx/12/04
	
	Finds out the index to chans given a vpb channel

\*--------------------------------------------------------------------------*/
int get_idx_from_ch(VPBREG *v, int ch)
{
	pri_chan *chans = (pri_chan*)v->chans;
	int i = 0;

	for(; i < v->numch; ++i){
		if(ch == chans[i].chan_num)
			return i;
	}
	throw Wobbly(MAPDEV_INVALID_CHANNEL);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: get_idx_from_ich()
	AUTHOR...: Ben Kramer
	DATE.....: xx/01/05
	
	Finds out the index to chans given an ISDN channel

\*--------------------------------------------------------------------------*/
int get_idx_from_ich(VPBREG *v, int ch)
{
	pri_chan *chans = (pri_chan *)v->chans;
	int i = 0;

	ch &= 0xff;     // strip off any extra flags added by libpri.
	for(; i < v->numch; ++i){
		if(ch == chans[i].iface->channel)
			return i;
	}
	throw Wobbly(MAPDEV_INVALID_CHANNEL);
}
#endif

