/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.Panel3D;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.TextObject;

public class Replay
extends CloseDialog
implements IconBarListener {
    ZirkelCanvas ZC;
    int Last;
    Construction C;
    Vector V;
    IconBar IB;
    boolean HaveBreaks;
    ConstructionObject O = null;

    public Replay(Frame frame, ZirkelCanvas zirkelCanvas) {
        super(frame, Global.name("replay.title"), true);
        Cloneable cloneable;
        this.ZC = zirkelCanvas;
        this.add(new ButtonAction(this, "Vor"));
        this.setLayout(new BorderLayout());
        this.IB = new IconBar(frame);
        this.IB.addLeft("allback");
        this.IB.addLeft("fastback");
        this.IB.addLeft("oneback");
        this.IB.addLeft("oneforward");
        this.IB.addLeft("fastforward");
        this.IB.addLeft("allforward");
        this.IB.addSeparatorLeft();
        this.IB.addLeft("nextbreak");
        this.IB.addToggleLeft("setbreak");
        this.IB.addSeparatorLeft();
        this.IB.addLeft("close");
        this.IB.setIconBarListener(this);
        this.add("Center", new Panel3D(this.IB));
        this.C = zirkelCanvas.getConstruction();
        this.V = new Vector();
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (ConstructionObject)enumeration.nextElement();
            if (((ConstructionObject)cloneable).mustHide(this.ZC) && !((ConstructionObject)cloneable).isBreakHide() && (!(cloneable instanceof TextObject) || !((ConstructionObject)cloneable).valid() || ((ConstructionObject)cloneable).isSuperHidden())) continue;
            this.V.addElement(cloneable);
        }
        this.HaveBreaks = this.haveBreaks();
        this.Last = 0;
        this.setLast();
        this.setEnabled(true);
        this.pack();
        cloneable = frame.getSize();
        Dimension dimension = this.getSize();
        Point point = frame.getLocation();
        this.setLocation(point.x + ((Dimension)cloneable).width - dimension.width - 5, point.y + ((Dimension)cloneable).height / 5);
    }

    public void iconPressed(String string) {
        if (string.equals("close")) {
            this.doclose();
        } else if (string.equals("allback")) {
            this.Last = 0;
            this.setLast();
        } else if (string.equals("allforward")) {
            this.Last = this.V.size();
            this.setLast();
        } else if (string.equals("fastback")) {
            this.Last -= 10;
            if (this.Last < 0) {
                this.Last = 0;
            }
            this.setLast();
        } else if (string.equals("fastforward")) {
            this.Last += 10;
            if (this.Last > this.V.size()) {
                this.Last = this.V.size();
            }
            this.setLast();
        } else if (string.equals("oneforward")) {
            ++this.Last;
            if (this.Last > this.V.size()) {
                this.Last = this.V.size();
            }
            this.setLast();
        } else if (string.equals("nextbreak")) {
            do {
                ++this.Last;
                if (this.Last <= this.V.size()) continue;
                this.Last = this.V.size();
                break;
            } while (this.Last < this.V.size() && (this.Last <= 0 || !((ConstructionObject)this.V.elementAt(this.Last)).isBreak()));
            this.setLast();
        } else if (string.equals("setbreak")) {
            if (this.Last > 0) {
                ConstructionObject constructionObject;
                constructionObject.setBreak(!(constructionObject = (ConstructionObject)this.V.elementAt(this.Last)).isBreak());
                this.IB.setState("setbreak", constructionObject.isBreak());
                if (constructionObject.isBreak() && this.IB.isShiftPressed()) {
                    constructionObject.setHideBreak(true);
                }
            }
            this.HaveBreaks = this.haveBreaks();
            this.IB.setEnabled("nextbreak", this.HaveBreaks);
        } else if (string.equals("oneback")) {
            --this.Last;
            if (this.Last < 0) {
                this.Last = 0;
            }
            this.setLast();
        }
        this.start();
    }

    public void start() {
        if (this.Last == 0) {
            this.IB.setEnabled("allback", false);
            this.IB.setEnabled("fastback", false);
            this.IB.setEnabled("oneback", false);
        } else {
            this.IB.setEnabled("allback", true);
            this.IB.setEnabled("fastback", true);
            this.IB.setEnabled("oneback", true);
        }
        if (this.Last < this.V.size()) {
            this.IB.setEnabled("allforward", true);
            this.IB.setEnabled("fastforward", true);
            this.IB.setEnabled("oneforward", true);
        } else {
            this.IB.setEnabled("allforward", false);
            this.IB.setEnabled("fastforward", false);
            this.IB.setEnabled("oneforward", false);
        }
    }

    public void doclose() {
        this.ZC.paintUntil(null);
        this.ZC.showStatus();
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof TextObject)) continue;
            ((TextObject)constructionObject).setDoShow(false);
        }
        this.ZC.repaint();
        super.doclose();
    }

    public void checkLast() {
        if (this.O != null) {
            ((TextObject)this.O).setDoShow(false);
        }
        this.O = null;
        if (this.Last > this.V.size() - 1) {
            return;
        }
        this.O = (ConstructionObject)this.V.elementAt(this.Last);
        if (this.O != null && this.O instanceof TextObject) {
            ((TextObject)this.O).setDoShow(true);
        } else {
            this.O = null;
        }
    }

    public void setLast() {
        ConstructionObject constructionObject;
        if (this.Last < this.V.size()) {
            constructionObject = (ConstructionObject)this.V.elementAt(this.Last);
            this.checkLast();
            this.ZC.paintUntil(constructionObject);
        } else {
            this.Last = this.V.size();
            this.checkLast();
            this.ZC.paintUntil(null);
        }
        if (this.Last >= 0 && this.Last < this.V.size()) {
            constructionObject = (ConstructionObject)this.V.elementAt(this.Last);
            this.ZC.showStatus(constructionObject.getName() + " : " + constructionObject.getText());
            this.IB.setState("setbreak", constructionObject.isBreak());
        } else {
            this.IB.setState("setbreak", false);
        }
        if (this.Last >= this.V.size() || this.Last == 0) {
            this.IB.setEnabled("setbreak", false);
        } else {
            this.IB.setEnabled("setbreak", true);
        }
        if (this.Last >= this.V.size() || !this.HaveBreaks) {
            this.IB.setEnabled("nextbreak", false);
        } else {
            this.IB.setEnabled("nextbreak", true);
        }
    }

    public boolean haveBreaks() {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            if (!((ConstructionObject)enumeration.nextElement()).isBreak()) continue;
            return true;
        }
        return false;
    }
}

