/*
 * ================================================================
 * Please view:
 *
 * 	README for program information.
 * 	COPYING for distribution information.
 *
 * 	based on ident2 by Michael Bacarella (defile@nyct.net)
 *
 * ================================================================ 
 */

#include "xtelld.h"
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
              
/* ------------------------------------------------------------------
 * get_request	:	a fgets for file descriptors 
 * ------------------------------------------------------------------
 */
short int get_request(int d, char buffer[], unsigned short int len)
{
    unsigned short i;
    char ch;

    memset(buffer, 0, len);
    for (i = 0; i < len; i++) {
	if (read(d, &ch, 1) != 1)
	    return -1;
	else if (ch == '\n')
	    break;
	else if (ch == '\r') {
	    read(d, &ch, 1);	/* it better be \n */
	    break;
	} else
	    buffer[i] = ch;
    }
    buffer[i] = '\0';
    return i;
}

int logFILE(const char *fromluser)
{
    int filedes;
    char *path;
    struct passwd *passs;
    struct stat s;

    if ((passs = getpwnam(fromluser)) != NULL) {
	path = malloc(strlen(passs->pw_dir) + sizeof(LOGFILE) + 1);
	if (path == NULL)
	    return -1;
	strcpy(path, passs->pw_dir);
	strcat(path, "/");
	strcat(path, LOGFILE);
#ifdef O_NOFOLLOW        
	if ((filedes = open(path, O_WRONLY | O_APPEND | O_NOFOLLOW)) != -1) {
#else
	if ((filedes = open(path, O_WRONLY | O_APPEND)) != -1) {
#endif
           if (fstat(filedes, &s) == 0) {
	        if (S_ISREG(s.st_mode)) {
		    free(path);
		    return filedes;
		}
	    }
	}
	free(path);
    }
    return -1;
}


/* ------------------------------------------------------------------
 * killsock:
 *	violently kills a socket
 * ------------------------------------------------------------------
 */
void killsock(int s)
{
    shutdown(s, 2);
    close(s);
}
