###--- >>> `oats' <<<----- Data from an Oats Field Trial

	## alias	 help(oats)

##___ Examples ___:

data(oats)
oats$Nf <- ordered(oats$N, levels=sort(levels(oats$N)))
oats.aov <- aov(Y ~ Nf*V + Error(B/V), data = oats, qr = TRUE)
summary(oats.aov)
# next line not implemented in R
##Don't run: summary(oats.aov, split=list(Nf=list(L=1, Dev=2:3)))
par(mfrow=c(1,2), pty="s")
plot(fitted(oats.aov[[4]]), studres(oats.aov[[4]]))
abline(h=0, lty=2)
oats.pr <- proj(oats.aov)
qqnorm(oats.pr[[4]][,"Residuals"], ylab="Stratum 4 residuals")
qqline(oats.pr[[4]][,"Residuals"])

par(mfrow=c(1,1), pty="m")
oats.aov2 <- aov(Y ~ N + V + Error(B/V), data = oats, qr = TRUE)
model.tables(oats.aov2, type = "means", se = TRUE)

## Keywords: 'datasets'.


