###--- >>> `kappa' <<<----- Estimate the Condition Number

	## alias	 help(kappa)
	## alias	 help(kappa.default)
	## alias	 help(kappa.lm)
	## alias	 help(kappa.qr)
	## alias	 help(kappa.tri)

##___ Examples ___:

kappa(x1 <- cbind(1,1:10))# 15.71
kappa(x1, exact=T)	  # 13.68
kappa(x2 <- cbind(x1,2:11))# high! [x2 is singular!]

hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
sv9 <- svd(h9 <- hilbert(9))$ d
kappa(h9)# pretty high!
kappa(h9, exact=TRUE) == max(sv9) / min(sv9)
kappa(h9, exact=TRUE) / kappa(h9) # .677 (i.e. rel.error = 32%)

## Keywords: 'math'.


