###--- >>> `persp.init,' <<<----- Sets up axes for perspective plotting using other functions from persp family.

##___ Examples ___:


# add text and a symbol to a wire frame plot
# 

grid<- make.surface.grid( list( seq(-1,1,,15), seq(-1,1,,15)))
z<- grid[,1]**2 - grid[,2]**2   # saddle function
as.surface( grid, z)-> out.p

persp( out.p)-> proj.info   # save projection info

persp.points( 0,0,0, pch="+",cex=1.5,  persp.out=proj.info)
persp.text( 0,0,0, "   location of saddle point", cex=2,adj=0, 
persp.out=proj.info)




# plot a helix

theta<- seq( 0,50,,200)
x<- sin( theta)
y<- cos(theta) 
z<- theta/25



persp.init( range(x), range( y), range(z))
persp.lines( x,y,z)




#
# Draw a sphere in perspective. 
#
        u <- seq(0, 2 * pi,  , 30)
        v <- seq( - pi, pi,  , 30)      #
# make make up a parametric function for the sphere
#
function(uv)
{
        temp <- cbind(sin(uv[, 1]) * cos(uv[, 2]), cos(uv[, 1]) * 
cos(uv[, 2]), 
                sin(uv[, 2]) )
        temp
}

        out <- as.tiles(list(u, v), fun.ball)        #
# draw 3-d axes and setup perspective
#
        persp.init(xlim = c(-1, 1), ylim = c(-1, 1), zlim = c(0, 1))    #
# add tiles drawing from back to front
        persp.tiles(out)

 

## Keywords: 'funfits'.


