###--- >>> `binnest' <<<----- Binary Random Effects Model with Two Levels of Nesting

##___ Examples ___:

y <- rbind(matrix(rbinom(20,1,0.6), ncol=4),
	matrix(rbinom(20,1,0.4), ncol=4))
resp <- restovec(y, nest=1:4, times=F)
ccov <- tcctomat(c(rep(0,5),rep(1,5)), name="treatment")
reps <- rmna(resp, ccov=ccov)
# two random effects
binnest(reps, mu=~treatment, preg=c(1,0), pre1=1, pre2=1)
# first level random effect only
binnest(reps, mu=~treatment, preg=c(1,-1), pre1=1)
# second level random effect only
binnest(reps, mu=~treatment, preg=c(1,-1), pre2=1)



