###--- >>> `restovec' <<<----- Create a response object

##___ Examples ___:

y <- matrix(rnorm(20),ncol=5)
# times assumed to be 1:5
restovec(y)
#unequally-spaced times
tt <- c(1,3,6,10,15)
print(resp <- restovec(y,times=tt))
response(resp)
response(resp, nind=2:3)
times(resp)
nobs(resp)
weights(resp)
nesting(resp)
# because individuals are the only nesting, this is the same as
covind(resp)
# binomial
y <- matrix(rpois(20,5),ncol=5)
# responses summarized as relative frequencies
print(respb <- restovec(y,totals=y+matrix(rpois(20,5),ncol=5),times=tt))
response(respb)
# censored data
y <- matrix(rweibull(20,2,5),ncol=5)
print(respc <- restovec(y,censor=matrix(rbinom(20,1,0.9),ncol=5),times=tt))
# if there is no censoring, censor indicator is not printed
response(respc)
# nesting clustered within individuals
nest <- c(1,1,2,2,2)
print(respn <- restovec(y,censor=matrix(rbinom(20,1,0.9),ncol=5),
	times=tt,nest=nest))
response(respn)
times(respn)
nesting(respn)



