###--- >>> `stableglm' <<<----- Stable Generalized Linear Regression Model

	## alias	 help(stableglm)
	## alias	 help(mode.stable)
	## alias	 help(fitted.values.stable)
	## alias	 help(coefficients.stable)
	## alias	 help(weights.stable)
	## alias	 help(df.residual.stable)
	## alias	 help(llik.stable)
	## alias	 help(llik.comp.stable)
	## alias	 help(deviance.stable)
	## alias	 help(deviance.comp.stable)
	## alias	 help(aic.stable)
	## alias	 help(aic.opt.stable)

##___ Examples ___:

library(stable)
## Share return over a 50 day period (see reference above)
# share
y <- c(296,296,300,302,300,304,303,299,293,294,294,293,295,287,288,297,305,
307,307,304,303,304,304,309,309,309,307,306,304,300,296,301,298,295,
295,293,292,297,294,293,306,303,301,303,308,305,302,301,297,299)  

#return
ret <- (y[2:50]-y[1:49])/y[1:49]
hist(ret, breaks=seq(-0.035,0.045,0.01))

day <- seq(0,0.48,by=0.01) # time measured in days/100
x <- seq(1,length(ret))-1

# Classic stationary normal model tail=2
print(z1  <- stableglm(y = ret, Delta = 1/y[1:49],
     loc = ret ~ 1, disp= ret ~ 1, skew = ret ~ 1, tail = tail.g(1.9999999),
     iloc = 0,idisp = 0, iskew = 0,
     otail = F, oskew = F))

# Normal model (tail=2) with dispersion=disp.h(b0+b1*day)
print(z2 <- stableglm(y = ret,Delta = 1/y[1:49],
      loc = ~ day,disp = ret ~ 1, skew = ret ~ 1,tail = tail.g(1.999999),
      iloc = c(0,0),idisp = 0,iskew = 0,
      oskew = F,otail =F))

# Stable model with loc(ation)=loc.h(b0+b1*day)
print(z3 <- stableglm(y = ret, Delta = 1/y[1:49],
      loc = ~ day, disp = ret ~ 1, skew = ret ~ 1, tail = ret ~ 1,
      iloc = c(0.001,0),idisp = 0,iskew = 0, itail = 0))

# Stable model with disp(ersion)=disp.h(b0+b1*day)
print(z4 <- stableglm(y = ret, Delta = 1/y[1:49],
      loc = ret ~ 1, disp = ret ~ day, skew = ret ~ 1, tail = ret ~ 1,
      iloc = 0,idisp = c(-4.5,0),iskew = -2, itail = 1))

# Stable model with skew(ness)=skew.h(b0+b1*day)
# Evaluation at fixed parameter values (since noopt is set to TRUE)
print(z5 <- stableglm(y = ret, Delta = 1/y[1:49],
      loc = ret ~ 1, disp = ret ~ 1, skew = ~ day, tail = ret ~ 1,
      iloc = 5.557e-04,idisp = -4.957,iskew = c(2.811,-2.158),itail = -5.261e-1,
      noopt=T))

# Stable model with tail=tail.h(b0+b1*day)
print(z6 <- stableglm(y = ret, Delta = 1/y[1:49],
      loc = ret ~ 1, disp = ret ~ 1, skew = ret ~ 1, tail = ret ~ day,
      iloc = 0.001,idisp = -5,iskew = -3, itail = c(2,-7),hessian=F))



