###--- >>> `solve' <<<----- Solve a System of Equations

	## alias	 help(solve)
	## alias	 help(solve.default)
	## alias	 help(solve.qr)

##___ Examples ___:

hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
h8 <- hilbert(8); h8
##Don't run: solve(h8) # gives error: `singular'
sh8 <- solve(h8, tol = 1e-10)
round(sh8 %*% h8, 3)

A <- hilbert(4)
A[] <- as.complex(A)
## might not be supported on all platforms
try(solve(A))

## Keywords: 'algebra'.


