###--- >>> `anova.gls' <<<----- Compare Likelihoods of Fitted Objects

	## alias	 help(anova.gls)

##___ Examples ___:

data(Ovary)
# AR(1) errors within each Mare
fm1 <- gls(follicles ~ sin(2*pi*Time) + cos(2*pi*Time), Ovary,
           correlation = corAR1(form = ~ 1 | Mare))
anova(fm1)
# variance changes with a power of the absolute fitted values?
fm2 <- update(fm1, weights = varPower())
anova(fm1, fm2)

## Keywords: 'models'.


