###--- >>> `pinktoe' <<<----- Pinktoe: convert S trees to web files for interactive traversal.

	## alias	 help(pinktoe)

##___ Examples ___:

#
# An example already exists above concerning early
# day motions. The early day motions example concerns binary variables and
# a categorical response variable.
#
#
# The next example shows how to use pinktoe on a tree built from the
# kyphosis dataset found in multiple chapters in Chambers, J.M.
# and Hastie, T.J. (1993) Statistical models in S, Chapman and
# Hall/CRC: London. I'm a bit confused because at the time of writing
# (May 2001) Amazon says the book is out of print and the publisher says
# "In stock".
#
#
#
# Generate a tree
#
##Don't run: 
##D z.kyphosis <- tree(kyphosis)


data("zkyphosis")

#
# Now really should do usual tree modelling things like check the model,
# test the assumptions, prune, cross-validation etc. However, for the
# purposes of this example we just want to turn the S tree into a set of
# web pages that we can traverse.
#
# So, we have to first write some user-supplied functions.
# The first one is the textfn. Let's call this
# kyphosis.text:
#

kyphosis.text <- function(n, file = "", append = F)
{
        cat("<BR>\n", file = file, append = append)
        cat("Variable: ", n, ": ", file = file, append = append)
        if(n == "Start")
                cat("The beginning of the range of vertabrae involved<BR>\n", 
                        file = file, append = append)
        else if(n == "Age")
                cat("The age of the child in months<BR>\n", file = file, 
                        append = append)
        else if(n == "Number")
                cat("The number of vertebrae involved in the operation<BR>\n", 
                        file = file, append = append)
        else cat("print \"Unknown variable<BR>\"\n", file = file, append = 
                        append)
}

#
# So when any of the variables are input to kyphosis.text an
# appropriate line of explanatory text is printed out.
#
#
# Now let's write the function that returns <TITLE> text:
# the tittextfn
#

kyphosistittext <- function(label)
return(paste("Variable:", label))

#
# This was very simple. It just appends the word "Variable: " in front of the
# variable name. Notice that this function does not print anything out, just
# returns a character string.
#
#
# Now the stateprintfn. When this function receives
# a yval at a leaf it has to print out the final state. In
# this case there are only two final states for kyphosis: present or absent.
# Here is the code:
#

kyphosisprint <- function(yval, file = "", append = F)
{
        if(yval == "present")
                cat(" &present;\n", file = file, append = append)
        else if(yval == "absent")
                cat(" &absent;\n", file = file, append = append)
        else cat("print \"Unknown kyphosis state<BR>\"\n", file = file, append
                         = append)
}

#
# Note that the above code calls the perl functions present and absent
# (the call is with & in front). So, we have to supply the definitions of
# these separately. We do this in a perl library called kyphosis.lib. This
# file contains the following text:
# (n.b. don't copy the following into R it won't make sense. Copy it to
# a file)
#

##Don't run: 
##D sub present {
##D         print "Kyphosis is <BLINK>Present</BLINK><BR>\n";
##D         &rethome;
##D         }
##D  
##D sub absent {
##D         print "Kyphosis is <BLINK>Absent</BLINK><BR>\n";
##D         &rethome;
##D         }
##D  
##D sub rethome {
##D         print "<P>\n";
##D         print "<a href=\"http://www.stats.bris.ac.uk/~magpn\">Return to <EM>Guy Nason's</EM> page</a>";
##D         }


#
# which as you can see merely prints out whether kyphosis is absent or
# present. Actually, this text is very simple and could have placed in
# the stateprintfn directly. However, more
# complex functionality in the .lib file might make it
# clearer to have this separation.
#
# For the commonhtml function I use my
# genericcommonhtml function which provides a link back to
# my home page. But you can modify this...
#
#

genericcommonhtml <- function(file, append)
{
        cat("<a href=\"http://www.stats.bris.ac.uk/~magpn\">Return to <EM>Guy Nason's</EM> home page</a>\n",
                file = file, append = append)
}
#
# For this example we need to create a local directory called Tree to store
# the files in. You might have already done this so the following command
# is not necessary if the directory exists.
#
system("mkdir Tree")

#
# Now let's issue the call to pinktoe to build the HTML and perl trees.
#

pinktoe(z.kyphosis, textfn=kyphosis.text, tittext=kyphosistittext, "",
  cgibindir="/~magpn/cgi-bin/TEST/",
  htmldir="/home/magpn/public_html/TEST/",
  localdir="Tree/",
  stateprintfn=kyphosisprint,
  requirelib="../kyphosis.lib",
  commonhtml=genericcommonhtml)

#
# Pinktoe should produce a collection of HTML and perl files in the Tree
# subdirectory.
#
# Note that the end / of both the cgibindir and htmldir should be provided.
#
#
# Then FTP the HTML files to the htmldir you specified.
# Then FTP the perl files to the cgibindir you specified and change their
# permissions to be executable by anybody (presuming this is what you want).
#
#
# Then point your browser to the HTML file that has _1 at the end of its
# filename. In this example it is Start_1.htm You should then be able to
# traverse the tree.
#
# As an example. Here is the Start_1.htm
# I prepared using the above example. Try it out and check it against the
# tree.
#
# Of course, the kyphosis tree is pretty simple and with only 3 numeric
# variables it is quite easy just to use the tree diagram. However, things
# are more complicated with larger trees and where the variables have a lot
# of associated information, such as with the early day motion data.
#
#

## Keywords: 'tree'.


