\name{kdesign}
\alias{kdesign}
\title{ Interface to design functions for kriging }
\description{
  This is a call wrapper to \code{\link{kdesign.greedy}}, 
  \code{\link{kdesign.dualgreedy}} and \code{\link{kdesign.cenum}}
}
\usage{
kdesign(algorithm="greedy", point.obj, eligible.obj, ns, at,
       var.mod.obj, xsw=NULL, ysw=NULL, xne=NULL, yne=NULL,
       dx=NULL, dy=NULL, angle=NULL, maxdist=NULL, extrap=FALSE,
       border=NULL, trend=0,
       rsearch=0, nsearch=0, nsmin=-1, nsmax=-1, pgrid=1,
       criterion="meanvar", verbose=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{algorithm}{ \code{"greedy"}, \code{"dualgreedy"} or \code{"cenum"} }
 \item{point.obj}{ Object of class \code{"point"}, generated by
   \code{\link[sgeostat]{point}} from the \code{library(sgeostat)} representing the
   existing network with \eqn{nf} stations.}
 \item{eligible.obj}{Object of class \code{"point"}, generated by
   \code{\link[sgeostat]{point}} from the \code{library(sgeostat)} representing the
   eligible points with \eqn{ne} stations. }
 \item{ns}{Number of stations have to be added to the existing
   network.}
 \item{at}{The variable, contained in \code{point.obj}, for which
   prediction will be carried out.}
 \item{var.mod.obj}{ Object of class \code{"variogram.model"} generated
   by \code{\link[sgeostat]{fit.variogram}} from the \code{library(sgeostat)}.}
  \item{xsw}{\eqn{x} coordinate of the south west corner of the
   prediction grid, else the prediction grid is generated automatically
   (default NULL).}
 \item{xne}{\eqn{x} coordinate of the north east corner of the
   prediction grid, else the prediction grid is generated automatically 
   (default NULL). }
  \item{ysw}{\eqn{y} coordinate of the south west corner of the
   prediction grid, else the prediction grid is generated automatically
   (default NULL).}
 \item{yne}{\eqn{y} coordinate of the north east corner of the
   prediction grid, else the prediction grid is generated automatically 
   (default NULL). }
 \item{dx}{Grid spacing in \eqn{x} direction, else it is automatically
   generated by the function (default NULL).}
 \item{dy}{Grid spacing in \eqn{y} direction, else it is automatically
   generated by the function (default NULL). }
  \item{angle}{ Parameter for rotating the grid (currently unimplemented). }
 \item{maxdist}{An optional maximum distance. If entered, then only
   sample points (i.e, in \code{point.obj}) within \code{maxdist} of
   each prediction point will be used to do the prediction at that
   point. If not entered, then all \eqn{n} sample points will be used to
     make the prediction at each point. }
 \item{extrap}{Logical, indicates if prediction outside the convex hull
   of data points  should be done, default \code{FALSE}.}
  \item{border}{ optional: restrict computation to points within a
    closed polygon, given as a list with two members \code{x} and \code{y}}
  \item{trend}{ The parameter \code{trend} indicates the trend behaviour
   of the underlying stochastic process (0: no trend (default), 1:
   linear trend, 2: quadratic trend). }
 \item{rsearch}{Fixed radius for search neighbourhood (use either
   \code{rsearch} or \code{nsearch}).}
 \item{nsearch}{Fixed cardinality for search neighbourhood (use either
   \code{rsearch} or \code{nsearch}). }
  \item{nsmin}{ Minimum number of points in search
   neighbourhood (applies additionally to \code{rsearch} or \code{nsearch}).}
 \item{nsmax}{ Maximum number of points in search
   neighbourhood (applies additionally to \code{rsearch} or \code{nsearch}).}
 \item{pgrid}{Parameter for automatically generating the grid. If
   \code{pgrid} is 1 the prediction grid is generated using all given
   points (default). If \code{pgrid} is 2, for the prediction grid only the 
   eligible points are treated.}
  \item{criterion}{One of \code{maxvar} (maximum of the krige variances),
   \code{meanvar} (default, mean of the krige variances). Indicates
   which criterion is to be minimized.}
 \item{verbose}{for debugging}
}
\value{
   see \code{\link{kdesign.greedy}},
  \code{\link{kdesign.dualgreedy}} or \code{\link{kdesign.cenum}}
}

\author{ C. Gebhardt }

\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.vmod"))==0){example(fit.variogram)}
if(length(ls(pat="maas"))==0){data(maas)}
}
# fixed points:
mass.50<-maas[1:50,]
# eligible points:
mass.10<-maas[51:60,]

point.obj<-point(mass.50)
eligible.obj<-point(mass.10)

dsg <- kdesign(algorithm="greedy", point.obj, eligible.obj, 2, "zinc",
              maas.vmod, extrap=FALSE, trend=0,
              rsearch=600, pgrid=1,
              criterion="meanvar", verbose=FALSE)
# should give:
# [1]  0  0  0 54  0  0  0 58  0  0
dsg$S
# should give:
# [1] 81155.6
dsg$opt
}

\seealso{ \code{\link{kdesign.greedy}},
  \code{\link{kdesign.dualgreedy}}, \code{\link{kdesign.cenum}}
}
\keyword{ design }%-- one or more ...
\keyword{ spatial }%-- one or more ...
