\name{krige.tilesov}
\alias{krige.tilesov}
\title{ Universal kriging on a rectangular blocked grid (overlap version)}
\usage{
krige.tilesov(point.obj, at, var.mod.obj, xsw=NULL, ysw=NULL, xne=NULL,
            yne=NULL, dx=NULL, dy=NULL, nx=NULL, ny=NULL, itx=NULL, ity=NULL,nxper=NULL,nyper=NULL,angle=NULL,
            maxdist=NULL, extrap=FALSE, border=NULL, trend=0, rsearch=0, nsearch=0,
            nsmin=-1, nsmax=-1, mode=3, duplicate = "error", dupfun = NULL)
}
\arguments{
  \item{point.obj}{ spatial data, class \code{"point"}}
  \item{at}{ name of variable of interest in \code{point.obj} }
  \item{var.mod.obj}{ variogram mode, generated by \code{\link[sgeostat]{fit.variogram}}  }
  \item{xsw}{ x coordinate of south west corner of the grid }
  \item{ysw}{ y coordinate of south west corner of the grid }
  \item{xne}{ x coordinate of north east corner of the grid }
  \item{yne}{ y coordinate of north east corner of the grid }
  \item{dx}{ grid spacing in x direction }
  \item{dy}{ grid spacing in y direction }
  \item{nx}{ grid dimension in x direction, to be used in absence of \code{dx} }
  \item{ny}{ grid dimension in y direction, to be used in absence of \code{dy} }
  \item{itx}{ number of grid points per tile in x direction }
  \item{ity}{ number of grid points per tile in y direction }
  \item{nxper}{number of overlapping grid points per tile in x direction}
  \item{nyper}{number of overlapping grid points per tile in y direction}
  \item{angle}{ rotation of grid -- not yet implemented --}
  \item{maxdist}{ synonym for  \code{rsearch}, for compatibility with
    \code{sgeostat}}
  \item{extrap}{logical, indicates whether to extrapolate beyond convex
    hull of data points, default \code{FALSE} }
  \item{border}{optional polygon (list with two components \code{x} and
    \code{y} of same length) representing a (possibly non convex) region
    of interest to be used instead of the convex hull. Needs
    \code{extrap=FALSE}.}
 \item{trend}{ order of trend function }
 \item{rsearch}{ fixed search radius }
 \item{nsearch}{ fixed nearest neighbour search }
 \item{nsmin}{ minimum no of points in search neighbourhood, default 0}
 \item{nsmax}{ maximum no of points in search neighbourhood,
   default \code{length(point.obj[at])} }
 \item{mode}{1 - calculate only krige prediction, 2 - calculate
   only krige variance (useful for network design purposes),
   3 - both (default)}
  \item{duplicate}{
    indicates how to handle duplicate data points. Possible values are
    \code{"error"} - produces an error message, \code{"strip"} - remove
    duplicate z values, \code{"mean"},\code{"median"},\code{"user"}  -
    calculate mean , median or user defined function of duplicate z
    values.}
  \item{dupfun}{this function is applied to duplicate points if
    \code{duplicate="user"}}
}
\description{
  Performs (2D) universal kriging on a given grid (divided in
  subrectangles (tiles) which can overlap) using data and variogram
  objects prepared with \code{\link[sgeostat]{point}},
  \code{\link[sgeostat]{pair}}, \code{\link[sgeostat]{est.variogram}}
  and   \code{\link[sgeostat]{fit.variogram}} from library
  \code{sgeostat}.

 }
 \details{
   Trend models are coded via the \code{trend} parameter (only up to
   order 2 supported):
   \tabular{lr}{
     \code{trend}   \tab trend function \cr
     0              \tab \code{z~1}     \cr
     1              \tab \code{z~x+y+1}     \cr
     2              \tab \code{z~x+y+I(x^2)+I(y^2)+x*y} 
   }
   Maybe I will implement a formula based interface later.

   In contrast to \code{\link{krige.grid}} the grid specified for
   \code{krige.tiles} is built by rectangular subregions
   (tiles). Kriging predictions for points belonging to the same tile are
   calculated in a single step. The intention was to
   reduce computational burden by collecting some neigbouring krige
   systems and forming a combined krige system (using multiple right
   hand sides in the krige equations, see LAPACK routine DGESV).

   If \code{mode} is set to 2 (default is 3) only kriging variances are
   calculated. In this case the values in \code{at} (the measurements)
   are not used. This may be useful for experimental design applications
   where only new locations are given and measurements do not yet exist.
   Of course \code{var.mod} must be given (computed from an existing
   dataset).
}
\value{
  An object of type \code{\link{krige.map}}.
    A list (identical to \code{\link{krige.grid}}):
    \item{x }{vector of x coordinates of grid}
    \item{y }{vector of y coordinates of grid}
    \item{z }{matrix of predicted values, see also \code{mode}}
    \item{var }{matrix of prediction variances}
    \item{tiles } { matrix containing the tile pattern, same dimension
      as \code{z}, values are the tile numbers the actual grid point
      belongs to. }  
    \item{snb }{matrix with 0-1 search neighbourhood codes,
      columns refer to grid poiuts, rows to data points} 
  }
\references{ ftp://ftp-stat.uni-klu.ac.at/pub/R/contrib }
\author{ A. Gebhardt <agebhard@uni-klu.ac.at> }
\note{

  Drawback: border effects between tiles, not only at the outer regions
  of the grid.
  
  This tile approach can be viewed as intermediate step to a block
  kriging predictor, it is only left to average predictions across tiles
  (identifying tiles with blocks).

}

 \seealso{ 
   \code{\link{krige.cell}},\code{\link[sgeostat]{krige}}
 }

 \examples{
\testonly{
# prepare variables from other example pages if they are not already there:
  if(length(ls(pat="maas.vmod"))==0){
    require(sgeostat);
    example(fit.variogram)
  }
  if(length(ls(pat="maas.bank"))==0) data(maas.bank)
}

# compare result and system.time() with example(krige.tiles)
system.time(
 maas.ktilesov <-
   krige.tilesov(maas.point, "zinc", maas.vmod,
     min(maas.bank$x), min(maas.bank$y),max(maas.bank$x), max(maas.bank$y),
     nx=100,ny=100, itx=10, ity=10,nxper=2,nyper=2, rsearch = 600,
extrap = F
#,
###    border=maas.bank
)
)
# show a picture with tile containing point(50,50) marked :
plot(maas.ktilesov,show.snb=TRUE,snb.i=50,snb.j=50)
}
\keyword{ rgeostat }%-- one or more ...
