/* postal-address-details.c generated by valac 0.36.1.697-2b74, the Vala compiler
 * generated from postal-address-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>


#define FOLKS_TYPE_POSTAL_ADDRESS (folks_postal_address_get_type ())
#define FOLKS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress))
#define FOLKS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))
#define FOLKS_IS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_IS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_POSTAL_ADDRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))

typedef struct _FolksPostalAddress FolksPostalAddress;
typedef struct _FolksPostalAddressClass FolksPostalAddressClass;
typedef struct _FolksPostalAddressPrivate FolksPostalAddressPrivate;
enum  {
	FOLKS_POSTAL_ADDRESS_DUMMY_PROPERTY,
	FOLKS_POSTAL_ADDRESS_PO_BOX,
	FOLKS_POSTAL_ADDRESS_EXTENSION,
	FOLKS_POSTAL_ADDRESS_STREET,
	FOLKS_POSTAL_ADDRESS_LOCALITY,
	FOLKS_POSTAL_ADDRESS_REGION,
	FOLKS_POSTAL_ADDRESS_POSTAL_CODE,
	FOLKS_POSTAL_ADDRESS_COUNTRY,
	FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT,
	FOLKS_POSTAL_ADDRESS_UID,
	FOLKS_POSTAL_ADDRESS_LAST_PROPERTY
};
static GParamSpec* folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS (folks_postal_address_field_details_get_type ())
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails))
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetailsClass))
#define FOLKS_IS_POSTAL_ADDRESS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS))
#define FOLKS_IS_POSTAL_ADDRESS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS))
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetailsClass))

typedef struct _FolksPostalAddressFieldDetails FolksPostalAddressFieldDetails;
typedef struct _FolksPostalAddressFieldDetailsClass FolksPostalAddressFieldDetailsClass;
typedef struct _FolksPostalAddressFieldDetailsPrivate FolksPostalAddressFieldDetailsPrivate;
enum  {
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID,
	FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_LAST_PROPERTY
};
static GParamSpec* folks_postal_address_field_details_properties[FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_LAST_PROPERTY];

#define FOLKS_TYPE_POSTAL_ADDRESS_DETAILS (folks_postal_address_details_get_type ())
#define FOLKS_POSTAL_ADDRESS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails))
#define FOLKS_IS_POSTAL_ADDRESS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS))
#define FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetailsIface))

typedef struct _FolksPostalAddressDetails FolksPostalAddressDetails;
typedef struct _FolksPostalAddressDetailsIface FolksPostalAddressDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksPostalAddressDetailsChangePostalAddressesData FolksPostalAddressDetailsChangePostalAddressesData;

struct _FolksPostalAddress {
	GObject parent_instance;
	FolksPostalAddressPrivate * priv;
};

struct _FolksPostalAddressClass {
	GObjectClass parent_class;
};

struct _FolksPostalAddressPrivate {
	gchar* _po_box;
	gchar* _extension;
	gchar* _street;
	gchar* _locality;
	gchar* _region;
	gchar* _postal_code;
	gchar* _country;
	gchar* _address_format;
	gchar* _uid;
};

struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*parameters_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*values_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	const gchar* (*get_id) (FolksAbstractFieldDetails* self);
	void (*set_id) (FolksAbstractFieldDetails* self, const gchar* value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksPostalAddressFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksPostalAddressFieldDetailsPrivate * priv;
};

struct _FolksPostalAddressFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

struct _FolksPostalAddressFieldDetailsPrivate {
	gchar* _id;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksPostalAddressDetailsIface {
	GTypeInterface parent_iface;
	void (*change_postal_addresses) (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_postal_addresses_finish) (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_postal_addresses) (FolksPostalAddressDetails* self);
	void (*set_postal_addresses) (FolksPostalAddressDetails* self, GeeSet* value);
};

struct _FolksPostalAddressDetailsChangePostalAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksPostalAddressDetails* self;
	GeeSet* postal_addresses;
	GError* _tmp0_;
	GError * _inner_error_;
};


static gpointer folks_postal_address_parent_class = NULL;
static gpointer folks_postal_address_field_details_parent_class = NULL;

GType folks_postal_address_get_type (void) G_GNUC_CONST;
#define FOLKS_POSTAL_ADDRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressPrivate))
FolksPostalAddress* folks_postal_address_new (const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid);
FolksPostalAddress* folks_postal_address_construct (GType object_type, const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid);
gboolean folks_postal_address_is_empty (FolksPostalAddress* self);
const gchar* folks_postal_address_get_po_box (FolksPostalAddress* self);
const gchar* folks_postal_address_get_extension (FolksPostalAddress* self);
const gchar* folks_postal_address_get_street (FolksPostalAddress* self);
const gchar* folks_postal_address_get_locality (FolksPostalAddress* self);
const gchar* folks_postal_address_get_region (FolksPostalAddress* self);
const gchar* folks_postal_address_get_postal_code (FolksPostalAddress* self);
const gchar* folks_postal_address_get_country (FolksPostalAddress* self);
const gchar* folks_postal_address_get_address_format (FolksPostalAddress* self);
gboolean folks_postal_address_equal (FolksPostalAddress* self, FolksPostalAddress* with);
gchar* folks_postal_address_to_string (FolksPostalAddress* self);
void folks_postal_address_set_po_box (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_extension (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_street (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_locality (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_region (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_postal_code (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_country (FolksPostalAddress* self, const gchar* value);
void folks_postal_address_set_address_format (FolksPostalAddress* self, const gchar* value);
const gchar* folks_postal_address_get_uid (FolksPostalAddress* self) G_GNUC_DEPRECATED;
void folks_postal_address_set_uid (FolksPostalAddress* self, const gchar* value) G_GNUC_DEPRECATED;
static void folks_postal_address_finalize (GObject * obj);
static void _vala_folks_postal_address_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_postal_address_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_postal_address_field_details_get_type (void) G_GNUC_CONST;
#define FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetailsPrivate))
FolksPostalAddressFieldDetails* folks_postal_address_field_details_new (FolksPostalAddress* value, GeeMultiMap* parameters);
FolksPostalAddressFieldDetails* folks_postal_address_field_details_construct (GType object_type, FolksPostalAddress* value, GeeMultiMap* parameters);
static gboolean folks_postal_address_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_parameters_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
static guint folks_postal_address_field_details_real_hash (FolksAbstractFieldDetails* base);
static GObject * folks_postal_address_field_details_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _folks_postal_address_field_details___lambda4_ (FolksPostalAddressFieldDetails* self, GObject* s, GParamSpec* p);
const gchar* folks_abstract_field_details_get_id (FolksAbstractFieldDetails* self);
void folks_abstract_field_details_set_id (FolksAbstractFieldDetails* self, const gchar* value);
static void __folks_postal_address_field_details___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void folks_postal_address_field_details_finalize (GObject * obj);
static void _vala_folks_postal_address_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_postal_address_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GQuark folks_property_error_quark (void);
GType folks_postal_address_details_get_type (void) G_GNUC_CONST;
static void folks_postal_address_details_real_change_postal_addresses_data_free (gpointer _data);
static void folks_postal_address_details_real_change_postal_addresses_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void folks_postal_address_details_real_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_postal_address_details_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_postal_address_details_change_postal_addresses_finish (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_postal_address_details_real_change_postal_addresses_co (FolksPostalAddressDetailsChangePostalAddressesData* _data_);
GeeSet* folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self);
void folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self, GeeSet* value);


/**
   * Create a PostalAddress.
   *
   * You can pass ``null`` if a component is not set.
   *
   * @param po_box the PO Box
   * @param extension the address extension
   * @param street the street name and number
   * @param locality the locality (city, town or village) name
   * @param region the region (state or province) name
   * @param postal_code the postal code
   * @param country the country name
   * @param address_format the address format
   * @param uid external UID for the address instance
   * @since 0.5.1
   */
FolksPostalAddress* folks_postal_address_construct (GType object_type, const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid) {
	FolksPostalAddress * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	_tmp0_ = po_box;
	_tmp1_ = extension;
	_tmp2_ = street;
	_tmp3_ = locality;
	_tmp4_ = region;
	_tmp5_ = postal_code;
	_tmp6_ = country;
	_tmp7_ = address_format;
	_tmp8_ = uid;
	self = (FolksPostalAddress*) g_object_new (object_type, "po-box", _tmp0_, "extension", _tmp1_, "street", _tmp2_, "locality", _tmp3_, "region", _tmp4_, "postal-code", _tmp5_, "country", _tmp6_, "address-format", _tmp7_, "uid", _tmp8_, NULL);
	return self;
}


FolksPostalAddress* folks_postal_address_new (const gchar* po_box, const gchar* extension, const gchar* street, const gchar* locality, const gchar* region, const gchar* postal_code, const gchar* country, const gchar* address_format, const gchar* uid) {
	return folks_postal_address_construct (FOLKS_TYPE_POSTAL_ADDRESS, po_box, extension, street, locality, region, postal_code, country, address_format, uid);
}


/**
   * Whether none of the components is set.
   *
   * @return ``true`` if all the components are the empty string, ``false``
   * otherwise.
   *
   * @since 0.6.7
   */
gboolean folks_postal_address_is_empty (FolksPostalAddress* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp7_ = folks_postal_address_get_po_box (self);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = folks_postal_address_get_extension (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = g_strcmp0 (_tmp10_, "") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = folks_postal_address_get_street (self);
		_tmp12_ = _tmp11_;
		_tmp5_ = g_strcmp0 (_tmp12_, "") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = folks_postal_address_get_locality (self);
		_tmp14_ = _tmp13_;
		_tmp4_ = g_strcmp0 (_tmp14_, "") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = folks_postal_address_get_region (self);
		_tmp16_ = _tmp15_;
		_tmp3_ = g_strcmp0 (_tmp16_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = folks_postal_address_get_postal_code (self);
		_tmp18_ = _tmp17_;
		_tmp2_ = g_strcmp0 (_tmp18_, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = folks_postal_address_get_country (self);
		_tmp20_ = _tmp19_;
		_tmp1_ = g_strcmp0 (_tmp20_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = folks_postal_address_get_address_format (self);
		_tmp22_ = _tmp21_;
		_tmp0_ = g_strcmp0 (_tmp22_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Compare if two postal addresses are equal. Addresses are equal if all their
   * components are equal (where ``null`` compares equal only with ``null``) and
   * they have the same set of types (or both have no types).
   *
   * This does not factor in the {@link PostalAddress.uid}.
   *
   * @param with another postal address to compare with
   * @return ``true`` if the addresses are equal, ``false`` otherwise
   */
gboolean folks_postal_address_equal (FolksPostalAddress* self, FolksPostalAddress* with) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	FolksPostalAddress* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (with != NULL, FALSE);
	_tmp7_ = folks_postal_address_get_po_box (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = with;
	_tmp10_ = folks_postal_address_get_po_box (_tmp9_);
	_tmp11_ = _tmp10_;
	if (g_strcmp0 (_tmp8_, _tmp11_) != 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		FolksPostalAddress* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp12_ = folks_postal_address_get_extension (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = with;
		_tmp15_ = folks_postal_address_get_extension (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp6_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		FolksPostalAddress* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp17_ = folks_postal_address_get_street (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = with;
		_tmp20_ = folks_postal_address_get_street (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp5_ = g_strcmp0 (_tmp18_, _tmp21_) != 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		FolksPostalAddress* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp22_ = folks_postal_address_get_locality (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = with;
		_tmp25_ = folks_postal_address_get_locality (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp4_ = g_strcmp0 (_tmp23_, _tmp26_) != 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		FolksPostalAddress* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp27_ = folks_postal_address_get_region (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = with;
		_tmp30_ = folks_postal_address_get_region (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp3_ = g_strcmp0 (_tmp28_, _tmp31_) != 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		FolksPostalAddress* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp32_ = folks_postal_address_get_postal_code (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = with;
		_tmp35_ = folks_postal_address_get_postal_code (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp2_ = g_strcmp0 (_tmp33_, _tmp36_) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		FolksPostalAddress* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp37_ = folks_postal_address_get_country (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = with;
		_tmp40_ = folks_postal_address_get_country (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp1_ = g_strcmp0 (_tmp38_, _tmp41_) != 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		FolksPostalAddress* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		_tmp42_ = folks_postal_address_get_address_format (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = with;
		_tmp45_ = folks_postal_address_get_address_format (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp0_ = g_strcmp0 (_tmp43_, _tmp46_) != 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


/**
   * Get a formatted version of the address. The format is localised, and by
   * default is comma-separated.
   *
   * @return a formatted address.
   *
   * @since 0.4.0
   */
gchar* folks_postal_address_to_string (FolksPostalAddress* self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (_ ("%s, %s, %s, %s, %s, %s, %s"));
	str = _tmp0_;
	_tmp1_ = folks_postal_address_get_po_box (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_get_extension (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_postal_address_get_street (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_postal_address_get_locality (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = folks_postal_address_get_region (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = folks_postal_address_get_postal_code (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = folks_postal_address_get_country (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf (str, _tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp14_);
	result = _tmp15_;
	_g_free0 (str);
	return result;
}


const gchar* folks_postal_address_get_po_box (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_po_box;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_po_box (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_po_box);
	self->priv->_po_box = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_PO_BOX]);
}


const gchar* folks_postal_address_get_extension (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_extension (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_EXTENSION]);
}


const gchar* folks_postal_address_get_street (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_street;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_street (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_street);
	self->priv->_street = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_STREET]);
}


const gchar* folks_postal_address_get_locality (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locality;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_locality (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_locality);
	self->priv->_locality = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_LOCALITY]);
}


const gchar* folks_postal_address_get_region (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_region;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_region (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_region);
	self->priv->_region = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_REGION]);
}


const gchar* folks_postal_address_get_postal_code (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_postal_code;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_postal_code (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_postal_code);
	self->priv->_postal_code = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_POSTAL_CODE]);
}


const gchar* folks_postal_address_get_country (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_country;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_country (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_country);
	self->priv->_country = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_COUNTRY]);
}


const gchar* folks_postal_address_get_address_format (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address_format;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_address_format (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_address_format);
	self->priv->_address_format = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT]);
}


const gchar* folks_postal_address_get_uid (FolksPostalAddress* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}


void folks_postal_address_set_uid (FolksPostalAddress* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_UID]);
}


static void folks_postal_address_class_init (FolksPostalAddressClass * klass) {
	folks_postal_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPostalAddressPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_postal_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_postal_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_postal_address_finalize;
	/**
	   * The PO Box.
	   *
	   * The PO Box (also known as Postal office box or Postal box).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_PO_BOX, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_PO_BOX] = g_param_spec_string ("po-box", "po-box", "po-box", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address extension.
	   *
	   * Any additional part of the address, for instance a flat number.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_EXTENSION, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_EXTENSION] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The street name and number.
	   *
	   * The street name including the optional building number.
	   * The number can be before or after the street name based on the
	   * language and country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_STREET, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_STREET] = g_param_spec_string ("street", "street", "street", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The locality.
	   *
	   * The locality, for instance the city name.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_LOCALITY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_LOCALITY] = g_param_spec_string ("locality", "locality", "locality", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The region.
	   *
	   * The region, for instance the name of the state or province.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_REGION, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_REGION] = g_param_spec_string ("region", "region", "region", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The postal code.
	   *
	   * The postal code (also known as post code, postcode or ZIP code).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_POSTAL_CODE, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_POSTAL_CODE] = g_param_spec_string ("postal-code", "postal-code", "postal-code", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The country.
	   *
	   * The name of the country.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_COUNTRY, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_COUNTRY] = g_param_spec_string ("country", "country", "country", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The address format.
	   *
	   * The two letter country code that determines the format or exact
	   * meaning of the other fields.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT] = g_param_spec_string ("address-format", "address-format", "address-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The UID of the Postal Address (if any).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_UID, folks_postal_address_properties[FOLKS_POSTAL_ADDRESS_UID] = g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT | G_PARAM_DEPRECATED));
}


static void folks_postal_address_instance_init (FolksPostalAddress * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self->priv = FOLKS_POSTAL_ADDRESS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_po_box = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_extension = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_street = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_locality = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_region = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_postal_code = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_country = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_address_format = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->priv->_uid = _tmp8_;
}


static void folks_postal_address_finalize (GObject * obj) {
	FolksPostalAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress);
	_g_free0 (self->priv->_po_box);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_street);
	_g_free0 (self->priv->_locality);
	_g_free0 (self->priv->_region);
	_g_free0 (self->priv->_postal_code);
	_g_free0 (self->priv->_country);
	_g_free0 (self->priv->_address_format);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_postal_address_parent_class)->finalize (obj);
}


/**
 * Object representing a postal mail address.
 *
 * The components of the address are never ``null``: an empty string
 * indicates that a property is not set.
 */
GType folks_postal_address_get_type (void) {
	static volatile gsize folks_postal_address_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddress), 0, (GInstanceInitFunc) folks_postal_address_instance_init, NULL };
		GType folks_postal_address_type_id;
		folks_postal_address_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPostalAddress", &g_define_type_info, 0);
		g_once_init_leave (&folks_postal_address_type_id__volatile, folks_postal_address_type_id);
	}
	return folks_postal_address_type_id__volatile;
}


static void _vala_folks_postal_address_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPostalAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX:
		g_value_set_string (value, folks_postal_address_get_po_box (self));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION:
		g_value_set_string (value, folks_postal_address_get_extension (self));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET:
		g_value_set_string (value, folks_postal_address_get_street (self));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY:
		g_value_set_string (value, folks_postal_address_get_locality (self));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION:
		g_value_set_string (value, folks_postal_address_get_region (self));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE:
		g_value_set_string (value, folks_postal_address_get_postal_code (self));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY:
		g_value_set_string (value, folks_postal_address_get_country (self));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT:
		g_value_set_string (value, folks_postal_address_get_address_format (self));
		break;
		case FOLKS_POSTAL_ADDRESS_UID:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		g_value_set_string (value, folks_postal_address_get_uid (self));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_postal_address_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPostalAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_PO_BOX:
		folks_postal_address_set_po_box (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_EXTENSION:
		folks_postal_address_set_extension (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_STREET:
		folks_postal_address_set_street (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_LOCALITY:
		folks_postal_address_set_locality (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_REGION:
		folks_postal_address_set_region (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_POSTAL_CODE:
		folks_postal_address_set_postal_code (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_COUNTRY:
		folks_postal_address_set_country (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_ADDRESS_FORMAT:
		folks_postal_address_set_address_format (self, g_value_get_string (value));
		break;
		case FOLKS_POSTAL_ADDRESS_UID:
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
		folks_postal_address_set_uid (self, g_value_get_string (value));
G_GNUC_END_IGNORE_DEPRECATIONS
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
   * Create a new PostalAddressFieldDetails.
   *
   * @param value the value of the field, a non-empty {@link PostalAddress}
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   *
   * @return a new PostalAddressFieldDetails
   *
   * @since 0.6.0
   */
FolksPostalAddressFieldDetails* folks_postal_address_field_details_construct (GType object_type, FolksPostalAddress* value, GeeMultiMap* parameters) {
	FolksPostalAddressFieldDetails * self = NULL;
	FolksPostalAddress* _tmp0_;
	gboolean _tmp1_;
	FolksPostalAddress* _tmp2_;
	GeeMultiMap* _tmp3_;
	FolksPostalAddress* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = value;
	_tmp1_ = folks_postal_address_is_empty (_tmp0_);
	if (_tmp1_) {
		g_warning ("postal-address-details.vala:285: Empty postal address passed to Postal" \
"AddressFieldDetails.");
	}
	_tmp2_ = value;
	_tmp3_ = parameters;
	_tmp4_ = value;
	_tmp5_ = folks_postal_address_get_uid (_tmp4_);
	_tmp6_ = _tmp5_;
	self = (FolksPostalAddressFieldDetails*) g_object_new (object_type, "t_type", FOLKS_TYPE_POSTAL_ADDRESS, "t_dup_func", (GBoxedCopyFunc) g_object_ref, "t_destroy_func", (GDestroyNotify) g_object_unref, "value", _tmp2_, "parameters", _tmp3_, "id", _tmp6_, NULL);
	return self;
}


FolksPostalAddressFieldDetails* folks_postal_address_field_details_new (FolksPostalAddress* value, GeeMultiMap* parameters) {
	return folks_postal_address_field_details_construct (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean folks_postal_address_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksPostalAddressFieldDetails * self;
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_;
	gboolean _tmp1_;
	gconstpointer _tmp2_;
	FolksPostalAddress* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FolksAbstractFieldDetails* _tmp6_;
	gconstpointer _tmp7_;
	FolksPostalAddress* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	self = (FolksPostalAddressFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_postal_address_field_details_parent_class)->parameters_equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), _tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = that;
	_tmp7_ = folks_abstract_field_details_get_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strcmp0 (_tmp5_, _tmp10_) == 0;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp5_);
	result = _tmp11_;
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_postal_address_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksPostalAddressFieldDetails * self;
	guint result = 0U;
	GHashFunc _tmp0_;
	gconstpointer _tmp1_;
	FolksPostalAddress* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	self = (FolksPostalAddressFieldDetails*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static const gchar* folks_postal_address_field_details_real_get_id (FolksAbstractFieldDetails* base) {
	const gchar* result;
	FolksPostalAddressFieldDetails* self;
	const gchar* _tmp0_;
	self = (FolksPostalAddressFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void folks_postal_address_field_details_real_set_id (FolksAbstractFieldDetails* base, const gchar* value) {
	FolksPostalAddressFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	FolksPostalAddress* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	self = (FolksPostalAddressFieldDetails*) base;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp3_;
	_tmp4_ = self->priv->_id;
	_tmp5_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp4_, _tmp8_) != 0) {
		gconstpointer _tmp9_;
		FolksPostalAddress* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_id;
		folks_postal_address_set_uid ((FolksPostalAddress*) _tmp10_, _tmp11_);
	}
	g_object_notify_by_pspec ((GObject *) self, folks_postal_address_field_details_properties[FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID]);
}


static void _folks_postal_address_field_details___lambda4_ (FolksPostalAddressFieldDetails* self, GObject* s, GParamSpec* p) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	FolksPostalAddress* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp1_, _tmp5_) != 0) {
		gconstpointer _tmp6_;
		FolksPostalAddress* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp7_);
		_tmp9_ = _tmp8_;
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, _tmp9_);
	}
}


static void __folks_postal_address_field_details___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_postal_address_field_details___lambda4_ ((FolksPostalAddressFieldDetails*) self, _sender, pspec);
}


static GObject * folks_postal_address_field_details_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksPostalAddressFieldDetails * self;
	gconstpointer _tmp0_;
	FolksPostalAddress* _tmp1_;
	parent_class = G_OBJECT_CLASS (folks_postal_address_field_details_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) ((FolksPostalAddress*) _tmp1_), "notify::uid", (GCallback) __folks_postal_address_field_details___lambda4__g_object_notify, self, 0);
	return obj;
}


static void folks_postal_address_field_details_class_init (FolksPostalAddressFieldDetailsClass * klass) {
	folks_postal_address_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPostalAddressFieldDetailsPrivate));
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails *, FolksAbstractFieldDetails*)) folks_postal_address_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails *)) folks_postal_address_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = folks_postal_address_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = folks_postal_address_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_postal_address_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_postal_address_field_details_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_postal_address_field_details_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_postal_address_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID, folks_postal_address_field_details_properties[FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_postal_address_field_details_instance_init (FolksPostalAddressFieldDetails * self) {
	self->priv = FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_GET_PRIVATE (self);
}


static void folks_postal_address_field_details_finalize (GObject * obj) {
	FolksPostalAddressFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_postal_address_field_details_parent_class)->finalize (obj);
}


/**
 * Object representing a PostalAddress value that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
GType folks_postal_address_field_details_get_type (void) {
	static volatile gsize folks_postal_address_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_postal_address_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPostalAddressFieldDetails), 0, (GInstanceInitFunc) folks_postal_address_field_details_instance_init, NULL };
		GType folks_postal_address_field_details_type_id;
		folks_postal_address_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksPostalAddressFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_postal_address_field_details_type_id__volatile, folks_postal_address_field_details_type_id);
	}
	return folks_postal_address_field_details_type_id__volatile;
}


static void _vala_folks_postal_address_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPostalAddressFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_postal_address_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPostalAddressFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails);
	switch (property_id) {
		case FOLKS_POSTAL_ADDRESS_FIELD_DETAILS_ID:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_postal_address_details_real_change_postal_addresses_data_free (gpointer _data) {
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->postal_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPostalAddressDetailsChangePostalAddressesData, _data_);
}


static void folks_postal_address_details_real_change_postal_addresses_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksPostalAddressDetailsChangePostalAddressesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_postal_address_details_real_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	FolksPostalAddressDetails* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	_data_ = g_slice_new0 (FolksPostalAddressDetailsChangePostalAddressesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, folks_postal_address_details_real_change_postal_addresses_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, folks_postal_address_details_real_change_postal_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = postal_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->postal_addresses);
	_data_->postal_addresses = _tmp2_;
	folks_postal_address_details_real_change_postal_addresses_co (_data_);
}


static void folks_postal_address_details_real_change_postal_addresses_finish (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error) {
	FolksPostalAddressDetailsChangePostalAddressesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


/**
   * Change the contact's postal addresses.
   *
   * It's preferred to call this rather than setting
   * {@link PostalAddressDetails.postal_addresses} directly, as this method
   * gives error notification and will only return once the addresses have been
   * written to the relevant backing store (or the operation's failed).
   *
   * @param postal_addresses the set of postal addresses
   * @throws PropertyError if setting the addresses failed
   * @since 0.6.2
   */
static gboolean folks_postal_address_details_real_change_postal_addresses_co (FolksPostalAddressDetailsChangePostalAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Postal addresses are not writeable on this contact."));
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_postal_address_details_change_postal_addresses (FolksPostalAddressDetails* self, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->change_postal_addresses (self, postal_addresses, _callback_, _user_data_);
}


void folks_postal_address_details_change_postal_addresses_finish (FolksPostalAddressDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->change_postal_addresses_finish (self, _res_, error);
}


GeeSet* folks_postal_address_details_get_postal_addresses (FolksPostalAddressDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->get_postal_addresses (self);
}


void folks_postal_address_details_set_postal_addresses (FolksPostalAddressDetails* self, GeeSet* value) {
	g_return_if_fail (self != NULL);
	FOLKS_POSTAL_ADDRESS_DETAILS_GET_INTERFACE (self)->set_postal_addresses (self, value);
}


static void folks_postal_address_details_base_init (FolksPostalAddressDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The postal addresses of the contact.
		   *
		   * A list of postal addresses associated to the contact.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("postal-addresses", "postal-addresses", "postal-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_postal_addresses = folks_postal_address_details_real_change_postal_addresses;
		iface->change_postal_addresses_finish = folks_postal_address_details_real_change_postal_addresses_finish;
	}
}


/**
 * Interface for classes that can provide postal addresses, such as
 * {@link Persona} and {@link Individual}.
 */
GType folks_postal_address_details_get_type (void) {
	static volatile gsize folks_postal_address_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_postal_address_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPostalAddressDetailsIface), (GBaseInitFunc) folks_postal_address_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_postal_address_details_type_id;
		folks_postal_address_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPostalAddressDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_postal_address_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_postal_address_details_type_id__volatile, folks_postal_address_details_type_id);
	}
	return folks_postal_address_details_type_id__volatile;
}



