static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Michael Muré <batolettre@gmail.com>                        \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_enum (sampler_type, _(\"Resampling method\"),                        \n"
"    GeglSamplerType, gegl_sampler_type,                                       \n"
"    GEGL_SAMPLER_CUBIC)                                                       \n"
"                                                                              \n"
"property_enum (abyss_policy, _(\"Abyss policy\"),                             \n"
"               GeglAbyssPolicy, gegl_abyss_policy,                            \n"
"               GEGL_ABYSS_NONE)                                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     map_absolute                                         \n"
"#define GEGL_OP_C_SOURCE map-absolute.c                                       \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"aux\", babl_format_n (babl_type (\"float\"), 2));\n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *region)                         \n"
"{                                                                             \n"
"  if (! strcmp (input_pad, \"input\"))                                        \n"
"    return *gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  else                                                                        \n"
"    return *region;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties       *o = GEGL_PROPERTIES (operation);                      \n"
"  const Babl           *format_io, *format_coords;                            \n"
"  GeglSampler          *sampler;                                              \n"
"  GeglBufferIterator   *it;                                                   \n"
"  gint                  index_in, index_out, index_coords;                    \n"
"                                                                              \n"
"  format_io = babl_format (\"RGBA float\");                                   \n"
"  format_coords = babl_format_n (babl_type (\"float\"), 2);                   \n"
"                                                                              \n"
"  sampler = gegl_buffer_sampler_new_at_level (input, format_io, o->sampler_type,\n"
"                                              level);                         \n"
"                                                                              \n"
"  if (aux != NULL)                                                            \n"
"    {                                                                         \n"
"      it = gegl_buffer_iterator_new (output, result, level, format_io,        \n"
"                                     GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);     \n"
"      index_out = 0;                                                          \n"
"                                                                              \n"
"      index_coords = gegl_buffer_iterator_add (it, aux, result, level, format_coords,\n"
"                                               GEGL_ACCESS_READ, GEGL_ABYSS_NONE);\n"
"      index_in = gegl_buffer_iterator_add (it, input, result, level, format_io,\n"
"                                           GEGL_ACCESS_READ, o->abyss_policy);\n"
"                                                                              \n"
"      while (gegl_buffer_iterator_next (it))                                  \n"
"        {                                                                     \n"
"          gint        w;                                                      \n"
"          gint        h;                                                      \n"
"          gfloat      x;                                                      \n"
"          gfloat      y;                                                      \n"
"          gfloat     *in = it->data[index_in];                                \n"
"          gfloat     *out = it->data[index_out];                              \n"
"          gfloat     *coords = it->data[index_coords];                        \n"
"                                                                              \n"
"          y = it->roi->y + 0.5; /* initial y coordinate */                    \n"
"                                                                              \n"
"          for (h = it->roi->height; h; h--, y++)                              \n"
"            {                                                                 \n"
"              x = it->roi->x + 0.5; /* initial x coordinate */                \n"
"                                                                              \n"
"              for (w = it->roi->width; w; w--, x++)                           \n"
"                {                                                             \n"
"                  /* if the coordinate asked is an exact pixel, we fetch it   \n"
"                   * directly, to avoid the blur of sampling */               \n"
"                  if (coords[0] == x && coords[1] == y)                       \n"
"                    {                                                         \n"
"                      out[0] = in[0];                                         \n"
"                      out[1] = in[1];                                         \n"
"                      out[2] = in[2];                                         \n"
"                      out[3] = in[3];                                         \n"
"                    }                                                         \n"
"                  else                                                        \n"
"                    {                                                         \n"
"                      gegl_sampler_get (sampler, coords[0],                   \n"
"                                                 coords[1],                   \n"
"                                                 NULL, out,                   \n"
"                                                 o->abyss_policy);            \n"
"                    }                                                         \n"
"                                                                              \n"
"                  coords += 2;                                                \n"
"                  in += 4;                                                    \n"
"                  out += 4;                                                   \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, result, o->abyss_policy,                       \n"
"                        output, result);                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"                                                                              \n"
"  composer_class->process = process;                                          \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",              \"gegl:map-absolute\",                             \n"
"    \"title\",              _(\"Map Absolute\"),                              \n"
"    \"categories\",        \"map\",                                           \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\", _(\"sample input with an auxiliary buffer that contain absolute source coordinates\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
