<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_proxy_ajp - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_proxy_ajp</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_ajp.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_ajp.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_proxy_ajp.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Module de support AJP pour
<code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>proxy_ajp_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_proxy_ajp.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.1 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module ncessite le chargement de <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>. Il fournit le support du <code>Protocole Apache
    JServ version 1.3</code> (nomm dans la suite de ce document
    <em>AJP13</em>).</p>

    <p>Pour tre en mesure d'exploiter le protocole <code>AJP13</code>,
    il est donc ncessaire de charger les modules
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> et <code class="module"><a href="../mod/mod_proxy_ajp.html">mod_proxy_ajp</a></code>.</p>

    <div class="warning"><h3>Avertissement</h3>
      <p>N'activez pas la fonctionnalit de mandataire avant d'avoir <a href="mod_proxy.html#access">scuris votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux non seulement pour
      votre rseau, mais aussi pour l'Internet au sens large. </p>
    </div>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#usage">Utilisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#env">Variables d'environnement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#overviewprotocol">Vue d'ensemble du protocole</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#basppacketstruct">Structure de base des paquets</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rpacetstruct">Structure des paquets de
requte</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#resppacketstruct">Structure du paquet de la
rponse</a></li>
</ul><h3 class="directives">Directives</h3>
<p>Ce module ne fournit aucune directive.</p>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_proxy_ajp">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_proxy_ajp">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></li>
<li><a href="../env.html">Documentation sur les variables
d'environnement</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Utilisation</a></h2>
    <p>Ce module permet de mandater en inverse un serveur d'application
    d'arrire-plan (comme Apache Tomcat) qui utilise le protocole AJP13.
    Son utilisation est similaire  celle d'un mandataire inverse HTTP,
    mais s'appuie sur le prefixe <code>ajp://</code> :</p>

    <div class="example"><h3>Mandataire inverse simple</h3><pre class="prettyprint lang-config">ProxyPass "/app" "ajp://backend.example.com:8009/app"</pre>
</div>

    <p>On peut aussi configurer un rpartiteur de charge :</p>
    <div class="example"><h3>Mandataire inverse avec rpartiteur de charge</h3><pre class="prettyprint lang-config">&lt;Proxy balancer://cluster&gt;
    BalancerMember "ajp://app1.example.com:8009" loadfactor=1
    BalancerMember "ajp://app2.example.com:8009" loadfactor=2
    ProxySet lbmethod=bytraffic
&lt;/Proxy&gt;
ProxyPass "/app" "balancer://cluster/app"</pre>
</div>

    <p>Notez qu'en gnral, la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypassreverse">ProxyPassReverse</a></code> n'est pas
    ncessaire. La requte AJP inclut l'en-tte host original fourni
    au mandataire, et le serveur d'application est sens gnrer des
    en-ttes auto-rfrenants relatifs  cet hte ; aucune rcriture
    n'est donc ncessaire.</p>

    <p>La situation la plus courante dans laquelle la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypassreverse">ProxyPassReverse</a></code> est ncessaire se
    rencontre lorsque le chemin de l'URL au niveau du mandataire est
    diffrente de celle du serveur d'arrire-plan. Dans ce cas, un
    en-tte redirect peut tre rcrit relativement  l'URL de l'hte
    original (et non du serveur d'arrire-plan <code>ajp://</code> URL)
    ; par exemple :</p>
    <div class="example"><h3>Rcriture d'un chemin mandat</h3><pre class="prettyprint lang-config">ProxyPass "/apps/foo" "ajp://backend.example.com:8009/foo"
ProxyPassReverse "/apps/foo" "http://www.example.com/foo"</pre>
</div>
    <p>Il est cependant prfrable en gnral de dployer l'application
    sur le serveur d'arrire-plan avec le mme chemin que sur le
    mandataire.
    </p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="env" id="env">Variables d'environnement</a></h2>
    <p>Les variables d'environnement dont le nom possde le prfixe
    <code>AJP_</code> sont transmises au serveur original en tant
    qu'attributs de requte AJP (le prfixe AJP_ tant supprim du nom
    de la cl).</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="overviewprotocol" id="overviewprotocol">Vue d'ensemble du protocole</a></h2>
    <p>Le protocole <code>AJP13</code> est orient paquet. Le format
    binaire a t prfr, probablement pour des raisons de
    performances, au format texte pourtant plus lisible. Le serveur web
    communique avec le conteneur de servlets sur une connexion TCP. Pour
    diminuer la charge induite par le processus de cration de socket,
    le serveur web va tenter d'utiliser des connexions TCP persistantes
    avec le conteneur de servlets, et de rutiliser les connexions
    pendant plusieurs cycles requtes/rponse.</p>
    <p>Lorsqu'une connexion a t assigne  une requte particulire,
    elle ne sera utilise pour aucune autre jusqu' ce que le cycle de
    traitement de la requte se soit termin. En d'autres termes, il n'y
    a pas de multiplexage des requtes sur une connexion. Ceci se
    traduit par un code beaucoup plus simple  chaque extrmit de la
    connexion, un nombre plus important de connexions tant cependant
    ouvertes en mme temps.</p>
    <p>Lorsque le serveur web a ouvert une connexion vers le conteneur
    de servlets, celle-ci peut se trouver dans l'un des tats suivants
    :</p>
    <ul>
    <li> Idle <br /> Aucune requte n'est traite sur cette
    connexion. </li>
    <li> Assigned <br /> La connexion fait l'objet d'un traitement de
    requte.</li>
    </ul>
    <p>Lorsqu'une connexion est assigne au traitement d'une requte
    particulire, les informations de base de cette dernire (comme les
    en-ttes HTTP, etc...) sont envoyes sur la connexion sous une forme
    trs condense (par exemple les chanes courantes sont codes sous
    forme d'entiers). Vous trouverez des dtails sur ce format plus
    loin dans la structure des paquets de requte. Si la requte possde
    un corps <code>(content-length &gt; 0)</code>, il est envoy dans un
    paquet spar immdiatement aprs.</p>
    <p>A ce moment, le conteneur est probablement prt  traiter la
    requte. Au cours de ce traitement, il peut renvoyer les messages
    suivants au serveur web :</p>
    <ul>
    <li>SEND_HEADERS <br />Renvoie un jeu d'en-ttes au navigateur.</li>
    <li>SEND_BODY_CHUNK <br />Renvoie un tronon de corps de requte au
    navigateur.
    </li>
    <li>GET_BODY_CHUNK <br />Reoit un autre tronon de donnes de la
    requte si elle n'a pas encore t transmise intgralement. Ce type
    de transmission est ncessaire car les paquets possdent une taille
    maximale fixe, et des quantits quelconques de donnes peuvent tre
    contenues dans le corps de la requte (pour un chargement de
    fichier, par exemple). Notez que cela n'a rien  voir avec le
    transfert HTTP fractionn.</li>
    <li>END_RESPONSE <br /> Termine le cycle du traitement de la
    requte.</li>
    </ul>
    <p>Chaque message est associ  un paquet de donnes format
    diffremment. Voir plus loin les structures des paquets de rponses
    pour plus de dtails.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="basppacketstruct" id="basppacketstruct">Structure de base des paquets</a></h2>
    <p>Ce protocole hrite en partie de XDR, mais il diffre sur de
    nombreux points (pas d'alignement sur 4 bits, par exemple).</p>
    <p>AJP13 utilise les octets selon leur ordre d'arrive par le rseau
    pour tous les types de donnes.</p>
    <p>Le protocole comporte quatre types de donnes : octets, boolens,
    entiers et chanes de caractres.</p>
    <dl>
    <dt><strong>Octet</strong></dt><dd>Un seul octet.</dd>
    <dt><strong>Boolen</strong></dt>
      <dd>Un seul octet, <code>1 = vrai</code>, <code>0 = faux</code>.
      L'utilisation d'autres valeurs non nulles (dans le style C) peut
      fonctionner dans certains cas, mais pas dans certains autres..</dd>
    <dt><strong>Entier</strong></dt>
      <dd>Un nombre compris entre <code>0 et 2^16 (32768)</code>, stock
      sur 2 octets en dbutant par l'octet de poids forts.</dd>
    <dt><strong>Chane</strong></dt>
      <dd>Une chane de taille variable (longueur limite  2^16). Elle
      est code comme suit : les deux premiers octets reprsentent la
      longueur de la chane, les octets suivants constituent la chane
      proprement dite (y compris le '\0' final). Notez que la longueur
      encode dans les deux premiers octets ne prend pas en compte le
      '\0' final, de la mme manire que <code>strlen</code>. Cela peut
      prter  confusion du point de vue de Java qui est surcharg de
      dclarations d'autoincrmentation tranges destines  traiter
      ces terminateurs. Je suppose que le but dans lequel cela a
      t conu ainsi tait de permettre au code C d'tre plus efficace
      lors de la lecture de chanes en provenance du conteneur de
      servlets -- avec le caractre \0 final, le code C peut transmettre
      des rfrences dans un seul tampon, sans avoir  effectuer de
      copie. En l'absence du caractre \0 final, le code C doit
      effectuer une copie afin de pouvoir tenir compte de sa notion de
      chane.</dd>
    </dl>

  <h3>Taille du paquet</h3>
    <p>Selon la majorit du code, la taille maximale du paquet est de
    <code>8 * 1024 bytes (8K)</code>. La taille relle du paquet est
    encode dans l'en-tte.</p>
  
  <h3>En-ttes de paquet</h3>
    <p>Les paquets envoys par le serveur vers le conteneur commencent
    par <code>0x1234</code>. Les paquets envoys par le conteneur vers
    le serveur commencent par <code>AB</code> (c'est  dire le code
    ASCII de A suivi du code ASCII de B). Ensuite, vient un entier (cod
    comme ci-dessus) reprsentant la longueur des donnes transmises.
    Bien que ceci puisse faire croire que la taille maximale des donnes
    est de 2^16, le code dfinit en fait ce maximum  8K.</p>
    <table>
           
      <tr>
        <th colspan="6"><em>Format du paquet (Serveur-&gt;Conteneur)</em></th>
      </tr>
      <tr>
        <th>Octet</th>
        <td>0</td>
        <td>1</td>
        <td>2</td>
        <td>3</td>
        <td>4...(n+3)</td>
      </tr>
      <tr>
        <th>Contenu</th>
        <td>0x12</td>
        <td>0x34</td>
        <td colspan="2">Taille des donnes (n)</td>
        <td>Data</td>
      </tr>
    </table>
    <table>
       
      <tr>
        <th colspan="6"><em>Format du paquet
	(Conteneur-&gt;Serveur)</em></th>
      </tr>
      <tr>
        <th>Octet</th>
        <td>0</td>
        <td>1</td>
        <td>2</td>
        <td>3</td>
        <td>4...(n+3)</td>
      </tr>
      <tr>
        <th>Contenu</th>
        <td>A</td>
        <td>B</td>
        <td colspan="2">Taille des donnes (n)</td>
        <td>Data</td>
      </tr>
    </table>
    <p>Pour la plupart des paquets, le premier octet de la charge utile
    encode le type de message,  l'exception des paquets contenant un
    corps de requte envoys du serveur vers le conteneur -- ils
    comportent un en-tte standard (<code>0x1234</code> suivi de la taille
    du paquet), mais celui-ci n'est suivi d'aucun prfixe.</p>
     <p>Le serveur web peut envoyer les messages suivants au conteneur
     de servlets :</p>
    <table>
       
      <tr>
        <td>Code</td>
        <td>Type de paquet</td>
        <td>Signification</td>
      </tr>
      <tr>
        <td>2</td>
        <td>Fait suivre la requte</td>
        <td>Dbute le cycle de traitement de la requte avec les donnes
	qui suivent.</td>
      </tr>
      <tr>
        <td>7</td>
        <td>Arrt</td>
        <td>Le serveur web demande au conteneur de s'arrter.</td>
      </tr>
      <tr>
        <td>8</td>
        <td>Ping</td>
        <td>Le serveur web demande au conteneur de prendre le contrle
	(phase de connexion scurise).</td>
      </tr>
      <tr>
        <td>10</td>
        <td>CPing</td>
        <td>Le serveur web demande au conteneur de rpondre rapidement
	avec un CPong.
        </td>
      </tr>
      <tr>
        <td>none</td>
        <td>Donnes</td>
        <td>Taille (2 octets) et les donnes correspondantes.</td>
      </tr>
    </table>
    <p> des fins de scurit, le conteneur n'effectuera rellement son
    <code>Arrt</code> que si la demande provient de la machine par
    laquelle il est hberg.</p>
    <p>Le premier paquet <code>Donnes</code> est envoy immdiatement
    aprs le paquet <code>Faire suivre la requte</code> par le serveur
    web.</p>
    <p>Le conteneur de servlets peut envoyer les types de messages
    suivants au serveur web :</p>
    <table>
       
      <tr>
        <td>Code</td>
        <td>Type de paquet</td>
        <td>Signification</td>
      </tr>
      <tr>
        <td>3</td>
        <td>Envoi d'un tronon de corps</td>
        <td>Envoi d'un tronon de corps depuis le conteneur de servlets
	vers le serveur web (et probablement vers le navigateur).</td>
      </tr>
      <tr>
        <td>4</td>
        <td>Envoie les en-ttes</td>
        <td>Envoi des en-ttes de rponse depuis le conteneur de
	servlets vers le serveur web (et probablement vers le
	navigateur).</td>
      </tr>
      <tr>
        <td>5</td>
        <td>Fin de la rponse</td>
        <td>Marque la fin de la rponse (et par consquent du cycle de
	traitement de la requte).
        </td>
      </tr>
      <tr>
        <td>6</td>
        <td>Rception du tronon de corps suivant</td>
        <td>Rception de la suite des donnes de la requte si elles
	n'ont pas encore t entirement transmises.</td>
      </tr>
      <tr>
        <td>9</td>
        <td>Rponse CPong</td>
        <td>La rponse  une requte CPing</td>
      </tr>
    </table>
    <p>Chacun des messages ci-dessus possde une structure interne
    diffrente dont vous trouverez les dtails ci-dessous.</p>
  
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="rpacetstruct" id="rpacetstruct">Structure des paquets de
requte</a></h2>
    <p>Pour les messages de type <em>Faire suivre la requte</em> depuis
    le serveur vers le conteneur :</p>
    <div class="example"><pre>AJP13_FORWARD_REQUEST :=
    prefix_code      (byte) 0x02 = JK_AJP13_FORWARD_REQUEST
    method           (byte)
    protocol         (string)
    req_uri          (string)
    remote_addr      (string)
    remote_host      (string)
    server_name      (string)
    server_port      (integer)
    is_ssl           (boolean)
    num_headers      (integer)
    request_headers *(req_header_name req_header_value)
    attributes      *(attribut_name attribute_value)
    request_terminator (byte) OxFF</pre></div>
    <p>Les <code>request_headers</code> possdent la structure suivante
    :
    </p><div class="example"><pre>req_header_name :=
    sc_req_header_name | (string)  [voir ci-dessous pour la manire dont
    ceci est interprt]

sc_req_header_name := 0xA0xx (integer)

req_header_value := (string)</pre></div>
    <p>Les <code>attributes</code> sont optionnels et possdent la
    structure suivante :</p>
    <div class="example"><pre>attribute_name := sc_a_name | (sc_a_req_attribute string)

attribute_value := (string)</pre></div>
    <p>Un des en-ttes les plus importants est
    <code>content-length</code>, car il indique si le conteneur doit ou
    non attendre un autre paquet immdiatement.</p>
  <h3>Description dtaille de la requte que le serveur
  fait suivre vers le conteneur
  </h3>
  <h3>Prfixe de la requte</h3>
    <p>Pour toutes les requtes, ce prfixe est 2. Voir ci-dessus pour
    les dtails des autres codes de prfixes.</p>
  
  <h3>Mthode</h3>
    <p>La mthode HTTP, encode sous la forme d'un seul octet :</p>
    <table>
      <tr><td>Nom commande</td><td>Code</td></tr>
      <tr><td>OPTIONS</td><td>1</td></tr>
      <tr><td>GET</td><td>2</td></tr>
      <tr><td>HEAD</td><td>3</td></tr>
      <tr><td>POST</td><td>4</td></tr>
      <tr><td>PUT</td><td>5</td></tr>
      <tr><td>DELETE</td><td>6</td></tr>
      <tr><td>TRACE</td><td>7</td></tr>
      <tr><td>PROPFIND</td><td>8</td></tr>
      <tr><td>PROPPATCH</td><td>9</td></tr>
      <tr><td>MKCOL</td><td>10</td></tr>
      <tr><td>COPY</td><td>11</td></tr>
      <tr><td>MOVE</td><td>12</td></tr>
      <tr><td>LOCK</td><td>13</td></tr>
      <tr><td>UNLOCK</td><td>14</td></tr>
      <tr><td>ACL</td><td>15</td></tr>
      <tr><td>REPORT</td><td>16</td></tr>
      <tr><td>VERSION-CONTROL</td><td>17</td></tr>
      <tr><td>CHECKIN</td><td>18</td></tr>
      <tr><td>CHECKOUT</td><td>19</td></tr>
      <tr><td>UNCHECKOUT</td><td>20</td></tr>
      <tr><td>SEARCH</td><td>21</td></tr>
      <tr><td>MKWORKSPACE</td><td>22</td></tr>
      <tr><td>UPDATE</td><td>23</td></tr>
      <tr><td>LABEL</td><td>24</td></tr>
      <tr><td>MERGE</td><td>25</td></tr>
      <tr><td>BASELINE_CONTROL</td><td>26</td></tr>
      <tr><td>MKACTIVITY</td><td>27</td></tr>
    </table>
    <p>Les versions futures d'ajp13 pourront transmettre des mthodes
    supplmentaires, mme si elles ne font pas partie de cette
    liste.</p>
  
  <h3>protocol, req_uri, remote_addr, remote_host, server_name,
  server_port, is_ssl</h3>
    <p>Les significations de ces lments sont triviales. Ils sont tous
    obligatoires et seront envoys avec chaque requte.</p>
  
  <h3>En-ttes</h3>
    <p>La structure de <code>request_headers</code> est la suivante
    : tout d'abord, le nombre d'en-ttes <code>num_headers</code> est
    encod, suivi d'une liste de paires nom d'en-tte
    <code>req_header_name</code> / valeur <code>req_header_value</code>.
    Les noms d'en-ttes courants sont cods sous forme d'entiers afin de
    gagner de la place. Si le nom d'en-tte ne fait partie de la liste
    des en-ttes courants, il est encod normalement (une chane de
    caractres prfixe par la taille). La liste des en-ttes courants
    <code>sc_req_header_name</code> avec leurs codes se prsente comme
    suit (il sont tous sensibles  la casse) :</p>
    <table>
      <tr><td>Nom</td><td>Valeur du code</td><td>Nom du code</td></tr>
      <tr><td>accept</td><td>0xA001</td><td>SC_REQ_ACCEPT</td></tr>
      <tr><td>accept-charset</td><td>0xA002</td><td>SC_REQ_ACCEPT_CHARSET
      </td></tr>
      <tr><td>accept-encoding</td><td>0xA003</td><td>SC_REQ_ACCEPT_ENCODING
      </td></tr>
      <tr><td>accept-language</td><td>0xA004</td><td>SC_REQ_ACCEPT_LANGUAGE
      </td></tr>
      <tr><td>authorization</td><td>0xA005</td><td>SC_REQ_AUTHORIZATION</td>
      </tr>
      <tr><td>connection</td><td>0xA006</td><td>SC_REQ_CONNECTION</td></tr>
      <tr><td>content-type</td><td>0xA007</td><td>SC_REQ_CONTENT_TYPE</td>
      </tr>
      <tr><td>content-length</td><td>0xA008</td><td>SC_REQ_CONTENT_LENGTH</td>
      </tr>
      <tr><td>cookie</td><td>0xA009</td><td>SC_REQ_COOKIE</td></tr>
      <tr><td>cookie2</td><td>0xA00A</td><td>SC_REQ_COOKIE2</td></tr>
      <tr><td>host</td><td>0xA00B</td><td>SC_REQ_HOST</td></tr>
      <tr><td>pragma</td><td>0xA00C</td><td>SC_REQ_PRAGMA</td></tr>
      <tr><td>referer</td><td>0xA00D</td><td>SC_REQ_REFERER</td></tr>
      <tr><td>user-agent</td><td>0xA00E</td><td>SC_REQ_USER_AGENT</td></tr>
    </table>
    <p>Le code Java qui lit ceci extrait l'entier reprsent par les
    deux premiers octets, et si le premier octet est
    <code>'0xA0'</code>, il utilise l'entier reprsent par le deuxime
    octet comme index d'un tableau de noms d'en-ttes. Si le premier
    octet n'est pas <code>0xA0</code>, l'entier reprsent par les deux
    octets est considr comme la longueur d'une chane qui est alors
    lue.</p>
    <p>Ceci ne peut fonctionner que si aucun nom d'en-tte ne possde
    une taille suprieure  <code>0x9FFF (==0xA000 - 1)</code>, ce qui
    est vraisemblable, bien qu'un peu arbitraire.</p>
    <div class="note"><h3>Note:</h3>
    L'en-tte <code>content-length</code> est extrmement important.
    S'il est prsent et non nul, le conteneur considre que la requte
    possde un corps (une requte POST, par exemple), et lit
    immdiatement le paquet suivant dans le flux d'entre pour extraire
    ce corps.
    </div>
  
  <h3>Attributs</h3>
    <p>Les attributs prfixs par <code>?</code> (par exemple
    <code>?context</code>) sont tous optionnels. Chacun d'eux est
    reprsent par un octet correspondant au type de l'attribut et par
    sa valeur (chane ou entier). Ils peuvent tre envoys dans un ordre
    quelconque (bien que le code C les envoie dans l'ordre ci-dessous).
    Un code de terminaison spcial est envoy pour signaler la fin de la
    liste des attributs optionnels. La liste des codes est la suivante
    :</p>
    <table>
      <tr><td>Information</td><td>Valeur code</td><td>Type de valeur</td><td>Note</td></tr>
      <tr><td>?context</td><td>0x01</td><td>-</td><td>Non implment
      actuellement
      </td></tr>
      <tr><td>?servlet_path</td><td>0x02</td><td>-</td><td>Non implment
      actuellement
      </td></tr>
      <tr><td>?remote_user</td><td>0x03</td><td>String</td><td /></tr>
      <tr><td>?auth_type</td><td>0x04</td><td>String</td><td /></tr>
      <tr><td>?query_string</td><td>0x05</td><td>String</td><td /></tr>
      <tr><td>?jvm_route</td><td>0x06</td><td>String</td><td /></tr>
      <tr><td>?ssl_cert</td><td>0x07</td><td>String</td><td /></tr>
      <tr><td>?ssl_cipher</td><td>0x08</td><td>String</td><td /></tr>
      <tr><td>?ssl_session</td><td>0x09</td><td>String</td><td /></tr>
      <tr><td>?req_attribute</td><td>0x0A</td><td>String</td><td>Nom (le
      nom de l'attribut vient ensuite)</td></tr>
      <tr><td>?ssl_key_size</td><td>0x0B</td><td>Integer</td><td /></tr>
      <tr><td>are_done</td><td>0xFF</td><td>-</td><td>request_terminator</td></tr>
    </table>
    <p><code>context</code> et <code>servlet_path</code> ne sont pas
    dfinis actuellement par le code C, et la majorit du code Java
    ignore compltement ce qui est envoy par l'intermdiaire de ces
    champs (il va mme parfois s'interrompre si une chane est
    envoye aprs un de ces codes). Je ne sais pas si c'est une bogue ou
    une fonctionnalit non implmente, ou tout simplement du code
    obsolte, mais en tout cas, il n'est pris en charge par aucune des
    deux extrmits de la connexion.</p>
    <p><code>remote_user</code> et <code>auth_type</code> concernent
    probablement l'authentification au niveau HTTP, et contiennent le
    nom de l'utilisateur distant ainsi que le type d'authentification
    utilise pour tablir son identit ( savoir Basic, Digest).</p>
    <p><code>query_string</code>, <code>ssl_cert</code>,
    <code>ssl_cipher</code> et <code>ssl_session</code> contiennent les
    lments HTTP et HTTPS correspondants.</p>
    <p><code>jvm_route</code> est utilis dans le cadre des sessions
    persistantes, en associant une session utilisateur  une instance
    Tomcat particulire en prsence de plusieurs rpartiteurs de
    charge.</p>
    <p>Au del de cette liste de base, tout autre attribut
    supplmentaire peut tre envoy via le code
    <code>req_attribute</code> <code>0x0A</code>. Une paire de chanes
    reprsentant le nom et la valeur de l'attribut est envoye
    immdiatement aprs chaque instance de ce code. Les variables
    d'environnement sont transmises par cette mthode.</p>
    <p>Enfin, lorsque tous les attributs ont t transmis, le
    terminateur d'attributs, <code>0xFF</code>, est envoy. Ce dernier
    indique  la fois la fin de la liste d'attributs et la fin du paquet
    de la requte</p>
  
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="resppacketstruct" id="resppacketstruct">Structure du paquet de la
rponse</a></h2>
    <p>Pour les messages que le conteneur peut renvoyer au
    serveur.</p>
    <div class="example"><pre>AJP13_SEND_BODY_CHUNK :=
  prefix_code   3
  chunk_length  (integer)
  chunk        *(byte)
  chunk_terminator (byte) Ox00


AJP13_SEND_HEADERS :=
  prefix_code       4
  http_status_code  (integer)
  http_status_msg   (string)
  num_headers       (integer)
  response_headers *(res_header_name header_value)

res_header_name :=
    sc_res_header_name | (string)   [voir ci-dessous pour la manire
    dont ceci est interprt]

sc_res_header_name := 0xA0 (byte)

header_value := (string)

AJP13_END_RESPONSE :=
  prefix_code       5
  reuse             (boolean)


AJP13_GET_BODY_CHUNK :=
  prefix_code       6
  requested_length  (integer)</pre></div>
  <h3>Dtails:</h3>
  <h3>Envoi d'un tronon de corps</h3>
    <p>Le tronon se compose essentiellement de donnes binaires et est
    renvoy directement au navigateur.</p>
  
  <h3>Envoi des en-ttes</h3>
    <p>Les code et message d'tat correspondent aux code et message HTTP
    habituels (par exemple <code>200</code> et <code>OK</code>). Les
    noms d'en-ttes de rponses sont cods de la mme faon que les noms
    d'en-ttes de requtes. Voir ci-dessus le codage des en-ttes pour
    plus de dtails  propos de la manire dont les codes se distinguent
    des chanes.<br />
    Les codes des en-ttes courants sont ::</p>
    <table>
      <tr><td>Nom</td><td>Valeur code</td></tr>
      <tr><td>Content-Type</td><td>0xA001</td></tr>
      <tr><td>Content-Language</td><td>0xA002</td></tr>
      <tr><td>Content-Length</td><td>0xA003</td></tr>
      <tr><td>Date</td><td>0xA004</td></tr>
      <tr><td>Last-Modified</td><td>0xA005</td></tr>
      <tr><td>Location</td><td>0xA006</td></tr>
      <tr><td>Set-Cookie</td><td>0xA007</td></tr>
      <tr><td>Set-Cookie2</td><td>0xA008</td></tr>
      <tr><td>Servlet-Engine</td><td>0xA009</td></tr>
      <tr><td>Status</td><td>0xA00A</td></tr>
      <tr><td>WWW-Authenticate</td><td>0xA00B</td></tr>
    </table>
    <p>La valeur de l'en-tte est code immdiatement aprs le code ou
    la chane du nom d'en-tte.</p>
  
  <h3>Fin de la rponse</h3>
    <p>Signale la fin de ce cycle de traitement de requte. Si le
    drapeau <code>reuse</code> est  true <code>(toute valeur autre que
    0 en langage C pur)</code>, cette
    connexion TCP peut tre rutilise pour traiter de nouvelles
    requtes entrantes. Si <code>reuse</code> est  false
    (==0), la connexion sera ferme.</p>
  
  <h3>Rception d'un tronon de corps</h3>
    <p>Le conteneur rclame la suite des donnes de la requte (dans le
    cas o la taille du corps tait trop importante pour pouvoir tre
    contenue dans le premier paquet envoy, o lorsque la requte est
    fractionne). Le serveur va alors envoyer un paquet contenant une
    quantit de donnes correspondant au minimum de la
    <code>request_length</code>, la taille maximale de corps envoye
    <code>(8186 (8 Koctets - 6))</code>, et le nombre rel d'octets
    restants  envoyer pour ce corps de requte.<br />
    S'il ne reste plus de donnes  transmettre pour ce corps de requte
    (c'est  dire si le conteneur de servlets tente de lire au del de
    la fin du corps), le serveur va renvoyer un paquet <em>vide</em>
    dont la charge utile est de longueur 0 et se prsentant sous la
    forme <code>(0x12,0x34,0x00,0x00)</code>.</p>
  
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_ajp.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_ajp.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_proxy_ajp.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_proxy_ajp.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>