/* ColorTransformation.c generated by valac 0.34.7, the Vala compiler
 * generated from ColorTransformation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RGB_ANALYTIC_PIXEL (rgb_analytic_pixel_get_type ())
typedef struct _RGBAnalyticPixel RGBAnalyticPixel;

#define TYPE_HSV_ANALYTIC_PIXEL (hsv_analytic_pixel_get_type ())
typedef struct _HSVAnalyticPixel HSVAnalyticPixel;

#define TYPE_COMPOSITION_MODE (composition_mode_get_type ())

#define TYPE_PIXEL_FORMAT (pixel_format_get_type ())

#define TYPE_PIXEL_TRANSFORMATION_TYPE (pixel_transformation_type_get_type ())

#define TYPE_PIXEL_TRANSFORMATION_BUNDLE (pixel_transformation_bundle_get_type ())
#define PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle))
#define PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))
#define IS_PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define IS_PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))

typedef struct _PixelTransformationBundle PixelTransformationBundle;
typedef struct _PixelTransformationBundleClass PixelTransformationBundleClass;
typedef struct _PixelTransformationBundlePrivate PixelTransformationBundlePrivate;

#define TYPE_PIXEL_TRANSFORMATION (pixel_transformation_get_type ())
#define PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformation))
#define PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))
#define IS_PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION))
#define IS_PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION))
#define PIXEL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))

typedef struct _PixelTransformation PixelTransformation;
typedef struct _PixelTransformationClass PixelTransformationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))

#define TYPE_HSV_TRANSFORMATION (hsv_transformation_get_type ())
#define HSV_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSV_TRANSFORMATION, HSVTransformation))
#define HSV_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSV_TRANSFORMATION, HSVTransformationClass))
#define IS_HSV_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSV_TRANSFORMATION))
#define IS_HSV_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSV_TRANSFORMATION))
#define HSV_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSV_TRANSFORMATION, HSVTransformationClass))

typedef struct _HSVTransformation HSVTransformation;
typedef struct _HSVTransformationClass HSVTransformationClass;

#define TYPE_EXPANSION_TRANSFORMATION (expansion_transformation_get_type ())
#define EXPANSION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation))
#define EXPANSION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationClass))
#define IS_EXPANSION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPANSION_TRANSFORMATION))
#define IS_EXPANSION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPANSION_TRANSFORMATION))
#define EXPANSION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationClass))

typedef struct _ExpansionTransformation ExpansionTransformation;
typedef struct _ExpansionTransformationClass ExpansionTransformationClass;
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define TYPE_SHADOW_DETAIL_TRANSFORMATION (shadow_detail_transformation_get_type ())
#define SHADOW_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation))
#define SHADOW_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationClass))
#define IS_SHADOW_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION))
#define IS_SHADOW_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHADOW_DETAIL_TRANSFORMATION))
#define SHADOW_DETAIL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationClass))

typedef struct _ShadowDetailTransformation ShadowDetailTransformation;
typedef struct _ShadowDetailTransformationClass ShadowDetailTransformationClass;

#define TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION (highlight_detail_transformation_get_type ())
#define HIGHLIGHT_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation))
#define HIGHLIGHT_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationClass))
#define IS_HIGHLIGHT_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION))
#define IS_HIGHLIGHT_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION))
#define HIGHLIGHT_DETAIL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationClass))

typedef struct _HighlightDetailTransformation HighlightDetailTransformation;
typedef struct _HighlightDetailTransformationClass HighlightDetailTransformationClass;

#define TYPE_RGB_TRANSFORMATION (rgb_transformation_get_type ())
#define RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformation))
#define RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))
#define IS_RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_TRANSFORMATION))
#define IS_RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_TRANSFORMATION))
#define RGB_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))

typedef struct _RGBTransformation RGBTransformation;
typedef struct _RGBTransformationClass RGBTransformationClass;

#define TYPE_TEMPERATURE_TRANSFORMATION (temperature_transformation_get_type ())
#define TEMPERATURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation))
#define TEMPERATURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationClass))
#define IS_TEMPERATURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPERATURE_TRANSFORMATION))
#define IS_TEMPERATURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPERATURE_TRANSFORMATION))
#define TEMPERATURE_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationClass))

typedef struct _TemperatureTransformation TemperatureTransformation;
typedef struct _TemperatureTransformationClass TemperatureTransformationClass;

#define TYPE_TINT_TRANSFORMATION (tint_transformation_get_type ())
#define TINT_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TINT_TRANSFORMATION, TintTransformation))
#define TINT_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TINT_TRANSFORMATION, TintTransformationClass))
#define IS_TINT_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TINT_TRANSFORMATION))
#define IS_TINT_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TINT_TRANSFORMATION))
#define TINT_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TINT_TRANSFORMATION, TintTransformationClass))

typedef struct _TintTransformation TintTransformation;
typedef struct _TintTransformationClass TintTransformationClass;

#define TYPE_SATURATION_TRANSFORMATION (saturation_transformation_get_type ())
#define SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformation))
#define SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))
#define IS_SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SATURATION_TRANSFORMATION))
#define IS_SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SATURATION_TRANSFORMATION))
#define SATURATION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))

typedef struct _SaturationTransformation SaturationTransformation;
typedef struct _SaturationTransformationClass SaturationTransformationClass;

#define TYPE_EXPOSURE_TRANSFORMATION (exposure_transformation_get_type ())
#define EXPOSURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation))
#define EXPOSURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationClass))
#define IS_EXPOSURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPOSURE_TRANSFORMATION))
#define IS_EXPOSURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPOSURE_TRANSFORMATION))
#define EXPOSURE_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationClass))

typedef struct _ExposureTransformation ExposureTransformation;
typedef struct _ExposureTransformationClass ExposureTransformationClass;

#define TYPE_CONTRAST_TRANSFORMATION (contrast_transformation_get_type ())
#define CONTRAST_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation))
#define CONTRAST_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationClass))
#define IS_CONTRAST_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTRAST_TRANSFORMATION))
#define IS_CONTRAST_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTRAST_TRANSFORMATION))
#define CONTRAST_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationClass))

typedef struct _ContrastTransformation ContrastTransformation;
typedef struct _ContrastTransformationClass ContrastTransformationClass;

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))

#define TYPE_PIXEL_TRANSFORMER (pixel_transformer_get_type ())
#define PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformer))
#define PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))
#define IS_PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMER))
#define IS_PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMER))
#define PIXEL_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))

typedef struct _PixelTransformer PixelTransformer;
typedef struct _PixelTransformerClass PixelTransformerClass;
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
typedef struct _ParamSpecPixelTransformationBundle ParamSpecPixelTransformationBundle;
typedef struct _PixelTransformationPrivate PixelTransformationPrivate;
typedef struct _ParamSpecPixelTransformation ParamSpecPixelTransformation;
typedef struct _RGBTransformationPrivate RGBTransformationPrivate;
typedef struct _HSVTransformationPrivate HSVTransformationPrivate;
typedef struct _TintTransformationPrivate TintTransformationPrivate;
typedef struct _TemperatureTransformationPrivate TemperatureTransformationPrivate;
typedef struct _SaturationTransformationPrivate SaturationTransformationPrivate;
typedef struct _ExposureTransformationPrivate ExposureTransformationPrivate;
typedef struct _ContrastTransformationPrivate ContrastTransformationPrivate;
typedef struct _PixelTransformerPrivate PixelTransformerPrivate;
typedef struct _ParamSpecPixelTransformer ParamSpecPixelTransformer;

#define TYPE_RGB_HISTOGRAM (rgb_histogram_get_type ())
#define RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM, RGBHistogram))
#define RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM, RGBHistogramClass))
#define IS_RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM))
#define IS_RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM))
#define RGB_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM, RGBHistogramClass))

typedef struct _RGBHistogram RGBHistogram;
typedef struct _RGBHistogramClass RGBHistogramClass;
typedef struct _RGBHistogramPrivate RGBHistogramPrivate;
typedef struct _ParamSpecRGBHistogram ParamSpecRGBHistogram;

#define TYPE_INTENSITY_HISTOGRAM (intensity_histogram_get_type ())
#define INTENSITY_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INTENSITY_HISTOGRAM, IntensityHistogram))
#define INTENSITY_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramClass))
#define IS_INTENSITY_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INTENSITY_HISTOGRAM))
#define IS_INTENSITY_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INTENSITY_HISTOGRAM))
#define INTENSITY_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramClass))

typedef struct _IntensityHistogram IntensityHistogram;
typedef struct _IntensityHistogramClass IntensityHistogramClass;
typedef struct _IntensityHistogramPrivate IntensityHistogramPrivate;
typedef struct _ParamSpecIntensityHistogram ParamSpecIntensityHistogram;
typedef struct _ExpansionTransformationPrivate ExpansionTransformationPrivate;
typedef struct _ShadowDetailTransformationPrivate ShadowDetailTransformationPrivate;

#define TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION (hermite_gamma_approximation_function_get_type ())
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunction))
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionClass))
#define IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION))
#define IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION))
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionClass))

typedef struct _HermiteGammaApproximationFunction HermiteGammaApproximationFunction;
typedef struct _HermiteGammaApproximationFunctionClass HermiteGammaApproximationFunctionClass;
#define _hermite_gamma_approximation_function_unref0(var) ((var == NULL) ? NULL : (var = (hermite_gamma_approximation_function_unref (var), NULL)))
typedef struct _HermiteGammaApproximationFunctionPrivate HermiteGammaApproximationFunctionPrivate;
typedef struct _ParamSpecHermiteGammaApproximationFunction ParamSpecHermiteGammaApproximationFunction;
typedef struct _HighlightDetailTransformationPrivate HighlightDetailTransformationPrivate;
#define _intensity_histogram_unref0(var) ((var == NULL) ? NULL : (var = (intensity_histogram_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RGBAnalyticPixel {
	gfloat red;
	gfloat green;
	gfloat blue;
};

struct _HSVAnalyticPixel {
	gfloat hue;
	gfloat saturation;
	gfloat light_value;
};

typedef enum  {
	COMPOSITION_MODE_NONE,
	COMPOSITION_MODE_RGB_MATRIX
} CompositionMode;

typedef enum  {
	PIXEL_FORMAT_RGB,
	PIXEL_FORMAT_HSV
} PixelFormat;

typedef enum  {
	PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION,
	PIXEL_TRANSFORMATION_TYPE_SHADOWS,
	PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS,
	PIXEL_TRANSFORMATION_TYPE_TEMPERATURE,
	PIXEL_TRANSFORMATION_TYPE_TINT,
	PIXEL_TRANSFORMATION_TYPE_SATURATION,
	PIXEL_TRANSFORMATION_TYPE_EXPOSURE,
	PIXEL_TRANSFORMATION_TYPE_CONTRAST
} PixelTransformationType;

struct _PixelTransformationBundle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformationBundlePrivate * priv;
};

struct _PixelTransformationBundleClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformationBundle *self);
};

struct _PixelTransformationBundlePrivate {
	GeeHashMap* map;
};

struct _ParamSpecPixelTransformationBundle {
	GParamSpec parent_instance;
};

struct _PixelTransformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformationPrivate * priv;
};

struct _PixelTransformationClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformation *self);
	PixelFormat (*get_preferred_format) (PixelTransformation* self);
	CompositionMode (*get_composition_mode) (PixelTransformation* self);
	void (*compose_with) (PixelTransformation* self, PixelTransformation* other);
	gboolean (*is_identity) (PixelTransformation* self);
	void (*transform_pixel_hsv) (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
	void (*transform_pixel_rgb) (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
	gchar* (*to_string) (PixelTransformation* self);
	PixelTransformation* (*copy) (PixelTransformation* self);
};

struct _PixelTransformationPrivate {
	PixelTransformationType type;
};

struct _ParamSpecPixelTransformation {
	GParamSpec parent_instance;
};

struct _RGBTransformation {
	PixelTransformation parent_instance;
	RGBTransformationPrivate * priv;
	gfloat* matrix_entries;
	gint matrix_entries_length1;
	gboolean identity;
};

struct _RGBTransformationClass {
	PixelTransformationClass parent_class;
};

struct _HSVTransformation {
	PixelTransformation parent_instance;
	HSVTransformationPrivate * priv;
};

struct _HSVTransformationClass {
	PixelTransformationClass parent_class;
};

struct _TintTransformation {
	RGBTransformation parent_instance;
	TintTransformationPrivate * priv;
};

struct _TintTransformationClass {
	RGBTransformationClass parent_class;
};

struct _TintTransformationPrivate {
	gfloat parameter;
};

struct _TemperatureTransformation {
	RGBTransformation parent_instance;
	TemperatureTransformationPrivate * priv;
};

struct _TemperatureTransformationClass {
	RGBTransformationClass parent_class;
};

struct _TemperatureTransformationPrivate {
	gfloat parameter;
};

struct _SaturationTransformation {
	RGBTransformation parent_instance;
	SaturationTransformationPrivate * priv;
};

struct _SaturationTransformationClass {
	RGBTransformationClass parent_class;
};

struct _SaturationTransformationPrivate {
	gfloat parameter;
};

struct _ExposureTransformation {
	RGBTransformation parent_instance;
	ExposureTransformationPrivate * priv;
};

struct _ExposureTransformationClass {
	RGBTransformationClass parent_class;
};

struct _ExposureTransformationPrivate {
	gfloat parameter;
};

struct _ContrastTransformation {
	RGBTransformation parent_instance;
	ContrastTransformationPrivate * priv;
};

struct _ContrastTransformationClass {
	RGBTransformationClass parent_class;
};

struct _ContrastTransformationPrivate {
	gfloat parameter;
};

struct _PixelTransformer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformerPrivate * priv;
};

struct _PixelTransformerClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformer *self);
};

struct _PixelTransformerPrivate {
	GeeArrayList* transformations;
	PixelTransformation** optimized_transformations;
	gint optimized_transformations_length1;
	gint _optimized_transformations_size_;
	gint optimized_slots_used;
};

struct _ParamSpecPixelTransformer {
	GParamSpec parent_instance;
};

struct _RGBHistogram {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RGBHistogramPrivate * priv;
};

struct _RGBHistogramClass {
	GTypeClass parent_class;
	void (*finalize) (RGBHistogram *self);
};

struct _RGBHistogramPrivate {
	gint* red_counts;
	gint red_counts_length1;
	gint _red_counts_size_;
	gint* green_counts;
	gint green_counts_length1;
	gint _green_counts_size_;
	gint* blue_counts;
	gint blue_counts_length1;
	gint _blue_counts_size_;
	gint* qualitative_red_counts;
	gint qualitative_red_counts_length1;
	gint _qualitative_red_counts_size_;
	gint* qualitative_green_counts;
	gint qualitative_green_counts_length1;
	gint _qualitative_green_counts_size_;
	gint* qualitative_blue_counts;
	gint qualitative_blue_counts_length1;
	gint _qualitative_blue_counts_size_;
	GdkPixbuf* graphic;
};

struct _ParamSpecRGBHistogram {
	GParamSpec parent_instance;
};

struct _IntensityHistogram {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IntensityHistogramPrivate * priv;
};

struct _IntensityHistogramClass {
	GTypeClass parent_class;
	void (*finalize) (IntensityHistogram *self);
};

struct _IntensityHistogramPrivate {
	gint* counts;
	gint counts_length1;
	gint _counts_size_;
	gfloat* probabilities;
	gint probabilities_length1;
	gint _probabilities_size_;
	gfloat* cumulative_probabilities;
	gint cumulative_probabilities_length1;
	gint _cumulative_probabilities_size_;
};

struct _ParamSpecIntensityHistogram {
	GParamSpec parent_instance;
};

struct _ExpansionTransformation {
	HSVTransformation parent_instance;
	ExpansionTransformationPrivate * priv;
};

struct _ExpansionTransformationClass {
	HSVTransformationClass parent_class;
};

struct _ExpansionTransformationPrivate {
	gfloat* remap_table;
	gint remap_table_length1;
	gint _remap_table_size_;
	gint low_kink;
	gint high_kink;
};

struct _ShadowDetailTransformation {
	HSVTransformation parent_instance;
	ShadowDetailTransformationPrivate * priv;
};

struct _ShadowDetailTransformationClass {
	HSVTransformationClass parent_class;
};

struct _ShadowDetailTransformationPrivate {
	gfloat intensity;
	gfloat* remap_table;
	gint remap_table_length1;
	gint _remap_table_size_;
};

struct _HermiteGammaApproximationFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HermiteGammaApproximationFunctionPrivate * priv;
};

struct _HermiteGammaApproximationFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (HermiteGammaApproximationFunction *self);
};

struct _HermiteGammaApproximationFunctionPrivate {
	gfloat x_scale;
	gfloat nonzero_interval_upper;
};

struct _ParamSpecHermiteGammaApproximationFunction {
	GParamSpec parent_instance;
};

struct _HighlightDetailTransformation {
	HSVTransformation parent_instance;
	HighlightDetailTransformationPrivate * priv;
};

struct _HighlightDetailTransformationClass {
	HSVTransformationClass parent_class;
};

struct _HighlightDetailTransformationPrivate {
	gfloat intensity;
	gfloat* remap_table;
	gint remap_table_length1;
	gint _remap_table_size_;
};


static gpointer pixel_transformation_bundle_parent_class = NULL;
static PixelTransformationBundle* pixel_transformation_bundle_copied_color_adjustments;
static PixelTransformationBundle* pixel_transformation_bundle_copied_color_adjustments = NULL;
static gpointer pixel_transformation_parent_class = NULL;
static gpointer rgb_transformation_parent_class = NULL;
static gpointer hsv_transformation_parent_class = NULL;
static gpointer tint_transformation_parent_class = NULL;
static gpointer temperature_transformation_parent_class = NULL;
static gpointer saturation_transformation_parent_class = NULL;
static gpointer exposure_transformation_parent_class = NULL;
static gpointer contrast_transformation_parent_class = NULL;
static gpointer pixel_transformer_parent_class = NULL;
static gpointer rgb_histogram_parent_class = NULL;
static gpointer intensity_histogram_parent_class = NULL;
static gpointer expansion_transformation_parent_class = NULL;
static gpointer shadow_detail_transformation_parent_class = NULL;
static gpointer hermite_gamma_approximation_function_parent_class = NULL;
static gpointer highlight_detail_transformation_parent_class = NULL;

GType rgb_analytic_pixel_get_type (void) G_GNUC_CONST;
RGBAnalyticPixel* rgb_analytic_pixel_dup (const RGBAnalyticPixel* self);
void rgb_analytic_pixel_free (RGBAnalyticPixel* self);
#define RGB_ANALYTIC_PIXEL_INV_255 (1.0f / 255.0f)
void rgb_analytic_pixel_init (RGBAnalyticPixel *self);
void rgb_analytic_pixel_init_from_components (RGBAnalyticPixel *self, gfloat red, gfloat green, gfloat blue);
void rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self, guchar red_quantized, guchar green_quantized, guchar blue_quantized);
GType hsv_analytic_pixel_get_type (void) G_GNUC_CONST;
HSVAnalyticPixel* hsv_analytic_pixel_dup (const HSVAnalyticPixel* self);
void hsv_analytic_pixel_free (HSVAnalyticPixel* self);
void rgb_analytic_pixel_init_from_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* hsv_pixel);
void hsv_analytic_pixel_to_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* result);
guchar rgb_analytic_pixel_quantized_red (RGBAnalyticPixel *self);
guchar rgb_analytic_pixel_quantized_green (RGBAnalyticPixel *self);
guchar rgb_analytic_pixel_quantized_blue (RGBAnalyticPixel *self);
gboolean rgb_analytic_pixel_equals (RGBAnalyticPixel *self, RGBAnalyticPixel* rhs);
guint rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self);
void rgb_analytic_pixel_to_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* result);
void hsv_analytic_pixel_init_from_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* p);
#define HSV_ANALYTIC_PIXEL_INV_255 (1.0f / 255.0f)
void hsv_analytic_pixel_init (HSVAnalyticPixel *self);
void hsv_analytic_pixel_init_from_components (HSVAnalyticPixel *self, gfloat hue, gfloat saturation, gfloat light_value);
void hsv_analytic_pixel_init_from_quantized_components (HSVAnalyticPixel *self, guchar hue_quantized, guchar saturation_quantized, guchar light_value_quantized);
gboolean hsv_analytic_pixel_equals (HSVAnalyticPixel *self, HSVAnalyticPixel* rhs);
guint hsv_analytic_pixel_hash_code (HSVAnalyticPixel *self);
GType composition_mode_get_type (void) G_GNUC_CONST;
GType pixel_format_get_type (void) G_GNUC_CONST;
GType pixel_transformation_type_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_bundle_ref (gpointer instance);
void pixel_transformation_bundle_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation_bundle (GValue* value, gpointer v_object);
void value_take_pixel_transformation_bundle (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation_bundle (const GValue* value);
GType pixel_transformation_bundle_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_ref (gpointer instance);
void pixel_transformation_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation (GValue* value, gpointer v_object);
void value_take_pixel_transformation (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation (const GValue* value);
GType pixel_transformation_get_type (void) G_GNUC_CONST;
#define PIXEL_TRANSFORMATION_BUNDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundlePrivate))
enum  {
	PIXEL_TRANSFORMATION_BUNDLE_DUMMY_PROPERTY
};
PixelTransformationBundle* pixel_transformation_bundle_new (void);
PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type);
PixelTransformationBundle* pixel_transformation_bundle_get_copied_color_adjustments (void);
void pixel_transformation_bundle_set_copied_color_adjustments (PixelTransformationBundle* adjustments);
gboolean pixel_transformation_bundle_has_copied_color_adjustments (void);
void pixel_transformation_bundle_set (PixelTransformationBundle* self, PixelTransformation* transformation);
PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self);
void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self);
ExpansionTransformation* expansion_transformation_new_from_extrema (gint black_point, gint white_point);
ExpansionTransformation* expansion_transformation_construct_from_extrema (GType object_type, gint black_point, gint white_point);
GType hsv_transformation_get_type (void) G_GNUC_CONST;
GType expansion_transformation_get_type (void) G_GNUC_CONST;
ShadowDetailTransformation* shadow_detail_transformation_new (gfloat user_intensity);
ShadowDetailTransformation* shadow_detail_transformation_construct (GType object_type, gfloat user_intensity);
GType shadow_detail_transformation_get_type (void) G_GNUC_CONST;
HighlightDetailTransformation* highlight_detail_transformation_new (gfloat user_intensity);
HighlightDetailTransformation* highlight_detail_transformation_construct (GType object_type, gfloat user_intensity);
GType highlight_detail_transformation_get_type (void) G_GNUC_CONST;
TemperatureTransformation* temperature_transformation_new (gfloat client_parameter);
TemperatureTransformation* temperature_transformation_construct (GType object_type, gfloat client_parameter);
GType rgb_transformation_get_type (void) G_GNUC_CONST;
GType temperature_transformation_get_type (void) G_GNUC_CONST;
TintTransformation* tint_transformation_new (gfloat client_param);
TintTransformation* tint_transformation_construct (GType object_type, gfloat client_param);
GType tint_transformation_get_type (void) G_GNUC_CONST;
SaturationTransformation* saturation_transformation_new (gfloat client_parameter);
SaturationTransformation* saturation_transformation_construct (GType object_type, gfloat client_parameter);
GType saturation_transformation_get_type (void) G_GNUC_CONST;
ExposureTransformation* exposure_transformation_new (gfloat client_parameter);
ExposureTransformation* exposure_transformation_construct (GType object_type, gfloat client_parameter);
GType exposure_transformation_get_type (void) G_GNUC_CONST;
ContrastTransformation* contrast_transformation_new (gfloat client_parameter);
ContrastTransformation* contrast_transformation_construct (GType object_type, gfloat client_parameter);
GType contrast_transformation_get_type (void) G_GNUC_CONST;
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_value_map (GValue* value, gpointer v_object);
void value_take_key_value_map (GValue* value, gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
void pixel_transformation_bundle_load (PixelTransformationBundle* self, KeyValueMap* store);
gchar* key_value_map_get_string (KeyValueMap* self, const gchar* key, const gchar* def);
ExpansionTransformation* expansion_transformation_new_from_string (const gchar* encoded_transformation);
ExpansionTransformation* expansion_transformation_construct_from_string (GType object_type, const gchar* encoded_transformation);
gfloat key_value_map_get_float (KeyValueMap* self, const gchar* key, gfloat def);
KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self, const gchar* group);
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type, const gchar* group);
PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self, PixelTransformationType type);
void key_value_map_set_string (KeyValueMap* self, const gchar* key, const gchar* value);
gchar* pixel_transformation_to_string (PixelTransformation* self);
void key_value_map_set_float (KeyValueMap* self, const gchar* key, gfloat value);
gfloat shadow_detail_transformation_get_parameter (ShadowDetailTransformation* self);
gfloat highlight_detail_transformation_get_parameter (HighlightDetailTransformation* self);
gfloat temperature_transformation_get_parameter (TemperatureTransformation* self);
gfloat tint_transformation_get_parameter (TintTransformation* self);
gfloat saturation_transformation_get_parameter (SaturationTransformation* self);
gfloat exposure_transformation_get_parameter (ExposureTransformation* self);
gfloat contrast_transformation_get_parameter (ContrastTransformation* self);
gint pixel_transformation_bundle_get_count (PixelTransformationBundle* self);
GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self);
gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self);
gboolean pixel_transformation_is_identity (PixelTransformation* self);
gpointer pixel_transformer_ref (gpointer instance);
void pixel_transformer_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformer (GValue* value, gpointer v_object);
void value_take_pixel_transformer (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformer (const GValue* value);
GType pixel_transformer_get_type (void) G_GNUC_CONST;
PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self);
PixelTransformer* pixel_transformer_new (void);
PixelTransformer* pixel_transformer_construct (GType object_type);
void pixel_transformer_attach_transformation (PixelTransformer* self, PixelTransformation* trans);
PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self);
static void pixel_transformation_bundle_finalize (PixelTransformationBundle* obj);
#define PIXEL_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXEL_TRANSFORMATION, PixelTransformationPrivate))
enum  {
	PIXEL_TRANSFORMATION_DUMMY_PROPERTY
};
PixelTransformation* pixel_transformation_construct (GType object_type, PixelTransformationType type);
PixelFormat pixel_transformation_get_preferred_format (PixelTransformation* self);
static PixelFormat pixel_transformation_real_get_preferred_format (PixelTransformation* self);
CompositionMode pixel_transformation_get_composition_mode (PixelTransformation* self);
static CompositionMode pixel_transformation_real_get_composition_mode (PixelTransformation* self);
void pixel_transformation_compose_with (PixelTransformation* self, PixelTransformation* other);
static void pixel_transformation_real_compose_with (PixelTransformation* self, PixelTransformation* other);
static gboolean pixel_transformation_real_is_identity (PixelTransformation* self);
void pixel_transformation_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
static void pixel_transformation_real_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
void pixel_transformation_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static void pixel_transformation_real_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static gchar* pixel_transformation_real_to_string (PixelTransformation* self);
PixelTransformation* pixel_transformation_copy (PixelTransformation* self);
static PixelTransformation* pixel_transformation_real_copy (PixelTransformation* self);
static void pixel_transformation_finalize (PixelTransformation* obj);
enum  {
	RGB_TRANSFORMATION_DUMMY_PROPERTY
};
#define RGB_TRANSFORMATION_MATRIX_SIZE 16
RGBTransformation* rgb_transformation_new (PixelTransformationType type);
RGBTransformation* rgb_transformation_construct (GType object_type, PixelTransformationType type);
static PixelFormat rgb_transformation_real_get_preferred_format (PixelTransformation* base);
static CompositionMode rgb_transformation_real_get_composition_mode (PixelTransformation* base);
static void rgb_transformation_real_compose_with (PixelTransformation* base, PixelTransformation* other);
static void rgb_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
static void rgb_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static gboolean rgb_transformation_real_is_identity (PixelTransformation* base);
static PixelTransformation* rgb_transformation_real_copy (PixelTransformation* base);
static void rgb_transformation_finalize (PixelTransformation* obj);
enum  {
	HSV_TRANSFORMATION_DUMMY_PROPERTY
};
HSVTransformation* hsv_transformation_construct (GType object_type, PixelTransformationType type);
static PixelFormat hsv_transformation_real_get_preferred_format (PixelTransformation* base);
static void hsv_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
#define TINT_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TINT_TRANSFORMATION, TintTransformationPrivate))
enum  {
	TINT_TRANSFORMATION_DUMMY_PROPERTY
};
#define TINT_TRANSFORMATION_INTENSITY_FACTOR 0.25f
#define TINT_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define TINT_TRANSFORMATION_MAX_PARAMETER 16.0f
static void tint_transformation_finalize (PixelTransformation* obj);
#define TEMPERATURE_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationPrivate))
enum  {
	TEMPERATURE_TRANSFORMATION_DUMMY_PROPERTY
};
#define TEMPERATURE_TRANSFORMATION_INTENSITY_FACTOR 0.33f
#define TEMPERATURE_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define TEMPERATURE_TRANSFORMATION_MAX_PARAMETER 16.0f
static void temperature_transformation_finalize (PixelTransformation* obj);
#define SATURATION_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationPrivate))
enum  {
	SATURATION_TRANSFORMATION_DUMMY_PROPERTY
};
#define SATURATION_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define SATURATION_TRANSFORMATION_MAX_PARAMETER 16.0f
static void saturation_transformation_finalize (PixelTransformation* obj);
#define EXPOSURE_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationPrivate))
enum  {
	EXPOSURE_TRANSFORMATION_DUMMY_PROPERTY
};
#define EXPOSURE_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define EXPOSURE_TRANSFORMATION_MAX_PARAMETER 16.0f
static void exposure_transformation_finalize (PixelTransformation* obj);
#define CONTRAST_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationPrivate))
enum  {
	CONTRAST_TRANSFORMATION_DUMMY_PROPERTY
};
#define CONTRAST_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define CONTRAST_TRANSFORMATION_MAX_PARAMETER 16.0f
#define CONTRAST_TRANSFORMATION_MAX_CONTRAST_ADJUSTMENT 0.5f
static void contrast_transformation_finalize (PixelTransformation* obj);
#define PIXEL_TRANSFORMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXEL_TRANSFORMER, PixelTransformerPrivate))
enum  {
	PIXEL_TRANSFORMER_DUMMY_PROPERTY
};
PixelTransformer* pixel_transformer_copy (PixelTransformer* self);
static void pixel_transformer_build_optimized_transformations (PixelTransformer* self);
static void pixel_transformer_apply_transformations (PixelTransformer* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
void pixel_transformer_detach_transformation (PixelTransformer* self, PixelTransformation* victim);
void pixel_transformer_replace_transformation (PixelTransformer* self, PixelTransformation* old_trans, PixelTransformation* new_trans);
void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable);
void pixel_transformer_transform_to_other_pixbuf (PixelTransformer* self, GdkPixbuf* source, GdkPixbuf* dest, GCancellable* cancellable);
void pixel_transformer_transform_from_fp (PixelTransformer* self, gfloat** fp_pixel_cache, int* fp_pixel_cache_length1, GdkPixbuf* dest);
static void pixel_transformer_finalize (PixelTransformer* obj);
gpointer rgb_histogram_ref (gpointer instance);
void rgb_histogram_unref (gpointer instance);
GParamSpec* param_spec_rgb_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_rgb_histogram (GValue* value, gpointer v_object);
void value_take_rgb_histogram (GValue* value, gpointer v_object);
gpointer value_get_rgb_histogram (const GValue* value);
GType rgb_histogram_get_type (void) G_GNUC_CONST;
#define RGB_HISTOGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RGB_HISTOGRAM, RGBHistogramPrivate))
enum  {
	RGB_HISTOGRAM_DUMMY_PROPERTY
};
#define RGB_HISTOGRAM_MARKED_BACKGROUND ((guchar) 30)
#define RGB_HISTOGRAM_MARKED_FOREGROUND ((guchar) 210)
#define RGB_HISTOGRAM_UNMARKED_BACKGROUND ((guchar) 120)
#define RGB_HISTOGRAM_GRAPHIC_WIDTH 256
#define RGB_HISTOGRAM_GRAPHIC_HEIGHT 100
RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf);
RGBHistogram* rgb_histogram_construct (GType object_type, GdkPixbuf* pixbuf);
static gint rgb_histogram_correct_snap_to_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i);
static gint rgb_histogram_correct_snap_from_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i);
static void rgb_histogram_smooth_extrema (RGBHistogram* self, gint** count_data, int* count_data_length1);
static void rgb_histogram_prepare_qualitative_counts (RGBHistogram* self);
GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self);
static void rgb_histogram_finalize (RGBHistogram* obj);
gpointer intensity_histogram_ref (gpointer instance);
void intensity_histogram_unref (gpointer instance);
GParamSpec* param_spec_intensity_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_intensity_histogram (GValue* value, gpointer v_object);
void value_take_intensity_histogram (GValue* value, gpointer v_object);
gpointer value_get_intensity_histogram (const GValue* value);
GType intensity_histogram_get_type (void) G_GNUC_CONST;
#define INTENSITY_HISTOGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramPrivate))
enum  {
	INTENSITY_HISTOGRAM_DUMMY_PROPERTY
};
IntensityHistogram* intensity_histogram_new (GdkPixbuf* pixbuf);
IntensityHistogram* intensity_histogram_construct (GType object_type, GdkPixbuf* pixbuf);
gfloat intensity_histogram_get_cumulative_probability (IntensityHistogram* self, gint level);
static void intensity_histogram_finalize (IntensityHistogram* obj);
#define EXPANSION_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationPrivate))
enum  {
	EXPANSION_TRANSFORMATION_DUMMY_PROPERTY
};
#define EXPANSION_TRANSFORMATION_LOW_DISCARD_MASS 0.02f
#define EXPANSION_TRANSFORMATION_HIGH_DISCARD_MASS 0.02f
ExpansionTransformation* expansion_transformation_new (IntensityHistogram* histogram);
ExpansionTransformation* expansion_transformation_construct (GType object_type, IntensityHistogram* histogram);
static void expansion_transformation_build_remap_table (ExpansionTransformation* self);
static void expansion_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result);
static gchar* expansion_transformation_real_to_string (PixelTransformation* base);
gint expansion_transformation_get_white_point (ExpansionTransformation* self);
gint expansion_transformation_get_black_point (ExpansionTransformation* self);
static gboolean expansion_transformation_real_is_identity (PixelTransformation* base);
static PixelTransformation* expansion_transformation_real_copy (PixelTransformation* base);
static void expansion_transformation_finalize (PixelTransformation* obj);
#define SHADOW_DETAIL_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationPrivate))
enum  {
	SHADOW_DETAIL_TRANSFORMATION_DUMMY_PROPERTY
};
#define SHADOW_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT 0.5f
#define SHADOW_DETAIL_TRANSFORMATION_MIN_TONAL_WIDTH 0.1f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_TONAL_WIDTH 1.0f
#define SHADOW_DETAIL_TRANSFORMATION_TONAL_WIDTH 1.0f
#define SHADOW_DETAIL_TRANSFORMATION_MIN_PARAMETER 0.0f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER 32.0f
gpointer hermite_gamma_approximation_function_ref (gpointer instance);
void hermite_gamma_approximation_function_unref (gpointer instance);
GParamSpec* param_spec_hermite_gamma_approximation_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hermite_gamma_approximation_function (GValue* value, gpointer v_object);
void value_take_hermite_gamma_approximation_function (GValue* value, gpointer v_object);
gpointer value_get_hermite_gamma_approximation_function (const GValue* value);
GType hermite_gamma_approximation_function_get_type (void) G_GNUC_CONST;
HermiteGammaApproximationFunction* hermite_gamma_approximation_function_new (gfloat user_interval_upper);
HermiteGammaApproximationFunction* hermite_gamma_approximation_function_construct (GType object_type, gfloat user_interval_upper);
gfloat hermite_gamma_approximation_function_evaluate (HermiteGammaApproximationFunction* self, gfloat x);
static void shadow_detail_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result);
static PixelTransformation* shadow_detail_transformation_real_copy (PixelTransformation* base);
static gboolean shadow_detail_transformation_real_is_identity (PixelTransformation* base);
static void shadow_detail_transformation_finalize (PixelTransformation* obj);
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionPrivate))
enum  {
	HERMITE_GAMMA_APPROXIMATION_FUNCTION_DUMMY_PROPERTY
};
static void hermite_gamma_approximation_function_finalize (HermiteGammaApproximationFunction* obj);
#define HIGHLIGHT_DETAIL_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationPrivate))
enum  {
	HIGHLIGHT_DETAIL_TRANSFORMATION_DUMMY_PROPERTY
};
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT 0.5f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_TONAL_WIDTH 0.1f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_TONAL_WIDTH 1.0f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_TONAL_WIDTH 1.0f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_PARAMETER (-32.0f)
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_PARAMETER 0.0f
static void highlight_detail_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result);
static PixelTransformation* highlight_detail_transformation_real_copy (PixelTransformation* base);
static gboolean highlight_detail_transformation_real_is_identity (PixelTransformation* base);
static void highlight_detail_transformation_finalize (PixelTransformation* obj);
#define AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY 8
#define AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY 100
#define AUTO_ENHANCE_SHADOW_DETECT_INTENSITY_RANGE (AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY - AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY)
#define AUTO_ENHANCE_SHADOW_MODE_HIGH_DISCARD_MASS 0.02f
#define AUTO_ENHANCE_SHADOW_AGGRESSIVENESS_MUL 0.4f
#define AUTO_ENHANCE_EMPIRICAL_DARK 30
PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void rgb_analytic_pixel_init (RGBAnalyticPixel *self) {
#line 14 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 15 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = 0.0f;
#line 16 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = 0.0f;
#line 17 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = 0.0f;
#line 913 "ColorTransformation.c"
}


void rgb_analytic_pixel_init_from_components (RGBAnalyticPixel *self, gfloat red, gfloat green, gfloat blue) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
#line 20 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 22 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = red;
#line 22 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.0f, 1.0f);
#line 22 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = green;
#line 23 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = CLAMP (_tmp2_, 0.0f, 1.0f);
#line 23 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = _tmp3_;
#line 24 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = blue;
#line 24 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = CLAMP (_tmp4_, 0.0f, 1.0f);
#line 24 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = _tmp5_;
#line 944 "ColorTransformation.c"
}


void rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self, guchar red_quantized, guchar green_quantized, guchar blue_quantized) {
	guchar _tmp0_ = '\0';
	guchar _tmp1_ = '\0';
	guchar _tmp2_ = '\0';
#line 27 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 29 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = red_quantized;
#line 29 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = ((gfloat) _tmp0_) * RGB_ANALYTIC_PIXEL_INV_255;
#line 30 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = green_quantized;
#line 30 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = ((gfloat) _tmp1_) * RGB_ANALYTIC_PIXEL_INV_255;
#line 31 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = blue_quantized;
#line 31 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = ((gfloat) _tmp2_) * RGB_ANALYTIC_PIXEL_INV_255;
#line 966 "ColorTransformation.c"
}


void rgb_analytic_pixel_init_from_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* hsv_pixel) {
	RGBAnalyticPixel from_hsv = {0};
	RGBAnalyticPixel _tmp0_ = {0};
	RGBAnalyticPixel _tmp1_ = {0};
	gfloat _tmp2_ = 0.0F;
	RGBAnalyticPixel _tmp3_ = {0};
	gfloat _tmp4_ = 0.0F;
	RGBAnalyticPixel _tmp5_ = {0};
	gfloat _tmp6_ = 0.0F;
#line 34 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (hsv_pixel != NULL);
#line 34 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 35 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_to_rgb (hsv_pixel, &_tmp0_);
#line 35 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	from_hsv = _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = from_hsv;
#line 36 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_.red;
#line 36 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = _tmp2_;
#line 37 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = from_hsv;
#line 37 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_.green;
#line 37 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = _tmp4_;
#line 38 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = from_hsv;
#line 38 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = _tmp5_.blue;
#line 38 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = _tmp6_;
#line 1005 "ColorTransformation.c"
}


guchar rgb_analytic_pixel_quantized_red (RGBAnalyticPixel *self) {
	guchar result = '\0';
	gfloat _tmp0_ = 0.0F;
#line 42 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).red;
#line 42 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (guchar) (_tmp0_ * 255.0f);
#line 42 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1018 "ColorTransformation.c"
}


guchar rgb_analytic_pixel_quantized_green (RGBAnalyticPixel *self) {
	guchar result = '\0';
	gfloat _tmp0_ = 0.0F;
#line 46 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).green;
#line 46 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (guchar) (_tmp0_ * 255.0f);
#line 46 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1031 "ColorTransformation.c"
}


guchar rgb_analytic_pixel_quantized_blue (RGBAnalyticPixel *self) {
	guchar result = '\0';
	gfloat _tmp0_ = 0.0F;
#line 50 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).blue;
#line 50 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (guchar) (_tmp0_ * 255.0f);
#line 50 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1044 "ColorTransformation.c"
}


gboolean rgb_analytic_pixel_equals (RGBAnalyticPixel *self, RGBAnalyticPixel* rhs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gfloat _tmp2_ = 0.0F;
	RGBAnalyticPixel* _tmp3_ = NULL;
	gfloat _tmp4_ = 0.0F;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).red;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = rhs;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = (*_tmp3_).red;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ == _tmp4_) {
#line 1063 "ColorTransformation.c"
		gfloat _tmp5_ = 0.0F;
		RGBAnalyticPixel* _tmp6_ = NULL;
		gfloat _tmp7_ = 0.0F;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = (*self).green;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = rhs;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = (*_tmp6_).green;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 1075 "ColorTransformation.c"
	} else {
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 1079 "ColorTransformation.c"
	}
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_) {
#line 1083 "ColorTransformation.c"
		gfloat _tmp8_ = 0.0F;
		RGBAnalyticPixel* _tmp9_ = NULL;
		gfloat _tmp10_ = 0.0F;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = (*self).blue;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = rhs;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = (*_tmp9_).blue;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp8_ == _tmp10_;
#line 1095 "ColorTransformation.c"
	} else {
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 1099 "ColorTransformation.c"
	}
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1105 "ColorTransformation.c"
}


guint rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self) {
	guint result = 0U;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).red;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = (*self).green;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).blue;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = ((((guint) (_tmp0_ * 255.0f)) << 16) + (((guint) (_tmp1_ * 255.0f)) << 8)) + ((guint) (_tmp2_ * 255.0f));
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1124 "ColorTransformation.c"
}


void rgb_analytic_pixel_to_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* result) {
	HSVAnalyticPixel _tmp0_ = {0};
#line 63 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_init_from_rgb (&_tmp0_, &(*self));
#line 63 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 1136 "ColorTransformation.c"
}


RGBAnalyticPixel* rgb_analytic_pixel_dup (const RGBAnalyticPixel* self) {
	RGBAnalyticPixel* dup;
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dup = g_new0 (RGBAnalyticPixel, 1);
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memcpy (dup, self, sizeof (RGBAnalyticPixel));
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return dup;
#line 1148 "ColorTransformation.c"
}


void rgb_analytic_pixel_free (RGBAnalyticPixel* self) {
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_free (self);
#line 1155 "ColorTransformation.c"
}


GType rgb_analytic_pixel_get_type (void) {
	static volatile gsize rgb_analytic_pixel_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_analytic_pixel_type_id__volatile)) {
		GType rgb_analytic_pixel_type_id;
		rgb_analytic_pixel_type_id = g_boxed_type_register_static ("RGBAnalyticPixel", (GBoxedCopyFunc) rgb_analytic_pixel_dup, (GBoxedFreeFunc) rgb_analytic_pixel_free);
		g_once_init_leave (&rgb_analytic_pixel_type_id__volatile, rgb_analytic_pixel_type_id);
	}
	return rgb_analytic_pixel_type_id__volatile;
}


void hsv_analytic_pixel_init (HSVAnalyticPixel *self) {
#line 74 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 75 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = 0.0f;
#line 76 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = 0.0f;
#line 77 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = 0.0f;
#line 1179 "ColorTransformation.c"
}


void hsv_analytic_pixel_init_from_components (HSVAnalyticPixel *self, gfloat hue, gfloat saturation, gfloat light_value) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
#line 80 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 82 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = hue;
#line 82 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.0f, 1.0f);
#line 82 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = _tmp1_;
#line 83 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = saturation;
#line 83 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = CLAMP (_tmp2_, 0.0f, 1.0f);
#line 83 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = _tmp3_;
#line 84 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = light_value;
#line 84 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = CLAMP (_tmp4_, 0.0f, 1.0f);
#line 84 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = _tmp5_;
#line 1210 "ColorTransformation.c"
}


void hsv_analytic_pixel_init_from_quantized_components (HSVAnalyticPixel *self, guchar hue_quantized, guchar saturation_quantized, guchar light_value_quantized) {
	guchar _tmp0_ = '\0';
	guchar _tmp1_ = '\0';
	guchar _tmp2_ = '\0';
#line 87 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 89 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = hue_quantized;
#line 89 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = ((gfloat) _tmp0_) * HSV_ANALYTIC_PIXEL_INV_255;
#line 90 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = saturation_quantized;
#line 90 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = ((gfloat) _tmp1_) * HSV_ANALYTIC_PIXEL_INV_255;
#line 91 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = light_value_quantized;
#line 91 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = ((gfloat) _tmp2_) * HSV_ANALYTIC_PIXEL_INV_255;
#line 1232 "ColorTransformation.c"
}


void hsv_analytic_pixel_init_from_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* p) {
	gfloat max_component = 0.0F;
	RGBAnalyticPixel _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
	RGBAnalyticPixel _tmp2_ = {0};
	gfloat _tmp3_ = 0.0F;
	gfloat _tmp4_ = 0.0F;
	RGBAnalyticPixel _tmp5_ = {0};
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	gfloat min_component = 0.0F;
	RGBAnalyticPixel _tmp8_ = {0};
	gfloat _tmp9_ = 0.0F;
	RGBAnalyticPixel _tmp10_ = {0};
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	RGBAnalyticPixel _tmp13_ = {0};
	gfloat _tmp14_ = 0.0F;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp53_ = 0.0F;
	gfloat _tmp54_ = 0.0F;
	gfloat _tmp55_ = 0.0F;
	gfloat _tmp56_ = 0.0F;
	gfloat _tmp57_ = 0.0F;
	gfloat _tmp58_ = 0.0F;
#line 94 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 94 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _tmp0_.red;
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *p;
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_.green;
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = MAX (_tmp1_, _tmp3_);
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = *p;
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = _tmp5_.blue;
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = MAX (_tmp4_, _tmp6_);
#line 95 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	max_component = _tmp7_;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = *p;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = _tmp8_.red;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = *p;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_.green;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = MIN (_tmp9_, _tmp11_);
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = *p;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = _tmp13_.blue;
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = MIN (_tmp12_, _tmp14_);
#line 96 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	min_component = _tmp15_;
#line 98 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = max_component;
#line 98 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = _tmp16_;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = max_component;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp18_ != 0.0f) {
#line 1313 "ColorTransformation.c"
		gfloat _tmp19_ = 0.0F;
		gfloat _tmp20_ = 0.0F;
		gfloat _tmp21_ = 0.0F;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp19_ = max_component;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = min_component;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = max_component;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = (_tmp19_ - _tmp20_) / _tmp21_;
#line 1325 "ColorTransformation.c"
	} else {
#line 100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = 0.0f;
#line 1329 "ColorTransformation.c"
	}
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = _tmp17_;
#line 102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = (*self).saturation;
#line 102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp22_ == 0.0f) {
#line 103 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		(*self).hue = 0.0f;
#line 1339 "ColorTransformation.c"
	} else {
		gfloat delta = 0.0F;
		gfloat _tmp23_ = 0.0F;
		gfloat _tmp24_ = 0.0F;
		RGBAnalyticPixel _tmp25_ = {0};
		gfloat _tmp26_ = 0.0F;
		gfloat _tmp27_ = 0.0F;
		gfloat _tmp49_ = 0.0F;
		gfloat _tmp50_ = 0.0F;
		gfloat _tmp52_ = 0.0F;
#line 105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = max_component;
#line 105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp24_ = min_component;
#line 105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		delta = _tmp23_ - _tmp24_;
#line 106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = *p;
#line 106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = _tmp25_.red;
#line 106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = max_component;
#line 106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp26_ == _tmp27_) {
#line 1364 "ColorTransformation.c"
			RGBAnalyticPixel _tmp28_ = {0};
			gfloat _tmp29_ = 0.0F;
			RGBAnalyticPixel _tmp30_ = {0};
			gfloat _tmp31_ = 0.0F;
			gfloat _tmp32_ = 0.0F;
#line 107 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp28_ = *p;
#line 107 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp29_ = _tmp28_.green;
#line 107 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp30_ = *p;
#line 107 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp31_ = _tmp30_.blue;
#line 107 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp32_ = delta;
#line 107 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			(*self).hue = (_tmp29_ - _tmp31_) / _tmp32_;
#line 1382 "ColorTransformation.c"
		} else {
			RGBAnalyticPixel _tmp33_ = {0};
			gfloat _tmp34_ = 0.0F;
			gfloat _tmp35_ = 0.0F;
#line 108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp33_ = *p;
#line 108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp34_ = _tmp33_.green;
#line 108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp35_ = max_component;
#line 108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp34_ == _tmp35_) {
#line 1395 "ColorTransformation.c"
				RGBAnalyticPixel _tmp36_ = {0};
				gfloat _tmp37_ = 0.0F;
				RGBAnalyticPixel _tmp38_ = {0};
				gfloat _tmp39_ = 0.0F;
				gfloat _tmp40_ = 0.0F;
#line 109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp36_ = *p;
#line 109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37_ = _tmp36_.blue;
#line 109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp38_ = *p;
#line 109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39_ = _tmp38_.red;
#line 109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp40_ = delta;
#line 109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				(*self).hue = 2.0f + ((_tmp37_ - _tmp39_) / _tmp40_);
#line 1413 "ColorTransformation.c"
			} else {
				RGBAnalyticPixel _tmp41_ = {0};
				gfloat _tmp42_ = 0.0F;
				gfloat _tmp43_ = 0.0F;
#line 110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_ = *p;
#line 110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42_ = _tmp41_.blue;
#line 110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43_ = max_component;
#line 110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp42_ == _tmp43_) {
#line 1426 "ColorTransformation.c"
					RGBAnalyticPixel _tmp44_ = {0};
					gfloat _tmp45_ = 0.0F;
					RGBAnalyticPixel _tmp46_ = {0};
					gfloat _tmp47_ = 0.0F;
					gfloat _tmp48_ = 0.0F;
#line 111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp44_ = *p;
#line 111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp45_ = _tmp44_.red;
#line 111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp46_ = *p;
#line 111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp47_ = _tmp46_.green;
#line 111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = delta;
#line 111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					(*self).hue = 4.0f + ((_tmp45_ - _tmp47_) / _tmp48_);
#line 1444 "ColorTransformation.c"
				}
			}
		}
#line 114 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp49_ = (*self).hue;
#line 114 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		(*self).hue = _tmp49_ * 60.0f;
#line 115 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp50_ = (*self).hue;
#line 115 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp50_ < 0.0f) {
#line 1456 "ColorTransformation.c"
			gfloat _tmp51_ = 0.0F;
#line 116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp51_ = (*self).hue;
#line 116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			(*self).hue = _tmp51_ + 360.0f;
#line 1462 "ColorTransformation.c"
		}
#line 118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp52_ = (*self).hue;
#line 118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		(*self).hue = _tmp52_ / 360.0f;
#line 1468 "ColorTransformation.c"
	}
#line 121 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = (*self).hue;
#line 121 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = CLAMP (_tmp53_, 0.0f, 1.0f);
#line 121 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = _tmp54_;
#line 122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = (*self).saturation;
#line 122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = CLAMP (_tmp55_, 0.0f, 1.0f);
#line 122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = _tmp56_;
#line 123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = (*self).light_value;
#line 123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = CLAMP (_tmp57_, 0.0f, 1.0f);
#line 123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = _tmp58_;
#line 1488 "ColorTransformation.c"
}


void hsv_analytic_pixel_to_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* result) {
	RGBAnalyticPixel _result_ = {0};
	gfloat _tmp0_ = 0.0F;
#line 127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_analytic_pixel_init (&_result_);
#line 129 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).saturation;
#line 129 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ == 0.0f) {
#line 1501 "ColorTransformation.c"
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		gfloat _tmp3_ = 0.0F;
#line 130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = (*self).light_value;
#line 130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_result_.red = _tmp1_;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = (*self).light_value;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_result_.green = _tmp2_;
#line 132 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = (*self).light_value;
#line 132 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_result_.blue = _tmp3_;
#line 1517 "ColorTransformation.c"
	} else {
		gfloat hue_denorm = 0.0F;
		gfloat _tmp4_ = 0.0F;
		gfloat _tmp5_ = 0.0F;
		gfloat hue_hexant = 0.0F;
		gfloat _tmp6_ = 0.0F;
		gint hexant_i_part = 0;
		gfloat _tmp7_ = 0.0F;
		gfloat hexant_f_part = 0.0F;
		gfloat _tmp8_ = 0.0F;
		gint _tmp9_ = 0;
		gfloat p = 0.0F;
		gfloat _tmp10_ = 0.0F;
		gfloat _tmp11_ = 0.0F;
		gfloat q = 0.0F;
		gfloat _tmp12_ = 0.0F;
		gfloat _tmp13_ = 0.0F;
		gfloat _tmp14_ = 0.0F;
		gfloat t = 0.0F;
		gfloat _tmp15_ = 0.0F;
		gfloat _tmp16_ = 0.0F;
		gfloat _tmp17_ = 0.0F;
		gint _tmp18_ = 0;
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = (*self).hue;
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hue_denorm = _tmp4_ * 360.0f;
#line 135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = hue_denorm;
#line 135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp5_ == 360.0f) {
#line 136 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			hue_denorm = 0.0f;
#line 1551 "ColorTransformation.c"
		}
#line 138 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = hue_denorm;
#line 138 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hue_hexant = _tmp6_ / 60.0f;
#line 140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = hue_hexant;
#line 140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hexant_i_part = (gint) _tmp7_;
#line 142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = hue_hexant;
#line 142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = hexant_i_part;
#line 142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hexant_f_part = _tmp8_ - ((gfloat) _tmp9_);
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = (*self).light_value;
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = (*self).saturation;
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		p = _tmp10_ * (1.0f - _tmp11_);
#line 146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = (*self).light_value;
#line 146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = (*self).saturation;
#line 146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_ = hexant_f_part;
#line 146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		q = _tmp12_ * (1.0f - (_tmp13_ * _tmp14_));
#line 147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_ = (*self).light_value;
#line 147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = (*self).saturation;
#line 147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = hexant_f_part;
#line 147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		t = _tmp15_ * (1.0f - (_tmp16_ * (1.0f - _tmp17_)));
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = hexant_i_part;
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		switch (_tmp18_) {
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			case 0:
#line 1595 "ColorTransformation.c"
			{
				gfloat _tmp19_ = 0.0F;
				gfloat _tmp20_ = 0.0F;
				gfloat _tmp21_ = 0.0F;
#line 159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = (*self).light_value;
#line 159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.red = _tmp19_;
#line 160 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = t;
#line 160 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.green = _tmp20_;
#line 161 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp21_ = p;
#line 161 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.blue = _tmp21_;
#line 162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 1614 "ColorTransformation.c"
			}
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			case 1:
#line 1618 "ColorTransformation.c"
			{
				gfloat _tmp22_ = 0.0F;
				gfloat _tmp23_ = 0.0F;
				gfloat _tmp24_ = 0.0F;
#line 165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22_ = q;
#line 165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.red = _tmp22_;
#line 166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = (*self).light_value;
#line 166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.green = _tmp23_;
#line 167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = p;
#line 167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.blue = _tmp24_;
#line 168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 1637 "ColorTransformation.c"
			}
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			case 2:
#line 1641 "ColorTransformation.c"
			{
				gfloat _tmp25_ = 0.0F;
				gfloat _tmp26_ = 0.0F;
				gfloat _tmp27_ = 0.0F;
#line 171 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = p;
#line 171 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.red = _tmp25_;
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = (*self).light_value;
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.green = _tmp26_;
#line 173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp27_ = t;
#line 173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.blue = _tmp27_;
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 1660 "ColorTransformation.c"
			}
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			case 3:
#line 1664 "ColorTransformation.c"
			{
				gfloat _tmp28_ = 0.0F;
				gfloat _tmp29_ = 0.0F;
				gfloat _tmp30_ = 0.0F;
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp28_ = p;
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.red = _tmp28_;
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp29_ = q;
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.green = _tmp29_;
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp30_ = (*self).light_value;
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.blue = _tmp30_;
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 1683 "ColorTransformation.c"
			}
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			case 4:
#line 1687 "ColorTransformation.c"
			{
				gfloat _tmp31_ = 0.0F;
				gfloat _tmp32_ = 0.0F;
				gfloat _tmp33_ = 0.0F;
#line 183 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp31_ = t;
#line 183 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.red = _tmp31_;
#line 184 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp32_ = p;
#line 184 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.green = _tmp32_;
#line 185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp33_ = (*self).light_value;
#line 185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.blue = _tmp33_;
#line 186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 1706 "ColorTransformation.c"
			}
#line 148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			case 5:
#line 1710 "ColorTransformation.c"
			{
				gfloat _tmp34_ = 0.0F;
				gfloat _tmp35_ = 0.0F;
				gfloat _tmp36_ = 0.0F;
#line 189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp34_ = (*self).light_value;
#line 189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.red = _tmp34_;
#line 190 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35_ = p;
#line 190 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.green = _tmp35_;
#line 191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp36_ = q;
#line 191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_result_.blue = _tmp36_;
#line 192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 1729 "ColorTransformation.c"
			}
			default:
			{
#line 195 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				g_error ("ColorTransformation.vala:195: bad color hexant in HSV-to-RGB conversio" \
"n");
#line 1735 "ColorTransformation.c"
			}
		}
	}
#line 199 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _result_;
#line 199 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 1743 "ColorTransformation.c"
}


gboolean hsv_analytic_pixel_equals (HSVAnalyticPixel *self, HSVAnalyticPixel* rhs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gfloat _tmp2_ = 0.0F;
	HSVAnalyticPixel _tmp3_ = {0};
	gfloat _tmp4_ = 0.0F;
#line 202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).hue;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = *rhs;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_.hue;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ == _tmp4_) {
#line 1764 "ColorTransformation.c"
		gfloat _tmp5_ = 0.0F;
		HSVAnalyticPixel _tmp6_ = {0};
		gfloat _tmp7_ = 0.0F;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = (*self).saturation;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = *rhs;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp6_.saturation;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 1776 "ColorTransformation.c"
	} else {
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 1780 "ColorTransformation.c"
	}
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_) {
#line 1784 "ColorTransformation.c"
		gfloat _tmp8_ = 0.0F;
		HSVAnalyticPixel _tmp9_ = {0};
		gfloat _tmp10_ = 0.0F;
#line 204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = (*self).light_value;
#line 204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = _tmp9_.light_value;
#line 204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp8_ == _tmp10_;
#line 1796 "ColorTransformation.c"
	} else {
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 1800 "ColorTransformation.c"
	}
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1806 "ColorTransformation.c"
}


guint hsv_analytic_pixel_hash_code (HSVAnalyticPixel *self) {
	guint result = 0U;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).hue;
#line 208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = (*self).saturation;
#line 208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).light_value;
#line 208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = ((((guint) (_tmp0_ * 255.0f)) << 16) + (((guint) (_tmp1_ * 255.0f)) << 8)) + ((guint) (_tmp2_ * 255.0f));
#line 208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1825 "ColorTransformation.c"
}


HSVAnalyticPixel* hsv_analytic_pixel_dup (const HSVAnalyticPixel* self) {
	HSVAnalyticPixel* dup;
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dup = g_new0 (HSVAnalyticPixel, 1);
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memcpy (dup, self, sizeof (HSVAnalyticPixel));
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return dup;
#line 1837 "ColorTransformation.c"
}


void hsv_analytic_pixel_free (HSVAnalyticPixel* self) {
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_free (self);
#line 1844 "ColorTransformation.c"
}


GType hsv_analytic_pixel_get_type (void) {
	static volatile gsize hsv_analytic_pixel_type_id__volatile = 0;
	if (g_once_init_enter (&hsv_analytic_pixel_type_id__volatile)) {
		GType hsv_analytic_pixel_type_id;
		hsv_analytic_pixel_type_id = g_boxed_type_register_static ("HSVAnalyticPixel", (GBoxedCopyFunc) hsv_analytic_pixel_dup, (GBoxedFreeFunc) hsv_analytic_pixel_free);
		g_once_init_leave (&hsv_analytic_pixel_type_id__volatile, hsv_analytic_pixel_type_id);
	}
	return hsv_analytic_pixel_type_id__volatile;
}


GType composition_mode_get_type (void) {
	static volatile gsize composition_mode_type_id__volatile = 0;
	if (g_once_init_enter (&composition_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPOSITION_MODE_NONE, "COMPOSITION_MODE_NONE", "none"}, {COMPOSITION_MODE_RGB_MATRIX, "COMPOSITION_MODE_RGB_MATRIX", "rgb-matrix"}, {0, NULL, NULL}};
		GType composition_mode_type_id;
		composition_mode_type_id = g_enum_register_static ("CompositionMode", values);
		g_once_init_leave (&composition_mode_type_id__volatile, composition_mode_type_id);
	}
	return composition_mode_type_id__volatile;
}


GType pixel_format_get_type (void) {
	static volatile gsize pixel_format_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_format_type_id__volatile)) {
		static const GEnumValue values[] = {{PIXEL_FORMAT_RGB, "PIXEL_FORMAT_RGB", "rgb"}, {PIXEL_FORMAT_HSV, "PIXEL_FORMAT_HSV", "hsv"}, {0, NULL, NULL}};
		GType pixel_format_type_id;
		pixel_format_type_id = g_enum_register_static ("PixelFormat", values);
		g_once_init_leave (&pixel_format_type_id__volatile, pixel_format_type_id);
	}
	return pixel_format_type_id__volatile;
}


GType pixel_transformation_type_get_type (void) {
	static volatile gsize pixel_transformation_type_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformation_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION, "PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION", "tone-expansion"}, {PIXEL_TRANSFORMATION_TYPE_SHADOWS, "PIXEL_TRANSFORMATION_TYPE_SHADOWS", "shadows"}, {PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS, "PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS", "highlights"}, {PIXEL_TRANSFORMATION_TYPE_TEMPERATURE, "PIXEL_TRANSFORMATION_TYPE_TEMPERATURE", "temperature"}, {PIXEL_TRANSFORMATION_TYPE_TINT, "PIXEL_TRANSFORMATION_TYPE_TINT", "tint"}, {PIXEL_TRANSFORMATION_TYPE_SATURATION, "PIXEL_TRANSFORMATION_TYPE_SATURATION", "saturation"}, {PIXEL_TRANSFORMATION_TYPE_EXPOSURE, "PIXEL_TRANSFORMATION_TYPE_EXPOSURE", "exposure"}, {PIXEL_TRANSFORMATION_TYPE_CONTRAST, "PIXEL_TRANSFORMATION_TYPE_CONTRAST", "contrast"}, {0, NULL, NULL}};
		GType pixel_transformation_type_type_id;
		pixel_transformation_type_type_id = g_enum_register_static ("PixelTransformationType", values);
		g_once_init_leave (&pixel_transformation_type_type_id__volatile, pixel_transformation_type_type_id);
	}
	return pixel_transformation_type_type_id__volatile;
}


PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type) {
	PixelTransformationBundle* self = NULL;
#line 240 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (PixelTransformationBundle*) g_type_create_instance (object_type);
#line 240 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 1901 "ColorTransformation.c"
}


PixelTransformationBundle* pixel_transformation_bundle_new (void) {
#line 240 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return pixel_transformation_bundle_construct (TYPE_PIXEL_TRANSFORMATION_BUNDLE);
#line 1908 "ColorTransformation.c"
}


static gpointer _pixel_transformation_bundle_ref0 (gpointer self) {
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? pixel_transformation_bundle_ref (self) : NULL;
#line 1915 "ColorTransformation.c"
}


PixelTransformationBundle* pixel_transformation_bundle_get_copied_color_adjustments (void) {
	PixelTransformationBundle* result = NULL;
	PixelTransformationBundle* _tmp0_ = NULL;
	PixelTransformationBundle* _tmp1_ = NULL;
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_copied_color_adjustments;
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _pixel_transformation_bundle_ref0 (_tmp0_);
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp1_;
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1931 "ColorTransformation.c"
}


void pixel_transformation_bundle_set_copied_color_adjustments (PixelTransformationBundle* adjustments) {
	PixelTransformationBundle* _tmp0_ = NULL;
	PixelTransformationBundle* _tmp1_ = NULL;
#line 247 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (adjustments));
#line 248 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = adjustments;
#line 248 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _pixel_transformation_bundle_ref0 (_tmp0_);
#line 248 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_bundle_unref0 (pixel_transformation_bundle_copied_color_adjustments);
#line 248 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_copied_color_adjustments = _tmp1_;
#line 1948 "ColorTransformation.c"
}


gboolean pixel_transformation_bundle_has_copied_color_adjustments (void) {
	gboolean result = FALSE;
	PixelTransformationBundle* _tmp0_ = NULL;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_copied_color_adjustments;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_ != NULL;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1961 "ColorTransformation.c"
}


void pixel_transformation_bundle_set (PixelTransformationBundle* self, PixelTransformation* transformation) {
	GeeHashMap* _tmp0_ = NULL;
	PixelTransformation* _tmp1_ = NULL;
	PixelTransformationType _tmp2_ = 0;
	PixelTransformation* _tmp3_ = NULL;
#line 255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self));
#line 255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (transformation));
#line 256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = transformation;
#line 256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = pixel_transformation_get_transformation_type (_tmp1_);
#line 256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = transformation;
#line 256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) ((gint) _tmp2_)), _tmp3_);
#line 1984 "ColorTransformation.c"
}


void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self) {
	ExpansionTransformation* _tmp0_ = NULL;
	ExpansionTransformation* _tmp1_ = NULL;
	ShadowDetailTransformation* _tmp2_ = NULL;
	ShadowDetailTransformation* _tmp3_ = NULL;
	HighlightDetailTransformation* _tmp4_ = NULL;
	HighlightDetailTransformation* _tmp5_ = NULL;
	TemperatureTransformation* _tmp6_ = NULL;
	TemperatureTransformation* _tmp7_ = NULL;
	TintTransformation* _tmp8_ = NULL;
	TintTransformation* _tmp9_ = NULL;
	SaturationTransformation* _tmp10_ = NULL;
	SaturationTransformation* _tmp11_ = NULL;
	ExposureTransformation* _tmp12_ = NULL;
	ExposureTransformation* _tmp13_ = NULL;
	ContrastTransformation* _tmp14_ = NULL;
	ContrastTransformation* _tmp15_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self));
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = expansion_transformation_new_from_extrema (0, 255);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _tmp0_;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp1_);
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = shadow_detail_transformation_new (0.0f);
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_;
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp3_);
#line 262 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = highlight_detail_transformation_new (0.0f);
#line 262 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_;
#line 262 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 262 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp5_);
#line 263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = temperature_transformation_new (0.0f);
#line 263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_;
#line 263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp7_);
#line 264 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = tint_transformation_new (0.0f);
#line 264 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = _tmp8_;
#line 264 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 264 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp9_);
#line 265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = saturation_transformation_new (0.0f);
#line 265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_;
#line 265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp11_);
#line 266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = exposure_transformation_new (0.0f);
#line 266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_;
#line 266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp13_);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = contrast_transformation_new (0.0f);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp15_);
#line 2071 "ColorTransformation.c"
}


void pixel_transformation_bundle_load (PixelTransformationBundle* self, KeyValueMap* store) {
	gchar* expansion_params_encoded = NULL;
	KeyValueMap* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	KeyValueMap* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	ShadowDetailTransformation* _tmp10_ = NULL;
	ShadowDetailTransformation* _tmp11_ = NULL;
	KeyValueMap* _tmp12_ = NULL;
	gfloat _tmp13_ = 0.0F;
	HighlightDetailTransformation* _tmp14_ = NULL;
	HighlightDetailTransformation* _tmp15_ = NULL;
	KeyValueMap* _tmp16_ = NULL;
	gfloat _tmp17_ = 0.0F;
	TemperatureTransformation* _tmp18_ = NULL;
	TemperatureTransformation* _tmp19_ = NULL;
	KeyValueMap* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	TintTransformation* _tmp22_ = NULL;
	TintTransformation* _tmp23_ = NULL;
	KeyValueMap* _tmp24_ = NULL;
	gfloat _tmp25_ = 0.0F;
	SaturationTransformation* _tmp26_ = NULL;
	SaturationTransformation* _tmp27_ = NULL;
	KeyValueMap* _tmp28_ = NULL;
	gfloat _tmp29_ = 0.0F;
	ExposureTransformation* _tmp30_ = NULL;
	ExposureTransformation* _tmp31_ = NULL;
	KeyValueMap* _tmp32_ = NULL;
	gfloat _tmp33_ = 0.0F;
	ContrastTransformation* _tmp34_ = NULL;
	ContrastTransformation* _tmp35_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self));
#line 270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_KEY_VALUE_MAP (store));
#line 271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = store;
#line 271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = key_value_map_get_string (_tmp0_, "expansion", "-");
#line 271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_params_encoded = _tmp1_;
#line 272 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = expansion_params_encoded;
#line 272 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_strcmp0 (_tmp2_, "-") == 0) {
#line 2122 "ColorTransformation.c"
		ExpansionTransformation* _tmp3_ = NULL;
		ExpansionTransformation* _tmp4_ = NULL;
#line 273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = expansion_transformation_new_from_extrema (0, 255);
#line 273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = _tmp3_;
#line 273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp4_);
#line 2133 "ColorTransformation.c"
	} else {
		const gchar* _tmp5_ = NULL;
		ExpansionTransformation* _tmp6_ = NULL;
		ExpansionTransformation* _tmp7_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = expansion_params_encoded;
#line 275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = expansion_transformation_new_from_string (_tmp5_);
#line 275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp6_;
#line 275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp7_);
#line 2148 "ColorTransformation.c"
	}
#line 277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = store;
#line 277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = key_value_map_get_float (_tmp8_, "shadows", 0.0f);
#line 277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = shadow_detail_transformation_new (_tmp9_);
#line 277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_;
#line 277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp11_);
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = store;
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = key_value_map_get_float (_tmp12_, "highlights", 0.0f);
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = highlight_detail_transformation_new (_tmp13_);
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_;
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp15_);
#line 279 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = store;
#line 279 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = key_value_map_get_float (_tmp16_, "temperature", 0.0f);
#line 279 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = temperature_transformation_new (_tmp17_);
#line 279 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = _tmp18_;
#line 279 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 279 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp19_);
#line 280 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = store;
#line 280 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = key_value_map_get_float (_tmp20_, "tint", 0.0f);
#line 280 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = tint_transformation_new (_tmp21_);
#line 280 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_;
#line 280 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 280 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp23_);
#line 281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = store;
#line 281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = key_value_map_get_float (_tmp24_, "saturation", 0.0f);
#line 281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = saturation_transformation_new (_tmp25_);
#line 281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = _tmp26_;
#line 281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp27_);
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = store;
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = key_value_map_get_float (_tmp28_, "exposure", 0.0f);
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = exposure_transformation_new (_tmp29_);
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = _tmp30_;
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp31_);
#line 283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = store;
#line 283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = key_value_map_get_float (_tmp32_, "contrast", 0.0f);
#line 283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = contrast_transformation_new (_tmp33_);
#line 283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_;
#line 283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp35_);
#line 270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (expansion_params_encoded);
#line 2236 "ColorTransformation.c"
}


KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self, const gchar* group) {
	KeyValueMap* result = NULL;
	KeyValueMap* store = NULL;
	const gchar* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	ExpansionTransformation* new_expansion_trans = NULL;
	PixelTransformation* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	ShadowDetailTransformation* new_shadows_trans = NULL;
	PixelTransformation* _tmp5_ = NULL;
	gfloat _tmp6_ = 0.0F;
	HighlightDetailTransformation* new_highlight_trans = NULL;
	PixelTransformation* _tmp7_ = NULL;
	gfloat _tmp8_ = 0.0F;
	TemperatureTransformation* new_temp_trans = NULL;
	PixelTransformation* _tmp9_ = NULL;
	gfloat _tmp10_ = 0.0F;
	TintTransformation* new_tint_trans = NULL;
	PixelTransformation* _tmp11_ = NULL;
	gfloat _tmp12_ = 0.0F;
	SaturationTransformation* new_sat_trans = NULL;
	PixelTransformation* _tmp13_ = NULL;
	gfloat _tmp14_ = 0.0F;
	ExposureTransformation* new_exposure_trans = NULL;
	PixelTransformation* _tmp15_ = NULL;
	gfloat _tmp16_ = 0.0F;
	ContrastTransformation* new_contrast_trans = NULL;
	PixelTransformation* _tmp17_ = NULL;
	gfloat _tmp18_ = 0.0F;
#line 286 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), NULL);
#line 286 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (group != NULL, NULL);
#line 287 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = group;
#line 287 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = key_value_map_new (_tmp0_);
#line 287 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	store = _tmp1_;
#line 289 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 289 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_expansion_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 291 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_expansion_trans != NULL, "new_expansion_trans != null");
#line 292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = pixel_transformation_to_string (G_TYPE_CHECK_INSTANCE_CAST (new_expansion_trans, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_;
#line 292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_string (store, "expansion", _tmp4_);
#line 292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (_tmp4_);
#line 294 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_SHADOWS);
#line 294 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_shadows_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 296 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_shadows_trans != NULL, "new_shadows_trans != null");
#line 297 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = shadow_detail_transformation_get_parameter (new_shadows_trans);
#line 297 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "shadows", _tmp6_);
#line 299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS);
#line 299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_highlight_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_highlight_trans != NULL, "new_highlight_trans != null");
#line 302 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = highlight_detail_transformation_get_parameter (new_highlight_trans);
#line 302 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "highlights", _tmp8_);
#line 304 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TEMPERATURE);
#line 304 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_temp_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation);
#line 306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_temp_trans != NULL, "new_temp_trans != null");
#line 307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = temperature_transformation_get_parameter (new_temp_trans);
#line 307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "temperature", _tmp10_);
#line 309 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TINT);
#line 309 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_tint_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_TINT_TRANSFORMATION, TintTransformation);
#line 311 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_tint_trans != NULL, "new_tint_trans != null");
#line 312 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = tint_transformation_get_parameter (new_tint_trans);
#line 312 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "tint", _tmp12_);
#line 314 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_SATURATION);
#line 314 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_sat_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_SATURATION_TRANSFORMATION, SaturationTransformation);
#line 316 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_sat_trans != NULL, "new_sat_trans != null");
#line 317 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = saturation_transformation_get_parameter (new_sat_trans);
#line 317 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "saturation", _tmp14_);
#line 319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_EXPOSURE);
#line 319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_exposure_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation);
#line 321 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_exposure_trans != NULL, "new_exposure_trans != null");
#line 322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = exposure_transformation_get_parameter (new_exposure_trans);
#line 322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "exposure", _tmp16_);
#line 324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_CONTRAST);
#line 324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_contrast_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation);
#line 326 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_contrast_trans != NULL, "new_contrast_trans != null");
#line 327 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = contrast_transformation_get_parameter (new_contrast_trans);
#line 327 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "contrast", _tmp18_);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = store;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_contrast_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_exposure_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_sat_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_tint_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_temp_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_highlight_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_shadows_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_expansion_trans);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2384 "ColorTransformation.c"
}


gint pixel_transformation_bundle_get_count (PixelTransformationBundle* self) {
	gint result = 0;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), 0);
#line 333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp2_;
#line 333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2405 "ColorTransformation.c"
}


PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self, PixelTransformationType type) {
	PixelTransformation* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	PixelTransformationType _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
#line 336 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), NULL);
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = type;
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) ((gint) _tmp1_)));
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (PixelTransformation*) _tmp2_;
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2426 "ColorTransformation.c"
}


GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self) {
	GeeIterable* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), NULL);
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2447 "ColorTransformation.c"
}


gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self) {
	gboolean result = FALSE;
#line 344 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), FALSE);
#line 2455 "ColorTransformation.c"
	{
		GeeIterator* _adjustment_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = pixel_transformation_bundle_get_transformations (self);
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp0_;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = _tmp2_;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_tmp1_);
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_adjustment_it = _tmp3_;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 2476 "ColorTransformation.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			PixelTransformation* adjustment = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			PixelTransformation* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = _adjustment_it;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp5_) {
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 2492 "ColorTransformation.c"
			}
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = _adjustment_it;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			adjustment = (PixelTransformation*) _tmp7_;
#line 346 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = adjustment;
#line 346 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = pixel_transformation_is_identity (_tmp8_);
#line 346 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp9_) {
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				result = FALSE;
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (adjustment);
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_g_object_unref0 (_adjustment_it);
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				return result;
#line 2514 "ColorTransformation.c"
			}
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (adjustment);
#line 2518 "ColorTransformation.c"
		}
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_adjustment_it);
#line 2522 "ColorTransformation.c"
	}
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = TRUE;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2528 "ColorTransformation.c"
}


PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self) {
	PixelTransformer* result = NULL;
	PixelTransformer* transformer = NULL;
	PixelTransformer* _tmp0_ = NULL;
#line 353 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), NULL);
#line 354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformer_new ();
#line 354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	transformer = _tmp0_;
#line 2542 "ColorTransformation.c"
	{
		GeeIterator* _transformation_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterable* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = pixel_transformation_bundle_get_transformations (self);
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = _tmp1_;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = _tmp3_;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_tmp2_);
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_it = _tmp4_;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 2563 "ColorTransformation.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			PixelTransformation* transformation = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			PixelTransformer* _tmp9_ = NULL;
			PixelTransformation* _tmp10_ = NULL;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = _transformation_it;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp6_) {
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 2579 "ColorTransformation.c"
			}
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = _transformation_it;
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			transformation = (PixelTransformation*) _tmp8_;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = transformer;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = transformation;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			pixel_transformer_attach_transformation (_tmp9_, _tmp10_);
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (transformation);
#line 2595 "ColorTransformation.c"
		}
#line 355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_transformation_it);
#line 2599 "ColorTransformation.c"
	}
#line 358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = transformer;
#line 358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2605 "ColorTransformation.c"
}


PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self) {
	PixelTransformationBundle* result = NULL;
	PixelTransformationBundle* bundle = NULL;
	PixelTransformationBundle* _tmp0_ = NULL;
#line 361 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (self), NULL);
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	bundle = _tmp0_;
#line 2619 "ColorTransformation.c"
	{
		GeeIterator* _transformation_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterable* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = pixel_transformation_bundle_get_transformations (self);
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = _tmp1_;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = _tmp3_;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_tmp2_);
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_it = _tmp4_;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 2640 "ColorTransformation.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			PixelTransformation* transformation = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			PixelTransformationBundle* _tmp9_ = NULL;
			PixelTransformation* _tmp10_ = NULL;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = _transformation_it;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp6_) {
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 2656 "ColorTransformation.c"
			}
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = _transformation_it;
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			transformation = (PixelTransformation*) _tmp8_;
#line 364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = bundle;
#line 364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = transformation;
#line 364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			pixel_transformation_bundle_set (_tmp9_, _tmp10_);
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (transformation);
#line 2672 "ColorTransformation.c"
		}
#line 363 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_transformation_it);
#line 2676 "ColorTransformation.c"
	}
#line 366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = bundle;
#line 366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2682 "ColorTransformation.c"
}


static void value_pixel_transformation_bundle_init (GValue* value) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 2689 "ColorTransformation.c"
}


static void value_pixel_transformation_bundle_free_value (GValue* value) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_unref (value->data[0].v_pointer);
#line 2698 "ColorTransformation.c"
	}
}


static void value_pixel_transformation_bundle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = pixel_transformation_bundle_ref (src_value->data[0].v_pointer);
#line 2708 "ColorTransformation.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2712 "ColorTransformation.c"
	}
}


static gpointer value_pixel_transformation_bundle_peek_pointer (const GValue* value) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 2720 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_bundle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 2727 "ColorTransformation.c"
		PixelTransformationBundle* object;
		object = collect_values[0].v_pointer;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2734 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2738 "ColorTransformation.c"
		}
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = pixel_transformation_bundle_ref (object);
#line 2742 "ColorTransformation.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2746 "ColorTransformation.c"
	}
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2750 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_bundle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixelTransformationBundle** object_p;
	object_p = collect_values[0].v_pointer;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2761 "ColorTransformation.c"
	}
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 2767 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 2771 "ColorTransformation.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = pixel_transformation_bundle_ref (value->data[0].v_pointer);
#line 2775 "ColorTransformation.c"
	}
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2779 "ColorTransformation.c"
}


GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixelTransformationBundle* spec;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 2793 "ColorTransformation.c"
}


gpointer value_get_pixel_transformation_bundle (const GValue* value) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 2802 "ColorTransformation.c"
}


void value_set_pixel_transformation_bundle (GValue* value, gpointer v_object) {
	PixelTransformationBundle* old;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_ref (value->data[0].v_pointer);
#line 2822 "ColorTransformation.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2826 "ColorTransformation.c"
	}
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_unref (old);
#line 2832 "ColorTransformation.c"
	}
}


void value_take_pixel_transformation_bundle (GValue* value, gpointer v_object) {
	PixelTransformationBundle* old;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 2851 "ColorTransformation.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2855 "ColorTransformation.c"
	}
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_unref (old);
#line 2861 "ColorTransformation.c"
	}
}


static void pixel_transformation_bundle_class_init (PixelTransformationBundleClass * klass) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_parent_class = g_type_class_peek_parent (klass);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationBundleClass *) klass)->finalize = pixel_transformation_bundle_finalize;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (PixelTransformationBundlePrivate));
#line 2873 "ColorTransformation.c"
}


static void pixel_transformation_bundle_instance_init (PixelTransformationBundle * self) {
	void* _tmp0_ = NULL;
	GDestroyNotify _tmp1_ = NULL;
	GeeHashDataFunc _tmp2_ = NULL;
	void* _tmp3_ = NULL;
	GDestroyNotify _tmp4_ = NULL;
	GeeEqualDataFunc _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = PIXEL_TRANSFORMATION_BUNDLE_GET_PRIVATE (self);
#line 237 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = gee_functions_get_hash_func_for (G_TYPE_INT, &_tmp0_, &_tmp1_);
#line 237 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = gee_functions_get_equal_func_for (G_TYPE_INT, &_tmp3_, &_tmp4_);
#line 237 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, TYPE_PIXEL_TRANSFORMATION, (GBoxedCopyFunc) pixel_transformation_ref, (GDestroyNotify) pixel_transformation_unref, _tmp2_, _tmp0_, _tmp1_, _tmp5_, _tmp3_, _tmp4_, NULL, NULL, NULL);
#line 237 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->map = _tmp6_;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 2897 "ColorTransformation.c"
}


static void pixel_transformation_bundle_finalize (PixelTransformationBundle* obj) {
	PixelTransformationBundle * self;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 237 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (self->priv->map);
#line 2909 "ColorTransformation.c"
}


GType pixel_transformation_bundle_get_type (void) {
	static volatile gsize pixel_transformation_bundle_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformation_bundle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixel_transformation_bundle_init, value_pixel_transformation_bundle_free_value, value_pixel_transformation_bundle_copy_value, value_pixel_transformation_bundle_peek_pointer, "p", value_pixel_transformation_bundle_collect_value, "p", value_pixel_transformation_bundle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixelTransformationBundleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformation_bundle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformationBundle), 0, (GInstanceInitFunc) pixel_transformation_bundle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixel_transformation_bundle_type_id;
		pixel_transformation_bundle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformationBundle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixel_transformation_bundle_type_id__volatile, pixel_transformation_bundle_type_id);
	}
	return pixel_transformation_bundle_type_id__volatile;
}


gpointer pixel_transformation_bundle_ref (gpointer instance) {
	PixelTransformationBundle* self;
	self = instance;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 2934 "ColorTransformation.c"
}


void pixel_transformation_bundle_unref (gpointer instance) {
	PixelTransformationBundle* self;
	self = instance;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS (self)->finalize (self);
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2947 "ColorTransformation.c"
	}
}


PixelTransformation* pixel_transformation_construct (GType object_type, PixelTransformationType type) {
	PixelTransformation* self = NULL;
	PixelTransformationType _tmp0_ = 0;
#line 373 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (PixelTransformation*) g_type_create_instance (object_type);
#line 374 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = type;
#line 374 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->type = _tmp0_;
#line 373 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 2963 "ColorTransformation.c"
}


PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self) {
	PixelTransformationType result = 0;
	PixelTransformationType _tmp0_ = 0;
#line 377 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION (self), 0);
#line 378 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->type;
#line 378 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 378 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2978 "ColorTransformation.c"
}


static PixelFormat pixel_transformation_real_get_preferred_format (PixelTransformation* self) {
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_critical ("Type `%s' does not implement abstract method `pixel_transformation_get_preferred_format'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return 0;
#line 2987 "ColorTransformation.c"
}


PixelFormat pixel_transformation_get_preferred_format (PixelTransformation* self) {
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION (self), 0);
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->get_preferred_format (self);
#line 2996 "ColorTransformation.c"
}


static CompositionMode pixel_transformation_real_get_composition_mode (PixelTransformation* self) {
	CompositionMode result = 0;
#line 384 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = COMPOSITION_MODE_NONE;
#line 384 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 3006 "ColorTransformation.c"
}


CompositionMode pixel_transformation_get_composition_mode (PixelTransformation* self) {
#line 383 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION (self), 0);
#line 383 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->get_composition_mode (self);
#line 3015 "ColorTransformation.c"
}


static void pixel_transformation_real_compose_with (PixelTransformation* self, PixelTransformation* other) {
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (other));
#line 388 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_error ("ColorTransformation.vala:388: %s", "PixelTransformation: compose_with( ): this type of pixel " "transformation doesn't support composition.");
#line 3024 "ColorTransformation.c"
}


void pixel_transformation_compose_with (PixelTransformation* self, PixelTransformation* other) {
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (self));
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_GET_CLASS (self)->compose_with (self, other);
#line 3033 "ColorTransformation.c"
}


static gboolean pixel_transformation_real_is_identity (PixelTransformation* self) {
	gboolean result = FALSE;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = TRUE;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 3043 "ColorTransformation.c"
}


gboolean pixel_transformation_is_identity (PixelTransformation* self) {
#line 392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION (self), FALSE);
#line 392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->is_identity (self);
#line 3052 "ColorTransformation.c"
}


static void pixel_transformation_real_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result) {
	HSVAnalyticPixel _tmp0_ = {0};
#line 396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 397 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 397 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp0_;
#line 397 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 3066 "ColorTransformation.c"
}


void pixel_transformation_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result) {
#line 396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (self));
#line 396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_GET_CLASS (self)->transform_pixel_hsv (self, p, result);
#line 3075 "ColorTransformation.c"
}


static void pixel_transformation_real_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
	RGBAnalyticPixel _tmp0_ = {0};
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 401 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 401 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp0_;
#line 401 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 3089 "ColorTransformation.c"
}


void pixel_transformation_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (self));
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_GET_CLASS (self)->transform_pixel_rgb (self, p, result);
#line 3098 "ColorTransformation.c"
}


static gchar* pixel_transformation_real_to_string (PixelTransformation* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_strdup ("PixelTransformation");
#line 405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 3111 "ColorTransformation.c"
}


gchar* pixel_transformation_to_string (PixelTransformation* self) {
#line 404 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION (self), NULL);
#line 404 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->to_string (self);
#line 3120 "ColorTransformation.c"
}


static PixelTransformation* pixel_transformation_real_copy (PixelTransformation* self) {
#line 408 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_critical ("Type `%s' does not implement abstract method `pixel_transformation_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 408 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 3129 "ColorTransformation.c"
}


PixelTransformation* pixel_transformation_copy (PixelTransformation* self) {
#line 408 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMATION (self), NULL);
#line 408 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->copy (self);
#line 3138 "ColorTransformation.c"
}


static void value_pixel_transformation_init (GValue* value) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 3145 "ColorTransformation.c"
}


static void value_pixel_transformation_free_value (GValue* value) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_unref (value->data[0].v_pointer);
#line 3154 "ColorTransformation.c"
	}
}


static void value_pixel_transformation_copy_value (const GValue* src_value, GValue* dest_value) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = pixel_transformation_ref (src_value->data[0].v_pointer);
#line 3164 "ColorTransformation.c"
	} else {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3168 "ColorTransformation.c"
	}
}


static gpointer value_pixel_transformation_peek_pointer (const GValue* value) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 3176 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 3183 "ColorTransformation.c"
		PixelTransformation* object;
		object = collect_values[0].v_pointer;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3190 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3194 "ColorTransformation.c"
		}
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = pixel_transformation_ref (object);
#line 3198 "ColorTransformation.c"
	} else {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 3202 "ColorTransformation.c"
	}
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 3206 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixelTransformation** object_p;
	object_p = collect_values[0].v_pointer;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3217 "ColorTransformation.c"
	}
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 3223 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 3227 "ColorTransformation.c"
	} else {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = pixel_transformation_ref (value->data[0].v_pointer);
#line 3231 "ColorTransformation.c"
	}
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 3235 "ColorTransformation.c"
}


GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixelTransformation* spec;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMATION), NULL);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 3249 "ColorTransformation.c"
}


gpointer value_get_pixel_transformation (const GValue* value) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION), NULL);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 3258 "ColorTransformation.c"
}


void value_set_pixel_transformation (GValue* value, gpointer v_object) {
	PixelTransformation* old;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_ref (value->data[0].v_pointer);
#line 3278 "ColorTransformation.c"
	} else {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 3282 "ColorTransformation.c"
	}
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_unref (old);
#line 3288 "ColorTransformation.c"
	}
}


void value_take_pixel_transformation (GValue* value, gpointer v_object) {
	PixelTransformation* old;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 3307 "ColorTransformation.c"
	} else {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 3311 "ColorTransformation.c"
	}
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_unref (old);
#line 3317 "ColorTransformation.c"
	}
}


static void pixel_transformation_class_init (PixelTransformationClass * klass) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_parent_class = g_type_class_peek_parent (klass);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = pixel_transformation_finalize;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (PixelTransformationPrivate));
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_preferred_format = (PixelFormat (*)(PixelTransformation*)) pixel_transformation_real_get_preferred_format;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*)(PixelTransformation*)) pixel_transformation_real_get_composition_mode;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->compose_with = (void (*)(PixelTransformation*, PixelTransformation*)) pixel_transformation_real_compose_with;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*)(PixelTransformation*)) pixel_transformation_real_is_identity;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*)(PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) pixel_transformation_real_transform_pixel_hsv;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*)(PixelTransformation*, RGBAnalyticPixel*, RGBAnalyticPixel*)) pixel_transformation_real_transform_pixel_rgb;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->to_string = (gchar* (*)(PixelTransformation*)) pixel_transformation_real_to_string;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*)(PixelTransformation*)) pixel_transformation_real_copy;
#line 3345 "ColorTransformation.c"
}


static void pixel_transformation_instance_init (PixelTransformation * self) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = PIXEL_TRANSFORMATION_GET_PRIVATE (self);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 3354 "ColorTransformation.c"
}


static void pixel_transformation_finalize (PixelTransformation* obj) {
	PixelTransformation * self;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 3364 "ColorTransformation.c"
}


GType pixel_transformation_get_type (void) {
	static volatile gsize pixel_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformation_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixel_transformation_init, value_pixel_transformation_free_value, value_pixel_transformation_copy_value, value_pixel_transformation_peek_pointer, "p", value_pixel_transformation_collect_value, "p", value_pixel_transformation_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixelTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformation), 0, (GInstanceInitFunc) pixel_transformation_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixel_transformation_type_id;
		pixel_transformation_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformation", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&pixel_transformation_type_id__volatile, pixel_transformation_type_id);
	}
	return pixel_transformation_type_id__volatile;
}


gpointer pixel_transformation_ref (gpointer instance) {
	PixelTransformation* self;
	self = instance;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 3389 "ColorTransformation.c"
}


void pixel_transformation_unref (gpointer instance) {
	PixelTransformation* self;
	self = instance;
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		PIXEL_TRANSFORMATION_GET_CLASS (self)->finalize (self);
#line 370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3402 "ColorTransformation.c"
	}
}


RGBTransformation* rgb_transformation_construct (GType object_type, PixelTransformationType type) {
	RGBTransformation* self = NULL;
	PixelTransformationType _tmp0_ = 0;
	gfloat* _tmp1_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = type;
#line 421 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (RGBTransformation*) pixel_transformation_construct (object_type, _tmp0_);
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = g_new0 (gfloat, 16);
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[0] = 1.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[1] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[2] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[3] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[4] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[5] = 1.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[6] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[7] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[8] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[9] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[10] = 1.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[11] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[12] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[13] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[14] = 0.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[15] = 1.0f;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries = (g_free (self->matrix_entries), NULL);
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries = _tmp1_;
#line 427 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries_length1 = 16;
#line 420 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 3457 "ColorTransformation.c"
}


RGBTransformation* rgb_transformation_new (PixelTransformationType type) {
#line 420 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return rgb_transformation_construct (TYPE_RGB_TRANSFORMATION, type);
#line 3464 "ColorTransformation.c"
}


static PixelFormat rgb_transformation_real_get_preferred_format (PixelTransformation* base) {
	RGBTransformation * self;
	PixelFormat result = 0;
#line 434 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 435 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = PIXEL_FORMAT_RGB;
#line 435 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 3477 "ColorTransformation.c"
}


static CompositionMode rgb_transformation_real_get_composition_mode (PixelTransformation* base) {
	RGBTransformation * self;
	CompositionMode result = 0;
#line 438 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 439 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = COMPOSITION_MODE_RGB_MATRIX;
#line 439 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 3490 "ColorTransformation.c"
}


static gpointer _pixel_transformation_ref0 (gpointer self) {
#line 447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? pixel_transformation_ref (self) : NULL;
#line 3497 "ColorTransformation.c"
}


static void rgb_transformation_real_compose_with (PixelTransformation* base, PixelTransformation* other) {
	RGBTransformation * self;
	PixelTransformation* _tmp0_ = NULL;
	CompositionMode _tmp1_ = 0;
	RGBTransformation* transform = NULL;
	PixelTransformation* _tmp2_ = NULL;
	RGBTransformation* _tmp3_ = NULL;
	gfloat* result_matrix_entries = NULL;
	gfloat* _tmp4_ = NULL;
	gint result_matrix_entries_length1 = 0;
	gint _result_matrix_entries_size_ = 0;
	gfloat* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	RGBTransformation* _tmp6_ = NULL;
	gfloat* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gfloat _tmp8_ = 0.0F;
	gfloat* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gfloat _tmp10_ = 0.0F;
	RGBTransformation* _tmp11_ = NULL;
	gfloat* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gfloat _tmp13_ = 0.0F;
	gfloat* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gfloat _tmp15_ = 0.0F;
	RGBTransformation* _tmp16_ = NULL;
	gfloat* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gfloat _tmp18_ = 0.0F;
	gfloat* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gfloat _tmp20_ = 0.0F;
	RGBTransformation* _tmp21_ = NULL;
	gfloat* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gfloat _tmp23_ = 0.0F;
	gfloat* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gfloat _tmp25_ = 0.0F;
	gfloat _tmp26_ = 0.0F;
	gfloat* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	RGBTransformation* _tmp28_ = NULL;
	gfloat* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gfloat _tmp30_ = 0.0F;
	gfloat* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gfloat _tmp32_ = 0.0F;
	RGBTransformation* _tmp33_ = NULL;
	gfloat* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gfloat _tmp35_ = 0.0F;
	gfloat* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gfloat _tmp37_ = 0.0F;
	RGBTransformation* _tmp38_ = NULL;
	gfloat* _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gfloat _tmp40_ = 0.0F;
	gfloat* _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	gfloat _tmp42_ = 0.0F;
	RGBTransformation* _tmp43_ = NULL;
	gfloat* _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	gfloat _tmp45_ = 0.0F;
	gfloat* _tmp46_ = NULL;
	gint _tmp46__length1 = 0;
	gfloat _tmp47_ = 0.0F;
	gfloat _tmp48_ = 0.0F;
	gfloat* _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	RGBTransformation* _tmp50_ = NULL;
	gfloat* _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	gfloat _tmp52_ = 0.0F;
	gfloat* _tmp53_ = NULL;
	gint _tmp53__length1 = 0;
	gfloat _tmp54_ = 0.0F;
	RGBTransformation* _tmp55_ = NULL;
	gfloat* _tmp56_ = NULL;
	gint _tmp56__length1 = 0;
	gfloat _tmp57_ = 0.0F;
	gfloat* _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gfloat _tmp59_ = 0.0F;
	RGBTransformation* _tmp60_ = NULL;
	gfloat* _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	gfloat _tmp62_ = 0.0F;
	gfloat* _tmp63_ = NULL;
	gint _tmp63__length1 = 0;
	gfloat _tmp64_ = 0.0F;
	RGBTransformation* _tmp65_ = NULL;
	gfloat* _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gfloat _tmp67_ = 0.0F;
	gfloat* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	gfloat _tmp69_ = 0.0F;
	gfloat _tmp70_ = 0.0F;
	gfloat* _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	RGBTransformation* _tmp72_ = NULL;
	gfloat* _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gfloat _tmp74_ = 0.0F;
	gfloat* _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
	gfloat _tmp76_ = 0.0F;
	RGBTransformation* _tmp77_ = NULL;
	gfloat* _tmp78_ = NULL;
	gint _tmp78__length1 = 0;
	gfloat _tmp79_ = 0.0F;
	gfloat* _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	gfloat _tmp81_ = 0.0F;
	RGBTransformation* _tmp82_ = NULL;
	gfloat* _tmp83_ = NULL;
	gint _tmp83__length1 = 0;
	gfloat _tmp84_ = 0.0F;
	gfloat* _tmp85_ = NULL;
	gint _tmp85__length1 = 0;
	gfloat _tmp86_ = 0.0F;
	RGBTransformation* _tmp87_ = NULL;
	gfloat* _tmp88_ = NULL;
	gint _tmp88__length1 = 0;
	gfloat _tmp89_ = 0.0F;
	gfloat* _tmp90_ = NULL;
	gint _tmp90__length1 = 0;
	gfloat _tmp91_ = 0.0F;
	gfloat _tmp92_ = 0.0F;
	gfloat* _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	RGBTransformation* _tmp94_ = NULL;
	gfloat* _tmp95_ = NULL;
	gint _tmp95__length1 = 0;
	gfloat _tmp96_ = 0.0F;
	gfloat* _tmp97_ = NULL;
	gint _tmp97__length1 = 0;
	gfloat _tmp98_ = 0.0F;
	RGBTransformation* _tmp99_ = NULL;
	gfloat* _tmp100_ = NULL;
	gint _tmp100__length1 = 0;
	gfloat _tmp101_ = 0.0F;
	gfloat* _tmp102_ = NULL;
	gint _tmp102__length1 = 0;
	gfloat _tmp103_ = 0.0F;
	RGBTransformation* _tmp104_ = NULL;
	gfloat* _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	gfloat _tmp106_ = 0.0F;
	gfloat* _tmp107_ = NULL;
	gint _tmp107__length1 = 0;
	gfloat _tmp108_ = 0.0F;
	RGBTransformation* _tmp109_ = NULL;
	gfloat* _tmp110_ = NULL;
	gint _tmp110__length1 = 0;
	gfloat _tmp111_ = 0.0F;
	gfloat* _tmp112_ = NULL;
	gint _tmp112__length1 = 0;
	gfloat _tmp113_ = 0.0F;
	gfloat _tmp114_ = 0.0F;
	gfloat* _tmp115_ = NULL;
	gint _tmp115__length1 = 0;
	RGBTransformation* _tmp116_ = NULL;
	gfloat* _tmp117_ = NULL;
	gint _tmp117__length1 = 0;
	gfloat _tmp118_ = 0.0F;
	gfloat* _tmp119_ = NULL;
	gint _tmp119__length1 = 0;
	gfloat _tmp120_ = 0.0F;
	RGBTransformation* _tmp121_ = NULL;
	gfloat* _tmp122_ = NULL;
	gint _tmp122__length1 = 0;
	gfloat _tmp123_ = 0.0F;
	gfloat* _tmp124_ = NULL;
	gint _tmp124__length1 = 0;
	gfloat _tmp125_ = 0.0F;
	RGBTransformation* _tmp126_ = NULL;
	gfloat* _tmp127_ = NULL;
	gint _tmp127__length1 = 0;
	gfloat _tmp128_ = 0.0F;
	gfloat* _tmp129_ = NULL;
	gint _tmp129__length1 = 0;
	gfloat _tmp130_ = 0.0F;
	RGBTransformation* _tmp131_ = NULL;
	gfloat* _tmp132_ = NULL;
	gint _tmp132__length1 = 0;
	gfloat _tmp133_ = 0.0F;
	gfloat* _tmp134_ = NULL;
	gint _tmp134__length1 = 0;
	gfloat _tmp135_ = 0.0F;
	gfloat _tmp136_ = 0.0F;
	gfloat* _tmp137_ = NULL;
	gint _tmp137__length1 = 0;
	RGBTransformation* _tmp138_ = NULL;
	gfloat* _tmp139_ = NULL;
	gint _tmp139__length1 = 0;
	gfloat _tmp140_ = 0.0F;
	gfloat* _tmp141_ = NULL;
	gint _tmp141__length1 = 0;
	gfloat _tmp142_ = 0.0F;
	RGBTransformation* _tmp143_ = NULL;
	gfloat* _tmp144_ = NULL;
	gint _tmp144__length1 = 0;
	gfloat _tmp145_ = 0.0F;
	gfloat* _tmp146_ = NULL;
	gint _tmp146__length1 = 0;
	gfloat _tmp147_ = 0.0F;
	RGBTransformation* _tmp148_ = NULL;
	gfloat* _tmp149_ = NULL;
	gint _tmp149__length1 = 0;
	gfloat _tmp150_ = 0.0F;
	gfloat* _tmp151_ = NULL;
	gint _tmp151__length1 = 0;
	gfloat _tmp152_ = 0.0F;
	RGBTransformation* _tmp153_ = NULL;
	gfloat* _tmp154_ = NULL;
	gint _tmp154__length1 = 0;
	gfloat _tmp155_ = 0.0F;
	gfloat* _tmp156_ = NULL;
	gint _tmp156__length1 = 0;
	gfloat _tmp157_ = 0.0F;
	gfloat _tmp158_ = 0.0F;
	gfloat* _tmp159_ = NULL;
	gint _tmp159__length1 = 0;
	RGBTransformation* _tmp160_ = NULL;
	gfloat* _tmp161_ = NULL;
	gint _tmp161__length1 = 0;
	gfloat _tmp162_ = 0.0F;
	gfloat* _tmp163_ = NULL;
	gint _tmp163__length1 = 0;
	gfloat _tmp164_ = 0.0F;
	RGBTransformation* _tmp165_ = NULL;
	gfloat* _tmp166_ = NULL;
	gint _tmp166__length1 = 0;
	gfloat _tmp167_ = 0.0F;
	gfloat* _tmp168_ = NULL;
	gint _tmp168__length1 = 0;
	gfloat _tmp169_ = 0.0F;
	RGBTransformation* _tmp170_ = NULL;
	gfloat* _tmp171_ = NULL;
	gint _tmp171__length1 = 0;
	gfloat _tmp172_ = 0.0F;
	gfloat* _tmp173_ = NULL;
	gint _tmp173__length1 = 0;
	gfloat _tmp174_ = 0.0F;
	RGBTransformation* _tmp175_ = NULL;
	gfloat* _tmp176_ = NULL;
	gint _tmp176__length1 = 0;
	gfloat _tmp177_ = 0.0F;
	gfloat* _tmp178_ = NULL;
	gint _tmp178__length1 = 0;
	gfloat _tmp179_ = 0.0F;
	gfloat _tmp180_ = 0.0F;
	gfloat* _tmp181_ = NULL;
	gint _tmp181__length1 = 0;
	RGBTransformation* _tmp182_ = NULL;
	gfloat* _tmp183_ = NULL;
	gint _tmp183__length1 = 0;
	gfloat _tmp184_ = 0.0F;
	gfloat* _tmp185_ = NULL;
	gint _tmp185__length1 = 0;
	gfloat _tmp186_ = 0.0F;
	RGBTransformation* _tmp187_ = NULL;
	gfloat* _tmp188_ = NULL;
	gint _tmp188__length1 = 0;
	gfloat _tmp189_ = 0.0F;
	gfloat* _tmp190_ = NULL;
	gint _tmp190__length1 = 0;
	gfloat _tmp191_ = 0.0F;
	RGBTransformation* _tmp192_ = NULL;
	gfloat* _tmp193_ = NULL;
	gint _tmp193__length1 = 0;
	gfloat _tmp194_ = 0.0F;
	gfloat* _tmp195_ = NULL;
	gint _tmp195__length1 = 0;
	gfloat _tmp196_ = 0.0F;
	RGBTransformation* _tmp197_ = NULL;
	gfloat* _tmp198_ = NULL;
	gint _tmp198__length1 = 0;
	gfloat _tmp199_ = 0.0F;
	gfloat* _tmp200_ = NULL;
	gint _tmp200__length1 = 0;
	gfloat _tmp201_ = 0.0F;
	gfloat _tmp202_ = 0.0F;
	gfloat* _tmp203_ = NULL;
	gint _tmp203__length1 = 0;
	RGBTransformation* _tmp204_ = NULL;
	gfloat* _tmp205_ = NULL;
	gint _tmp205__length1 = 0;
	gfloat _tmp206_ = 0.0F;
	gfloat* _tmp207_ = NULL;
	gint _tmp207__length1 = 0;
	gfloat _tmp208_ = 0.0F;
	RGBTransformation* _tmp209_ = NULL;
	gfloat* _tmp210_ = NULL;
	gint _tmp210__length1 = 0;
	gfloat _tmp211_ = 0.0F;
	gfloat* _tmp212_ = NULL;
	gint _tmp212__length1 = 0;
	gfloat _tmp213_ = 0.0F;
	RGBTransformation* _tmp214_ = NULL;
	gfloat* _tmp215_ = NULL;
	gint _tmp215__length1 = 0;
	gfloat _tmp216_ = 0.0F;
	gfloat* _tmp217_ = NULL;
	gint _tmp217__length1 = 0;
	gfloat _tmp218_ = 0.0F;
	RGBTransformation* _tmp219_ = NULL;
	gfloat* _tmp220_ = NULL;
	gint _tmp220__length1 = 0;
	gfloat _tmp221_ = 0.0F;
	gfloat* _tmp222_ = NULL;
	gint _tmp222__length1 = 0;
	gfloat _tmp223_ = 0.0F;
	gfloat _tmp224_ = 0.0F;
	gfloat* _tmp225_ = NULL;
	gint _tmp225__length1 = 0;
	RGBTransformation* _tmp226_ = NULL;
	gfloat* _tmp227_ = NULL;
	gint _tmp227__length1 = 0;
	gfloat _tmp228_ = 0.0F;
	gfloat* _tmp229_ = NULL;
	gint _tmp229__length1 = 0;
	gfloat _tmp230_ = 0.0F;
	RGBTransformation* _tmp231_ = NULL;
	gfloat* _tmp232_ = NULL;
	gint _tmp232__length1 = 0;
	gfloat _tmp233_ = 0.0F;
	gfloat* _tmp234_ = NULL;
	gint _tmp234__length1 = 0;
	gfloat _tmp235_ = 0.0F;
	RGBTransformation* _tmp236_ = NULL;
	gfloat* _tmp237_ = NULL;
	gint _tmp237__length1 = 0;
	gfloat _tmp238_ = 0.0F;
	gfloat* _tmp239_ = NULL;
	gint _tmp239__length1 = 0;
	gfloat _tmp240_ = 0.0F;
	RGBTransformation* _tmp241_ = NULL;
	gfloat* _tmp242_ = NULL;
	gint _tmp242__length1 = 0;
	gfloat _tmp243_ = 0.0F;
	gfloat* _tmp244_ = NULL;
	gint _tmp244__length1 = 0;
	gfloat _tmp245_ = 0.0F;
	gfloat _tmp246_ = 0.0F;
	gfloat* _tmp247_ = NULL;
	gint _tmp247__length1 = 0;
	RGBTransformation* _tmp248_ = NULL;
	gfloat* _tmp249_ = NULL;
	gint _tmp249__length1 = 0;
	gfloat _tmp250_ = 0.0F;
	gfloat* _tmp251_ = NULL;
	gint _tmp251__length1 = 0;
	gfloat _tmp252_ = 0.0F;
	RGBTransformation* _tmp253_ = NULL;
	gfloat* _tmp254_ = NULL;
	gint _tmp254__length1 = 0;
	gfloat _tmp255_ = 0.0F;
	gfloat* _tmp256_ = NULL;
	gint _tmp256__length1 = 0;
	gfloat _tmp257_ = 0.0F;
	RGBTransformation* _tmp258_ = NULL;
	gfloat* _tmp259_ = NULL;
	gint _tmp259__length1 = 0;
	gfloat _tmp260_ = 0.0F;
	gfloat* _tmp261_ = NULL;
	gint _tmp261__length1 = 0;
	gfloat _tmp262_ = 0.0F;
	RGBTransformation* _tmp263_ = NULL;
	gfloat* _tmp264_ = NULL;
	gint _tmp264__length1 = 0;
	gfloat _tmp265_ = 0.0F;
	gfloat* _tmp266_ = NULL;
	gint _tmp266__length1 = 0;
	gfloat _tmp267_ = 0.0F;
	gfloat _tmp268_ = 0.0F;
	gfloat* _tmp269_ = NULL;
	gint _tmp269__length1 = 0;
	RGBTransformation* _tmp270_ = NULL;
	gfloat* _tmp271_ = NULL;
	gint _tmp271__length1 = 0;
	gfloat _tmp272_ = 0.0F;
	gfloat* _tmp273_ = NULL;
	gint _tmp273__length1 = 0;
	gfloat _tmp274_ = 0.0F;
	RGBTransformation* _tmp275_ = NULL;
	gfloat* _tmp276_ = NULL;
	gint _tmp276__length1 = 0;
	gfloat _tmp277_ = 0.0F;
	gfloat* _tmp278_ = NULL;
	gint _tmp278__length1 = 0;
	gfloat _tmp279_ = 0.0F;
	RGBTransformation* _tmp280_ = NULL;
	gfloat* _tmp281_ = NULL;
	gint _tmp281__length1 = 0;
	gfloat _tmp282_ = 0.0F;
	gfloat* _tmp283_ = NULL;
	gint _tmp283__length1 = 0;
	gfloat _tmp284_ = 0.0F;
	RGBTransformation* _tmp285_ = NULL;
	gfloat* _tmp286_ = NULL;
	gint _tmp286__length1 = 0;
	gfloat _tmp287_ = 0.0F;
	gfloat* _tmp288_ = NULL;
	gint _tmp288__length1 = 0;
	gfloat _tmp289_ = 0.0F;
	gfloat _tmp290_ = 0.0F;
	gfloat* _tmp291_ = NULL;
	gint _tmp291__length1 = 0;
	RGBTransformation* _tmp292_ = NULL;
	gfloat* _tmp293_ = NULL;
	gint _tmp293__length1 = 0;
	gfloat _tmp294_ = 0.0F;
	gfloat* _tmp295_ = NULL;
	gint _tmp295__length1 = 0;
	gfloat _tmp296_ = 0.0F;
	RGBTransformation* _tmp297_ = NULL;
	gfloat* _tmp298_ = NULL;
	gint _tmp298__length1 = 0;
	gfloat _tmp299_ = 0.0F;
	gfloat* _tmp300_ = NULL;
	gint _tmp300__length1 = 0;
	gfloat _tmp301_ = 0.0F;
	RGBTransformation* _tmp302_ = NULL;
	gfloat* _tmp303_ = NULL;
	gint _tmp303__length1 = 0;
	gfloat _tmp304_ = 0.0F;
	gfloat* _tmp305_ = NULL;
	gint _tmp305__length1 = 0;
	gfloat _tmp306_ = 0.0F;
	RGBTransformation* _tmp307_ = NULL;
	gfloat* _tmp308_ = NULL;
	gint _tmp308__length1 = 0;
	gfloat _tmp309_ = 0.0F;
	gfloat* _tmp310_ = NULL;
	gint _tmp310__length1 = 0;
	gfloat _tmp311_ = 0.0F;
	gfloat _tmp312_ = 0.0F;
	gfloat* _tmp313_ = NULL;
	gint _tmp313__length1 = 0;
	RGBTransformation* _tmp314_ = NULL;
	gfloat* _tmp315_ = NULL;
	gint _tmp315__length1 = 0;
	gfloat _tmp316_ = 0.0F;
	gfloat* _tmp317_ = NULL;
	gint _tmp317__length1 = 0;
	gfloat _tmp318_ = 0.0F;
	RGBTransformation* _tmp319_ = NULL;
	gfloat* _tmp320_ = NULL;
	gint _tmp320__length1 = 0;
	gfloat _tmp321_ = 0.0F;
	gfloat* _tmp322_ = NULL;
	gint _tmp322__length1 = 0;
	gfloat _tmp323_ = 0.0F;
	RGBTransformation* _tmp324_ = NULL;
	gfloat* _tmp325_ = NULL;
	gint _tmp325__length1 = 0;
	gfloat _tmp326_ = 0.0F;
	gfloat* _tmp327_ = NULL;
	gint _tmp327__length1 = 0;
	gfloat _tmp328_ = 0.0F;
	RGBTransformation* _tmp329_ = NULL;
	gfloat* _tmp330_ = NULL;
	gint _tmp330__length1 = 0;
	gfloat _tmp331_ = 0.0F;
	gfloat* _tmp332_ = NULL;
	gint _tmp332__length1 = 0;
	gfloat _tmp333_ = 0.0F;
	gfloat _tmp334_ = 0.0F;
	gfloat* _tmp335_ = NULL;
	gint _tmp335__length1 = 0;
	RGBTransformation* _tmp336_ = NULL;
	gfloat* _tmp337_ = NULL;
	gint _tmp337__length1 = 0;
	gfloat _tmp338_ = 0.0F;
	gfloat* _tmp339_ = NULL;
	gint _tmp339__length1 = 0;
	gfloat _tmp340_ = 0.0F;
	RGBTransformation* _tmp341_ = NULL;
	gfloat* _tmp342_ = NULL;
	gint _tmp342__length1 = 0;
	gfloat _tmp343_ = 0.0F;
	gfloat* _tmp344_ = NULL;
	gint _tmp344__length1 = 0;
	gfloat _tmp345_ = 0.0F;
	RGBTransformation* _tmp346_ = NULL;
	gfloat* _tmp347_ = NULL;
	gint _tmp347__length1 = 0;
	gfloat _tmp348_ = 0.0F;
	gfloat* _tmp349_ = NULL;
	gint _tmp349__length1 = 0;
	gfloat _tmp350_ = 0.0F;
	RGBTransformation* _tmp351_ = NULL;
	gfloat* _tmp352_ = NULL;
	gint _tmp352__length1 = 0;
	gfloat _tmp353_ = 0.0F;
	gfloat* _tmp354_ = NULL;
	gint _tmp354__length1 = 0;
	gfloat _tmp355_ = 0.0F;
	gfloat _tmp356_ = 0.0F;
	gboolean _tmp366_ = FALSE;
	gboolean _tmp367_ = FALSE;
#line 442 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 442 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (other));
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = other;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixel_transformation_get_composition_mode (_tmp0_);
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_ != COMPOSITION_MODE_RGB_MATRIX) {
#line 444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:444: %s", "RGBTransformation: compose_with( ): 'other' transformation " "does not support RGB_MATRIX composition mode");
#line 4022 "ColorTransformation.c"
	}
#line 447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = other;
#line 447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _pixel_transformation_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_RGB_TRANSFORMATION, RGBTransformation));
#line 447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	transform = _tmp3_;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = g_new0 (gfloat, 16);
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result_matrix_entries = _tmp4_;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result_matrix_entries_length1 = 16;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_matrix_entries_size_ = result_matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = result_matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5__length1 = result_matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = transform;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7__length1 = _tmp6_->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp7_[0];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = self->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9__length1 = self->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = _tmp9_[0];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = transform;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = _tmp11_->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12__length1 = _tmp11_->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_[1];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = self->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14__length1 = self->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_[4];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = transform;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = _tmp16_->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17__length1 = _tmp16_->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = _tmp17_[2];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = self->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19__length1 = self->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = _tmp19_[8];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = transform;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = _tmp21_->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22__length1 = _tmp21_->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_[3];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = self->matrix_entries;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24__length1 = self->matrix_entries_length1;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = _tmp24_[12];
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_[0] = (((_tmp8_ * _tmp10_) + (_tmp13_ * _tmp15_)) + (_tmp18_ * _tmp20_)) + (_tmp23_ * _tmp25_);
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = _tmp5_[0];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = result_matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27__length1 = result_matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = transform;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp28_->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29__length1 = _tmp28_->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = _tmp29_[0];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = self->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31__length1 = self->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = _tmp31_[1];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = transform;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = _tmp33_->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34__length1 = _tmp33_->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_[1];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36_ = self->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36__length1 = self->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp37_ = _tmp36_[5];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38_ = transform;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39_ = _tmp38_->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39__length1 = _tmp38_->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40_ = _tmp39_[2];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = self->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41__length1 = self->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = _tmp41_[9];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = transform;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = _tmp43_->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44__length1 = _tmp43_->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = _tmp44_[3];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = self->matrix_entries;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46__length1 = self->matrix_entries_length1;
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = _tmp46_[13];
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_[1] = (((_tmp30_ * _tmp32_) + (_tmp35_ * _tmp37_)) + (_tmp40_ * _tmp42_)) + (_tmp45_ * _tmp47_);
#line 458 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = _tmp27_[1];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = result_matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49__length1 = result_matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = transform;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51_ = _tmp50_->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51__length1 = _tmp50_->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52_ = _tmp51_[0];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = self->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53__length1 = self->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = _tmp53_[2];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = transform;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = _tmp55_->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56__length1 = _tmp55_->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = _tmp56_[1];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = self->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58__length1 = self->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp59_ = _tmp58_[6];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60_ = transform;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61_ = _tmp60_->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61__length1 = _tmp60_->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp62_ = _tmp61_[2];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_ = self->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63__length1 = self->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp64_ = _tmp63_[10];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp65_ = transform;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66_ = _tmp65_->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66__length1 = _tmp65_->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp67_ = _tmp66_[3];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68_ = self->matrix_entries;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68__length1 = self->matrix_entries_length1;
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp69_ = _tmp68_[14];
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_[2] = (((_tmp52_ * _tmp54_) + (_tmp57_ * _tmp59_)) + (_tmp62_ * _tmp64_)) + (_tmp67_ * _tmp69_);
#line 464 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp70_ = _tmp49_[2];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71_ = result_matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71__length1 = result_matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp72_ = transform;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73_ = _tmp72_->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73__length1 = _tmp72_->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp74_ = _tmp73_[0];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp75_ = self->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp75__length1 = self->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp76_ = _tmp75_[3];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp77_ = transform;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78_ = _tmp77_->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78__length1 = _tmp77_->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp79_ = _tmp78_[1];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80_ = self->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80__length1 = self->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp81_ = _tmp80_[7];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp82_ = transform;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp83_ = _tmp82_->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp83__length1 = _tmp82_->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp84_ = _tmp83_[2];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85_ = self->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85__length1 = self->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp86_ = _tmp85_[11];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp87_ = transform;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88_ = _tmp87_->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88__length1 = _tmp87_->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp89_ = _tmp88_[3];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90_ = self->matrix_entries;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90__length1 = self->matrix_entries_length1;
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp91_ = _tmp90_[15];
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71_[3] = (((_tmp74_ * _tmp76_) + (_tmp79_ * _tmp81_)) + (_tmp84_ * _tmp86_)) + (_tmp89_ * _tmp91_);
#line 470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp92_ = _tmp71_[3];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93_ = result_matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93__length1 = result_matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp94_ = transform;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp95_ = _tmp94_->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp95__length1 = _tmp94_->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp96_ = _tmp95_[4];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97_ = self->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97__length1 = self->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp98_ = _tmp97_[0];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp99_ = transform;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100_ = _tmp99_->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100__length1 = _tmp99_->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp101_ = _tmp100_[5];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102_ = self->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102__length1 = self->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp103_ = _tmp102_[4];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp104_ = transform;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp105_ = _tmp104_->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp105__length1 = _tmp104_->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp106_ = _tmp105_[6];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp107_ = self->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp107__length1 = self->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp108_ = _tmp107_[8];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp109_ = transform;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp110_ = _tmp109_->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp110__length1 = _tmp109_->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp111_ = _tmp110_[7];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp112_ = self->matrix_entries;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp112__length1 = self->matrix_entries_length1;
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp113_ = _tmp112_[12];
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93_[4] = (((_tmp96_ * _tmp98_) + (_tmp101_ * _tmp103_)) + (_tmp106_ * _tmp108_)) + (_tmp111_ * _tmp113_);
#line 477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp114_ = _tmp93_[4];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp115_ = result_matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp115__length1 = result_matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp116_ = transform;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp117_ = _tmp116_->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp117__length1 = _tmp116_->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp118_ = _tmp117_[4];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp119_ = self->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp119__length1 = self->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp120_ = _tmp119_[1];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp121_ = transform;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp122_ = _tmp121_->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp122__length1 = _tmp121_->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp123_ = _tmp122_[5];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp124_ = self->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp124__length1 = self->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp125_ = _tmp124_[5];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp126_ = transform;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp127_ = _tmp126_->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp127__length1 = _tmp126_->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp128_ = _tmp127_[6];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp129_ = self->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp129__length1 = self->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp130_ = _tmp129_[9];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp131_ = transform;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp132_ = _tmp131_->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp132__length1 = _tmp131_->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp133_ = _tmp132_[7];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp134_ = self->matrix_entries;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp134__length1 = self->matrix_entries_length1;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp135_ = _tmp134_[13];
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp115_[5] = (((_tmp118_ * _tmp120_) + (_tmp123_ * _tmp125_)) + (_tmp128_ * _tmp130_)) + (_tmp133_ * _tmp135_);
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp136_ = _tmp115_[5];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp137_ = result_matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp137__length1 = result_matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp138_ = transform;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp139_ = _tmp138_->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp139__length1 = _tmp138_->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp140_ = _tmp139_[4];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp141_ = self->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp141__length1 = self->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp142_ = _tmp141_[2];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp143_ = transform;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp144_ = _tmp143_->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp144__length1 = _tmp143_->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp145_ = _tmp144_[5];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp146_ = self->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp146__length1 = self->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp147_ = _tmp146_[6];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp148_ = transform;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp149_ = _tmp148_->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp149__length1 = _tmp148_->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp150_ = _tmp149_[6];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp151_ = self->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp151__length1 = self->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp152_ = _tmp151_[10];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp153_ = transform;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp154_ = _tmp153_->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp154__length1 = _tmp153_->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp155_ = _tmp154_[7];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp156_ = self->matrix_entries;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp156__length1 = self->matrix_entries_length1;
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp157_ = _tmp156_[14];
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp137_[6] = (((_tmp140_ * _tmp142_) + (_tmp145_ * _tmp147_)) + (_tmp150_ * _tmp152_)) + (_tmp155_ * _tmp157_);
#line 489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp158_ = _tmp137_[6];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp159_ = result_matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp159__length1 = result_matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp160_ = transform;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp161_ = _tmp160_->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp161__length1 = _tmp160_->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp162_ = _tmp161_[4];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp163_ = self->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp163__length1 = self->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp164_ = _tmp163_[3];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp165_ = transform;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp166_ = _tmp165_->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp166__length1 = _tmp165_->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp167_ = _tmp166_[5];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp168_ = self->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp168__length1 = self->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp169_ = _tmp168_[7];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp170_ = transform;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp171_ = _tmp170_->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp171__length1 = _tmp170_->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp172_ = _tmp171_[6];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp173_ = self->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp173__length1 = self->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp174_ = _tmp173_[11];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp175_ = transform;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp176_ = _tmp175_->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp176__length1 = _tmp175_->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp177_ = _tmp176_[7];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp178_ = self->matrix_entries;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp178__length1 = self->matrix_entries_length1;
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp179_ = _tmp178_[15];
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp159_[7] = (((_tmp162_ * _tmp164_) + (_tmp167_ * _tmp169_)) + (_tmp172_ * _tmp174_)) + (_tmp177_ * _tmp179_);
#line 495 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp180_ = _tmp159_[7];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp181_ = result_matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp181__length1 = result_matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp182_ = transform;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp183_ = _tmp182_->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp183__length1 = _tmp182_->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp184_ = _tmp183_[8];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp185_ = self->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp185__length1 = self->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp186_ = _tmp185_[0];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp187_ = transform;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp188_ = _tmp187_->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp188__length1 = _tmp187_->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp189_ = _tmp188_[9];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp190_ = self->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp190__length1 = self->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp191_ = _tmp190_[4];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp192_ = transform;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp193_ = _tmp192_->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp193__length1 = _tmp192_->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp194_ = _tmp193_[10];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp195_ = self->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp195__length1 = self->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp196_ = _tmp195_[8];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp197_ = transform;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp198_ = _tmp197_->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp198__length1 = _tmp197_->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp199_ = _tmp198_[11];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp200_ = self->matrix_entries;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp200__length1 = self->matrix_entries_length1;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp201_ = _tmp200_[12];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp181_[8] = (((_tmp184_ * _tmp186_) + (_tmp189_ * _tmp191_)) + (_tmp194_ * _tmp196_)) + (_tmp199_ * _tmp201_);
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp202_ = _tmp181_[8];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp203_ = result_matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp203__length1 = result_matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp204_ = transform;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp205_ = _tmp204_->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp205__length1 = _tmp204_->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp206_ = _tmp205_[8];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp207_ = self->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp207__length1 = self->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp208_ = _tmp207_[1];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp209_ = transform;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp210_ = _tmp209_->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp210__length1 = _tmp209_->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp211_ = _tmp210_[9];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp212_ = self->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp212__length1 = self->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp213_ = _tmp212_[5];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp214_ = transform;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp215_ = _tmp214_->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp215__length1 = _tmp214_->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp216_ = _tmp215_[10];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp217_ = self->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp217__length1 = self->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp218_ = _tmp217_[9];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp219_ = transform;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp220_ = _tmp219_->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp220__length1 = _tmp219_->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp221_ = _tmp220_[11];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp222_ = self->matrix_entries;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp222__length1 = self->matrix_entries_length1;
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp223_ = _tmp222_[13];
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp203_[9] = (((_tmp206_ * _tmp208_) + (_tmp211_ * _tmp213_)) + (_tmp216_ * _tmp218_)) + (_tmp221_ * _tmp223_);
#line 508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp224_ = _tmp203_[9];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp225_ = result_matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp225__length1 = result_matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp226_ = transform;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp227_ = _tmp226_->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp227__length1 = _tmp226_->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp228_ = _tmp227_[8];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp229_ = self->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp229__length1 = self->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp230_ = _tmp229_[2];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp231_ = transform;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp232_ = _tmp231_->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp232__length1 = _tmp231_->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp233_ = _tmp232_[9];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp234_ = self->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp234__length1 = self->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp235_ = _tmp234_[6];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp236_ = transform;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp237_ = _tmp236_->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp237__length1 = _tmp236_->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp238_ = _tmp237_[10];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp239_ = self->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp239__length1 = self->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp240_ = _tmp239_[10];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp241_ = transform;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp242_ = _tmp241_->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp242__length1 = _tmp241_->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp243_ = _tmp242_[11];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp244_ = self->matrix_entries;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp244__length1 = self->matrix_entries_length1;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp245_ = _tmp244_[14];
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp225_[10] = (((_tmp228_ * _tmp230_) + (_tmp233_ * _tmp235_)) + (_tmp238_ * _tmp240_)) + (_tmp243_ * _tmp245_);
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp246_ = _tmp225_[10];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp247_ = result_matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp247__length1 = result_matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp248_ = transform;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp249_ = _tmp248_->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp249__length1 = _tmp248_->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp250_ = _tmp249_[8];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp251_ = self->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp251__length1 = self->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp252_ = _tmp251_[3];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp253_ = transform;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp254_ = _tmp253_->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp254__length1 = _tmp253_->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp255_ = _tmp254_[9];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp256_ = self->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp256__length1 = self->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp257_ = _tmp256_[7];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp258_ = transform;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp259_ = _tmp258_->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp259__length1 = _tmp258_->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp260_ = _tmp259_[10];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp261_ = self->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp261__length1 = self->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp262_ = _tmp261_[11];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp263_ = transform;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp264_ = _tmp263_->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp264__length1 = _tmp263_->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp265_ = _tmp264_[11];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp266_ = self->matrix_entries;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp266__length1 = self->matrix_entries_length1;
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp267_ = _tmp266_[15];
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp247_[11] = (((_tmp250_ * _tmp252_) + (_tmp255_ * _tmp257_)) + (_tmp260_ * _tmp262_)) + (_tmp265_ * _tmp267_);
#line 520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp268_ = _tmp247_[11];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp269_ = result_matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp269__length1 = result_matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp270_ = transform;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp271_ = _tmp270_->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp271__length1 = _tmp270_->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp272_ = _tmp271_[12];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp273_ = self->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp273__length1 = self->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp274_ = _tmp273_[0];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp275_ = transform;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp276_ = _tmp275_->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp276__length1 = _tmp275_->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp277_ = _tmp276_[13];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp278_ = self->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp278__length1 = self->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp279_ = _tmp278_[4];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp280_ = transform;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp281_ = _tmp280_->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp281__length1 = _tmp280_->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp282_ = _tmp281_[14];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp283_ = self->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp283__length1 = self->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp284_ = _tmp283_[8];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp285_ = transform;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp286_ = _tmp285_->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp286__length1 = _tmp285_->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp287_ = _tmp286_[15];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp288_ = self->matrix_entries;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp288__length1 = self->matrix_entries_length1;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp289_ = _tmp288_[12];
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp269_[12] = (((_tmp272_ * _tmp274_) + (_tmp277_ * _tmp279_)) + (_tmp282_ * _tmp284_)) + (_tmp287_ * _tmp289_);
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp290_ = _tmp269_[12];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp291_ = result_matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp291__length1 = result_matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp292_ = transform;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp293_ = _tmp292_->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp293__length1 = _tmp292_->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp294_ = _tmp293_[12];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp295_ = self->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp295__length1 = self->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp296_ = _tmp295_[1];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp297_ = transform;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp298_ = _tmp297_->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp298__length1 = _tmp297_->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp299_ = _tmp298_[13];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp300_ = self->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp300__length1 = self->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp301_ = _tmp300_[5];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp302_ = transform;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp303_ = _tmp302_->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp303__length1 = _tmp302_->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp304_ = _tmp303_[14];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp305_ = self->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp305__length1 = self->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp306_ = _tmp305_[9];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp307_ = transform;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp308_ = _tmp307_->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp308__length1 = _tmp307_->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp309_ = _tmp308_[15];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp310_ = self->matrix_entries;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp310__length1 = self->matrix_entries_length1;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp311_ = _tmp310_[13];
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp291_[13] = (((_tmp294_ * _tmp296_) + (_tmp299_ * _tmp301_)) + (_tmp304_ * _tmp306_)) + (_tmp309_ * _tmp311_);
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp312_ = _tmp291_[13];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp313_ = result_matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp313__length1 = result_matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp314_ = transform;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp315_ = _tmp314_->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp315__length1 = _tmp314_->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp316_ = _tmp315_[12];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp317_ = self->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp317__length1 = self->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp318_ = _tmp317_[2];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp319_ = transform;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp320_ = _tmp319_->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp320__length1 = _tmp319_->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp321_ = _tmp320_[13];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp322_ = self->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp322__length1 = self->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp323_ = _tmp322_[6];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp324_ = transform;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp325_ = _tmp324_->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp325__length1 = _tmp324_->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp326_ = _tmp325_[14];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp327_ = self->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp327__length1 = self->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp328_ = _tmp327_[10];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp329_ = transform;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp330_ = _tmp329_->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp330__length1 = _tmp329_->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp331_ = _tmp330_[15];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp332_ = self->matrix_entries;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp332__length1 = self->matrix_entries_length1;
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp333_ = _tmp332_[14];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp313_[14] = (((_tmp316_ * _tmp318_) + (_tmp321_ * _tmp323_)) + (_tmp326_ * _tmp328_)) + (_tmp331_ * _tmp333_);
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp334_ = _tmp313_[14];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp335_ = result_matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp335__length1 = result_matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp336_ = transform;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp337_ = _tmp336_->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp337__length1 = _tmp336_->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp338_ = _tmp337_[12];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp339_ = self->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp339__length1 = self->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp340_ = _tmp339_[3];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp341_ = transform;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp342_ = _tmp341_->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp342__length1 = _tmp341_->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp343_ = _tmp342_[13];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp344_ = self->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp344__length1 = self->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp345_ = _tmp344_[7];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp346_ = transform;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp347_ = _tmp346_->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp347__length1 = _tmp346_->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp348_ = _tmp347_[14];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp349_ = self->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp349__length1 = self->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp350_ = _tmp349_[11];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp351_ = transform;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp352_ = _tmp351_->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp352__length1 = _tmp351_->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp353_ = _tmp352_[15];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp354_ = self->matrix_entries;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp354__length1 = self->matrix_entries_length1;
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp355_ = _tmp354_[15];
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp335_[15] = (((_tmp338_ * _tmp340_) + (_tmp343_ * _tmp345_)) + (_tmp348_ * _tmp350_)) + (_tmp353_ * _tmp355_);
#line 545 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp356_ = _tmp335_[15];
#line 5062 "ColorTransformation.c"
	{
		gint i = 0;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 5067 "ColorTransformation.c"
		{
			gboolean _tmp357_ = FALSE;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp357_ = TRUE;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 5074 "ColorTransformation.c"
				gint _tmp359_ = 0;
				gfloat* _tmp360_ = NULL;
				gint _tmp360__length1 = 0;
				gint _tmp361_ = 0;
				gfloat* _tmp362_ = NULL;
				gint _tmp362__length1 = 0;
				gint _tmp363_ = 0;
				gfloat _tmp364_ = 0.0F;
				gfloat _tmp365_ = 0.0F;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp357_) {
#line 5086 "ColorTransformation.c"
					gint _tmp358_ = 0;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp358_ = i;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp358_ + 1;
#line 5092 "ColorTransformation.c"
				}
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp357_ = FALSE;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp359_ = i;
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp359_ < RGB_TRANSFORMATION_MATRIX_SIZE)) {
#line 551 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 5102 "ColorTransformation.c"
				}
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp360_ = self->matrix_entries;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp360__length1 = self->matrix_entries_length1;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp361_ = i;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp362_ = result_matrix_entries;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp362__length1 = result_matrix_entries_length1;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp363_ = i;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp364_ = _tmp362_[_tmp363_];
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp360_[_tmp361_] = _tmp364_;
#line 552 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp365_ = _tmp360_[_tmp361_];
#line 5122 "ColorTransformation.c"
			}
		}
	}
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp367_ = self->identity;
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp367_) {
#line 5130 "ColorTransformation.c"
		RGBTransformation* _tmp368_ = NULL;
		gboolean _tmp369_ = FALSE;
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp368_ = transform;
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp369_ = _tmp368_->identity;
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp366_ = _tmp369_;
#line 5139 "ColorTransformation.c"
	} else {
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp366_ = FALSE;
#line 5143 "ColorTransformation.c"
	}
#line 554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->identity = _tmp366_;
#line 442 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result_matrix_entries = (g_free (result_matrix_entries), NULL);
#line 442 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (transform);
#line 5151 "ColorTransformation.c"
}


static void rgb_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* p, HSVAnalyticPixel* result) {
	RGBTransformation * self;
	RGBAnalyticPixel _tmp0_ = {0};
	RGBAnalyticPixel _tmp1_ = {0};
	HSVAnalyticPixel _tmp2_ = {0};
#line 557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_to_rgb (p, &_tmp0_);
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_transform_pixel_rgb (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation), &_tmp0_, &_tmp1_);
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_analytic_pixel_to_hsv (&_tmp1_, &_tmp2_);
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp2_;
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 5174 "ColorTransformation.c"
}


static void rgb_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
	RGBTransformation * self;
	gfloat red_out = 0.0F;
	RGBAnalyticPixel _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
	gfloat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gfloat _tmp3_ = 0.0F;
	RGBAnalyticPixel _tmp4_ = {0};
	gfloat _tmp5_ = 0.0F;
	gfloat* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gfloat _tmp7_ = 0.0F;
	RGBAnalyticPixel _tmp8_ = {0};
	gfloat _tmp9_ = 0.0F;
	gfloat* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gfloat _tmp11_ = 0.0F;
	gfloat* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gfloat _tmp13_ = 0.0F;
	gfloat _tmp14_ = 0.0F;
	gfloat _tmp15_ = 0.0F;
	gfloat green_out = 0.0F;
	RGBAnalyticPixel _tmp16_ = {0};
	gfloat _tmp17_ = 0.0F;
	gfloat* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gfloat _tmp19_ = 0.0F;
	RGBAnalyticPixel _tmp20_ = {0};
	gfloat _tmp21_ = 0.0F;
	gfloat* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gfloat _tmp23_ = 0.0F;
	RGBAnalyticPixel _tmp24_ = {0};
	gfloat _tmp25_ = 0.0F;
	gfloat* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gfloat _tmp27_ = 0.0F;
	gfloat* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gfloat _tmp29_ = 0.0F;
	gfloat _tmp30_ = 0.0F;
	gfloat _tmp31_ = 0.0F;
	gfloat blue_out = 0.0F;
	RGBAnalyticPixel _tmp32_ = {0};
	gfloat _tmp33_ = 0.0F;
	gfloat* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gfloat _tmp35_ = 0.0F;
	RGBAnalyticPixel _tmp36_ = {0};
	gfloat _tmp37_ = 0.0F;
	gfloat* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gfloat _tmp39_ = 0.0F;
	RGBAnalyticPixel _tmp40_ = {0};
	gfloat _tmp41_ = 0.0F;
	gfloat* _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gfloat _tmp43_ = 0.0F;
	gfloat* _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	gfloat _tmp45_ = 0.0F;
	gfloat _tmp46_ = 0.0F;
	gfloat _tmp47_ = 0.0F;
	gfloat _tmp48_ = 0.0F;
	gfloat _tmp49_ = 0.0F;
	gfloat _tmp50_ = 0.0F;
	RGBAnalyticPixel _tmp51_ = {0};
#line 561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _tmp0_.red;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->matrix_entries;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = self->matrix_entries_length1;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_[0];
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = *p;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_.green;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = self->matrix_entries;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6__length1 = self->matrix_entries_length1;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_[1];
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = *p;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = _tmp8_.blue;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = self->matrix_entries;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10__length1 = self->matrix_entries_length1;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_[2];
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = self->matrix_entries;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12__length1 = self->matrix_entries_length1;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_[3];
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	red_out = (((_tmp1_ * _tmp3_) + (_tmp5_ * _tmp7_)) + (_tmp9_ * _tmp11_)) + _tmp13_;
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = red_out;
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = CLAMP (_tmp14_, 0.0f, 1.0f);
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	red_out = _tmp15_;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = *p;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = _tmp16_.red;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = self->matrix_entries;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18__length1 = self->matrix_entries_length1;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = _tmp18_[4];
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = *p;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = _tmp20_.green;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = self->matrix_entries;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22__length1 = self->matrix_entries_length1;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_[5];
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = *p;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = _tmp24_.blue;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = self->matrix_entries;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26__length1 = self->matrix_entries_length1;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = _tmp26_[6];
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = self->matrix_entries;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28__length1 = self->matrix_entries_length1;
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp28_[7];
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	green_out = (((_tmp17_ * _tmp19_) + (_tmp21_ * _tmp23_)) + (_tmp25_ * _tmp27_)) + _tmp29_;
#line 572 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = green_out;
#line 572 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = CLAMP (_tmp30_, 0.0f, 1.0f);
#line 572 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	green_out = _tmp31_;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = *p;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = _tmp32_.red;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = self->matrix_entries;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34__length1 = self->matrix_entries_length1;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_[8];
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36_ = *p;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp37_ = _tmp36_.green;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38_ = self->matrix_entries;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38__length1 = self->matrix_entries_length1;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39_ = _tmp38_[9];
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40_ = *p;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = _tmp40_.blue;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = self->matrix_entries;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42__length1 = self->matrix_entries_length1;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = _tmp42_[10];
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = self->matrix_entries;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44__length1 = self->matrix_entries_length1;
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = _tmp44_[11];
#line 574 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	blue_out = (((_tmp33_ * _tmp35_) + (_tmp37_ * _tmp39_)) + (_tmp41_ * _tmp43_)) + _tmp45_;
#line 578 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = blue_out;
#line 578 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = CLAMP (_tmp46_, 0.0f, 1.0f);
#line 578 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	blue_out = _tmp47_;
#line 580 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = red_out;
#line 580 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = green_out;
#line 580 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = blue_out;
#line 580 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_analytic_pixel_init_from_components (&_tmp51_, _tmp48_, _tmp49_, _tmp50_);
#line 580 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp51_;
#line 580 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 5395 "ColorTransformation.c"
}


static gboolean rgb_transformation_real_is_identity (PixelTransformation* base) {
	RGBTransformation * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 583 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 584 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->identity;
#line 584 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 584 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5411 "ColorTransformation.c"
}


static PixelTransformation* rgb_transformation_real_copy (PixelTransformation* base) {
	RGBTransformation * self;
	PixelTransformation* result = NULL;
	RGBTransformation* _result_ = NULL;
	PixelTransformationType _tmp0_ = 0;
	RGBTransformation* _tmp1_ = NULL;
#line 587 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 588 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_get_transformation_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 588 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = rgb_transformation_new (_tmp0_);
#line 588 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_ = _tmp1_;
#line 5429 "ColorTransformation.c"
	{
		gint i = 0;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 5434 "ColorTransformation.c"
		{
			gboolean _tmp2_ = FALSE;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp2_ = TRUE;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 5441 "ColorTransformation.c"
				gint _tmp4_ = 0;
				RGBTransformation* _tmp5_ = NULL;
				gfloat* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gfloat* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gfloat _tmp10_ = 0.0F;
				gfloat _tmp11_ = 0.0F;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp2_) {
#line 5454 "ColorTransformation.c"
					gint _tmp3_ = 0;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp3_ = i;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp3_ + 1;
#line 5460 "ColorTransformation.c"
				}
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp2_ = FALSE;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = i;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp4_ < RGB_TRANSFORMATION_MATRIX_SIZE)) {
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 5470 "ColorTransformation.c"
				}
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = _result_;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = _tmp5_->matrix_entries;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6__length1 = _tmp5_->matrix_entries_length1;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = self->matrix_entries;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8__length1 = self->matrix_entries_length1;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = i;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_[_tmp7_] = _tmp10_;
#line 591 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = _tmp6_[_tmp7_];
#line 5492 "ColorTransformation.c"
			}
		}
	}
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5500 "ColorTransformation.c"
}


static void rgb_transformation_class_init (RGBTransformationClass * klass) {
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_transformation_parent_class = g_type_class_peek_parent (klass);
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = rgb_transformation_finalize;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_preferred_format = (PixelFormat (*)(PixelTransformation*)) rgb_transformation_real_get_preferred_format;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*)(PixelTransformation*)) rgb_transformation_real_get_composition_mode;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->compose_with = (void (*)(PixelTransformation*, PixelTransformation*)) rgb_transformation_real_compose_with;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*)(PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) rgb_transformation_real_transform_pixel_hsv;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*)(PixelTransformation*, RGBAnalyticPixel*, RGBAnalyticPixel*)) rgb_transformation_real_transform_pixel_rgb;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*)(PixelTransformation*)) rgb_transformation_real_is_identity;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*)(PixelTransformation*)) rgb_transformation_real_copy;
#line 5523 "ColorTransformation.c"
}


static void rgb_transformation_instance_init (RGBTransformation * self) {
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->identity = TRUE;
#line 5530 "ColorTransformation.c"
}


static void rgb_transformation_finalize (PixelTransformation* obj) {
	RGBTransformation * self;
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 414 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries = (g_free (self->matrix_entries), NULL);
#line 411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (rgb_transformation_parent_class)->finalize (obj);
#line 5542 "ColorTransformation.c"
}


GType rgb_transformation_get_type (void) {
	static volatile gsize rgb_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RGBTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBTransformation), 0, (GInstanceInitFunc) rgb_transformation_instance_init, NULL };
		GType rgb_transformation_type_id;
		rgb_transformation_type_id = g_type_register_static (TYPE_PIXEL_TRANSFORMATION, "RGBTransformation", &g_define_type_info, 0);
		g_once_init_leave (&rgb_transformation_type_id__volatile, rgb_transformation_type_id);
	}
	return rgb_transformation_type_id__volatile;
}


HSVTransformation* hsv_transformation_construct (GType object_type, PixelTransformationType type) {
	HSVTransformation* self = NULL;
	PixelTransformationType _tmp0_ = 0;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = type;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (HSVTransformation*) pixel_transformation_construct (object_type, _tmp0_);
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5567 "ColorTransformation.c"
}


static PixelFormat hsv_transformation_real_get_preferred_format (PixelTransformation* base) {
	HSVTransformation * self;
	PixelFormat result = 0;
#line 603 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = PIXEL_FORMAT_HSV;
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5580 "ColorTransformation.c"
}


static void hsv_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
	HSVTransformation * self;
	HSVAnalyticPixel _tmp0_ = {0};
	HSVAnalyticPixel _tmp1_ = {0};
	RGBAnalyticPixel _tmp2_ = {0};
#line 607 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 607 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 608 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_analytic_pixel_to_hsv (p, &_tmp0_);
#line 608 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_transform_pixel_hsv (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation), &_tmp0_, &_tmp1_);
#line 608 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_to_rgb (&_tmp1_, &_tmp2_);
#line 608 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp2_;
#line 608 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 5603 "ColorTransformation.c"
}


static void hsv_transformation_class_init (HSVTransformationClass * klass) {
#line 598 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_transformation_parent_class = g_type_class_peek_parent (klass);
#line 598 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_preferred_format = (PixelFormat (*)(PixelTransformation*)) hsv_transformation_real_get_preferred_format;
#line 598 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*)(PixelTransformation*, RGBAnalyticPixel*, RGBAnalyticPixel*)) hsv_transformation_real_transform_pixel_rgb;
#line 5614 "ColorTransformation.c"
}


static void hsv_transformation_instance_init (HSVTransformation * self) {
}


GType hsv_transformation_get_type (void) {
	static volatile gsize hsv_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&hsv_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HSVTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hsv_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HSVTransformation), 0, (GInstanceInitFunc) hsv_transformation_instance_init, NULL };
		GType hsv_transformation_type_id;
		hsv_transformation_type_id = g_type_register_static (TYPE_PIXEL_TRANSFORMATION, "HSVTransformation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&hsv_transformation_type_id__volatile, hsv_transformation_type_id);
	}
	return hsv_transformation_type_id__volatile;
}


TintTransformation* tint_transformation_construct (GType object_type, gfloat client_param) {
	TintTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 620 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (TintTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TINT);
#line 622 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_param;
#line 622 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, TINT_TRANSFORMATION_MIN_PARAMETER, TINT_TRANSFORMATION_MAX_PARAMETER);
#line 622 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 624 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 624 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5651 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_ = 0.0F;
		gfloat _tmp4_ = 0.0F;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
		gfloat _tmp7_ = 0.0F;
		gfloat* _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gfloat _tmp9_ = 0.0F;
		gfloat _tmp10_ = 0.0F;
		gfloat* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gfloat _tmp12_ = 0.0F;
		gfloat _tmp13_ = 0.0F;
#line 625 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 625 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp3_ / TINT_TRANSFORMATION_MAX_PARAMETER;
#line 626 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = adjusted_param;
#line 626 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp4_ * TINT_TRANSFORMATION_INTENSITY_FACTOR;
#line 628 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 628 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 628 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = adjusted_param;
#line 628 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_[11] -= _tmp6_ / 2;
#line 628 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[11];
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = adjusted_param;
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_[7] += _tmp9_;
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = _tmp8_[7];
#line 630 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 630 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 630 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = adjusted_param;
#line 630 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_[3] -= _tmp12_ / 2;
#line 630 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = _tmp11_[3];
#line 632 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5707 "ColorTransformation.c"
	}
#line 619 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5711 "ColorTransformation.c"
}


TintTransformation* tint_transformation_new (gfloat client_param) {
#line 619 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return tint_transformation_construct (TYPE_TINT_TRANSFORMATION, client_param);
#line 5718 "ColorTransformation.c"
}


gfloat tint_transformation_get_parameter (TintTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 636 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_TINT_TRANSFORMATION (self), 0.0F);
#line 637 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 637 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 637 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5733 "ColorTransformation.c"
}


static void tint_transformation_class_init (TintTransformationClass * klass) {
#line 612 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	tint_transformation_parent_class = g_type_class_peek_parent (klass);
#line 612 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = tint_transformation_finalize;
#line 612 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (TintTransformationPrivate));
#line 5744 "ColorTransformation.c"
}


static void tint_transformation_instance_init (TintTransformation * self) {
#line 612 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = TINT_TRANSFORMATION_GET_PRIVATE (self);
#line 5751 "ColorTransformation.c"
}


static void tint_transformation_finalize (PixelTransformation* obj) {
	TintTransformation * self;
#line 612 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TINT_TRANSFORMATION, TintTransformation);
#line 612 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (tint_transformation_parent_class)->finalize (obj);
#line 5761 "ColorTransformation.c"
}


GType tint_transformation_get_type (void) {
	static volatile gsize tint_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&tint_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TintTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tint_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TintTransformation), 0, (GInstanceInitFunc) tint_transformation_instance_init, NULL };
		GType tint_transformation_type_id;
		tint_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "TintTransformation", &g_define_type_info, 0);
		g_once_init_leave (&tint_transformation_type_id__volatile, tint_transformation_type_id);
	}
	return tint_transformation_type_id__volatile;
}


TemperatureTransformation* temperature_transformation_construct (GType object_type, gfloat client_parameter) {
	TemperatureTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 649 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (TemperatureTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TEMPERATURE);
#line 651 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 651 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, TEMPERATURE_TRANSFORMATION_MIN_PARAMETER, TEMPERATURE_TRANSFORMATION_MAX_PARAMETER);
#line 651 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 653 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 653 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5794 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_ = 0.0F;
		gfloat _tmp4_ = 0.0F;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
		gfloat _tmp7_ = 0.0F;
		gfloat* _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gfloat _tmp9_ = 0.0F;
		gfloat _tmp10_ = 0.0F;
		gfloat* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gfloat _tmp12_ = 0.0F;
		gfloat _tmp13_ = 0.0F;
#line 654 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 654 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp3_ / TEMPERATURE_TRANSFORMATION_MAX_PARAMETER;
#line 655 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = adjusted_param;
#line 655 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp4_ * TEMPERATURE_TRANSFORMATION_INTENSITY_FACTOR;
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = adjusted_param;
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_[11] -= _tmp6_;
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[11];
#line 658 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 658 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 658 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = adjusted_param;
#line 658 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_[7] += _tmp9_ / 2;
#line 658 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = _tmp8_[7];
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = adjusted_param;
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_[3] += _tmp12_ / 2;
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = _tmp11_[3];
#line 661 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5850 "ColorTransformation.c"
	}
#line 648 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5854 "ColorTransformation.c"
}


TemperatureTransformation* temperature_transformation_new (gfloat client_parameter) {
#line 648 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return temperature_transformation_construct (TYPE_TEMPERATURE_TRANSFORMATION, client_parameter);
#line 5861 "ColorTransformation.c"
}


gfloat temperature_transformation_get_parameter (TemperatureTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 665 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_TEMPERATURE_TRANSFORMATION (self), 0.0F);
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5876 "ColorTransformation.c"
}


static void temperature_transformation_class_init (TemperatureTransformationClass * klass) {
#line 641 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temperature_transformation_parent_class = g_type_class_peek_parent (klass);
#line 641 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = temperature_transformation_finalize;
#line 641 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (TemperatureTransformationPrivate));
#line 5887 "ColorTransformation.c"
}


static void temperature_transformation_instance_init (TemperatureTransformation * self) {
#line 641 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = TEMPERATURE_TRANSFORMATION_GET_PRIVATE (self);
#line 5894 "ColorTransformation.c"
}


static void temperature_transformation_finalize (PixelTransformation* obj) {
	TemperatureTransformation * self;
#line 641 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation);
#line 641 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (temperature_transformation_parent_class)->finalize (obj);
#line 5904 "ColorTransformation.c"
}


GType temperature_transformation_get_type (void) {
	static volatile gsize temperature_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&temperature_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TemperatureTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) temperature_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TemperatureTransformation), 0, (GInstanceInitFunc) temperature_transformation_instance_init, NULL };
		GType temperature_transformation_type_id;
		temperature_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "TemperatureTransformation", &g_define_type_info, 0);
		g_once_init_leave (&temperature_transformation_type_id__volatile, temperature_transformation_type_id);
	}
	return temperature_transformation_type_id__volatile;
}


SaturationTransformation* saturation_transformation_construct (GType object_type, gfloat client_parameter) {
	SaturationTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 677 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (SaturationTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_SATURATION);
#line 679 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 679 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, SATURATION_TRANSFORMATION_MIN_PARAMETER, SATURATION_TRANSFORMATION_MAX_PARAMETER);
#line 679 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 681 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 681 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5937 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_ = 0.0F;
		gfloat _tmp4_ = 0.0F;
		gfloat one_third = 0.0F;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
		gfloat _tmp7_ = 0.0F;
		gfloat _tmp8_ = 0.0F;
		gfloat _tmp9_ = 0.0F;
		gfloat* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gfloat _tmp11_ = 0.0F;
		gfloat _tmp12_ = 0.0F;
		gfloat _tmp13_ = 0.0F;
		gfloat* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gfloat _tmp15_ = 0.0F;
		gfloat _tmp16_ = 0.0F;
		gfloat _tmp17_ = 0.0F;
		gfloat* _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gfloat _tmp19_ = 0.0F;
		gfloat _tmp20_ = 0.0F;
		gfloat _tmp21_ = 0.0F;
		gfloat* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		gfloat _tmp23_ = 0.0F;
		gfloat _tmp24_ = 0.0F;
		gfloat _tmp25_ = 0.0F;
		gfloat _tmp26_ = 0.0F;
		gfloat* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gfloat _tmp28_ = 0.0F;
		gfloat _tmp29_ = 0.0F;
		gfloat _tmp30_ = 0.0F;
		gfloat* _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gfloat _tmp32_ = 0.0F;
		gfloat _tmp33_ = 0.0F;
		gfloat _tmp34_ = 0.0F;
		gfloat* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gfloat _tmp36_ = 0.0F;
		gfloat _tmp37_ = 0.0F;
		gfloat _tmp38_ = 0.0F;
		gfloat* _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gfloat _tmp40_ = 0.0F;
		gfloat _tmp41_ = 0.0F;
		gfloat _tmp42_ = 0.0F;
		gfloat _tmp43_ = 0.0F;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp3_ / SATURATION_TRANSFORMATION_MAX_PARAMETER;
#line 683 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = adjusted_param;
#line 683 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp4_ + 1.0f;
#line 685 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		one_third = 0.3333333f;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = adjusted_param;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = one_third;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = adjusted_param;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_[0] = ((1.0f - _tmp6_) * _tmp7_) + _tmp8_;
#line 687 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = _tmp5_[0];
#line 689 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 689 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 689 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = adjusted_param;
#line 689 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = one_third;
#line 689 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_[1] = (1.0f - _tmp11_) * _tmp12_;
#line 689 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = _tmp10_[1];
#line 690 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 690 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 690 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_ = adjusted_param;
#line 690 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = one_third;
#line 690 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_[2] = (1.0f - _tmp15_) * _tmp16_;
#line 690 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = _tmp14_[2];
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp19_ = adjusted_param;
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = one_third;
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_[4] = (1.0f - _tmp19_) * _tmp20_;
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = _tmp18_[4];
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = adjusted_param;
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp24_ = one_third;
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = adjusted_param;
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_[5] = ((1.0f - _tmp23_) * _tmp24_) + _tmp25_;
#line 693 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = _tmp22_[5];
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp28_ = adjusted_param;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp29_ = one_third;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_[6] = (1.0f - _tmp28_) * _tmp29_;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp30_ = _tmp27_[6];
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp32_ = adjusted_param;
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp33_ = one_third;
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31_[8] = (1.0f - _tmp32_) * _tmp33_;
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp34_ = _tmp31_[8];
#line 698 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 698 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 698 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = adjusted_param;
#line 698 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp37_ = one_third;
#line 698 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_[9] = (1.0f - _tmp36_) * _tmp37_;
#line 698 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp38_ = _tmp35_[9];
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp40_ = adjusted_param;
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp41_ = one_third;
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp42_ = adjusted_param;
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_[10] = ((1.0f - _tmp40_) * _tmp41_) + _tmp42_;
#line 699 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp43_ = _tmp39_[10];
#line 702 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 6116 "ColorTransformation.c"
	}
#line 676 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 6120 "ColorTransformation.c"
}


SaturationTransformation* saturation_transformation_new (gfloat client_parameter) {
#line 676 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return saturation_transformation_construct (TYPE_SATURATION_TRANSFORMATION, client_parameter);
#line 6127 "ColorTransformation.c"
}


gfloat saturation_transformation_get_parameter (SaturationTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 706 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_SATURATION_TRANSFORMATION (self), 0.0F);
#line 707 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 707 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 707 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6142 "ColorTransformation.c"
}


static void saturation_transformation_class_init (SaturationTransformationClass * klass) {
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	saturation_transformation_parent_class = g_type_class_peek_parent (klass);
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = saturation_transformation_finalize;
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (SaturationTransformationPrivate));
#line 6153 "ColorTransformation.c"
}


static void saturation_transformation_instance_init (SaturationTransformation * self) {
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = SATURATION_TRANSFORMATION_GET_PRIVATE (self);
#line 6160 "ColorTransformation.c"
}


static void saturation_transformation_finalize (PixelTransformation* obj) {
	SaturationTransformation * self;
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SATURATION_TRANSFORMATION, SaturationTransformation);
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (saturation_transformation_parent_class)->finalize (obj);
#line 6170 "ColorTransformation.c"
}


GType saturation_transformation_get_type (void) {
	static volatile gsize saturation_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&saturation_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SaturationTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saturation_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SaturationTransformation), 0, (GInstanceInitFunc) saturation_transformation_instance_init, NULL };
		GType saturation_transformation_type_id;
		saturation_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "SaturationTransformation", &g_define_type_info, 0);
		g_once_init_leave (&saturation_transformation_type_id__volatile, saturation_transformation_type_id);
	}
	return saturation_transformation_type_id__volatile;
}


ExposureTransformation* exposure_transformation_construct (GType object_type, gfloat client_parameter) {
	ExposureTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 718 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExposureTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_EXPOSURE);
#line 720 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 720 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, EXPOSURE_TRANSFORMATION_MIN_PARAMETER, EXPOSURE_TRANSFORMATION_MAX_PARAMETER);
#line 720 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 722 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 722 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 6203 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_ = 0.0F;
		gfloat* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gfloat _tmp5_ = 0.0F;
		gfloat _tmp6_ = 0.0F;
		gfloat* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gfloat _tmp8_ = 0.0F;
		gfloat _tmp9_ = 0.0F;
		gfloat* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gfloat _tmp11_ = 0.0F;
		gfloat _tmp12_ = 0.0F;
#line 724 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 724 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = ((_tmp3_ + 16.0f) / 32.0f) + 0.5f;
#line 726 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 726 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 726 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = adjusted_param;
#line 726 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_[0] = _tmp5_;
#line 726 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = _tmp4_[0];
#line 727 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 727 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 727 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = adjusted_param;
#line 727 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_[5] = _tmp8_;
#line 727 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = _tmp7_[5];
#line 728 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 728 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 728 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = adjusted_param;
#line 728 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_[10] = _tmp11_;
#line 728 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = _tmp10_[10];
#line 730 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 6254 "ColorTransformation.c"
	}
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 6258 "ColorTransformation.c"
}


ExposureTransformation* exposure_transformation_new (gfloat client_parameter) {
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return exposure_transformation_construct (TYPE_EXPOSURE_TRANSFORMATION, client_parameter);
#line 6265 "ColorTransformation.c"
}


gfloat exposure_transformation_get_parameter (ExposureTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 734 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_EXPOSURE_TRANSFORMATION (self), 0.0F);
#line 735 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 735 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 735 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6280 "ColorTransformation.c"
}


static void exposure_transformation_class_init (ExposureTransformationClass * klass) {
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	exposure_transformation_parent_class = g_type_class_peek_parent (klass);
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = exposure_transformation_finalize;
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ExposureTransformationPrivate));
#line 6291 "ColorTransformation.c"
}


static void exposure_transformation_instance_init (ExposureTransformation * self) {
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = EXPOSURE_TRANSFORMATION_GET_PRIVATE (self);
#line 6298 "ColorTransformation.c"
}


static void exposure_transformation_finalize (PixelTransformation* obj) {
	ExposureTransformation * self;
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation);
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (exposure_transformation_parent_class)->finalize (obj);
#line 6308 "ColorTransformation.c"
}


GType exposure_transformation_get_type (void) {
	static volatile gsize exposure_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&exposure_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExposureTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exposure_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExposureTransformation), 0, (GInstanceInitFunc) exposure_transformation_instance_init, NULL };
		GType exposure_transformation_type_id;
		exposure_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "ExposureTransformation", &g_define_type_info, 0);
		g_once_init_leave (&exposure_transformation_type_id__volatile, exposure_transformation_type_id);
	}
	return exposure_transformation_type_id__volatile;
}


ContrastTransformation* contrast_transformation_construct (GType object_type, gfloat client_parameter) {
	ContrastTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ContrastTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_CONTRAST);
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, CONTRAST_TRANSFORMATION_MIN_PARAMETER, CONTRAST_TRANSFORMATION_MAX_PARAMETER);
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 752 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 752 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 6341 "ColorTransformation.c"
		gfloat contrast_adjustment = 0.0F;
		gfloat _tmp3_ = 0.0F;
		gfloat component_coefficient = 0.0F;
		gfloat _tmp4_ = 0.0F;
		gfloat component_offset = 0.0F;
		gfloat _tmp5_ = 0.0F;
		gfloat* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gfloat _tmp7_ = 0.0F;
		gfloat _tmp8_ = 0.0F;
		gfloat* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gfloat _tmp10_ = 0.0F;
		gfloat _tmp11_ = 0.0F;
		gfloat* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gfloat _tmp13_ = 0.0F;
		gfloat _tmp14_ = 0.0F;
		gfloat* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gfloat _tmp16_ = 0.0F;
		gfloat _tmp17_ = 0.0F;
		gfloat* _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gfloat _tmp19_ = 0.0F;
		gfloat _tmp20_ = 0.0F;
		gfloat* _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		gfloat _tmp22_ = 0.0F;
		gfloat _tmp23_ = 0.0F;
#line 754 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 754 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		contrast_adjustment = (_tmp3_ / 16.0f) * CONTRAST_TRANSFORMATION_MAX_CONTRAST_ADJUSTMENT;
#line 755 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = contrast_adjustment;
#line 755 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		component_coefficient = 1.0f + _tmp4_;
#line 756 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = contrast_adjustment;
#line 756 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		component_offset = _tmp5_ / (-2.0f);
#line 758 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 758 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 758 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = component_coefficient;
#line 758 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_[0] = _tmp7_;
#line 758 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = _tmp6_[0];
#line 759 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 759 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 759 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = component_coefficient;
#line 759 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_[5] = _tmp10_;
#line 759 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = _tmp9_[5];
#line 760 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 760 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 760 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = component_coefficient;
#line 760 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_[10] = _tmp13_;
#line 760 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_ = _tmp12_[10];
#line 762 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 762 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 762 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = component_offset;
#line 762 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_[3] = _tmp16_;
#line 762 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = _tmp15_[3];
#line 763 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 763 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 763 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp19_ = component_offset;
#line 763 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_[7] = _tmp19_;
#line 763 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = _tmp18_[7];
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_ = component_offset;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_[11] = _tmp22_;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = _tmp21_[11];
#line 766 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 6446 "ColorTransformation.c"
	}
#line 747 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 6450 "ColorTransformation.c"
}


ContrastTransformation* contrast_transformation_new (gfloat client_parameter) {
#line 747 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return contrast_transformation_construct (TYPE_CONTRAST_TRANSFORMATION, client_parameter);
#line 6457 "ColorTransformation.c"
}


gfloat contrast_transformation_get_parameter (ContrastTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 770 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_CONTRAST_TRANSFORMATION (self), 0.0F);
#line 771 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 771 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 771 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6472 "ColorTransformation.c"
}


static void contrast_transformation_class_init (ContrastTransformationClass * klass) {
#line 739 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	contrast_transformation_parent_class = g_type_class_peek_parent (klass);
#line 739 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = contrast_transformation_finalize;
#line 739 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ContrastTransformationPrivate));
#line 6483 "ColorTransformation.c"
}


static void contrast_transformation_instance_init (ContrastTransformation * self) {
#line 739 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = CONTRAST_TRANSFORMATION_GET_PRIVATE (self);
#line 6490 "ColorTransformation.c"
}


static void contrast_transformation_finalize (PixelTransformation* obj) {
	ContrastTransformation * self;
#line 739 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation);
#line 739 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (contrast_transformation_parent_class)->finalize (obj);
#line 6500 "ColorTransformation.c"
}


GType contrast_transformation_get_type (void) {
	static volatile gsize contrast_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&contrast_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContrastTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contrast_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContrastTransformation), 0, (GInstanceInitFunc) contrast_transformation_instance_init, NULL };
		GType contrast_transformation_type_id;
		contrast_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "ContrastTransformation", &g_define_type_info, 0);
		g_once_init_leave (&contrast_transformation_type_id__volatile, contrast_transformation_type_id);
	}
	return contrast_transformation_type_id__volatile;
}


PixelTransformer* pixel_transformer_construct (GType object_type) {
	PixelTransformer* self = NULL;
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (PixelTransformer*) g_type_create_instance (object_type);
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 6522 "ColorTransformation.c"
}


PixelTransformer* pixel_transformer_new (void) {
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return pixel_transformer_construct (TYPE_PIXEL_TRANSFORMER);
#line 6529 "ColorTransformation.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? g_object_ref (self) : NULL;
#line 6536 "ColorTransformation.c"
}


PixelTransformer* pixel_transformer_copy (PixelTransformer* self) {
	PixelTransformer* result = NULL;
	PixelTransformer* clone = NULL;
	PixelTransformer* _tmp0_ = NULL;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_PIXEL_TRANSFORMER (self), NULL);
#line 785 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformer_new ();
#line 785 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	clone = _tmp0_;
#line 6550 "ColorTransformation.c"
	{
		GeeArrayList* _transformation_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _transformation_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _transformation_index = 0;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = self->priv->transformations;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_list = _tmp2_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = _transformation_list;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = _tmp4_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_size = _tmp5_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_index = -1;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 6578 "ColorTransformation.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			PixelTransformation* transformation = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			PixelTransformer* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			PixelTransformation* _tmp14_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = _transformation_index;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_transformation_index = _tmp6_ + 1;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = _transformation_index;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = _transformation_size;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 6601 "ColorTransformation.c"
			}
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = _transformation_list;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = _transformation_index;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp10_);
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			transformation = (PixelTransformation*) _tmp11_;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = clone;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = _tmp12_->priv->transformations;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = transformation;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (transformation);
#line 6621 "ColorTransformation.c"
		}
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_transformation_list);
#line 6625 "ColorTransformation.c"
	}
#line 790 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = clone;
#line 790 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6631 "ColorTransformation.c"
}


static void pixel_transformer_build_optimized_transformations (PixelTransformer* self) {
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	PixelTransformation** _tmp3_ = NULL;
	PixelTransformation* pre_trans = NULL;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->transformations;
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = g_new0 (PixelTransformation*, _tmp2_ + 1);
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = (_vala_array_free (self->priv->optimized_transformations, self->priv->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = _tmp3_;
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations_length1 = _tmp2_;
#line 794 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_optimized_transformations_size_ = self->priv->optimized_transformations_length1;
#line 796 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pre_trans = NULL;
#line 797 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_slots_used = 0;
#line 6663 "ColorTransformation.c"
	{
		gint i = 0;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 6668 "ColorTransformation.c"
		{
			gboolean _tmp4_ = FALSE;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = TRUE;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 6675 "ColorTransformation.c"
				gint _tmp6_ = 0;
				GeeArrayList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				PixelTransformation* trans = NULL;
				GeeArrayList* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gpointer _tmp12_ = NULL;
				PixelTransformation* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				PixelTransformation* this_trans = NULL;
				PixelTransformation* _tmp15_ = NULL;
				CompositionMode _tmp16_ = 0;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				PixelTransformation* _tmp23_ = NULL;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp4_) {
#line 6694 "ColorTransformation.c"
					gint _tmp5_ = 0;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp5_ = i;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp5_ + 1;
#line 6700 "ColorTransformation.c"
				}
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = FALSE;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = i;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = self->priv->transformations;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = _tmp8_;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp6_ < _tmp9_)) {
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 6716 "ColorTransformation.c"
				}
#line 799 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = self->priv->transformations;
#line 799 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = i;
#line 799 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
#line 799 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				trans = (PixelTransformation*) _tmp12_;
#line 801 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = trans;
#line 801 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = pixel_transformation_is_identity (_tmp13_);
#line 801 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp14_) {
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (trans);
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					continue;
#line 6736 "ColorTransformation.c"
				}
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				this_trans = NULL;
#line 805 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = trans;
#line 805 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = pixel_transformation_get_composition_mode (_tmp15_);
#line 805 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp16_ == COMPOSITION_MODE_NONE) {
#line 6746 "ColorTransformation.c"
					PixelTransformation* _tmp17_ = NULL;
					PixelTransformation* _tmp18_ = NULL;
#line 806 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp17_ = trans;
#line 806 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = _pixel_transformation_ref0 (_tmp17_);
#line 806 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (this_trans);
#line 806 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					this_trans = _tmp18_;
#line 6757 "ColorTransformation.c"
				} else {
					PixelTransformation* _tmp19_ = NULL;
					PixelTransformation* _tmp20_ = NULL;
#line 808 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = trans;
#line 808 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = pixel_transformation_copy (_tmp19_);
#line 808 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (this_trans);
#line 808 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					this_trans = _tmp20_;
#line 6769 "ColorTransformation.c"
				}
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = pre_trans;
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp23_ != NULL) {
#line 6775 "ColorTransformation.c"
					PixelTransformation* _tmp24_ = NULL;
					CompositionMode _tmp25_ = 0;
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp24_ = this_trans;
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp25_ = pixel_transformation_get_composition_mode (_tmp24_);
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp22_ = _tmp25_ != COMPOSITION_MODE_NONE;
#line 6784 "ColorTransformation.c"
				} else {
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp22_ = FALSE;
#line 6788 "ColorTransformation.c"
				}
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp22_) {
#line 6792 "ColorTransformation.c"
					PixelTransformation* _tmp26_ = NULL;
					CompositionMode _tmp27_ = 0;
					PixelTransformation* _tmp28_ = NULL;
					CompositionMode _tmp29_ = 0;
#line 811 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp26_ = this_trans;
#line 811 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27_ = pixel_transformation_get_composition_mode (_tmp26_);
#line 811 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp28_ = pre_trans;
#line 811 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp29_ = pixel_transformation_get_composition_mode (_tmp28_);
#line 811 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = _tmp27_ == _tmp29_;
#line 6807 "ColorTransformation.c"
				} else {
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = FALSE;
#line 6811 "ColorTransformation.c"
				}
#line 810 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp21_) {
#line 6815 "ColorTransformation.c"
					PixelTransformation* _tmp30_ = NULL;
					PixelTransformation* _tmp31_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = pre_trans;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31_ = this_trans;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pixel_transformation_compose_with (_tmp30_, _tmp31_);
#line 6824 "ColorTransformation.c"
				} else {
					PixelTransformation** _tmp32_ = NULL;
					gint _tmp32__length1 = 0;
					gint _tmp33_ = 0;
					PixelTransformation* _tmp34_ = NULL;
					PixelTransformation* _tmp35_ = NULL;
					PixelTransformation* _tmp36_ = NULL;
					PixelTransformation* _tmp37_ = NULL;
					PixelTransformation* _tmp38_ = NULL;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_ = self->priv->optimized_transformations;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32__length1 = self->priv->optimized_transformations_length1;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp33_ = self->priv->optimized_slots_used;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->priv->optimized_slots_used = _tmp33_ + 1;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp34_ = this_trans;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35_ = _pixel_transformation_ref0 (_tmp34_);
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (_tmp32_[_tmp33_]);
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_[_tmp33_] = _tmp35_;
#line 814 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp36_ = _tmp32_[_tmp33_];
#line 815 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp37_ = this_trans;
#line 815 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp38_ = _pixel_transformation_ref0 (_tmp37_);
#line 815 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (pre_trans);
#line 815 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pre_trans = _tmp38_;
#line 6860 "ColorTransformation.c"
				}
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (this_trans);
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (trans);
#line 6866 "ColorTransformation.c"
			}
		}
	}
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (pre_trans);
#line 6872 "ColorTransformation.c"
}


static void pixel_transformer_apply_transformations (PixelTransformer* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
	PixelFormat current_format = 0;
	RGBAnalyticPixel p_rgb = {0};
	RGBAnalyticPixel _tmp0_ = {0};
	HSVAnalyticPixel p_hsv = {0};
	PixelFormat _tmp21_ = 0;
#line 820 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 820 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (p != NULL);
#line 821 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	current_format = PIXEL_FORMAT_RGB;
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	p_rgb = _tmp0_;
#line 823 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_init (&p_hsv);
#line 6894 "ColorTransformation.c"
	{
		gint i = 0;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 6899 "ColorTransformation.c"
		{
			gboolean _tmp1_ = FALSE;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp1_ = TRUE;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 6906 "ColorTransformation.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				PixelTransformation* trans = NULL;
				PixelTransformation** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				PixelTransformation* _tmp7_ = NULL;
				PixelTransformation* _tmp8_ = NULL;
				PixelTransformation* _tmp9_ = NULL;
				PixelFormat _tmp10_ = 0;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp1_) {
#line 6919 "ColorTransformation.c"
					gint _tmp2_ = 0;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp2_ = i;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp2_ + 1;
#line 6925 "ColorTransformation.c"
				}
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp1_ = FALSE;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp3_ = i;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = self->priv->optimized_slots_used;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 6937 "ColorTransformation.c"
				}
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = self->priv->optimized_transformations;
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5__length1 = self->priv->optimized_transformations_length1;
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = i;
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = _pixel_transformation_ref0 (_tmp7_);
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				trans = _tmp8_;
#line 827 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = trans;
#line 827 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = pixel_transformation_get_preferred_format (_tmp9_);
#line 827 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp10_ == PIXEL_FORMAT_RGB) {
#line 6957 "ColorTransformation.c"
					PixelFormat _tmp11_ = 0;
					PixelTransformation* _tmp13_ = NULL;
					RGBAnalyticPixel _tmp14_ = {0};
					RGBAnalyticPixel _tmp15_ = {0};
#line 828 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11_ = current_format;
#line 828 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp11_ == PIXEL_FORMAT_HSV) {
#line 6966 "ColorTransformation.c"
						RGBAnalyticPixel _tmp12_ = {0};
#line 829 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						hsv_analytic_pixel_to_rgb (&p_hsv, &_tmp12_);
#line 829 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						p_rgb = _tmp12_;
#line 830 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						current_format = PIXEL_FORMAT_RGB;
#line 6974 "ColorTransformation.c"
					}
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = trans;
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp14_ = p_rgb;
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pixel_transformation_transform_pixel_rgb (_tmp13_, &_tmp14_, &_tmp15_);
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					p_rgb = _tmp15_;
#line 6984 "ColorTransformation.c"
				} else {
					PixelFormat _tmp16_ = 0;
					PixelTransformation* _tmp18_ = NULL;
					HSVAnalyticPixel _tmp19_ = {0};
					HSVAnalyticPixel _tmp20_ = {0};
#line 834 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp16_ = current_format;
#line 834 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp16_ == PIXEL_FORMAT_RGB) {
#line 6994 "ColorTransformation.c"
						HSVAnalyticPixel _tmp17_ = {0};
#line 835 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						rgb_analytic_pixel_to_hsv (&p_rgb, &_tmp17_);
#line 835 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						p_hsv = _tmp17_;
#line 836 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						current_format = PIXEL_FORMAT_HSV;
#line 7002 "ColorTransformation.c"
					}
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = trans;
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = p_hsv;
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pixel_transformation_transform_pixel_hsv (_tmp18_, &_tmp19_, &_tmp20_);
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					p_hsv = _tmp20_;
#line 7012 "ColorTransformation.c"
				}
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (trans);
#line 7016 "ColorTransformation.c"
			}
		}
	}
#line 842 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = current_format;
#line 842 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp21_ == PIXEL_FORMAT_HSV) {
#line 7024 "ColorTransformation.c"
		RGBAnalyticPixel _tmp22_ = {0};
#line 843 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hsv_analytic_pixel_to_rgb (&p_hsv, &_tmp22_);
#line 843 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		p_rgb = _tmp22_;
#line 7030 "ColorTransformation.c"
	}
#line 845 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = p_rgb;
#line 845 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 7036 "ColorTransformation.c"
}


void pixel_transformer_attach_transformation (PixelTransformer* self, PixelTransformation* trans) {
	GeeArrayList* _tmp0_ = NULL;
	PixelTransformation* _tmp1_ = NULL;
#line 851 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 851 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (trans));
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->transformations;
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = trans;
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 853 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = (_vala_array_free (self->priv->optimized_transformations, self->priv->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 853 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = NULL;
#line 853 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations_length1 = 0;
#line 853 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_optimized_transformations_size_ = self->priv->optimized_transformations_length1;
#line 7061 "ColorTransformation.c"
}


void pixel_transformer_detach_transformation (PixelTransformer* self, PixelTransformation* victim) {
	GeeArrayList* _tmp0_ = NULL;
	PixelTransformation* _tmp1_ = NULL;
#line 858 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 858 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (victim));
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->transformations;
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = victim;
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 860 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = (_vala_array_free (self->priv->optimized_transformations, self->priv->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 860 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = NULL;
#line 860 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations_length1 = 0;
#line 860 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_optimized_transformations_size_ = self->priv->optimized_transformations_length1;
#line 7086 "ColorTransformation.c"
}


void pixel_transformer_replace_transformation (PixelTransformer* self, PixelTransformation* old_trans, PixelTransformation* new_trans) {
#line 865 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 865 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (old_trans));
#line 865 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION (new_trans));
#line 7097 "ColorTransformation.c"
	{
		gint i = 0;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 7102 "ColorTransformation.c"
		{
			gboolean _tmp0_ = FALSE;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp0_ = TRUE;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 7109 "ColorTransformation.c"
				gint _tmp2_ = 0;
				GeeArrayList* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GeeArrayList* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gpointer _tmp8_ = NULL;
				PixelTransformation* _tmp9_ = NULL;
				PixelTransformation* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp0_) {
#line 7122 "ColorTransformation.c"
					gint _tmp1_ = 0;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp1_ = i;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp1_ + 1;
#line 7128 "ColorTransformation.c"
				}
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp0_ = FALSE;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp2_ = i;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp3_ = self->priv->transformations;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = _tmp4_;
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 867 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7144 "ColorTransformation.c"
				}
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = self->priv->transformations;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp7_);
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = (PixelTransformation*) _tmp8_;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = old_trans;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = _tmp9_ == _tmp10_;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (_tmp9_);
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp11_) {
#line 7162 "ColorTransformation.c"
					GeeArrayList* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					PixelTransformation* _tmp14_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = self->priv->transformations;
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = i;
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp14_ = new_trans;
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp13_, _tmp14_);
#line 871 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->priv->optimized_transformations = (_vala_array_free (self->priv->optimized_transformations, self->priv->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 871 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->priv->optimized_transformations = NULL;
#line 871 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->priv->optimized_transformations_length1 = 0;
#line 871 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->priv->_optimized_transformations_size_ = self->priv->optimized_transformations_length1;
#line 872 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return;
#line 7184 "ColorTransformation.c"
				}
			}
		}
	}
#line 875 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_error ("ColorTransformation.vala:875: %s", "PixelTransformer: replace_transformation( ): old_trans is not present " \
"in " "transformation collection");
#line 7191 "ColorTransformation.c"
}


void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 879 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 879 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 879 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 880 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixbuf;
#line 880 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixbuf;
#line 880 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = cancellable;
#line 880 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformer_transform_to_other_pixbuf (self, _tmp0_, _tmp1_, _tmp2_);
#line 7213 "ColorTransformation.c"
}


void pixel_transformer_transform_from_fp (PixelTransformer* self, gfloat** fp_pixel_cache, int* fp_pixel_cache_length1, GdkPixbuf* dest) {
	PixelTransformation** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint dest_width = 0;
	GdkPixbuf* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint dest_height = 0;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint dest_num_channels = 0;
	GdkPixbuf* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint dest_rowstride = 0;
	GdkPixbuf* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	guchar* dest_pixels = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	guint8* _tmp10_ = NULL;
	gint dest_pixels_length1 = 0;
	gint _dest_pixels_size_ = 0;
	gint cache_pixel_ticker = 0;
#line 883 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 883 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (GDK_IS_PIXBUF (dest));
#line 884 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->optimized_transformations;
#line 884 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = self->priv->optimized_transformations_length1;
#line 884 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ == NULL) {
#line 885 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_build_optimized_transformations (self);
#line 7250 "ColorTransformation.c"
	}
#line 887 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = dest;
#line 887 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
#line 887 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_width = _tmp2_;
#line 888 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = dest;
#line 888 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
#line 888 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_height = _tmp4_;
#line 889 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = dest;
#line 889 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = gdk_pixbuf_get_n_channels (_tmp5_);
#line 889 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_num_channels = _tmp6_;
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = dest;
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = gdk_pixbuf_get_rowstride (_tmp7_);
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_rowstride = _tmp8_;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = dest;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = gdk_pixbuf_get_pixels (_tmp9_);
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_pixels = _tmp10_;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_pixels_length1 = -1;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_dest_pixels_size_ = dest_pixels_length1;
#line 893 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	cache_pixel_ticker = 0;
#line 7288 "ColorTransformation.c"
	{
		gint j = 0;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		j = 0;
#line 7293 "ColorTransformation.c"
		{
			gboolean _tmp11_ = FALSE;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = TRUE;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 7300 "ColorTransformation.c"
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint row_start_index = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint row_end_index = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp11_) {
#line 7312 "ColorTransformation.c"
					gint _tmp12_ = 0;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = j;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					j = _tmp12_ + 1;
#line 7318 "ColorTransformation.c"
				}
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = FALSE;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = j;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = dest_height;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp13_ < _tmp14_)) {
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7330 "ColorTransformation.c"
				}
#line 896 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = j;
#line 896 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = dest_rowstride;
#line 896 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_index = _tmp15_ * _tmp16_;
#line 897 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = row_start_index;
#line 897 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = dest_width;
#line 897 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = dest_num_channels;
#line 897 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_end_index = _tmp17_ + (_tmp18_ * _tmp19_);
#line 7346 "ColorTransformation.c"
				{
					gint i = 0;
					gint _tmp20_ = 0;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = row_start_index;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp20_;
#line 7354 "ColorTransformation.c"
					{
						gboolean _tmp21_ = FALSE;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21_ = TRUE;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 7361 "ColorTransformation.c"
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							RGBAnalyticPixel pixel = {0};
							gfloat* _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							gint _tmp27_ = 0;
							gfloat _tmp28_ = 0.0F;
							gfloat* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp30_ = 0;
							gfloat _tmp31_ = 0.0F;
							gfloat* _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp33_ = 0;
							gfloat _tmp34_ = 0.0F;
							gint _tmp35_ = 0;
							RGBAnalyticPixel _tmp36_ = {0};
							RGBAnalyticPixel _tmp37_ = {0};
							guchar* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp39_ = 0;
							RGBAnalyticPixel _tmp40_ = {0};
							gfloat _tmp41_ = 0.0F;
							guchar _tmp42_ = '\0';
							guchar* _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							gint _tmp44_ = 0;
							RGBAnalyticPixel _tmp45_ = {0};
							gfloat _tmp46_ = 0.0F;
							guchar _tmp47_ = '\0';
							guchar* _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							gint _tmp49_ = 0;
							RGBAnalyticPixel _tmp50_ = {0};
							gfloat _tmp51_ = 0.0F;
							guchar _tmp52_ = '\0';
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp21_) {
#line 7400 "ColorTransformation.c"
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp22_ = i;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp23_ = dest_num_channels;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								i = _tmp22_ + _tmp23_;
#line 7409 "ColorTransformation.c"
							}
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp21_ = FALSE;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp24_ = i;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp25_ = row_end_index;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp24_ < _tmp25_)) {
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 7421 "ColorTransformation.c"
							}
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26_ = *fp_pixel_cache;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26__length1 = *fp_pixel_cache_length1;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp27_ = cache_pixel_ticker;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp28_ = _tmp26_[_tmp27_];
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29_ = *fp_pixel_cache;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29__length1 = *fp_pixel_cache_length1;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp30_ = cache_pixel_ticker;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32_ = *fp_pixel_cache;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32__length1 = *fp_pixel_cache_length1;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp33_ = cache_pixel_ticker;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp34_ = _tmp32_[_tmp33_ + 2];
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							rgb_analytic_pixel_init_from_components (&pixel, _tmp28_, _tmp31_, _tmp34_);
#line 904 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp35_ = cache_pixel_ticker;
#line 904 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							cache_pixel_ticker = _tmp35_ + 3;
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp36_ = pixel;
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_transformer_apply_transformations (self, &_tmp36_, &_tmp37_);
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel = _tmp37_;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_ = dest_pixels;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38__length1 = dest_pixels_length1;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp39_ = i;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp40_ = pixel;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp41_ = _tmp40_.red;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_[_tmp39_] = (guchar) (_tmp41_ * 255.0f);
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp42_ = _tmp38_[_tmp39_];
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp43_ = dest_pixels;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp43__length1 = dest_pixels_length1;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp44_ = i;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp45_ = pixel;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp46_ = _tmp45_.green;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp43_[_tmp44_ + 1] = (guchar) (_tmp46_ * 255.0f);
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp47_ = _tmp43_[_tmp44_ + 1];
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp48_ = dest_pixels;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp48__length1 = dest_pixels_length1;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp49_ = i;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp50_ = pixel;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp51_ = _tmp50_.blue;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp48_[_tmp49_ + 2] = (guchar) (_tmp51_ * 255.0f);
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp52_ = _tmp48_[_tmp49_ + 2];
#line 7501 "ColorTransformation.c"
						}
					}
				}
			}
		}
	}
}


void pixel_transformer_transform_to_other_pixbuf (PixelTransformer* self, GdkPixbuf* source, GdkPixbuf* dest, GCancellable* cancellable) {
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GdkPixbuf* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GdkPixbuf* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GdkPixbuf* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GdkPixbuf* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	PixelTransformation** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint n_channels = 0;
	GdkPixbuf* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint rowstride = 0;
	GdkPixbuf* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint width = 0;
	GdkPixbuf* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint height = 0;
	GdkPixbuf* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint rowbytes = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	guchar* source_pixels = NULL;
	GdkPixbuf* _tmp29_ = NULL;
	guint8* _tmp30_ = NULL;
	gint source_pixels_length1 = 0;
	gint _source_pixels_size_ = 0;
	guchar* dest_pixels = NULL;
	GdkPixbuf* _tmp31_ = NULL;
	guint8* _tmp32_ = NULL;
	gint dest_pixels_length1 = 0;
	gint _dest_pixels_size_ = 0;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMER (self));
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (GDK_IS_PIXBUF (source));
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (GDK_IS_PIXBUF (dest));
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = source;
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = dest;
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = gdk_pixbuf_get_width (_tmp3_);
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_;
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != _tmp5_) {
#line 918 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:918: PixelTransformer: source and destination" \
" pixbufs must have the same width");
#line 7581 "ColorTransformation.c"
	}
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = source;
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp7_;
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = dest;
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_;
#line 920 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp8_ != _tmp11_) {
#line 921 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:921: PixelTransformer: source and destination" \
" pixbufs must have the same height");
#line 7599 "ColorTransformation.c"
	}
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = source;
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = gdk_pixbuf_get_n_channels (_tmp12_);
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = _tmp13_;
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = dest;
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = gdk_pixbuf_get_n_channels (_tmp15_);
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = _tmp16_;
#line 923 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp14_ != _tmp17_) {
#line 924 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:924: %s", "PixelTransformer: source and destination pixbufs must have the same nu" \
"mber " "of channels");
#line 7617 "ColorTransformation.c"
	}
#line 927 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = self->priv->optimized_transformations;
#line 927 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18__length1 = self->priv->optimized_transformations_length1;
#line 927 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp18_ == NULL) {
#line 928 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_build_optimized_transformations (self);
#line 7627 "ColorTransformation.c"
	}
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = source;
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = gdk_pixbuf_get_n_channels (_tmp19_);
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	n_channels = _tmp20_;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = source;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = gdk_pixbuf_get_rowstride (_tmp21_);
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rowstride = _tmp22_;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = source;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	width = _tmp24_;
#line 933 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = source;
#line 933 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = gdk_pixbuf_get_height (_tmp25_);
#line 933 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	height = _tmp26_;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = n_channels;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = width;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rowbytes = _tmp27_ * _tmp28_;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = source;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = gdk_pixbuf_get_pixels (_tmp29_);
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	source_pixels = _tmp30_;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	source_pixels_length1 = -1;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_source_pixels_size_ = source_pixels_length1;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = dest;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = gdk_pixbuf_get_pixels (_tmp31_);
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_pixels = _tmp32_;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_pixels_length1 = -1;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_dest_pixels_size_ = dest_pixels_length1;
#line 7679 "ColorTransformation.c"
	{
		gint j = 0;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		j = 0;
#line 7684 "ColorTransformation.c"
		{
			gboolean _tmp33_ = FALSE;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp33_ = TRUE;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 7691 "ColorTransformation.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint row_start_index = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint row_end_index = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gboolean _tmp70_ = FALSE;
				GCancellable* _tmp71_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp33_) {
#line 7704 "ColorTransformation.c"
					gint _tmp34_ = 0;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp34_ = j;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					j = _tmp34_ + 1;
#line 7710 "ColorTransformation.c"
				}
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp33_ = FALSE;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35_ = j;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp36_ = height;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp35_ < _tmp36_)) {
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7722 "ColorTransformation.c"
				}
#line 938 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37_ = j;
#line 938 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp38_ = rowstride;
#line 938 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_index = _tmp37_ * _tmp38_;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39_ = row_start_index;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp40_ = rowbytes;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_end_index = _tmp39_ + _tmp40_;
#line 7736 "ColorTransformation.c"
				{
					gint i = 0;
					gint _tmp41_ = 0;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp41_ = row_start_index;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp41_;
#line 7744 "ColorTransformation.c"
					{
						gboolean _tmp42_ = FALSE;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp42_ = TRUE;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 7751 "ColorTransformation.c"
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							RGBAnalyticPixel current_pixel = {0};
							guchar* _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							gint _tmp48_ = 0;
							guchar _tmp49_ = '\0';
							guchar* _tmp50_ = NULL;
							gint _tmp50__length1 = 0;
							gint _tmp51_ = 0;
							guchar _tmp52_ = '\0';
							guchar* _tmp53_ = NULL;
							gint _tmp53__length1 = 0;
							gint _tmp54_ = 0;
							guchar _tmp55_ = '\0';
							RGBAnalyticPixel _tmp56_ = {0};
							RGBAnalyticPixel _tmp57_ = {0};
							guchar* _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							gint _tmp59_ = 0;
							guchar _tmp60_ = '\0';
							guchar _tmp61_ = '\0';
							guchar* _tmp62_ = NULL;
							gint _tmp62__length1 = 0;
							gint _tmp63_ = 0;
							guchar _tmp64_ = '\0';
							guchar _tmp65_ = '\0';
							guchar* _tmp66_ = NULL;
							gint _tmp66__length1 = 0;
							gint _tmp67_ = 0;
							guchar _tmp68_ = '\0';
							guchar _tmp69_ = '\0';
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp42_) {
#line 7786 "ColorTransformation.c"
								gint _tmp43_ = 0;
								gint _tmp44_ = 0;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp43_ = i;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp44_ = n_channels;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								i = _tmp43_ + _tmp44_;
#line 7795 "ColorTransformation.c"
							}
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp42_ = FALSE;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp45_ = i;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp46_ = row_end_index;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp45_ < _tmp46_)) {
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 7807 "ColorTransformation.c"
							}
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp47_ = source_pixels;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp47__length1 = source_pixels_length1;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp48_ = i;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp49_ = _tmp47_[_tmp48_];
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp50_ = source_pixels;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp50__length1 = source_pixels_length1;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp51_ = i;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp52_ = _tmp50_[_tmp51_ + 1];
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp53_ = source_pixels;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp53__length1 = source_pixels_length1;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp54_ = i;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp55_ = _tmp53_[_tmp54_ + 2];
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							rgb_analytic_pixel_init_from_quantized_components (&current_pixel, _tmp49_, _tmp52_, _tmp55_);
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp56_ = current_pixel;
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_transformer_apply_transformations (self, &_tmp56_, &_tmp57_);
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							current_pixel = _tmp57_;
#line 946 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp58_ = dest_pixels;
#line 946 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp58__length1 = dest_pixels_length1;
#line 946 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp59_ = i;
#line 946 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp60_ = rgb_analytic_pixel_quantized_red (&current_pixel);
#line 946 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp58_[_tmp59_] = _tmp60_;
#line 946 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp61_ = _tmp58_[_tmp59_];
#line 947 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp62_ = dest_pixels;
#line 947 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp62__length1 = dest_pixels_length1;
#line 947 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp63_ = i;
#line 947 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp64_ = rgb_analytic_pixel_quantized_green (&current_pixel);
#line 947 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp62_[_tmp63_ + 1] = _tmp64_;
#line 947 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp65_ = _tmp62_[_tmp63_ + 1];
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp66_ = dest_pixels;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp66__length1 = dest_pixels_length1;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp67_ = i;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp68_ = rgb_analytic_pixel_quantized_blue (&current_pixel);
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp66_[_tmp67_ + 2] = _tmp68_;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp69_ = _tmp66_[_tmp67_ + 2];
#line 7877 "ColorTransformation.c"
						}
					}
				}
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp71_ = cancellable;
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp71_ != NULL) {
#line 7885 "ColorTransformation.c"
					GCancellable* _tmp72_ = NULL;
					gboolean _tmp73_ = FALSE;
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp72_ = cancellable;
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp73_ = g_cancellable_is_cancelled (_tmp72_);
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp70_ = _tmp73_;
#line 7894 "ColorTransformation.c"
				} else {
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp70_ = FALSE;
#line 7898 "ColorTransformation.c"
				}
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp70_) {
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return;
#line 7904 "ColorTransformation.c"
				}
			}
		}
	}
}


static void value_pixel_transformer_init (GValue* value) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 7915 "ColorTransformation.c"
}


static void value_pixel_transformer_free_value (GValue* value) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_unref (value->data[0].v_pointer);
#line 7924 "ColorTransformation.c"
	}
}


static void value_pixel_transformer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = pixel_transformer_ref (src_value->data[0].v_pointer);
#line 7934 "ColorTransformation.c"
	} else {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7938 "ColorTransformation.c"
	}
}


static gpointer value_pixel_transformer_peek_pointer (const GValue* value) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 7946 "ColorTransformation.c"
}


static gchar* value_pixel_transformer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 7953 "ColorTransformation.c"
		PixelTransformer* object;
		object = collect_values[0].v_pointer;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7960 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7964 "ColorTransformation.c"
		}
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = pixel_transformer_ref (object);
#line 7968 "ColorTransformation.c"
	} else {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 7972 "ColorTransformation.c"
	}
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 7976 "ColorTransformation.c"
}


static gchar* value_pixel_transformer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixelTransformer** object_p;
	object_p = collect_values[0].v_pointer;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7987 "ColorTransformation.c"
	}
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 7993 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 7997 "ColorTransformation.c"
	} else {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = pixel_transformer_ref (value->data[0].v_pointer);
#line 8001 "ColorTransformation.c"
	}
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 8005 "ColorTransformation.c"
}


GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixelTransformer* spec;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMER), NULL);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 8019 "ColorTransformation.c"
}


gpointer value_get_pixel_transformer (const GValue* value) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER), NULL);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 8028 "ColorTransformation.c"
}


void value_set_pixel_transformer (GValue* value, gpointer v_object) {
	PixelTransformer* old;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER));
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMER));
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_ref (value->data[0].v_pointer);
#line 8048 "ColorTransformation.c"
	} else {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 8052 "ColorTransformation.c"
	}
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_unref (old);
#line 8058 "ColorTransformation.c"
	}
}


void value_take_pixel_transformer (GValue* value, gpointer v_object) {
	PixelTransformer* old;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER));
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMER));
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 8077 "ColorTransformation.c"
	} else {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 8081 "ColorTransformation.c"
	}
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_unref (old);
#line 8087 "ColorTransformation.c"
	}
}


static void pixel_transformer_class_init (PixelTransformerClass * klass) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformer_parent_class = g_type_class_peek_parent (klass);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformerClass *) klass)->finalize = pixel_transformer_finalize;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (PixelTransformerPrivate));
#line 8099 "ColorTransformation.c"
}


static void pixel_transformer_instance_init (PixelTransformer * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = PIXEL_TRANSFORMER_GET_PRIVATE (self);
#line 776 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = gee_array_list_new (TYPE_PIXEL_TRANSFORMATION, (GBoxedCopyFunc) pixel_transformation_ref, (GDestroyNotify) pixel_transformation_unref, NULL, NULL, NULL);
#line 776 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->transformations = _tmp0_;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = NULL;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations_length1 = 0;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_optimized_transformations_size_ = self->priv->optimized_transformations_length1;
#line 779 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_slots_used = 0;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 8121 "ColorTransformation.c"
}


static void pixel_transformer_finalize (PixelTransformer* obj) {
	PixelTransformer * self;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMER, PixelTransformer);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 776 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (self->priv->transformations);
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->optimized_transformations = (_vala_array_free (self->priv->optimized_transformations, self->priv->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 8135 "ColorTransformation.c"
}


GType pixel_transformer_get_type (void) {
	static volatile gsize pixel_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixel_transformer_init, value_pixel_transformer_free_value, value_pixel_transformer_copy_value, value_pixel_transformer_peek_pointer, "p", value_pixel_transformer_collect_value, "p", value_pixel_transformer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixelTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformer), 0, (GInstanceInitFunc) pixel_transformer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixel_transformer_type_id;
		pixel_transformer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixel_transformer_type_id__volatile, pixel_transformer_type_id);
	}
	return pixel_transformer_type_id__volatile;
}


gpointer pixel_transformer_ref (gpointer instance) {
	PixelTransformer* self;
	self = instance;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 8160 "ColorTransformation.c"
}


void pixel_transformer_unref (gpointer instance) {
	PixelTransformer* self;
	self = instance;
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		PIXEL_TRANSFORMER_GET_CLASS (self)->finalize (self);
#line 775 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8173 "ColorTransformation.c"
	}
}


RGBHistogram* rgb_histogram_construct (GType object_type, GdkPixbuf* pixbuf) {
	RGBHistogram* self = NULL;
	gint sample_bytes = 0;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint pixel_bytes = 0;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint row_length_bytes = 0;
	gint _tmp5_ = 0;
	GdkPixbuf* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	guchar* pixel_data = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	guint8* _tmp10_ = NULL;
	gint pixel_data_length1 = 0;
	gint _pixel_data_size_ = 0;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (RGBHistogram*) g_type_create_instance (object_type);
#line 975 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixbuf;
#line 975 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gdk_pixbuf_get_bits_per_sample (_tmp0_);
#line 975 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	sample_bytes = _tmp1_ / 8;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = sample_bytes;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = pixbuf;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = gdk_pixbuf_get_n_channels (_tmp3_);
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_bytes = _tmp2_ * _tmp4_;
#line 977 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = pixel_bytes;
#line 977 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = pixbuf;
#line 977 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
#line 977 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp7_;
#line 977 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	row_length_bytes = _tmp5_ * _tmp8_;
#line 979 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = pixbuf;
#line 979 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = gdk_pixbuf_get_pixels (_tmp9_);
#line 979 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_data = _tmp10_;
#line 979 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_data_length1 = -1;
#line 979 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_data_size_ = pixel_data_length1;
#line 8235 "ColorTransformation.c"
	{
		gint y = 0;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		y = 0;
#line 8240 "ColorTransformation.c"
		{
			gboolean _tmp11_ = FALSE;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = TRUE;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 8247 "ColorTransformation.c"
				gint _tmp13_ = 0;
				GdkPixbuf* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint row_start_offset = 0;
				gint _tmp17_ = 0;
				GdkPixbuf* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint r_offset = 0;
				gint _tmp21_ = 0;
				gint g_offset = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint b_offset = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp11_) {
#line 8268 "ColorTransformation.c"
					gint _tmp12_ = 0;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = y;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					y = _tmp12_ + 1;
#line 8274 "ColorTransformation.c"
				}
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = FALSE;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = y;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = pixbuf;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = _tmp15_;
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 981 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 8290 "ColorTransformation.c"
				}
#line 982 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = y;
#line 982 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = pixbuf;
#line 982 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = gdk_pixbuf_get_rowstride (_tmp18_);
#line 982 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = _tmp19_;
#line 982 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_offset = _tmp17_ * _tmp20_;
#line 984 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp21_ = row_start_offset;
#line 984 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				r_offset = _tmp21_;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22_ = row_start_offset;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = sample_bytes;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				g_offset = _tmp22_ + _tmp23_;
#line 986 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = row_start_offset;
#line 986 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = sample_bytes;
#line 986 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = sample_bytes;
#line 986 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				b_offset = (_tmp24_ + _tmp25_) + _tmp26_;
#line 988 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				while (TRUE) {
#line 8322 "ColorTransformation.c"
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					gint* _tmp30_ = NULL;
					gint _tmp30__length1 = 0;
					guchar* _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					gint _tmp32_ = 0;
					guchar _tmp33_ = '\0';
					gint _tmp34_ = 0;
					gint* _tmp35_ = NULL;
					gint _tmp35__length1 = 0;
					guchar* _tmp36_ = NULL;
					gint _tmp36__length1 = 0;
					gint _tmp37_ = 0;
					guchar _tmp38_ = '\0';
					gint _tmp39_ = 0;
					gint* _tmp40_ = NULL;
					gint _tmp40__length1 = 0;
					guchar* _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					gint _tmp42_ = 0;
					guchar _tmp43_ = '\0';
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
#line 988 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27_ = b_offset;
#line 988 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp28_ = row_start_offset;
#line 988 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp29_ = row_length_bytes;
#line 988 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!(_tmp27_ < (_tmp28_ + _tmp29_))) {
#line 988 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						break;
#line 8363 "ColorTransformation.c"
					}
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = self->priv->red_counts;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30__length1 = self->priv->red_counts_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31_ = pixel_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31__length1 = pixel_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_ = r_offset;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp33_ = _tmp31_[_tmp32_];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_[_tmp33_] += 1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp34_ = _tmp30_[_tmp33_];
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35_ = self->priv->green_counts;
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35__length1 = self->priv->green_counts_length1;
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp36_ = pixel_data;
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp36__length1 = pixel_data_length1;
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp37_ = g_offset;
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp38_ = _tmp36_[_tmp37_];
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35_[_tmp38_] += 1;
#line 990 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp39_ = _tmp35_[_tmp38_];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp40_ = self->priv->blue_counts;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp40__length1 = self->priv->blue_counts_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp41_ = pixel_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp41__length1 = pixel_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp42_ = b_offset;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp43_ = _tmp41_[_tmp42_];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp40_[_tmp43_] += 1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp44_ = _tmp40_[_tmp43_];
#line 993 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp45_ = r_offset;
#line 993 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp46_ = pixel_bytes;
#line 993 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					r_offset = _tmp45_ + _tmp46_;
#line 994 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp47_ = g_offset;
#line 994 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = pixel_bytes;
#line 994 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					g_offset = _tmp47_ + _tmp48_;
#line 995 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp49_ = b_offset;
#line 995 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp50_ = pixel_bytes;
#line 995 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					b_offset = _tmp49_ + _tmp50_;
#line 8431 "ColorTransformation.c"
				}
			}
		}
	}
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 8438 "ColorTransformation.c"
}


RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf) {
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return rgb_histogram_construct (TYPE_RGB_HISTOGRAM, pixbuf);
#line 8445 "ColorTransformation.c"
}


static gint rgb_histogram_correct_snap_to_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gint* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
#line 1000 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM (self), 0);
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = buckets;
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = buckets_length1;
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp0__length1 == 256, "buckets.length == 256");
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = i;
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ >= 0) {
#line 8472 "ColorTransformation.c"
		gint _tmp3_ = 0;
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = i;
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp3_ <= 255;
#line 8478 "ColorTransformation.c"
	} else {
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 8482 "ColorTransformation.c"
	}
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp1_, "(i >= 0) && (i <= 255)");
#line 1004 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = i;
#line 1004 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ == 0) {
#line 8490 "ColorTransformation.c"
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = buckets;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = buckets_length1;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = i;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[_tmp6_];
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp7_ > 0) {
#line 8505 "ColorTransformation.c"
			gint* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = buckets;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8__length1 = buckets_length1;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = i;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = _tmp8_[_tmp9_ + 1];
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp10_ > 0) {
#line 8520 "ColorTransformation.c"
				gint* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = buckets;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11__length1 = buckets_length1;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = i;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = buckets;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14__length1 = buckets_length1;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = i;
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = _tmp14_[_tmp15_ + 1];
#line 1007 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp13_ > (2 * _tmp16_)) {
#line 8547 "ColorTransformation.c"
					gint* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
#line 1008 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp17_ = buckets;
#line 1008 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp17__length1 = buckets_length1;
#line 1008 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = i;
#line 1008 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = _tmp17_[_tmp18_ + 1];
#line 1008 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					result = _tmp19_;
#line 1008 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return result;
#line 8564 "ColorTransformation.c"
				}
			}
		}
	} else {
		gint _tmp20_ = 0;
#line 1009 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = i;
#line 1009 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp20_ == 255) {
#line 8574 "ColorTransformation.c"
			gint* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 1010 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp21_ = buckets;
#line 1010 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp21__length1 = buckets_length1;
#line 1010 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp22_ = i;
#line 1010 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp23_ = _tmp21_[_tmp22_];
#line 1010 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp23_ > 0) {
#line 8589 "ColorTransformation.c"
				gint* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
#line 1011 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = buckets;
#line 1011 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24__length1 = buckets_length1;
#line 1011 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = i;
#line 1011 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = _tmp24_[_tmp25_ - 1];
#line 1011 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp26_ > 0) {
#line 8604 "ColorTransformation.c"
					gint* _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					gint* _tmp30_ = NULL;
					gint _tmp30__length1 = 0;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27_ = buckets;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27__length1 = buckets_length1;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp28_ = i;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp29_ = _tmp27_[_tmp28_];
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = buckets;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30__length1 = buckets_length1;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31_ = i;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_ = _tmp30_[_tmp31_ - 1];
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp29_ > (2 * _tmp32_)) {
#line 8631 "ColorTransformation.c"
						gint* _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp33_ = buckets;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp33__length1 = buckets_length1;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp34_ = i;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp35_ = _tmp33_[_tmp34_ - 1];
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						result = _tmp35_;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						return result;
#line 8648 "ColorTransformation.c"
					}
				}
			}
		} else {
			gint* _tmp36_ = NULL;
			gint _tmp36__length1 = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp36_ = buckets;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp36__length1 = buckets_length1;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp37_ = i;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp38_ = _tmp36_[_tmp37_];
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp38_ > 0) {
#line 8667 "ColorTransformation.c"
				gint* _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint* _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint* _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39_ = buckets;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39__length1 = buckets_length1;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp40_ = i;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_ = _tmp39_[_tmp40_];
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42_ = buckets;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42__length1 = buckets_length1;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43_ = i;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp44_ = _tmp42_[_tmp43_ - 1];
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp45_ = buckets;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp45__length1 = buckets_length1;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp46_ = i;
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = _tmp45_[_tmp46_ + 1];
#line 1016 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp41_ > ((_tmp44_ + _tmp47_) / 2)) {
#line 8706 "ColorTransformation.c"
					gint* _tmp48_ = NULL;
					gint _tmp48__length1 = 0;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
					gint* _tmp51_ = NULL;
					gint _tmp51__length1 = 0;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = buckets;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48__length1 = buckets_length1;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp49_ = i;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp50_ = _tmp48_[_tmp49_ - 1];
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp51_ = buckets;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp51__length1 = buckets_length1;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp52_ = i;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp53_ = _tmp51_[_tmp52_ + 1];
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					result = (_tmp50_ + _tmp53_) / 2;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return result;
#line 8735 "ColorTransformation.c"
				}
			}
		}
	}
#line 1020 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = buckets;
#line 1020 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54__length1 = buckets_length1;
#line 1020 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = i;
#line 1020 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = _tmp54_[_tmp55_];
#line 1020 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp56_;
#line 1020 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 8752 "ColorTransformation.c"
}


static gint rgb_histogram_correct_snap_from_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gint* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM (self), 0);
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = buckets;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = buckets_length1;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp0__length1 == 256, "buckets.length == 256");
#line 1025 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = i;
#line 1025 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ >= 0) {
#line 8779 "ColorTransformation.c"
		gint _tmp3_ = 0;
#line 1025 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = i;
#line 1025 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp3_ <= 255;
#line 8785 "ColorTransformation.c"
	} else {
#line 1025 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 8789 "ColorTransformation.c"
	}
#line 1025 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp1_, "(i >= 0) && (i <= 255)");
#line 1027 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = i;
#line 1027 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ == 0) {
#line 8797 "ColorTransformation.c"
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1028 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = buckets;
#line 1028 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = buckets_length1;
#line 1028 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = i;
#line 1028 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[_tmp6_];
#line 1028 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		result = _tmp7_;
#line 1028 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return result;
#line 8814 "ColorTransformation.c"
	} else {
		gint _tmp8_ = 0;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = i;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp8_ == 255) {
#line 8821 "ColorTransformation.c"
			gint* _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = buckets;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9__length1 = buckets_length1;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = i;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = _tmp9_[_tmp10_];
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = _tmp11_;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 8838 "ColorTransformation.c"
		} else {
			gint* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = buckets;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12__length1 = buckets_length1;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = i;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = _tmp12_[_tmp13_];
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp14_ == 0) {
#line 8854 "ColorTransformation.c"
				gint* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 1033 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = buckets;
#line 1033 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15__length1 = buckets_length1;
#line 1033 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = i;
#line 1033 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = _tmp15_[_tmp16_ - 1];
#line 1033 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp17_ > 0) {
#line 8869 "ColorTransformation.c"
					gint* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = buckets;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18__length1 = buckets_length1;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = i;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = _tmp18_[_tmp19_ + 1];
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp20_ > 0) {
#line 8884 "ColorTransformation.c"
						gint* _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
						gint* _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						gint _tmp25_ = 0;
						gint _tmp26_ = 0;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21_ = buckets;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21__length1 = buckets_length1;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp22_ = i;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp23_ = _tmp21_[_tmp22_ - 1];
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp24_ = buckets;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp24__length1 = buckets_length1;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp25_ = i;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp26_ = _tmp24_[_tmp25_ + 1];
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						result = (_tmp23_ + _tmp26_) / 2;
#line 1035 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						return result;
#line 8913 "ColorTransformation.c"
					}
				}
			}
		}
	}
#line 1038 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = buckets;
#line 1038 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27__length1 = buckets_length1;
#line 1038 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = i;
#line 1038 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp27_[_tmp28_];
#line 1038 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp29_;
#line 1038 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 8931 "ColorTransformation.c"
}


static void rgb_histogram_smooth_extrema (RGBHistogram* self, gint** count_data, int* count_data_length1) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp11_ = 0;
	gint* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp13_ = 0;
	gint* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gint _tmp15_ = 0;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
	gint* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp23_ = 0;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gint _tmp25_ = 0;
	gint* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gint _tmp27_ = 0;
	gint* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gint* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	gint _tmp33_ = 0;
	gint* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gint _tmp35_ = 0;
	gint* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gint _tmp37_ = 0;
	gint* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp39_ = 0;
	gint* _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint* _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	gint* _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	gint _tmp45_ = 0;
	gint* _tmp46_ = NULL;
	gint _tmp46__length1 = 0;
	gint _tmp47_ = 0;
	gint* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gint _tmp49_ = 0;
	gint* _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	gint _tmp51_ = 0;
	gint* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint* _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	gint* _tmp56_ = NULL;
	gint _tmp56__length1 = 0;
	gint _tmp57_ = 0;
	gint* _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gint _tmp59_ = 0;
	gint* _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint* _tmp63_ = NULL;
	gint _tmp63__length1 = 0;
	gint* _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	gint _tmp65_ = 0;
	gint* _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gint _tmp67_ = 0;
	gint* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	gint _tmp69_ = 0;
	gint* _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint* _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gint* _tmp74_ = NULL;
	gint _tmp74__length1 = 0;
	gint _tmp75_ = 0;
	gint* _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	gint _tmp77_ = 0;
	gint* _tmp78_ = NULL;
	gint _tmp78__length1 = 0;
	gint _tmp79_ = 0;
	gint* _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	gint _tmp81_ = 0;
	gint* _tmp82_ = NULL;
	gint _tmp82__length1 = 0;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
	gint* _tmp85_ = NULL;
	gint _tmp85__length1 = 0;
	gint* _tmp86_ = NULL;
	gint _tmp86__length1 = 0;
	gint _tmp87_ = 0;
	gint* _tmp88_ = NULL;
	gint _tmp88__length1 = 0;
	gint _tmp89_ = 0;
	gint* _tmp90_ = NULL;
	gint _tmp90__length1 = 0;
	gint _tmp91_ = 0;
	gint* _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	gint _tmp93_ = 0;
	gint* _tmp94_ = NULL;
	gint _tmp94__length1 = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	gint* _tmp97_ = NULL;
	gint _tmp97__length1 = 0;
	gint* _tmp98_ = NULL;
	gint _tmp98__length1 = 0;
	gint _tmp99_ = 0;
	gint* _tmp100_ = NULL;
	gint _tmp100__length1 = 0;
	gint _tmp101_ = 0;
	gint* _tmp102_ = NULL;
	gint _tmp102__length1 = 0;
	gint _tmp103_ = 0;
	gint* _tmp104_ = NULL;
	gint _tmp104__length1 = 0;
	gint _tmp105_ = 0;
	gint* _tmp106_ = NULL;
	gint _tmp106__length1 = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM (self));
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *count_data;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = *count_data_length1;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp0__length1 == 256, "count_data.length == 256");
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = *count_data;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1__length1 = *count_data_length1;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *count_data;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = *count_data_length1;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_[0];
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = *count_data;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4__length1 = *count_data_length1;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_[1];
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = *count_data;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6__length1 = *count_data_length1;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_[2];
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[0] = (((5 * _tmp3_) + (3 * _tmp5_)) + (2 * _tmp7_)) / 10;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp1_[0];
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = *count_data;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9__length1 = *count_data_length1;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = *count_data;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10__length1 = *count_data_length1;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_[0];
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = *count_data;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12__length1 = *count_data_length1;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_[1];
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = *count_data;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14__length1 = *count_data_length1;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_[2];
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = *count_data;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16__length1 = *count_data_length1;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = _tmp16_[3];
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_[1] = ((((3 * _tmp11_) + (5 * _tmp13_)) + (3 * _tmp15_)) + (2 * _tmp17_)) / 13;
#line 1050 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = _tmp9_[1];
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = *count_data;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19__length1 = *count_data_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = *count_data;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20__length1 = *count_data_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = _tmp20_[0];
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = *count_data;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22__length1 = *count_data_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_[1];
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = *count_data;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24__length1 = *count_data_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = _tmp24_[2];
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = *count_data;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26__length1 = *count_data_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = _tmp26_[3];
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = *count_data;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28__length1 = *count_data_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp28_[4];
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_[2] = (((((2 * _tmp21_) + (3 * _tmp23_)) + (5 * _tmp25_)) + (3 * _tmp27_)) + (2 * _tmp29_)) / 15;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = _tmp19_[2];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = *count_data;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31__length1 = *count_data_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = *count_data;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32__length1 = *count_data_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = _tmp32_[1];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = *count_data;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34__length1 = *count_data_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_[2];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36_ = *count_data;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36__length1 = *count_data_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp37_ = _tmp36_[3];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38_ = *count_data;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38__length1 = *count_data_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39_ = _tmp38_[4];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40_ = *count_data;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40__length1 = *count_data_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = _tmp40_[5];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_[3] = (((((2 * _tmp33_) + (3 * _tmp35_)) + (5 * _tmp37_)) + (3 * _tmp39_)) + (2 * _tmp41_)) / 15;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = _tmp31_[3];
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = *count_data;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43__length1 = *count_data_length1;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = *count_data;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44__length1 = *count_data_length1;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = _tmp44_[2];
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = *count_data;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46__length1 = *count_data_length1;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = _tmp46_[3];
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = *count_data;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48__length1 = *count_data_length1;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = _tmp48_[4];
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = *count_data;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50__length1 = *count_data_length1;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51_ = _tmp50_[5];
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52_ = *count_data;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52__length1 = *count_data_length1;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = _tmp52_[6];
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_[4] = (((((2 * _tmp45_) + (3 * _tmp47_)) + (5 * _tmp49_)) + (3 * _tmp51_)) + (2 * _tmp53_)) / 15;
#line 1056 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = _tmp43_[4];
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = *count_data;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55__length1 = *count_data_length1;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = *count_data;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56__length1 = *count_data_length1;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = _tmp56_[255];
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = *count_data;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58__length1 = *count_data_length1;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp59_ = _tmp58_[254];
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60_ = *count_data;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60__length1 = *count_data_length1;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61_ = _tmp60_[253];
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_[255] = (((5 * _tmp57_) + (3 * _tmp59_)) + (2 * _tmp61_)) / 10;
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp62_ = _tmp55_[255];
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_ = *count_data;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63__length1 = *count_data_length1;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp64_ = *count_data;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp64__length1 = *count_data_length1;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp65_ = _tmp64_[255];
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66_ = *count_data;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66__length1 = *count_data_length1;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp67_ = _tmp66_[254];
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68_ = *count_data;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68__length1 = *count_data_length1;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp69_ = _tmp68_[253];
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp70_ = *count_data;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp70__length1 = *count_data_length1;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71_ = _tmp70_[252];
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_[254] = ((((3 * _tmp65_) + (5 * _tmp67_)) + (3 * _tmp69_)) + (2 * _tmp71_)) / 13;
#line 1061 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp72_ = _tmp63_[254];
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73_ = *count_data;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73__length1 = *count_data_length1;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp74_ = *count_data;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp74__length1 = *count_data_length1;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp75_ = _tmp74_[255];
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp76_ = *count_data;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp76__length1 = *count_data_length1;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp77_ = _tmp76_[254];
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78_ = *count_data;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78__length1 = *count_data_length1;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp79_ = _tmp78_[253];
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80_ = *count_data;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80__length1 = *count_data_length1;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp81_ = _tmp80_[252];
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp82_ = *count_data;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp82__length1 = *count_data_length1;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp83_ = _tmp82_[251];
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73_[253] = (((((2 * _tmp75_) + (3 * _tmp77_)) + (5 * _tmp79_)) + (3 * _tmp81_)) + (2 * _tmp83_)) / 15;
#line 1063 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp84_ = _tmp73_[253];
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85_ = *count_data;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85__length1 = *count_data_length1;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp86_ = *count_data;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp86__length1 = *count_data_length1;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp87_ = _tmp86_[254];
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88_ = *count_data;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88__length1 = *count_data_length1;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp89_ = _tmp88_[253];
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90_ = *count_data;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90__length1 = *count_data_length1;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp91_ = _tmp90_[252];
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp92_ = *count_data;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp92__length1 = *count_data_length1;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93_ = _tmp92_[251];
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp94_ = *count_data;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp94__length1 = *count_data_length1;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp95_ = _tmp94_[250];
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85_[252] = (((((2 * _tmp87_) + (3 * _tmp89_)) + (5 * _tmp91_)) + (3 * _tmp93_)) + (2 * _tmp95_)) / 15;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp96_ = _tmp85_[252];
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97_ = *count_data;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97__length1 = *count_data_length1;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp98_ = *count_data;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp98__length1 = *count_data_length1;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp99_ = _tmp98_[253];
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100_ = *count_data;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100__length1 = *count_data_length1;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp101_ = _tmp100_[252];
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102_ = *count_data;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102__length1 = *count_data_length1;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp103_ = _tmp102_[251];
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp104_ = *count_data;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp104__length1 = *count_data_length1;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp105_ = _tmp104_[250];
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp106_ = *count_data;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp106__length1 = *count_data_length1;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp107_ = _tmp106_[249];
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97_[251] = (((((2 * _tmp99_) + (3 * _tmp101_)) + (5 * _tmp103_)) + (3 * _tmp105_)) + (2 * _tmp107_)) / 15;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp108_ = _tmp97_[251];
#line 9452 "ColorTransformation.c"
}


static void rgb_histogram_prepare_qualitative_counts (RGBHistogram* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gint* _tmp7_ = NULL;
	gint* temp_red_counts = NULL;
	gint* _tmp8_ = NULL;
	gint temp_red_counts_length1 = 0;
	gint _temp_red_counts_size_ = 0;
	gint* temp_green_counts = NULL;
	gint* _tmp9_ = NULL;
	gint temp_green_counts_length1 = 0;
	gint _temp_green_counts_size_ = 0;
	gint* temp_blue_counts = NULL;
	gint* _tmp10_ = NULL;
	gint temp_blue_counts_length1 = 0;
	gint _temp_blue_counts_size_ = 0;
	gint mean_qual_count = 0;
	gint _tmp87_ = 0;
	gint constrained_max_qual_count = 0;
	gint _tmp88_ = 0;
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM (self));
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->qualitative_red_counts;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = self->priv->qualitative_red_counts_length1;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != NULL) {
#line 9488 "ColorTransformation.c"
		gint* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->qualitative_green_counts;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3__length1 = self->priv->qualitative_green_counts_length1;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 9497 "ColorTransformation.c"
	} else {
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 9501 "ColorTransformation.c"
	}
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_) {
#line 9505 "ColorTransformation.c"
		gint* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = self->priv->qualitative_blue_counts;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4__length1 = self->priv->qualitative_blue_counts_length1;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 9514 "ColorTransformation.c"
	} else {
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 9518 "ColorTransformation.c"
	}
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_) {
#line 1074 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return;
#line 9524 "ColorTransformation.c"
	}
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = g_new0 (gint, 256);
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = (g_free (self->priv->qualitative_red_counts), NULL);
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = _tmp5_;
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts_length1 = 256;
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
#line 1077 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = g_new0 (gint, 256);
#line 1077 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = (g_free (self->priv->qualitative_green_counts), NULL);
#line 1077 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = _tmp6_;
#line 1077 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts_length1 = 256;
#line 1077 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
#line 1078 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = g_new0 (gint, 256);
#line 1078 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = (g_free (self->priv->qualitative_blue_counts), NULL);
#line 1078 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = _tmp7_;
#line 1078 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts_length1 = 256;
#line 1078 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = g_new0 (gint, 256);
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_red_counts = _tmp8_;
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_red_counts_length1 = 256;
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_temp_red_counts_size_ = temp_red_counts_length1;
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = g_new0 (gint, 256);
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_green_counts = _tmp9_;
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_green_counts_length1 = 256;
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_temp_green_counts_size_ = temp_green_counts_length1;
#line 1082 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = g_new0 (gint, 256);
#line 1082 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_blue_counts = _tmp10_;
#line 1082 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_blue_counts_length1 = 256;
#line 1082 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_temp_blue_counts_size_ = temp_blue_counts_length1;
#line 9580 "ColorTransformation.c"
	{
		gint i = 0;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9585 "ColorTransformation.c"
		{
			gboolean _tmp11_ = FALSE;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = TRUE;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9592 "ColorTransformation.c"
				gint _tmp13_ = 0;
				gint* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				gint* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gint _tmp21_ = 0;
				gint* _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				gint* _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp11_) {
#line 9620 "ColorTransformation.c"
					gint _tmp12_ = 0;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = i;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp12_ + 1;
#line 9626 "ColorTransformation.c"
				}
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = FALSE;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = i;
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp13_ < 256)) {
#line 1088 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9636 "ColorTransformation.c"
				}
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = self->priv->qualitative_red_counts;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14__length1 = self->priv->qualitative_red_counts_length1;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = i;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = self->priv->red_counts;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16__length1 = self->priv->red_counts_length1;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = i;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = rgb_histogram_correct_snap_from_quantization (self, _tmp16_, _tmp16__length1, _tmp17_);
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_[_tmp15_] = _tmp18_;
#line 1089 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = _tmp14_[_tmp15_];
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = self->priv->qualitative_green_counts;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20__length1 = self->priv->qualitative_green_counts_length1;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp21_ = i;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22_ = self->priv->green_counts;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22__length1 = self->priv->green_counts_length1;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = i;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = rgb_histogram_correct_snap_from_quantization (self, _tmp22_, _tmp22__length1, _tmp23_);
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_[_tmp21_] = _tmp24_;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = _tmp20_[_tmp21_];
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = self->priv->qualitative_blue_counts;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26__length1 = self->priv->qualitative_blue_counts_length1;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp27_ = i;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp28_ = self->priv->blue_counts;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp28__length1 = self->priv->blue_counts_length1;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp29_ = i;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp30_ = rgb_histogram_correct_snap_from_quantization (self, _tmp28_, _tmp28__length1, _tmp29_);
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_[_tmp27_] = _tmp30_;
#line 1093 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp31_ = _tmp26_[_tmp27_];
#line 9692 "ColorTransformation.c"
			}
		}
	}
	{
		gint i = 0;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9700 "ColorTransformation.c"
		{
			gboolean _tmp32_ = FALSE;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp32_ = TRUE;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9707 "ColorTransformation.c"
				gint _tmp34_ = 0;
				gint* _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gint _tmp36_ = 0;
				gint* _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint* _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				gint _tmp42_ = 0;
				gint* _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint* _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gint _tmp48_ = 0;
				gint* _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp32_) {
#line 9735 "ColorTransformation.c"
					gint _tmp33_ = 0;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp33_ = i;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp33_ + 1;
#line 9741 "ColorTransformation.c"
				}
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp32_ = FALSE;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp34_ = i;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp34_ < 256)) {
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9751 "ColorTransformation.c"
				}
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35_ = temp_red_counts;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35__length1 = temp_red_counts_length1;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp36_ = i;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37_ = self->priv->qualitative_red_counts;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37__length1 = self->priv->qualitative_red_counts_length1;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp38_ = i;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39_ = _tmp37_[_tmp38_];
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35_[_tmp36_] = _tmp39_;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp40_ = _tmp35_[_tmp36_];
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_ = temp_green_counts;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41__length1 = temp_green_counts_length1;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42_ = i;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43_ = self->priv->qualitative_green_counts;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43__length1 = self->priv->qualitative_green_counts_length1;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp44_ = i;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp45_ = _tmp43_[_tmp44_];
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_[_tmp42_] = _tmp45_;
#line 1099 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp46_ = _tmp41_[_tmp42_];
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = temp_blue_counts;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47__length1 = temp_blue_counts_length1;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp48_ = i;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49_ = self->priv->qualitative_blue_counts;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49__length1 = self->priv->qualitative_blue_counts_length1;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_ = i;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp51_ = _tmp49_[_tmp50_];
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_[_tmp48_] = _tmp51_;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52_ = _tmp47_[_tmp48_];
#line 9807 "ColorTransformation.c"
			}
		}
	}
	{
		gint i = 0;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9815 "ColorTransformation.c"
		{
			gboolean _tmp53_ = FALSE;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp53_ = TRUE;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9822 "ColorTransformation.c"
				gint _tmp55_ = 0;
				gint* _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gint _tmp57_ = 0;
				gint* _tmp58_ = NULL;
				gint _tmp58__length1 = 0;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				gint* _tmp62_ = NULL;
				gint _tmp62__length1 = 0;
				gint _tmp63_ = 0;
				gint* _tmp64_ = NULL;
				gint _tmp64__length1 = 0;
				gint _tmp65_ = 0;
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint* _tmp68_ = NULL;
				gint _tmp68__length1 = 0;
				gint _tmp69_ = 0;
				gint* _tmp70_ = NULL;
				gint _tmp70__length1 = 0;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp53_) {
#line 9850 "ColorTransformation.c"
					gint _tmp54_ = 0;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp54_ = i;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp54_ + 1;
#line 9856 "ColorTransformation.c"
				}
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = FALSE;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp55_ = i;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp55_ < 256)) {
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9866 "ColorTransformation.c"
				}
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_ = self->priv->qualitative_red_counts;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56__length1 = self->priv->qualitative_red_counts_length1;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp57_ = i;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58_ = temp_red_counts;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58__length1 = temp_red_counts_length1;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp59_ = i;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp60_ = rgb_histogram_correct_snap_to_quantization (self, _tmp58_, _tmp58__length1, _tmp59_);
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_[_tmp57_] = _tmp60_;
#line 1106 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_ = _tmp56_[_tmp57_];
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62_ = self->priv->qualitative_green_counts;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62__length1 = self->priv->qualitative_green_counts_length1;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp63_ = i;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp64_ = temp_green_counts;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp64__length1 = temp_green_counts_length1;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp65_ = i;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp66_ = rgb_histogram_correct_snap_to_quantization (self, _tmp64_, _tmp64__length1, _tmp65_);
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62_[_tmp63_] = _tmp66_;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp67_ = _tmp62_[_tmp63_];
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp68_ = self->priv->qualitative_blue_counts;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp68__length1 = self->priv->qualitative_blue_counts_length1;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp69_ = i;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp70_ = temp_blue_counts;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp70__length1 = temp_blue_counts_length1;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp71_ = i;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp72_ = rgb_histogram_correct_snap_to_quantization (self, _tmp70_, _tmp70__length1, _tmp71_);
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp68_[_tmp69_] = _tmp72_;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp73_ = _tmp68_[_tmp69_];
#line 9922 "ColorTransformation.c"
			}
		}
	}
#line 1116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	mean_qual_count = 0;
#line 9928 "ColorTransformation.c"
	{
		gint i = 0;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9933 "ColorTransformation.c"
		{
			gboolean _tmp74_ = FALSE;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp74_ = TRUE;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9940 "ColorTransformation.c"
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint* _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				gint* _tmp81_ = NULL;
				gint _tmp81__length1 = 0;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint* _tmp84_ = NULL;
				gint _tmp84__length1 = 0;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp74_) {
#line 9957 "ColorTransformation.c"
					gint _tmp75_ = 0;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp75_ = i;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp75_ + 1;
#line 9963 "ColorTransformation.c"
				}
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp74_ = FALSE;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp76_ = i;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp76_ < 256)) {
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9973 "ColorTransformation.c"
				}
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp77_ = mean_qual_count;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp78_ = self->priv->qualitative_red_counts;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp78__length1 = self->priv->qualitative_red_counts_length1;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp79_ = i;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp80_ = _tmp78_[_tmp79_];
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp81_ = self->priv->qualitative_green_counts;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp81__length1 = self->priv->qualitative_green_counts_length1;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp82_ = i;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp83_ = _tmp81_[_tmp82_];
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp84_ = self->priv->qualitative_blue_counts;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp84__length1 = self->priv->qualitative_blue_counts_length1;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp85_ = i;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp86_ = _tmp84_[_tmp85_];
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				mean_qual_count = _tmp77_ + ((_tmp80_ + _tmp83_) + _tmp86_);
#line 10003 "ColorTransformation.c"
			}
		}
	}
#line 1121 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp87_ = mean_qual_count;
#line 1121 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	mean_qual_count = _tmp87_ / (256 * 3);
#line 1122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88_ = mean_qual_count;
#line 1122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	constrained_max_qual_count = 8 * _tmp88_;
#line 10015 "ColorTransformation.c"
	{
		gint i = 0;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 10020 "ColorTransformation.c"
		{
			gboolean _tmp89_ = FALSE;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp89_ = TRUE;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 10027 "ColorTransformation.c"
				gint _tmp91_ = 0;
				gint* _tmp92_ = NULL;
				gint _tmp92__length1 = 0;
				gint _tmp93_ = 0;
				gint _tmp94_ = 0;
				gint _tmp95_ = 0;
				gint* _tmp100_ = NULL;
				gint _tmp100__length1 = 0;
				gint _tmp101_ = 0;
				gint _tmp102_ = 0;
				gint _tmp103_ = 0;
				gint* _tmp108_ = NULL;
				gint _tmp108__length1 = 0;
				gint _tmp109_ = 0;
				gint _tmp110_ = 0;
				gint _tmp111_ = 0;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp89_) {
#line 10046 "ColorTransformation.c"
					gint _tmp90_ = 0;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp90_ = i;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp90_ + 1;
#line 10052 "ColorTransformation.c"
				}
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp89_ = FALSE;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp91_ = i;
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp91_ < 256)) {
#line 1123 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 10062 "ColorTransformation.c"
				}
#line 1124 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp92_ = self->priv->qualitative_red_counts;
#line 1124 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp92__length1 = self->priv->qualitative_red_counts_length1;
#line 1124 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp93_ = i;
#line 1124 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp94_ = _tmp92_[_tmp93_];
#line 1124 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp95_ = constrained_max_qual_count;
#line 1124 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp94_ > _tmp95_) {
#line 10076 "ColorTransformation.c"
					gint* _tmp96_ = NULL;
					gint _tmp96__length1 = 0;
					gint _tmp97_ = 0;
					gint _tmp98_ = 0;
					gint _tmp99_ = 0;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp96_ = self->priv->qualitative_red_counts;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp96__length1 = self->priv->qualitative_red_counts_length1;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp97_ = i;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp98_ = constrained_max_qual_count;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp96_[_tmp97_] = _tmp98_;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp99_ = _tmp96_[_tmp97_];
#line 10094 "ColorTransformation.c"
				}
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp100_ = self->priv->qualitative_green_counts;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp100__length1 = self->priv->qualitative_green_counts_length1;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp101_ = i;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp102_ = _tmp100_[_tmp101_];
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp103_ = constrained_max_qual_count;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp102_ > _tmp103_) {
#line 10108 "ColorTransformation.c"
					gint* _tmp104_ = NULL;
					gint _tmp104__length1 = 0;
					gint _tmp105_ = 0;
					gint _tmp106_ = 0;
					gint _tmp107_ = 0;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp104_ = self->priv->qualitative_green_counts;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp104__length1 = self->priv->qualitative_green_counts_length1;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp105_ = i;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp106_ = constrained_max_qual_count;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp104_[_tmp105_] = _tmp106_;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp107_ = _tmp104_[_tmp105_];
#line 10126 "ColorTransformation.c"
				}
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp108_ = self->priv->qualitative_blue_counts;
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp108__length1 = self->priv->qualitative_blue_counts_length1;
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp109_ = i;
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp110_ = _tmp108_[_tmp109_];
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp111_ = constrained_max_qual_count;
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp110_ > _tmp111_) {
#line 10140 "ColorTransformation.c"
					gint* _tmp112_ = NULL;
					gint _tmp112__length1 = 0;
					gint _tmp113_ = 0;
					gint _tmp114_ = 0;
					gint _tmp115_ = 0;
#line 1131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp112_ = self->priv->qualitative_blue_counts;
#line 1131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp112__length1 = self->priv->qualitative_blue_counts_length1;
#line 1131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp113_ = i;
#line 1131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp114_ = constrained_max_qual_count;
#line 1131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp112_[_tmp113_] = _tmp114_;
#line 1131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp115_ = _tmp112_[_tmp113_];
#line 10158 "ColorTransformation.c"
				}
			}
		}
	}
#line 1134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_red_counts, &self->priv->qualitative_red_counts_length1);
#line 1135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_green_counts, &self->priv->qualitative_green_counts_length1);
#line 1136 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_blue_counts, &self->priv->qualitative_blue_counts_length1);
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_blue_counts = (g_free (temp_blue_counts), NULL);
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_green_counts = (g_free (temp_green_counts), NULL);
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_red_counts = (g_free (temp_red_counts), NULL);
#line 10175 "ColorTransformation.c"
}


GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp121_ = NULL;
	GdkPixbuf* _tmp122_ = NULL;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM (self), NULL);
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->graphic;
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ == NULL) {
#line 10190 "ColorTransformation.c"
		gint max_count = 0;
		GdkPixbuf* _tmp25_ = NULL;
		gint rowstride = 0;
		GdkPixbuf* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint sample_bytes = 0;
		GdkPixbuf* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint pixel_bytes = 0;
		gint _tmp31_ = 0;
		GdkPixbuf* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gdouble scale_bar = 0.0;
		gint _tmp34_ = 0;
		guchar* pixel_data = NULL;
		GdkPixbuf* _tmp35_ = NULL;
		guint8* _tmp36_ = NULL;
		gint pixel_data_length1 = 0;
		gint _pixel_data_size_ = 0;
		gint _tmp37_ = 0;
#line 1141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_prepare_qualitative_counts (self);
#line 1142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		max_count = 0;
#line 10216 "ColorTransformation.c"
		{
			gint i = 0;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			i = 0;
#line 10221 "ColorTransformation.c"
			{
				gboolean _tmp1_ = FALSE;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp1_ = TRUE;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				while (TRUE) {
#line 10228 "ColorTransformation.c"
					gint _tmp3_ = 0;
					gint* _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!_tmp1_) {
#line 10247 "ColorTransformation.c"
						gint _tmp2_ = 0;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp2_ = i;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						i = _tmp2_ + 1;
#line 10253 "ColorTransformation.c"
					}
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp1_ = FALSE;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp3_ = i;
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!(_tmp3_ < 256)) {
#line 1143 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						break;
#line 10263 "ColorTransformation.c"
					}
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp4_ = self->priv->qualitative_red_counts;
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp4__length1 = self->priv->qualitative_red_counts_length1;
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp5_ = i;
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp6_ = _tmp4_[_tmp5_];
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp7_ = max_count;
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp6_ > _tmp7_) {
#line 10277 "ColorTransformation.c"
						gint* _tmp8_ = NULL;
						gint _tmp8__length1 = 0;
						gint _tmp9_ = 0;
						gint _tmp10_ = 0;
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp8_ = self->priv->qualitative_red_counts;
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp8__length1 = self->priv->qualitative_red_counts_length1;
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp9_ = i;
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp10_ = _tmp8_[_tmp9_];
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						max_count = _tmp10_;
#line 10292 "ColorTransformation.c"
					}
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11_ = self->priv->qualitative_green_counts;
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11__length1 = self->priv->qualitative_green_counts_length1;
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = i;
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = _tmp11_[_tmp12_];
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp14_ = max_count;
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp13_ > _tmp14_) {
#line 10306 "ColorTransformation.c"
						gint* _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						gint _tmp16_ = 0;
						gint _tmp17_ = 0;
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp15_ = self->priv->qualitative_green_counts;
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp15__length1 = self->priv->qualitative_green_counts_length1;
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp16_ = i;
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp17_ = _tmp15_[_tmp16_];
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						max_count = _tmp17_;
#line 10321 "ColorTransformation.c"
					}
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = self->priv->qualitative_blue_counts;
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18__length1 = self->priv->qualitative_blue_counts_length1;
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = i;
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = _tmp18_[_tmp19_];
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = max_count;
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp20_ > _tmp21_) {
#line 10335 "ColorTransformation.c"
						gint* _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp22_ = self->priv->qualitative_blue_counts;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp22__length1 = self->priv->qualitative_blue_counts_length1;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp23_ = i;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp24_ = _tmp22_[_tmp23_];
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						max_count = _tmp24_;
#line 10350 "ColorTransformation.c"
					}
				}
			}
		}
#line 1152 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, RGB_HISTOGRAM_GRAPHIC_WIDTH, RGB_HISTOGRAM_GRAPHIC_HEIGHT);
#line 1152 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (self->priv->graphic);
#line 1152 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->graphic = _tmp25_;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = self->priv->graphic;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = gdk_pixbuf_get_rowstride (_tmp26_);
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp28_ = _tmp27_;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rowstride = _tmp28_;
#line 1156 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp29_ = self->priv->graphic;
#line 1156 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp30_ = gdk_pixbuf_get_bits_per_sample (_tmp29_);
#line 1156 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		sample_bytes = _tmp30_ / 8;
#line 1157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31_ = sample_bytes;
#line 1157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp32_ = self->priv->graphic;
#line 1157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp33_ = gdk_pixbuf_get_n_channels (_tmp32_);
#line 1157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_bytes = _tmp31_ * _tmp33_;
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp34_ = max_count;
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		scale_bar = (0.98 * ((gdouble) RGB_HISTOGRAM_GRAPHIC_HEIGHT)) / ((gdouble) _tmp34_);
#line 1162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_ = self->priv->graphic;
#line 1162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = gdk_pixbuf_get_pixels (_tmp35_);
#line 1162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_data = _tmp36_;
#line 1162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_data_length1 = -1;
#line 1162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_data_size_ = pixel_data_length1;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp37_ = max_count;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp37_ == 0) {
#line 10401 "ColorTransformation.c"
			GdkPixbuf* _tmp51_ = NULL;
			GdkPixbuf* _tmp52_ = NULL;
			{
				gint i = 0;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = 0;
#line 10408 "ColorTransformation.c"
				{
					gboolean _tmp38_ = FALSE;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp38_ = TRUE;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					while (TRUE) {
#line 10415 "ColorTransformation.c"
						gint _tmp40_ = 0;
						gint _tmp41_ = 0;
						GdkPixbuf* _tmp42_ = NULL;
						gint _tmp43_ = 0;
						gint _tmp44_ = 0;
						GdkPixbuf* _tmp45_ = NULL;
						gint _tmp46_ = 0;
						gint _tmp47_ = 0;
						guchar* _tmp48_ = NULL;
						gint _tmp48__length1 = 0;
						gint _tmp49_ = 0;
						guchar _tmp50_ = '\0';
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						if (!_tmp38_) {
#line 10430 "ColorTransformation.c"
							gint _tmp39_ = 0;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp39_ = i;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							i = _tmp39_ + 1;
#line 10436 "ColorTransformation.c"
						}
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp38_ = FALSE;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp40_ = i;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp41_ = pixel_bytes;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp42_ = self->priv->graphic;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp43_ = gdk_pixbuf_get_width (_tmp42_);
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp44_ = _tmp43_;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp45_ = self->priv->graphic;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp46_ = gdk_pixbuf_get_height (_tmp45_);
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp47_ = _tmp46_;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						if (!(_tmp40_ < ((_tmp41_ * _tmp44_) * _tmp47_))) {
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							break;
#line 10460 "ColorTransformation.c"
						}
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp48_ = pixel_data;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp48__length1 = pixel_data_length1;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp49_ = i;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp48_[_tmp49_] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp50_ = _tmp48_[_tmp49_];
#line 10472 "ColorTransformation.c"
					}
				}
			}
#line 1170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp51_ = self->priv->graphic;
#line 1170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp52_ = _g_object_ref0 (_tmp51_);
#line 1170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = _tmp52_;
#line 1170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 10484 "ColorTransformation.c"
		}
		{
			gint x = 0;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			x = 0;
#line 10490 "ColorTransformation.c"
			{
				gboolean _tmp53_ = FALSE;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = TRUE;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				while (TRUE) {
#line 10497 "ColorTransformation.c"
					gint _tmp55_ = 0;
					gint red_bar_height = 0;
					gint* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					gint _tmp57_ = 0;
					gint _tmp58_ = 0;
					gdouble _tmp59_ = 0.0;
					gint green_bar_height = 0;
					gint* _tmp60_ = NULL;
					gint _tmp60__length1 = 0;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
					gdouble _tmp63_ = 0.0;
					gint blue_bar_height = 0;
					gint* _tmp64_ = NULL;
					gint _tmp64__length1 = 0;
					gint _tmp65_ = 0;
					gint _tmp66_ = 0;
					gdouble _tmp67_ = 0.0;
					gint max_bar_height = 0;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					gint y = 0;
					gint pixel_index = 0;
					gint _tmp73_ = 0;
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!_tmp53_) {
#line 10531 "ColorTransformation.c"
						gint _tmp54_ = 0;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp54_ = x;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						x = _tmp54_ + 1;
#line 10537 "ColorTransformation.c"
					}
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp53_ = FALSE;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp55_ = x;
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!(_tmp55_ < 256)) {
#line 1173 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						break;
#line 10547 "ColorTransformation.c"
					}
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp56_ = self->priv->qualitative_red_counts;
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp56__length1 = self->priv->qualitative_red_counts_length1;
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp57_ = x;
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp58_ = _tmp56_[_tmp57_];
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp59_ = scale_bar;
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					red_bar_height = (gint) (((gdouble) _tmp58_) * _tmp59_);
#line 1176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp60_ = self->priv->qualitative_green_counts;
#line 1176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp60__length1 = self->priv->qualitative_green_counts_length1;
#line 1176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp61_ = x;
#line 1176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp62_ = _tmp60_[_tmp61_];
#line 1176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp63_ = scale_bar;
#line 1176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					green_bar_height = (gint) (((gdouble) _tmp62_) * _tmp63_);
#line 1178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp64_ = self->priv->qualitative_blue_counts;
#line 1178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp64__length1 = self->priv->qualitative_blue_counts_length1;
#line 1178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp65_ = x;
#line 1178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp66_ = _tmp64_[_tmp65_];
#line 1178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp67_ = scale_bar;
#line 1178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					blue_bar_height = (gint) (((gdouble) _tmp66_) * _tmp67_);
#line 1181 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp68_ = red_bar_height;
#line 1181 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp69_ = green_bar_height;
#line 1181 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp70_ = MAX (_tmp68_, _tmp69_);
#line 1181 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp71_ = blue_bar_height;
#line 1181 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp72_ = MAX (_tmp70_, _tmp71_);
#line 1181 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					max_bar_height = _tmp72_;
#line 1184 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					y = RGB_HISTOGRAM_GRAPHIC_HEIGHT - 1;
#line 1185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp73_ = x;
#line 1185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp74_ = pixel_bytes;
#line 1185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp75_ = y;
#line 1185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp76_ = rowstride;
#line 1185 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pixel_index = (_tmp73_ * _tmp74_) + (_tmp75_ * _tmp76_);
#line 10609 "ColorTransformation.c"
					{
						gboolean _tmp77_ = FALSE;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp77_ = TRUE;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 10616 "ColorTransformation.c"
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							guchar* _tmp81_ = NULL;
							gint _tmp81__length1 = 0;
							gint _tmp82_ = 0;
							guchar _tmp83_ = '\0';
							guchar* _tmp84_ = NULL;
							gint _tmp84__length1 = 0;
							gint _tmp85_ = 0;
							guchar _tmp86_ = '\0';
							guchar* _tmp87_ = NULL;
							gint _tmp87__length1 = 0;
							gint _tmp88_ = 0;
							guchar _tmp89_ = '\0';
							gint _tmp90_ = 0;
							gint _tmp91_ = 0;
							gint _tmp95_ = 0;
							gint _tmp96_ = 0;
							gint _tmp100_ = 0;
							gint _tmp101_ = 0;
							gint _tmp105_ = 0;
							gint _tmp106_ = 0;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp77_) {
#line 10641 "ColorTransformation.c"
								gint _tmp78_ = 0;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp78_ = y;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								y = _tmp78_ - 1;
#line 10647 "ColorTransformation.c"
							}
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp77_ = FALSE;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp79_ = y;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp80_ = max_bar_height;
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp79_ >= (RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp80_))) {
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 10659 "ColorTransformation.c"
							}
#line 1187 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp81_ = pixel_data;
#line 1187 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp81__length1 = pixel_data_length1;
#line 1187 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp82_ = pixel_index;
#line 1187 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp81_[_tmp82_] = RGB_HISTOGRAM_MARKED_BACKGROUND;
#line 1187 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp83_ = _tmp81_[_tmp82_];
#line 1188 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp84_ = pixel_data;
#line 1188 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp84__length1 = pixel_data_length1;
#line 1188 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp85_ = pixel_index;
#line 1188 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp84_[_tmp85_ + 1] = RGB_HISTOGRAM_MARKED_BACKGROUND;
#line 1188 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp86_ = _tmp84_[_tmp85_ + 1];
#line 1189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp87_ = pixel_data;
#line 1189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp87__length1 = pixel_data_length1;
#line 1189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp88_ = pixel_index;
#line 1189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp87_[_tmp88_ + 2] = RGB_HISTOGRAM_MARKED_BACKGROUND;
#line 1189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp89_ = _tmp87_[_tmp88_ + 2];
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp90_ = y;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp91_ = red_bar_height;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (_tmp90_ >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp91_) - 1)) {
#line 10697 "ColorTransformation.c"
								guchar* _tmp92_ = NULL;
								gint _tmp92__length1 = 0;
								gint _tmp93_ = 0;
								guchar _tmp94_ = '\0';
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp92_ = pixel_data;
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp92__length1 = pixel_data_length1;
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp93_ = pixel_index;
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp92_[_tmp93_] = RGB_HISTOGRAM_MARKED_FOREGROUND;
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp94_ = _tmp92_[_tmp93_];
#line 10712 "ColorTransformation.c"
							}
#line 1193 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp95_ = y;
#line 1193 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp96_ = green_bar_height;
#line 1193 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (_tmp95_ >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp96_) - 1)) {
#line 10720 "ColorTransformation.c"
								guchar* _tmp97_ = NULL;
								gint _tmp97__length1 = 0;
								gint _tmp98_ = 0;
								guchar _tmp99_ = '\0';
#line 1194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp97_ = pixel_data;
#line 1194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp97__length1 = pixel_data_length1;
#line 1194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp98_ = pixel_index;
#line 1194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp97_[_tmp98_ + 1] = RGB_HISTOGRAM_MARKED_FOREGROUND;
#line 1194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp99_ = _tmp97_[_tmp98_ + 1];
#line 10735 "ColorTransformation.c"
							}
#line 1195 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp100_ = y;
#line 1195 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp101_ = blue_bar_height;
#line 1195 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (_tmp100_ >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp101_) - 1)) {
#line 10743 "ColorTransformation.c"
								guchar* _tmp102_ = NULL;
								gint _tmp102__length1 = 0;
								gint _tmp103_ = 0;
								guchar _tmp104_ = '\0';
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp102_ = pixel_data;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp102__length1 = pixel_data_length1;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp103_ = pixel_index;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp102_[_tmp103_ + 2] = RGB_HISTOGRAM_MARKED_FOREGROUND;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp104_ = _tmp102_[_tmp103_ + 2];
#line 10758 "ColorTransformation.c"
							}
#line 1198 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp105_ = pixel_index;
#line 1198 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp106_ = rowstride;
#line 1198 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_index = _tmp105_ - _tmp106_;
#line 10766 "ColorTransformation.c"
						}
					}
					{
						gboolean _tmp107_ = FALSE;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp107_ = TRUE;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 10775 "ColorTransformation.c"
							gint _tmp109_ = 0;
							guchar* _tmp110_ = NULL;
							gint _tmp110__length1 = 0;
							gint _tmp111_ = 0;
							guchar _tmp112_ = '\0';
							guchar* _tmp113_ = NULL;
							gint _tmp113__length1 = 0;
							gint _tmp114_ = 0;
							guchar _tmp115_ = '\0';
							guchar* _tmp116_ = NULL;
							gint _tmp116__length1 = 0;
							gint _tmp117_ = 0;
							guchar _tmp118_ = '\0';
							gint _tmp119_ = 0;
							gint _tmp120_ = 0;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp107_) {
#line 10793 "ColorTransformation.c"
								gint _tmp108_ = 0;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp108_ = y;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								y = _tmp108_ - 1;
#line 10799 "ColorTransformation.c"
							}
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp107_ = FALSE;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp109_ = y;
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp109_ >= 0)) {
#line 1201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 10809 "ColorTransformation.c"
							}
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp110_ = pixel_data;
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp110__length1 = pixel_data_length1;
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp111_ = pixel_index;
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp110_[_tmp111_] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp112_ = _tmp110_[_tmp111_];
#line 1203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp113_ = pixel_data;
#line 1203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp113__length1 = pixel_data_length1;
#line 1203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp114_ = pixel_index;
#line 1203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp113_[_tmp114_ + 1] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp115_ = _tmp113_[_tmp114_ + 1];
#line 1204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp116_ = pixel_data;
#line 1204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp116__length1 = pixel_data_length1;
#line 1204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp117_ = pixel_index;
#line 1204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp116_[_tmp117_ + 2] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp118_ = _tmp116_[_tmp117_ + 2];
#line 1206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp119_ = pixel_index;
#line 1206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp120_ = rowstride;
#line 1206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_index = _tmp119_ - _tmp120_;
#line 10847 "ColorTransformation.c"
						}
					}
				}
			}
		}
	}
#line 1211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp121_ = self->priv->graphic;
#line 1211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp122_ = _g_object_ref0 (_tmp121_);
#line 1211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp122_;
#line 1211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 10862 "ColorTransformation.c"
}


static void value_rgb_histogram_init (GValue* value) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 10869 "ColorTransformation.c"
}


static void value_rgb_histogram_free_value (GValue* value) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_unref (value->data[0].v_pointer);
#line 10878 "ColorTransformation.c"
	}
}


static void value_rgb_histogram_copy_value (const GValue* src_value, GValue* dest_value) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = rgb_histogram_ref (src_value->data[0].v_pointer);
#line 10888 "ColorTransformation.c"
	} else {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 10892 "ColorTransformation.c"
	}
}


static gpointer value_rgb_histogram_peek_pointer (const GValue* value) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 10900 "ColorTransformation.c"
}


static gchar* value_rgb_histogram_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 10907 "ColorTransformation.c"
		RGBHistogram* object;
		object = collect_values[0].v_pointer;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10914 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10918 "ColorTransformation.c"
		}
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = rgb_histogram_ref (object);
#line 10922 "ColorTransformation.c"
	} else {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 10926 "ColorTransformation.c"
	}
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 10930 "ColorTransformation.c"
}


static gchar* value_rgb_histogram_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RGBHistogram** object_p;
	object_p = collect_values[0].v_pointer;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 10941 "ColorTransformation.c"
	}
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 10947 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 10951 "ColorTransformation.c"
	} else {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = rgb_histogram_ref (value->data[0].v_pointer);
#line 10955 "ColorTransformation.c"
	}
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 10959 "ColorTransformation.c"
}


GParamSpec* param_spec_rgb_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRGBHistogram* spec;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_RGB_HISTOGRAM), NULL);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 10973 "ColorTransformation.c"
}


gpointer value_get_rgb_histogram (const GValue* value) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM), NULL);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 10982 "ColorTransformation.c"
}


void value_set_rgb_histogram (GValue* value, gpointer v_object) {
	RGBHistogram* old;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM));
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RGB_HISTOGRAM));
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_ref (value->data[0].v_pointer);
#line 11002 "ColorTransformation.c"
	} else {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11006 "ColorTransformation.c"
	}
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_unref (old);
#line 11012 "ColorTransformation.c"
	}
}


void value_take_rgb_histogram (GValue* value, gpointer v_object) {
	RGBHistogram* old;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM));
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RGB_HISTOGRAM));
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 11031 "ColorTransformation.c"
	} else {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11035 "ColorTransformation.c"
	}
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_unref (old);
#line 11041 "ColorTransformation.c"
	}
}


static void rgb_histogram_class_init (RGBHistogramClass * klass) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_parent_class = g_type_class_peek_parent (klass);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((RGBHistogramClass *) klass)->finalize = rgb_histogram_finalize;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (RGBHistogramPrivate));
#line 11053 "ColorTransformation.c"
}


static void rgb_histogram_instance_init (RGBHistogram * self) {
	gint* _tmp0_ = NULL;
	gint* _tmp1_ = NULL;
	gint* _tmp2_ = NULL;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = RGB_HISTOGRAM_GET_PRIVATE (self);
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_new0 (gint, 256);
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->red_counts = _tmp0_;
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->red_counts_length1 = 256;
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_red_counts_size_ = self->priv->red_counts_length1;
#line 967 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = g_new0 (gint, 256);
#line 967 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->green_counts = _tmp1_;
#line 967 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->green_counts_length1 = 256;
#line 967 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_green_counts_size_ = self->priv->green_counts_length1;
#line 968 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = g_new0 (gint, 256);
#line 968 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->blue_counts = _tmp2_;
#line 968 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->blue_counts_length1 = 256;
#line 968 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_blue_counts_size_ = self->priv->blue_counts_length1;
#line 969 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = NULL;
#line 969 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts_length1 = 0;
#line 969 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
#line 970 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = NULL;
#line 970 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts_length1 = 0;
#line 970 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
#line 971 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = NULL;
#line 971 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts_length1 = 0;
#line 971 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->graphic = NULL;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 11109 "ColorTransformation.c"
}


static void rgb_histogram_finalize (RGBHistogram* obj) {
	RGBHistogram * self;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM, RGBHistogram);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->red_counts = (g_free (self->priv->red_counts), NULL);
#line 967 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->green_counts = (g_free (self->priv->green_counts), NULL);
#line 968 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->blue_counts = (g_free (self->priv->blue_counts), NULL);
#line 969 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = (g_free (self->priv->qualitative_red_counts), NULL);
#line 970 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = (g_free (self->priv->qualitative_green_counts), NULL);
#line 971 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = (g_free (self->priv->qualitative_blue_counts), NULL);
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (self->priv->graphic);
#line 11133 "ColorTransformation.c"
}


GType rgb_histogram_get_type (void) {
	static volatile gsize rgb_histogram_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_rgb_histogram_init, value_rgb_histogram_free_value, value_rgb_histogram_copy_value, value_rgb_histogram_peek_pointer, "p", value_rgb_histogram_collect_value, "p", value_rgb_histogram_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogram), 0, (GInstanceInitFunc) rgb_histogram_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rgb_histogram_type_id;
		rgb_histogram_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RGBHistogram", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rgb_histogram_type_id__volatile, rgb_histogram_type_id);
	}
	return rgb_histogram_type_id__volatile;
}


gpointer rgb_histogram_ref (gpointer instance) {
	RGBHistogram* self;
	self = instance;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 11158 "ColorTransformation.c"
}


void rgb_histogram_unref (gpointer instance) {
	RGBHistogram* self;
	self = instance;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		RGB_HISTOGRAM_GET_CLASS (self)->finalize (self);
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 11171 "ColorTransformation.c"
	}
}


IntensityHistogram* intensity_histogram_construct (GType object_type, GdkPixbuf* pixbuf) {
	IntensityHistogram* self = NULL;
	gint n_channels = 0;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint rowstride = 0;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint width = 0;
	GdkPixbuf* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint height = 0;
	GdkPixbuf* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint rowbytes = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	guchar* pixels = NULL;
	GdkPixbuf* _tmp10_ = NULL;
	guint8* _tmp11_ = NULL;
	gint pixels_length1 = 0;
	gint _pixels_size_ = 0;
	gfloat pixel_count = 0.0F;
	GdkPixbuf* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	GdkPixbuf* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gfloat accumulator = 0.0F;
#line 1220 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 1220 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (IntensityHistogram*) g_type_create_instance (object_type);
#line 1221 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixbuf;
#line 1221 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gdk_pixbuf_get_n_channels (_tmp0_);
#line 1221 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	n_channels = _tmp1_;
#line 1222 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = pixbuf;
#line 1222 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = gdk_pixbuf_get_rowstride (_tmp2_);
#line 1222 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rowstride = _tmp3_;
#line 1223 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = pixbuf;
#line 1223 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
#line 1223 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	width = _tmp5_;
#line 1224 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = pixbuf;
#line 1224 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 1224 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	height = _tmp7_;
#line 1225 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = n_channels;
#line 1225 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = width;
#line 1225 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rowbytes = _tmp8_ * _tmp9_;
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = pixbuf;
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = gdk_pixbuf_get_pixels (_tmp10_);
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixels = _tmp11_;
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixels_length1 = -1;
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixels_size_ = pixels_length1;
#line 11250 "ColorTransformation.c"
	{
		gint j = 0;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		j = 0;
#line 11255 "ColorTransformation.c"
		{
			gboolean _tmp12_ = FALSE;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = TRUE;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 11262 "ColorTransformation.c"
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint row_start_index = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint row_end_index = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp12_) {
#line 11273 "ColorTransformation.c"
					gint _tmp13_ = 0;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = j;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					j = _tmp13_ + 1;
#line 11279 "ColorTransformation.c"
				}
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = FALSE;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = j;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = height;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp14_ < _tmp15_)) {
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 11291 "ColorTransformation.c"
				}
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = j;
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = rowstride;
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_index = _tmp16_ * _tmp17_;
#line 1229 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = row_start_index;
#line 1229 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = rowbytes;
#line 1229 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_end_index = _tmp18_ + _tmp19_;
#line 11305 "ColorTransformation.c"
				{
					gint i = 0;
					gint _tmp20_ = 0;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = row_start_index;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp20_;
#line 11313 "ColorTransformation.c"
					{
						gboolean _tmp21_ = FALSE;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21_ = TRUE;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 11320 "ColorTransformation.c"
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							RGBAnalyticPixel pix_rgb = {0};
							guchar* _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							gint _tmp27_ = 0;
							guchar _tmp28_ = '\0';
							guchar* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp30_ = 0;
							guchar _tmp31_ = '\0';
							guchar* _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp33_ = 0;
							guchar _tmp34_ = '\0';
							HSVAnalyticPixel pix_hsi = {0};
							RGBAnalyticPixel _tmp35_ = {0};
							gint quantized_light_value = 0;
							HSVAnalyticPixel _tmp36_ = {0};
							gfloat _tmp37_ = 0.0F;
							gint* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp21_) {
#line 11347 "ColorTransformation.c"
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp22_ = i;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp23_ = n_channels;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								i = _tmp22_ + _tmp23_;
#line 11356 "ColorTransformation.c"
							}
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp21_ = FALSE;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp24_ = i;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp25_ = row_end_index;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp24_ < _tmp25_)) {
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 11368 "ColorTransformation.c"
							}
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26_ = pixels;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26__length1 = pixels_length1;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp27_ = i;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp28_ = _tmp26_[_tmp27_];
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29_ = pixels;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29__length1 = pixels_length1;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp30_ = i;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32_ = pixels;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32__length1 = pixels_length1;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp33_ = i;
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp34_ = _tmp32_[_tmp33_ + 2];
#line 1231 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							rgb_analytic_pixel_init_from_quantized_components (&pix_rgb, _tmp28_, _tmp31_, _tmp34_);
#line 1233 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp35_ = pix_rgb;
#line 1233 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							hsv_analytic_pixel_init_from_rgb (&pix_hsi, &_tmp35_);
#line 1234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp36_ = pix_hsi;
#line 1234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp37_ = _tmp36_.light_value;
#line 1234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							quantized_light_value = (gint) (_tmp37_ * 255.0f);
#line 1235 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_ = self->priv->counts;
#line 1235 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38__length1 = self->priv->counts_length1;
#line 1235 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp39_ = quantized_light_value;
#line 1235 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_[_tmp39_] += 1;
#line 1235 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp40_ = _tmp38_[_tmp39_];
#line 11416 "ColorTransformation.c"
						}
					}
				}
			}
		}
	}
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = pixbuf;
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = gdk_pixbuf_get_width (_tmp41_);
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = _tmp42_;
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = pixbuf;
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = gdk_pixbuf_get_height (_tmp44_);
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = _tmp45_;
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_count = (gfloat) (_tmp43_ * _tmp46_);
#line 1240 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	accumulator = 0.0f;
#line 11439 "ColorTransformation.c"
	{
		gint i = 0;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 11444 "ColorTransformation.c"
		{
			gboolean _tmp47_ = FALSE;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp47_ = TRUE;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 11451 "ColorTransformation.c"
				gint _tmp49_ = 0;
				gfloat* _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				gint _tmp51_ = 0;
				gint* _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gfloat _tmp55_ = 0.0F;
				gfloat _tmp56_ = 0.0F;
				gfloat _tmp57_ = 0.0F;
				gfloat* _tmp58_ = NULL;
				gint _tmp58__length1 = 0;
				gint _tmp59_ = 0;
				gfloat _tmp60_ = 0.0F;
				gfloat* _tmp61_ = NULL;
				gint _tmp61__length1 = 0;
				gint _tmp62_ = 0;
				gfloat _tmp63_ = 0.0F;
				gfloat _tmp64_ = 0.0F;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp47_) {
#line 11474 "ColorTransformation.c"
					gint _tmp48_ = 0;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = i;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp48_ + 1;
#line 11480 "ColorTransformation.c"
				}
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = FALSE;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49_ = i;
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp49_ < 256)) {
#line 1241 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 11490 "ColorTransformation.c"
				}
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_ = self->priv->probabilities;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50__length1 = self->priv->probabilities_length1;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp51_ = i;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52_ = self->priv->counts;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52__length1 = self->priv->counts_length1;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = i;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp54_ = _tmp52_[_tmp53_];
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp55_ = pixel_count;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_[_tmp51_] = ((gfloat) _tmp54_) / _tmp55_;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_ = _tmp50_[_tmp51_];
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp57_ = accumulator;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58_ = self->priv->probabilities;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58__length1 = self->priv->probabilities_length1;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp59_ = i;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp60_ = _tmp58_[_tmp59_];
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				accumulator = _tmp57_ + _tmp60_;
#line 1244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_ = self->priv->cumulative_probabilities;
#line 1244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61__length1 = self->priv->cumulative_probabilities_length1;
#line 1244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62_ = i;
#line 1244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp63_ = accumulator;
#line 1244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_[_tmp62_] = _tmp63_;
#line 1244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp64_ = _tmp61_[_tmp62_];
#line 11536 "ColorTransformation.c"
			}
		}
	}
#line 1220 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 11542 "ColorTransformation.c"
}


IntensityHistogram* intensity_histogram_new (GdkPixbuf* pixbuf) {
#line 1220 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return intensity_histogram_construct (TYPE_INTENSITY_HISTOGRAM, pixbuf);
#line 11549 "ColorTransformation.c"
}


gfloat intensity_histogram_get_cumulative_probability (IntensityHistogram* self, gint level) {
	gfloat result = 0.0F;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gfloat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
#line 1248 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_INTENSITY_HISTOGRAM (self), 0.0F);
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = level;
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0, 255);
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	level = _tmp1_;
#line 1251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->cumulative_probabilities;
#line 1251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = self->priv->cumulative_probabilities_length1;
#line 1251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = level;
#line 1251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp2_[_tmp3_];
#line 1251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp4_;
#line 1251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 11581 "ColorTransformation.c"
}


static void value_intensity_histogram_init (GValue* value) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 11588 "ColorTransformation.c"
}


static void value_intensity_histogram_free_value (GValue* value) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_unref (value->data[0].v_pointer);
#line 11597 "ColorTransformation.c"
	}
}


static void value_intensity_histogram_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = intensity_histogram_ref (src_value->data[0].v_pointer);
#line 11607 "ColorTransformation.c"
	} else {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 11611 "ColorTransformation.c"
	}
}


static gpointer value_intensity_histogram_peek_pointer (const GValue* value) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 11619 "ColorTransformation.c"
}


static gchar* value_intensity_histogram_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 11626 "ColorTransformation.c"
		IntensityHistogram* object;
		object = collect_values[0].v_pointer;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 11633 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 11637 "ColorTransformation.c"
		}
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = intensity_histogram_ref (object);
#line 11641 "ColorTransformation.c"
	} else {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11645 "ColorTransformation.c"
	}
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 11649 "ColorTransformation.c"
}


static gchar* value_intensity_histogram_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IntensityHistogram** object_p;
	object_p = collect_values[0].v_pointer;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 11660 "ColorTransformation.c"
	}
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 11666 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 11670 "ColorTransformation.c"
	} else {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = intensity_histogram_ref (value->data[0].v_pointer);
#line 11674 "ColorTransformation.c"
	}
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 11678 "ColorTransformation.c"
}


GParamSpec* param_spec_intensity_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecIntensityHistogram* spec;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_INTENSITY_HISTOGRAM), NULL);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 11692 "ColorTransformation.c"
}


gpointer value_get_intensity_histogram (const GValue* value) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM), NULL);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 11701 "ColorTransformation.c"
}


void value_set_intensity_histogram (GValue* value, gpointer v_object) {
	IntensityHistogram* old;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM));
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INTENSITY_HISTOGRAM));
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_ref (value->data[0].v_pointer);
#line 11721 "ColorTransformation.c"
	} else {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11725 "ColorTransformation.c"
	}
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_unref (old);
#line 11731 "ColorTransformation.c"
	}
}


void value_take_intensity_histogram (GValue* value, gpointer v_object) {
	IntensityHistogram* old;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM));
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INTENSITY_HISTOGRAM));
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 11750 "ColorTransformation.c"
	} else {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11754 "ColorTransformation.c"
	}
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_unref (old);
#line 11760 "ColorTransformation.c"
	}
}


static void intensity_histogram_class_init (IntensityHistogramClass * klass) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intensity_histogram_parent_class = g_type_class_peek_parent (klass);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((IntensityHistogramClass *) klass)->finalize = intensity_histogram_finalize;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (IntensityHistogramPrivate));
#line 11772 "ColorTransformation.c"
}


static void intensity_histogram_instance_init (IntensityHistogram * self) {
	gint* _tmp0_ = NULL;
	gfloat* _tmp1_ = NULL;
	gfloat* _tmp2_ = NULL;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = INTENSITY_HISTOGRAM_GET_PRIVATE (self);
#line 1216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_new0 (gint, 256);
#line 1216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->counts = _tmp0_;
#line 1216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->counts_length1 = 256;
#line 1216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_counts_size_ = self->priv->counts_length1;
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = g_new0 (gfloat, 256);
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->probabilities = _tmp1_;
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->probabilities_length1 = 256;
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_probabilities_size_ = self->priv->probabilities_length1;
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = g_new0 (gfloat, 256);
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->cumulative_probabilities = _tmp2_;
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->cumulative_probabilities_length1 = 256;
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_cumulative_probabilities_size_ = self->priv->cumulative_probabilities_length1;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 11808 "ColorTransformation.c"
}


static void intensity_histogram_finalize (IntensityHistogram* obj) {
	IntensityHistogram * self;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INTENSITY_HISTOGRAM, IntensityHistogram);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 1216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->counts = (g_free (self->priv->counts), NULL);
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->probabilities = (g_free (self->priv->probabilities), NULL);
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->cumulative_probabilities = (g_free (self->priv->cumulative_probabilities), NULL);
#line 11824 "ColorTransformation.c"
}


GType intensity_histogram_get_type (void) {
	static volatile gsize intensity_histogram_type_id__volatile = 0;
	if (g_once_init_enter (&intensity_histogram_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_intensity_histogram_init, value_intensity_histogram_free_value, value_intensity_histogram_copy_value, value_intensity_histogram_peek_pointer, "p", value_intensity_histogram_collect_value, "p", value_intensity_histogram_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IntensityHistogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) intensity_histogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IntensityHistogram), 0, (GInstanceInitFunc) intensity_histogram_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType intensity_histogram_type_id;
		intensity_histogram_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IntensityHistogram", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&intensity_histogram_type_id__volatile, intensity_histogram_type_id);
	}
	return intensity_histogram_type_id__volatile;
}


gpointer intensity_histogram_ref (gpointer instance) {
	IntensityHistogram* self;
	self = instance;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 11849 "ColorTransformation.c"
}


void intensity_histogram_unref (gpointer instance) {
	IntensityHistogram* self;
	self = instance;
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		INTENSITY_HISTOGRAM_GET_CLASS (self)->finalize (self);
#line 1215 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 11862 "ColorTransformation.c"
	}
}


ExpansionTransformation* expansion_transformation_construct (GType object_type, IntensityHistogram* histogram) {
	ExpansionTransformation* self = NULL;
	gfloat* _tmp0_ = NULL;
	gfloat LOW_KINK_MASS = 0.0F;
	gfloat HIGH_KINK_MASS = 0.0F;
#line 1263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_INTENSITY_HISTOGRAM (histogram), NULL);
#line 1264 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 1266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_new0 (gfloat, 256);
#line 1266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = _tmp0_;
#line 1266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table_length1 = 256;
#line 1266 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 1268 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	LOW_KINK_MASS = EXPANSION_TRANSFORMATION_LOW_DISCARD_MASS;
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->low_kink = 0;
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	while (TRUE) {
#line 11892 "ColorTransformation.c"
		IntensityHistogram* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gfloat _tmp3_ = 0.0F;
		gfloat _tmp4_ = 0.0F;
		gint _tmp5_ = 0;
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = histogram;
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = self->priv->low_kink;
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = intensity_histogram_get_cumulative_probability (_tmp1_, _tmp2_);
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = LOW_KINK_MASS;
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (!(_tmp3_ < _tmp4_)) {
#line 1270 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			break;
#line 11910 "ColorTransformation.c"
		}
#line 1271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = self->priv->low_kink;
#line 1271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->low_kink = _tmp5_ + 1;
#line 11916 "ColorTransformation.c"
	}
#line 1273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	HIGH_KINK_MASS = 1.0f - EXPANSION_TRANSFORMATION_HIGH_DISCARD_MASS;
#line 1274 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->high_kink = 255;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	while (TRUE) {
#line 11924 "ColorTransformation.c"
		gboolean _tmp6_ = FALSE;
		IntensityHistogram* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gfloat _tmp9_ = 0.0F;
		gfloat _tmp10_ = 0.0F;
		gint _tmp12_ = 0;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = histogram;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = self->priv->high_kink;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = intensity_histogram_get_cumulative_probability (_tmp7_, _tmp8_);
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = HIGH_KINK_MASS;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp9_ > _tmp10_) {
#line 11941 "ColorTransformation.c"
			gint _tmp11_ = 0;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = self->priv->high_kink;
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = _tmp11_ > 0;
#line 11947 "ColorTransformation.c"
		} else {
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = FALSE;
#line 11951 "ColorTransformation.c"
		}
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (!_tmp6_) {
#line 1275 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			break;
#line 11957 "ColorTransformation.c"
		}
#line 1276 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = self->priv->high_kink;
#line 1276 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->high_kink = _tmp12_ - 1;
#line 11963 "ColorTransformation.c"
	}
#line 1278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_build_remap_table (self);
#line 1263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 11969 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_new (IntensityHistogram* histogram) {
#line 1263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return expansion_transformation_construct (TYPE_EXPANSION_TRANSFORMATION, histogram);
#line 11976 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_construct_from_extrema (GType object_type, gint black_point, gint white_point) {
	ExpansionTransformation* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 1282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 1284 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = white_point;
#line 1284 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0, 255);
#line 1284 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	white_point = _tmp1_;
#line 1285 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = black_point;
#line 1285 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = CLAMP (_tmp2_, 0, 255);
#line 1285 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	black_point = _tmp3_;
#line 1287 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = black_point;
#line 1287 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = white_point;
#line 1287 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ == _tmp5_) {
#line 12010 "ColorTransformation.c"
		gint _tmp6_ = 0;
#line 1288 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = black_point;
#line 1288 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp6_ == 0) {
#line 1289 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			white_point = 1;
#line 12018 "ColorTransformation.c"
		} else {
			gint _tmp7_ = 0;
#line 1290 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = white_point;
#line 1290 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp7_ == 255) {
#line 1291 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				black_point = 254;
#line 12027 "ColorTransformation.c"
			} else {
				gint _tmp8_ = 0;
#line 1293 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = white_point;
#line 1293 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				black_point = _tmp8_ - 1;
#line 12034 "ColorTransformation.c"
			}
		}
	}
#line 1296 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = black_point;
#line 1296 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->low_kink = _tmp9_;
#line 1297 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = white_point;
#line 1297 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->high_kink = _tmp10_;
#line 1299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_build_remap_table (self);
#line 1281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12050 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_new_from_extrema (gint black_point, gint white_point) {
#line 1281 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return expansion_transformation_construct_from_extrema (TYPE_EXPANSION_TRANSFORMATION, black_point, white_point);
#line 12057 "ColorTransformation.c"
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1199 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1200 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1200 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1201 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1201 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strchug (_tmp1_);
#line 1202 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1202 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 12080 "ColorTransformation.c"
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1191 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1192 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1192 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1193 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1193 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strchomp (_tmp1_);
#line 1194 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1194 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 12103 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_construct_from_string (GType object_type, const gchar* encoded_transformation) {
	ExpansionTransformation* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint num_captured = 0;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 1302 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (encoded_transformation != NULL, NULL);
#line 1303 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 1305 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = encoded_transformation;
#line 1305 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_strcanon (_tmp0_, "0123456789. ", ' ');
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = encoded_transformation;
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = string_chug (_tmp1_);
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_;
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (_tmp3_);
#line 1307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = encoded_transformation;
#line 1307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = string_chomp (_tmp4_);
#line 1307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = _tmp5_;
#line 1307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (_tmp6_);
#line 1309 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = encoded_transformation;
#line 1309 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = sscanf (_tmp7_, "%d %d", &self->priv->low_kink, &self->priv->high_kink);
#line 1309 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	num_captured = _tmp8_;
#line 1312 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (num_captured == 2, "num_captured == 2");
#line 1314 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_build_remap_table (self);
#line 1302 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12155 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_new_from_string (const gchar* encoded_transformation) {
#line 1302 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return expansion_transformation_construct_from_string (TYPE_EXPANSION_TRANSFORMATION, encoded_transformation);
#line 12162 "ColorTransformation.c"
}


static void expansion_transformation_build_remap_table (ExpansionTransformation* self) {
	gfloat* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gfloat low_kink_f = 0.0F;
	gint _tmp2_ = 0;
	gfloat high_kink_f = 0.0F;
	gint _tmp3_ = 0;
	gfloat slope = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gfloat intercept = 0.0F;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	gint i = 0;
#line 1317 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (IS_EXPANSION_TRANSFORMATION (self));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->remap_table;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = self->priv->remap_table_length1;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ == NULL) {
#line 12189 "ColorTransformation.c"
		gfloat* _tmp1_ = NULL;
#line 1319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = g_new0 (gfloat, 256);
#line 1319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->remap_table = _tmp1_;
#line 1319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->remap_table_length1 = 256;
#line 1319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 12201 "ColorTransformation.c"
	}
#line 1321 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->low_kink;
#line 1321 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	low_kink_f = ((gfloat) _tmp2_) / 255.0f;
#line 1322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = self->priv->high_kink;
#line 1322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	high_kink_f = ((gfloat) _tmp3_) / 255.0f;
#line 1324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = high_kink_f;
#line 1324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = low_kink_f;
#line 1324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	slope = 1.0f / (_tmp4_ - _tmp5_);
#line 1325 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = low_kink_f;
#line 1325 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = high_kink_f;
#line 1325 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = low_kink_f;
#line 1325 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intercept = -(_tmp6_ / (_tmp7_ - _tmp8_));
#line 1327 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	i = 0;
#line 12227 "ColorTransformation.c"
	{
		gboolean _tmp9_ = FALSE;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = TRUE;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 12234 "ColorTransformation.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gfloat* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gint _tmp14_ = 0;
			gfloat _tmp15_ = 0.0F;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp9_) {
#line 12243 "ColorTransformation.c"
				gint _tmp10_ = 0;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = i;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = _tmp10_ + 1;
#line 12249 "ColorTransformation.c"
			}
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = FALSE;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = i;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = self->priv->low_kink;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp11_ <= _tmp12_)) {
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 12261 "ColorTransformation.c"
			}
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = self->priv->remap_table;
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13__length1 = self->priv->remap_table_length1;
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = i;
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_[_tmp14_] = 0.0f;
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp15_ = _tmp13_[_tmp14_];
#line 12273 "ColorTransformation.c"
		}
	}
	{
		gboolean _tmp16_ = FALSE;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = TRUE;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 12282 "ColorTransformation.c"
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gfloat* _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gint _tmp21_ = 0;
			gfloat _tmp22_ = 0.0F;
			gint _tmp23_ = 0;
			gfloat _tmp24_ = 0.0F;
			gfloat _tmp25_ = 0.0F;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp16_) {
#line 12294 "ColorTransformation.c"
				gint _tmp17_ = 0;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = i;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = _tmp17_ + 1;
#line 12300 "ColorTransformation.c"
			}
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp16_ = FALSE;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp18_ = i;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp19_ = self->priv->high_kink;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp18_ < _tmp19_)) {
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 12312 "ColorTransformation.c"
			}
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = self->priv->remap_table;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20__length1 = self->priv->remap_table_length1;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp21_ = i;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp22_ = slope;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp23_ = i;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp24_ = intercept;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_[_tmp21_] = (_tmp22_ * (((gfloat) _tmp23_) / 255.0f)) + _tmp24_;
#line 1332 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp25_ = _tmp20_[_tmp21_];
#line 12330 "ColorTransformation.c"
		}
	}
	{
		gboolean _tmp26_ = FALSE;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = TRUE;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 12339 "ColorTransformation.c"
			gint _tmp28_ = 0;
			gfloat* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			gint _tmp30_ = 0;
			gfloat _tmp31_ = 0.0F;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp26_) {
#line 12347 "ColorTransformation.c"
				gint _tmp27_ = 0;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp27_ = i;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = _tmp27_ + 1;
#line 12353 "ColorTransformation.c"
			}
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp26_ = FALSE;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp28_ = i;
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp28_ < 256)) {
#line 1334 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 12363 "ColorTransformation.c"
			}
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp29_ = self->priv->remap_table;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp29__length1 = self->priv->remap_table_length1;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp30_ = i;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp29_[_tmp30_] = 1.0f;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp31_ = _tmp29_[_tmp30_];
#line 12375 "ColorTransformation.c"
		}
	}
}


static void expansion_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result) {
	ExpansionTransformation * self;
	gint remap_index = 0;
	HSVAnalyticPixel _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
	HSVAnalyticPixel _result_ = {0};
	HSVAnalyticPixel _tmp2_ = {0};
	gfloat* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gfloat _tmp4_ = 0.0F;
	HSVAnalyticPixel _tmp5_ = {0};
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
#line 1338 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1338 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (pixel != NULL);
#line 1339 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *pixel;
#line 1339 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _tmp0_.light_value;
#line 1339 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	remap_index = (gint) (_tmp1_ * 255.0f);
#line 1341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *pixel;
#line 1341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_ = _tmp2_;
#line 1342 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = self->priv->remap_table;
#line 1342 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3__length1 = self->priv->remap_table_length1;
#line 1342 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_[remap_index];
#line 1342 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_.light_value = _tmp4_;
#line 1344 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _result_;
#line 1344 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = _tmp5_.light_value;
#line 1344 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = CLAMP (_tmp6_, 0.0f, 1.0f);
#line 1344 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_.light_value = _tmp7_;
#line 1346 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _result_;
#line 1346 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 12428 "ColorTransformation.c"
}


static gchar* expansion_transformation_real_to_string (PixelTransformation* base) {
	ExpansionTransformation * self;
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
#line 1349 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->high_kink;
#line 1350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = g_strdup_printf ("{ %d, %d }", _tmp0_, _tmp1_);
#line 1350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp2_;
#line 1350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12450 "ColorTransformation.c"
}


gint expansion_transformation_get_white_point (ExpansionTransformation* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 1353 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_EXPANSION_TRANSFORMATION (self), 0);
#line 1354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->high_kink;
#line 1354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12465 "ColorTransformation.c"
}


gint expansion_transformation_get_black_point (ExpansionTransformation* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 1357 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_EXPANSION_TRANSFORMATION (self), 0);
#line 1358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12480 "ColorTransformation.c"
}


static gboolean expansion_transformation_real_is_identity (PixelTransformation* base) {
	ExpansionTransformation * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 1361 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->low_kink;
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_ == 0) {
#line 12495 "ColorTransformation.c"
		gint _tmp2_ = 0;
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = self->priv->high_kink;
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp2_ == 255;
#line 12501 "ColorTransformation.c"
	} else {
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 12505 "ColorTransformation.c"
	}
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12511 "ColorTransformation.c"
}


static PixelTransformation* expansion_transformation_real_copy (PixelTransformation* base) {
	ExpansionTransformation * self;
	PixelTransformation* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	ExpansionTransformation* _tmp2_ = NULL;
#line 1365 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->high_kink;
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = expansion_transformation_new_from_extrema (_tmp0_, _tmp1_);
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12533 "ColorTransformation.c"
}


static void expansion_transformation_class_init (ExpansionTransformationClass * klass) {
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_parent_class = g_type_class_peek_parent (klass);
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = expansion_transformation_finalize;
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ExpansionTransformationPrivate));
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*)(PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) expansion_transformation_real_transform_pixel_hsv;
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->to_string = (gchar* (*)(PixelTransformation*)) expansion_transformation_real_to_string;
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*)(PixelTransformation*)) expansion_transformation_real_is_identity;
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*)(PixelTransformation*)) expansion_transformation_real_copy;
#line 12552 "ColorTransformation.c"
}


static void expansion_transformation_instance_init (ExpansionTransformation * self) {
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = EXPANSION_TRANSFORMATION_GET_PRIVATE (self);
#line 1256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = NULL;
#line 1256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table_length1 = 0;
#line 1256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 12565 "ColorTransformation.c"
}


static void expansion_transformation_finalize (PixelTransformation* obj) {
	ExpansionTransformation * self;
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (expansion_transformation_parent_class)->finalize (obj);
#line 12577 "ColorTransformation.c"
}


GType expansion_transformation_get_type (void) {
	static volatile gsize expansion_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&expansion_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExpansionTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expansion_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpansionTransformation), 0, (GInstanceInitFunc) expansion_transformation_instance_init, NULL };
		GType expansion_transformation_type_id;
		expansion_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "ExpansionTransformation", &g_define_type_info, 0);
		g_once_init_leave (&expansion_transformation_type_id__volatile, expansion_transformation_type_id);
	}
	return expansion_transformation_type_id__volatile;
}


ShadowDetailTransformation* shadow_detail_transformation_construct (GType object_type, gfloat user_intensity) {
	ShadowDetailTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat intensity_adj = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat effect_shift = 0.0F;
	gfloat _tmp3_ = 0.0F;
	HermiteGammaApproximationFunction* func = NULL;
	HermiteGammaApproximationFunction* _tmp4_ = NULL;
	gfloat* _tmp5_ = NULL;
#line 1383 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ShadowDetailTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_SHADOWS);
#line 1385 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = user_intensity;
#line 1385 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = _tmp0_;
#line 1386 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->intensity;
#line 1386 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = CLAMP (_tmp1_ / SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER, 0.0f, 1.0f);
#line 1386 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intensity_adj = _tmp2_;
#line 1388 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = intensity_adj;
#line 1388 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	effect_shift = SHADOW_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT * _tmp3_;
#line 1389 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = hermite_gamma_approximation_function_new (SHADOW_DETAIL_TRANSFORMATION_TONAL_WIDTH);
#line 1389 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	func = _tmp4_;
#line 1392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = g_new0 (gfloat, 256);
#line 1392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = _tmp5_;
#line 1392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table_length1 = 256;
#line 1392 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 12634 "ColorTransformation.c"
	{
		gint i = 0;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 12639 "ColorTransformation.c"
		{
			gboolean _tmp6_ = FALSE;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = TRUE;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 12646 "ColorTransformation.c"
				gint _tmp8_ = 0;
				gfloat x = 0.0F;
				gint _tmp9_ = 0;
				gfloat weight = 0.0F;
				HermiteGammaApproximationFunction* _tmp10_ = NULL;
				gfloat _tmp11_ = 0.0F;
				gfloat _tmp12_ = 0.0F;
				gfloat* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gfloat _tmp15_ = 0.0F;
				gfloat _tmp16_ = 0.0F;
				gfloat _tmp17_ = 0.0F;
				gfloat _tmp18_ = 0.0F;
				gfloat _tmp19_ = 0.0F;
				gfloat _tmp20_ = 0.0F;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp6_) {
#line 12665 "ColorTransformation.c"
					gint _tmp7_ = 0;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp7_ = i;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp7_ + 1;
#line 12671 "ColorTransformation.c"
				}
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = FALSE;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = i;
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp8_ < 256)) {
#line 1393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 12681 "ColorTransformation.c"
				}
#line 1394 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = i;
#line 1394 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				x = ((gfloat) _tmp9_) / 255.0f;
#line 1395 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = func;
#line 1395 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = x;
#line 1395 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = hermite_gamma_approximation_function_evaluate (_tmp10_, _tmp11_);
#line 1395 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				weight = _tmp12_;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = self->priv->remap_table;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13__length1 = self->priv->remap_table_length1;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = i;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = weight;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = x;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = effect_shift;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = weight;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = x;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_[_tmp14_] = (_tmp15_ * (_tmp16_ + _tmp17_)) + ((1.0f - _tmp18_) * _tmp19_);
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = _tmp13_[_tmp14_];
#line 12715 "ColorTransformation.c"
			}
		}
	}
#line 1382 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_hermite_gamma_approximation_function_unref0 (func);
#line 1382 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12723 "ColorTransformation.c"
}


ShadowDetailTransformation* shadow_detail_transformation_new (gfloat user_intensity) {
#line 1382 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return shadow_detail_transformation_construct (TYPE_SHADOW_DETAIL_TRANSFORMATION, user_intensity);
#line 12730 "ColorTransformation.c"
}


static void shadow_detail_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result) {
	ShadowDetailTransformation * self;
	HSVAnalyticPixel _result_ = {0};
	HSVAnalyticPixel _tmp0_ = {0};
	gfloat* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	HSVAnalyticPixel _tmp2_ = {0};
	gfloat _tmp3_ = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
#line 1400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (pixel != NULL);
#line 1401 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *pixel;
#line 1401 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_ = _tmp0_;
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->remap_table;
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1__length1 = self->priv->remap_table_length1;
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *pixel;
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_.light_value;
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp1_[(gint) (_tmp3_ * 255.0f)];
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = CLAMP (_tmp4_, 0.0f, 1.0f);
#line 1402 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_.light_value = _tmp5_;
#line 1403 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _result_;
#line 1403 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 12770 "ColorTransformation.c"
}


static PixelTransformation* shadow_detail_transformation_real_copy (PixelTransformation* base) {
	ShadowDetailTransformation * self;
	PixelTransformation* result = NULL;
	gfloat _tmp0_ = 0.0F;
	ShadowDetailTransformation* _tmp1_ = NULL;
#line 1406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1407 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1407 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = shadow_detail_transformation_new (_tmp0_);
#line 1407 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 1407 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12789 "ColorTransformation.c"
}


static gboolean shadow_detail_transformation_real_is_identity (PixelTransformation* base) {
	ShadowDetailTransformation * self;
	gboolean result = FALSE;
	gfloat _tmp0_ = 0.0F;
#line 1410 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_ == 0.0f;
#line 1411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12805 "ColorTransformation.c"
}


gfloat shadow_detail_transformation_get_parameter (ShadowDetailTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 1414 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_SHADOW_DETAIL_TRANSFORMATION (self), 0.0F);
#line 1415 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1415 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1415 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12820 "ColorTransformation.c"
}


static void shadow_detail_transformation_class_init (ShadowDetailTransformationClass * klass) {
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	shadow_detail_transformation_parent_class = g_type_class_peek_parent (klass);
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = shadow_detail_transformation_finalize;
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ShadowDetailTransformationPrivate));
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*)(PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) shadow_detail_transformation_real_transform_pixel_hsv;
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*)(PixelTransformation*)) shadow_detail_transformation_real_copy;
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*)(PixelTransformation*)) shadow_detail_transformation_real_is_identity;
#line 12837 "ColorTransformation.c"
}


static void shadow_detail_transformation_instance_init (ShadowDetailTransformation * self) {
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = SHADOW_DETAIL_TRANSFORMATION_GET_PRIVATE (self);
#line 1376 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = 0.0f;
#line 1377 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = NULL;
#line 1377 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table_length1 = 0;
#line 1377 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 12852 "ColorTransformation.c"
}


static void shadow_detail_transformation_finalize (PixelTransformation* obj) {
	ShadowDetailTransformation * self;
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1377 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1370 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (shadow_detail_transformation_parent_class)->finalize (obj);
#line 12864 "ColorTransformation.c"
}


GType shadow_detail_transformation_get_type (void) {
	static volatile gsize shadow_detail_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&shadow_detail_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShadowDetailTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shadow_detail_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShadowDetailTransformation), 0, (GInstanceInitFunc) shadow_detail_transformation_instance_init, NULL };
		GType shadow_detail_transformation_type_id;
		shadow_detail_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "ShadowDetailTransformation", &g_define_type_info, 0);
		g_once_init_leave (&shadow_detail_transformation_type_id__volatile, shadow_detail_transformation_type_id);
	}
	return shadow_detail_transformation_type_id__volatile;
}


HermiteGammaApproximationFunction* hermite_gamma_approximation_function_construct (GType object_type, gfloat user_interval_upper) {
	HermiteGammaApproximationFunction* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 1423 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (HermiteGammaApproximationFunction*) g_type_create_instance (object_type);
#line 1424 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = user_interval_upper;
#line 1424 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.1f, 1.0f);
#line 1424 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->nonzero_interval_upper = _tmp1_;
#line 1425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->nonzero_interval_upper;
#line 1425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->x_scale = 1.0f / _tmp2_;
#line 1423 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12899 "ColorTransformation.c"
}


HermiteGammaApproximationFunction* hermite_gamma_approximation_function_new (gfloat user_interval_upper) {
#line 1423 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return hermite_gamma_approximation_function_construct (TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, user_interval_upper);
#line 12906 "ColorTransformation.c"
}


gfloat hermite_gamma_approximation_function_evaluate (HermiteGammaApproximationFunction* self, gfloat x) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 1428 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION (self), 0.0F);
#line 1429 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = x;
#line 1429 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ < 0.0f) {
#line 1430 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		result = 0.0f;
#line 1430 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return result;
#line 12923 "ColorTransformation.c"
	} else {
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = x;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = self->priv->nonzero_interval_upper;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp1_ > _tmp2_) {
#line 1432 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = 0.0f;
#line 1432 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 12937 "ColorTransformation.c"
		} else {
			gfloat indep_var = 0.0F;
			gfloat _tmp3_ = 0.0F;
			gfloat _tmp4_ = 0.0F;
			gfloat dep_var = 0.0F;
			gfloat _tmp5_ = 0.0F;
			gfloat _tmp6_ = 0.0F;
			gfloat _tmp7_ = 0.0F;
			gfloat _tmp8_ = 0.0F;
			gfloat _tmp9_ = 0.0F;
			gfloat _tmp10_ = 0.0F;
			gfloat _tmp11_ = 0.0F;
			gfloat _tmp12_ = 0.0F;
#line 1434 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp3_ = self->priv->x_scale;
#line 1434 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = x;
#line 1434 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			indep_var = _tmp3_ * _tmp4_;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = indep_var;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = indep_var;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = indep_var;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = indep_var;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = indep_var;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = indep_var;
#line 1436 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			dep_var = 6.0f * ((((_tmp5_ * _tmp6_) * _tmp7_) - (2.0f * (_tmp8_ * _tmp9_))) + _tmp10_);
#line 1439 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = dep_var;
#line 1439 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = CLAMP (_tmp11_, 0.0f, 1.0f);
#line 1439 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = _tmp12_;
#line 1439 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 12979 "ColorTransformation.c"
		}
	}
}


static void value_hermite_gamma_approximation_function_init (GValue* value) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 12988 "ColorTransformation.c"
}


static void value_hermite_gamma_approximation_function_free_value (GValue* value) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_unref (value->data[0].v_pointer);
#line 12997 "ColorTransformation.c"
	}
}


static void value_hermite_gamma_approximation_function_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = hermite_gamma_approximation_function_ref (src_value->data[0].v_pointer);
#line 13007 "ColorTransformation.c"
	} else {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 13011 "ColorTransformation.c"
	}
}


static gpointer value_hermite_gamma_approximation_function_peek_pointer (const GValue* value) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 13019 "ColorTransformation.c"
}


static gchar* value_hermite_gamma_approximation_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 13026 "ColorTransformation.c"
		HermiteGammaApproximationFunction* object;
		object = collect_values[0].v_pointer;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13033 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13037 "ColorTransformation.c"
		}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = hermite_gamma_approximation_function_ref (object);
#line 13041 "ColorTransformation.c"
	} else {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 13045 "ColorTransformation.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 13049 "ColorTransformation.c"
}


static gchar* value_hermite_gamma_approximation_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HermiteGammaApproximationFunction** object_p;
	object_p = collect_values[0].v_pointer;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 13060 "ColorTransformation.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 13066 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 13070 "ColorTransformation.c"
	} else {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = hermite_gamma_approximation_function_ref (value->data[0].v_pointer);
#line 13074 "ColorTransformation.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 13078 "ColorTransformation.c"
}


GParamSpec* param_spec_hermite_gamma_approximation_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHermiteGammaApproximationFunction* spec;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION), NULL);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 13092 "ColorTransformation.c"
}


gpointer value_get_hermite_gamma_approximation_function (const GValue* value) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION), NULL);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 13101 "ColorTransformation.c"
}


void value_set_hermite_gamma_approximation_function (GValue* value, gpointer v_object) {
	HermiteGammaApproximationFunction* old;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_ref (value->data[0].v_pointer);
#line 13121 "ColorTransformation.c"
	} else {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 13125 "ColorTransformation.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_unref (old);
#line 13131 "ColorTransformation.c"
	}
}


void value_take_hermite_gamma_approximation_function (GValue* value, gpointer v_object) {
	HermiteGammaApproximationFunction* old;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 13150 "ColorTransformation.c"
	} else {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 13154 "ColorTransformation.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_unref (old);
#line 13160 "ColorTransformation.c"
	}
}


static void hermite_gamma_approximation_function_class_init (HermiteGammaApproximationFunctionClass * klass) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hermite_gamma_approximation_function_parent_class = g_type_class_peek_parent (klass);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((HermiteGammaApproximationFunctionClass *) klass)->finalize = hermite_gamma_approximation_function_finalize;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (HermiteGammaApproximationFunctionPrivate));
#line 13172 "ColorTransformation.c"
}


static void hermite_gamma_approximation_function_instance_init (HermiteGammaApproximationFunction * self) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_PRIVATE (self);
#line 1420 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->x_scale = 1.0f;
#line 1421 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->nonzero_interval_upper = 1.0f;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 13185 "ColorTransformation.c"
}


static void hermite_gamma_approximation_function_finalize (HermiteGammaApproximationFunction* obj) {
	HermiteGammaApproximationFunction * self;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunction);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 13195 "ColorTransformation.c"
}


GType hermite_gamma_approximation_function_get_type (void) {
	static volatile gsize hermite_gamma_approximation_function_type_id__volatile = 0;
	if (g_once_init_enter (&hermite_gamma_approximation_function_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hermite_gamma_approximation_function_init, value_hermite_gamma_approximation_function_free_value, value_hermite_gamma_approximation_function_copy_value, value_hermite_gamma_approximation_function_peek_pointer, "p", value_hermite_gamma_approximation_function_collect_value, "p", value_hermite_gamma_approximation_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HermiteGammaApproximationFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hermite_gamma_approximation_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HermiteGammaApproximationFunction), 0, (GInstanceInitFunc) hermite_gamma_approximation_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hermite_gamma_approximation_function_type_id;
		hermite_gamma_approximation_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HermiteGammaApproximationFunction", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hermite_gamma_approximation_function_type_id__volatile, hermite_gamma_approximation_function_type_id);
	}
	return hermite_gamma_approximation_function_type_id__volatile;
}


gpointer hermite_gamma_approximation_function_ref (gpointer instance) {
	HermiteGammaApproximationFunction* self;
	self = instance;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 13220 "ColorTransformation.c"
}


void hermite_gamma_approximation_function_unref (gpointer instance) {
	HermiteGammaApproximationFunction* self;
	self = instance;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_CLASS (self)->finalize (self);
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 13233 "ColorTransformation.c"
	}
}


HighlightDetailTransformation* highlight_detail_transformation_construct (GType object_type, gfloat user_intensity) {
	HighlightDetailTransformation* self = NULL;
	gfloat _tmp0_ = 0.0F;
	gfloat intensity_adj = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat effect_shift = 0.0F;
	gfloat _tmp3_ = 0.0F;
	HermiteGammaApproximationFunction* func = NULL;
	HermiteGammaApproximationFunction* _tmp4_ = NULL;
	gfloat* _tmp5_ = NULL;
#line 1457 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (HighlightDetailTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS);
#line 1459 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = user_intensity;
#line 1459 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = _tmp0_;
#line 1460 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->intensity;
#line 1460 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = CLAMP (_tmp1_ / HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_PARAMETER, 0.0f, 1.0f);
#line 1460 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intensity_adj = _tmp2_;
#line 1462 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = intensity_adj;
#line 1462 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	effect_shift = HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT * _tmp3_;
#line 1463 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = hermite_gamma_approximation_function_new (HIGHLIGHT_DETAIL_TRANSFORMATION_TONAL_WIDTH);
#line 1463 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	func = _tmp4_;
#line 1466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = g_new0 (gfloat, 256);
#line 1466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = _tmp5_;
#line 1466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table_length1 = 256;
#line 1466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 13279 "ColorTransformation.c"
	{
		gint i = 0;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 13284 "ColorTransformation.c"
		{
			gboolean _tmp6_ = FALSE;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = TRUE;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 13291 "ColorTransformation.c"
				gint _tmp8_ = 0;
				gfloat x = 0.0F;
				gint _tmp9_ = 0;
				gfloat weight = 0.0F;
				HermiteGammaApproximationFunction* _tmp10_ = NULL;
				gfloat _tmp11_ = 0.0F;
				gfloat _tmp12_ = 0.0F;
				gfloat* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gfloat _tmp15_ = 0.0F;
				gfloat _tmp16_ = 0.0F;
				gfloat _tmp17_ = 0.0F;
				gfloat _tmp18_ = 0.0F;
				gfloat _tmp19_ = 0.0F;
				gfloat _tmp20_ = 0.0F;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp6_) {
#line 13310 "ColorTransformation.c"
					gint _tmp7_ = 0;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp7_ = i;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp7_ + 1;
#line 13316 "ColorTransformation.c"
				}
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = FALSE;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = i;
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp8_ < 256)) {
#line 1467 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 13326 "ColorTransformation.c"
				}
#line 1468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = i;
#line 1468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				x = ((gfloat) _tmp9_) / 255.0f;
#line 1469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = func;
#line 1469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = x;
#line 1469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = hermite_gamma_approximation_function_evaluate (_tmp10_, 1.0f - _tmp11_);
#line 1469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				weight = _tmp12_;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = self->priv->remap_table;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13__length1 = self->priv->remap_table_length1;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = i;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = weight;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = x;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = effect_shift;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = weight;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = x;
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_[_tmp14_] = (_tmp15_ * (_tmp16_ - _tmp17_)) + ((1.0f - _tmp18_) * _tmp19_);
#line 1470 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = _tmp13_[_tmp14_];
#line 13360 "ColorTransformation.c"
			}
		}
	}
#line 1456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_hermite_gamma_approximation_function_unref0 (func);
#line 1456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 13368 "ColorTransformation.c"
}


HighlightDetailTransformation* highlight_detail_transformation_new (gfloat user_intensity) {
#line 1456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return highlight_detail_transformation_construct (TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, user_intensity);
#line 13375 "ColorTransformation.c"
}


static void highlight_detail_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result) {
	HighlightDetailTransformation * self;
	HSVAnalyticPixel _result_ = {0};
	HSVAnalyticPixel _tmp0_ = {0};
	gfloat* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	HSVAnalyticPixel _tmp2_ = {0};
	gfloat _tmp3_ = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
#line 1474 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1474 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (pixel != NULL);
#line 1475 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *pixel;
#line 1475 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_ = _tmp0_;
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->remap_table;
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1__length1 = self->priv->remap_table_length1;
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *pixel;
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_.light_value;
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp1_[(gint) (_tmp3_ * 255.0f)];
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = CLAMP (_tmp4_, 0.0f, 1.0f);
#line 1476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_.light_value = _tmp5_;
#line 1477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _result_;
#line 1477 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 13415 "ColorTransformation.c"
}


static PixelTransformation* highlight_detail_transformation_real_copy (PixelTransformation* base) {
	HighlightDetailTransformation * self;
	PixelTransformation* result = NULL;
	gfloat _tmp0_ = 0.0F;
	HighlightDetailTransformation* _tmp1_ = NULL;
#line 1480 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1481 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1481 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = highlight_detail_transformation_new (_tmp0_);
#line 1481 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 1481 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 13434 "ColorTransformation.c"
}


static gboolean highlight_detail_transformation_real_is_identity (PixelTransformation* base) {
	HighlightDetailTransformation * self;
	gboolean result = FALSE;
	gfloat _tmp0_ = 0.0F;
#line 1484 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1485 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1485 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_ == 0.0f;
#line 1485 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 13450 "ColorTransformation.c"
}


gfloat highlight_detail_transformation_get_parameter (HighlightDetailTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
#line 1488 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (IS_HIGHLIGHT_DETAIL_TRANSFORMATION (self), 0.0F);
#line 1489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1489 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 13465 "ColorTransformation.c"
}


static void highlight_detail_transformation_class_init (HighlightDetailTransformationClass * klass) {
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	highlight_detail_transformation_parent_class = g_type_class_peek_parent (klass);
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = highlight_detail_transformation_finalize;
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (HighlightDetailTransformationPrivate));
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*)(PixelTransformation*, HSVAnalyticPixel*, HSVAnalyticPixel*)) highlight_detail_transformation_real_transform_pixel_hsv;
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*)(PixelTransformation*)) highlight_detail_transformation_real_copy;
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*)(PixelTransformation*)) highlight_detail_transformation_real_is_identity;
#line 13482 "ColorTransformation.c"
}


static void highlight_detail_transformation_instance_init (HighlightDetailTransformation * self) {
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = HIGHLIGHT_DETAIL_TRANSFORMATION_GET_PRIVATE (self);
#line 1450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = 0.0f;
#line 1451 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = NULL;
#line 1451 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table_length1 = 0;
#line 1451 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_remap_table_size_ = self->priv->remap_table_length1;
#line 13497 "ColorTransformation.c"
}


static void highlight_detail_transformation_finalize (PixelTransformation* obj) {
	HighlightDetailTransformation * self;
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1451 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->remap_table = (g_free (self->priv->remap_table), NULL);
#line 1444 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (highlight_detail_transformation_parent_class)->finalize (obj);
#line 13509 "ColorTransformation.c"
}


GType highlight_detail_transformation_get_type (void) {
	static volatile gsize highlight_detail_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&highlight_detail_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HighlightDetailTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) highlight_detail_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HighlightDetailTransformation), 0, (GInstanceInitFunc) highlight_detail_transformation_instance_init, NULL };
		GType highlight_detail_transformation_type_id;
		highlight_detail_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "HighlightDetailTransformation", &g_define_type_info, 0);
		g_once_init_leave (&highlight_detail_transformation_type_id__volatile, highlight_detail_transformation_type_id);
	}
	return highlight_detail_transformation_type_id__volatile;
}


PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf) {
	PixelTransformationBundle* result = NULL;
	PixelTransformationBundle* adjustments = NULL;
	PixelTransformationBundle* _tmp0_ = NULL;
	IntensityHistogram* analysis_histogram = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	IntensityHistogram* _tmp2_ = NULL;
	gfloat pct_in_range = 0.0F;
	IntensityHistogram* _tmp3_ = NULL;
	gfloat _tmp4_ = 0.0F;
	IntensityHistogram* _tmp5_ = NULL;
	gfloat _tmp6_ = 0.0F;
	gfloat shadow_range_mean_prob_val = 0.0F;
	IntensityHistogram* _tmp7_ = NULL;
	gfloat _tmp8_ = 0.0F;
	IntensityHistogram* _tmp9_ = NULL;
	gfloat _tmp10_ = 0.0F;
	gint shadow_mean_intensity = 0;
	gboolean _tmp18_ = FALSE;
	gfloat _tmp19_ = 0.0F;
	PixelTransformationBundle* _tmp46_ = NULL;
	HighlightDetailTransformation* _tmp47_ = NULL;
	HighlightDetailTransformation* _tmp48_ = NULL;
	PixelTransformationBundle* _tmp49_ = NULL;
	TemperatureTransformation* _tmp50_ = NULL;
	TemperatureTransformation* _tmp51_ = NULL;
	PixelTransformationBundle* _tmp52_ = NULL;
	TintTransformation* _tmp53_ = NULL;
	TintTransformation* _tmp54_ = NULL;
	PixelTransformationBundle* _tmp55_ = NULL;
	ExposureTransformation* _tmp56_ = NULL;
	ExposureTransformation* _tmp57_ = NULL;
	PixelTransformationBundle* _tmp58_ = NULL;
	ContrastTransformation* _tmp59_ = NULL;
	ContrastTransformation* _tmp60_ = NULL;
	PixelTransformationBundle* _tmp61_ = NULL;
	SaturationTransformation* _tmp62_ = NULL;
	SaturationTransformation* _tmp63_ = NULL;
#line 1502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 1503 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 1503 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	adjustments = _tmp0_;
#line 1505 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixbuf;
#line 1505 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = intensity_histogram_new (_tmp1_);
#line 1505 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	analysis_histogram = _tmp2_;
#line 1508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = analysis_histogram;
#line 1508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = intensity_histogram_get_cumulative_probability (_tmp3_, AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY);
#line 1508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = analysis_histogram;
#line 1508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = intensity_histogram_get_cumulative_probability (_tmp5_, AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY);
#line 1508 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pct_in_range = 100.0f * (_tmp4_ - _tmp6_);
#line 1514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = analysis_histogram;
#line 1514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = intensity_histogram_get_cumulative_probability (_tmp7_, AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY);
#line 1514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = analysis_histogram;
#line 1514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = intensity_histogram_get_cumulative_probability (_tmp9_, AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY);
#line 1514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	shadow_range_mean_prob_val = (_tmp8_ + _tmp10_) * 0.5f;
#line 1517 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	shadow_mean_intensity = AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY;
#line 13597 "ColorTransformation.c"
	{
		gboolean _tmp11_ = FALSE;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = TRUE;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 13604 "ColorTransformation.c"
			gint _tmp13_ = 0;
			IntensityHistogram* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gfloat _tmp16_ = 0.0F;
			gfloat _tmp17_ = 0.0F;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp11_) {
#line 13612 "ColorTransformation.c"
				gint _tmp12_ = 0;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = shadow_mean_intensity;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				shadow_mean_intensity = _tmp12_ + 1;
#line 13618 "ColorTransformation.c"
			}
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = FALSE;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = shadow_mean_intensity;
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp13_ <= AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY)) {
#line 1518 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 13628 "ColorTransformation.c"
			}
#line 1519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = analysis_histogram;
#line 1519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp15_ = shadow_mean_intensity;
#line 1519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp16_ = intensity_histogram_get_cumulative_probability (_tmp14_, _tmp15_);
#line 1519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp17_ = shadow_range_mean_prob_val;
#line 1519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp16_ >= _tmp17_) {
#line 1520 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 13642 "ColorTransformation.c"
			}
		}
	}
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = pct_in_range;
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp19_ > 40.0f) {
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = TRUE;
#line 13652 "ColorTransformation.c"
	} else {
		gboolean _tmp20_ = FALSE;
		gfloat _tmp21_ = 0.0F;
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = pct_in_range;
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp21_ > 20.0f) {
#line 13660 "ColorTransformation.c"
			gint _tmp22_ = 0;
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp22_ = shadow_mean_intensity;
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = _tmp22_ < AUTO_ENHANCE_EMPIRICAL_DARK;
#line 13666 "ColorTransformation.c"
		} else {
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = FALSE;
#line 13670 "ColorTransformation.c"
		}
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = _tmp20_;
#line 13674 "ColorTransformation.c"
	}
#line 1528 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp18_) {
#line 13678 "ColorTransformation.c"
		gfloat shadow_trans_effect_size = 0.0F;
		gint _tmp23_ = 0;
		gfloat _tmp24_ = 0.0F;
		PixelTransformationBundle* _tmp25_ = NULL;
		gfloat _tmp26_ = 0.0F;
		ShadowDetailTransformation* _tmp27_ = NULL;
		ShadowDetailTransformation* _tmp28_ = NULL;
		gint discard_point = 0;
		PixelTransformationBundle* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		ExpansionTransformation* _tmp37_ = NULL;
		ExpansionTransformation* _tmp38_ = NULL;
#line 1529 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = shadow_mean_intensity;
#line 1529 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		shadow_trans_effect_size = ((((gfloat) AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY) - ((gfloat) _tmp23_)) / ((gfloat) AUTO_ENHANCE_SHADOW_DETECT_INTENSITY_RANGE)) * SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER;
#line 1533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp24_ = shadow_trans_effect_size;
#line 1533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		shadow_trans_effect_size = _tmp24_ * AUTO_ENHANCE_SHADOW_AGGRESSIVENESS_MUL;
#line 1535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = adjustments;
#line 1535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = shadow_trans_effect_size;
#line 1535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = shadow_detail_transformation_new (_tmp26_);
#line 1535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp28_ = _tmp27_;
#line 1535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp28_);
#line 1539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		discard_point = 255;
#line 13713 "ColorTransformation.c"
		{
			gboolean _tmp29_ = FALSE;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp29_ = TRUE;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 13720 "ColorTransformation.c"
				gint _tmp31_ = 0;
				IntensityHistogram* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gfloat _tmp34_ = 0.0F;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp29_) {
#line 13727 "ColorTransformation.c"
					gint _tmp30_ = 0;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = discard_point;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					discard_point = _tmp30_ - 1;
#line 13733 "ColorTransformation.c"
				}
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp29_ = FALSE;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp31_ = discard_point;
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp31_ > -1)) {
#line 1540 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 13743 "ColorTransformation.c"
				}
#line 1541 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp32_ = analysis_histogram;
#line 1541 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp33_ = discard_point;
#line 1541 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp34_ = intensity_histogram_get_cumulative_probability (_tmp32_, _tmp33_);
#line 1541 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if ((1.0f - _tmp34_) > AUTO_ENHANCE_SHADOW_MODE_HIGH_DISCARD_MASS) {
#line 1543 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 13755 "ColorTransformation.c"
				}
			}
		}
#line 1546 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_ = adjustments;
#line 1546 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = discard_point;
#line 1546 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp37_ = expansion_transformation_new_from_extrema (0, _tmp36_);
#line 1546 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp38_ = _tmp37_;
#line 1546 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1546 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp38_);
#line 13771 "ColorTransformation.c"
	} else {
		PixelTransformationBundle* _tmp39_ = NULL;
		IntensityHistogram* _tmp40_ = NULL;
		ExpansionTransformation* _tmp41_ = NULL;
		ExpansionTransformation* _tmp42_ = NULL;
		PixelTransformationBundle* _tmp43_ = NULL;
		ShadowDetailTransformation* _tmp44_ = NULL;
		ShadowDetailTransformation* _tmp45_ = NULL;
#line 1549 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_ = adjustments;
#line 1549 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp40_ = analysis_histogram;
#line 1549 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp41_ = expansion_transformation_new (_tmp40_);
#line 1549 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp42_ = _tmp41_;
#line 1549 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp39_, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1549 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp42_);
#line 1550 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp43_ = adjustments;
#line 1550 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp44_ = shadow_detail_transformation_new ((gfloat) 0);
#line 1550 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp45_ = _tmp44_;
#line 1550 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1550 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp45_);
#line 13802 "ColorTransformation.c"
	}
#line 1554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = adjustments;
#line 1554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = highlight_detail_transformation_new (0.0f);
#line 1554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = _tmp47_;
#line 1554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1554 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp48_);
#line 1555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = adjustments;
#line 1555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = temperature_transformation_new (0.0f);
#line 1555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51_ = _tmp50_;
#line 1555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp51_);
#line 1556 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52_ = adjustments;
#line 1556 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = tint_transformation_new (0.0f);
#line 1556 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = _tmp53_;
#line 1556 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1556 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp54_);
#line 1557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = adjustments;
#line 1557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = exposure_transformation_new (0.0f);
#line 1557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = _tmp56_;
#line 1557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp55_, G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1557 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp57_);
#line 1558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = adjustments;
#line 1558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp59_ = contrast_transformation_new (0.0f);
#line 1558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60_ = _tmp59_;
#line 1558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp60_);
#line 1559 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61_ = adjustments;
#line 1559 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp62_ = saturation_transformation_new (0.0f);
#line 1559 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_ = _tmp62_;
#line 1559 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp61_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1559 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp63_);
#line 1561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = adjustments;
#line 1561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_intensity_histogram_unref0 (analysis_histogram);
#line 1561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 13870 "ColorTransformation.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



