/* file.c generated by valac 0.34.7, the Vala compiler
 * generated from file.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* Returns true if the file is claimed, false if it exists, and throws an Error otherwise.  The file*/
/* will be created when the function exits and should be overwritten.  Note that the file is not*/
/* held open; claiming a file is merely based on its existence.*/
/**/
/* This function is thread-safe.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);


gboolean claim_file (GFile* file, GError** error);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
void disassemble_filename (const gchar* basename, gchar** name, gchar** ext);
glong find_last_offset (const gchar* str, gchar c);
guint64 query_total_file_size (GFile* file_or_dir, GCancellable* cancellable, GError** error);
void delete_all_files (GFile* dir, GeeSet* exceptions, ProgressMonitor monitor, void* monitor_target, guint64 file_count, GCancellable* cancellable, GError** error);
time_t query_file_modified (GFile* file, GError** error);
gboolean query_is_directory (GFile* file);
gboolean query_is_directory_empty (GFile* dir, GError** error);
gchar* get_display_pathname (GFile* file);
gchar* strip_pretty_path (const gchar* path);
gchar* get_file_info_id (GFileInfo* info);
void skip_uint64 (GInputStream* input, guint64 skip_amount, GError** error);
guint64 count_files_in_directory (GFile* dir, GError** error);
gboolean file_equal (GFile* a, GFile* b);
guint file_hash (GFile* file);


static gpointer _g_error_copy0 (gpointer self) {
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
	return self ? g_error_copy (self) : NULL;
#line 52 "file.c"
}


gboolean claim_file (GFile* file, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 62 "file.c"
	{
		GFile* _tmp0_ = NULL;
		GFileOutputStream* _tmp1_ = NULL;
		GFileOutputStream* _tmp2_ = NULL;
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = file;
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = g_file_create (_tmp0_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = _tmp1_;
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp2_);
#line 14 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "file.c"
			goto __catch0_g_error;
		}
#line 17 "/home/jens/Source/shotwell/src/util/file.vala"
		result = TRUE;
#line 17 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 84 "file.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
		err = _inner_error_;
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = err;
#line 20 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!g_error_matches (_tmp3_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 99 "file.c"
			GFile* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp4_ = file;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp5_ = g_file_get_path (_tmp4_);
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp6_ = _tmp5_;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp7_ = err;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp8_ = _tmp7_->message;
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			g_warning ("file.vala:21: claim_file %s: %s", _tmp6_, _tmp8_);
#line 21 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_free0 (_tmp6_);
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp9_ = err;
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp10_ = _g_error_copy0 (_tmp9_);
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_inner_error_ = _tmp10_;
#line 23 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 129 "file.c"
			goto __finally0;
		}
#line 26 "/home/jens/Source/shotwell/src/util/file.vala"
		result = FALSE;
#line 26 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_error_free0 (err);
#line 26 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 138 "file.c"
	}
	__finally0:
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
	g_propagate_error (error, _inner_error_);
#line 13 "/home/jens/Source/shotwell/src/util/file.vala"
	return _tmp11_;
#line 145 "file.c"
}


GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error) {
	gboolean _vala_collision = FALSE;
	GFile* result = NULL;
	GFile* file = NULL;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gchar* name = NULL;
	gchar* ext = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GFile* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
#line 36 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (dir), NULL);
#line 36 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = dir;
#line 38 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = basename;
#line 38 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = g_file_get_child (_tmp0_, _tmp1_);
#line 38 "/home/jens/Source/shotwell/src/util/file.vala"
	file = _tmp2_;
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = file;
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp5_ = claim_file (_tmp4_, &_inner_error_);
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = _tmp5_;
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (file);
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
		return NULL;
#line 195 "file.c"
	}
#line 39 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp3_) {
#line 40 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_collision = FALSE;
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
		result = file;
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
		if (collision) {
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
			*collision = _vala_collision;
#line 207 "file.c"
		}
#line 42 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 211 "file.c"
	}
#line 46 "/home/jens/Source/shotwell/src/util/file.vala"
	_vala_collision = TRUE;
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp6_ = basename;
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	disassemble_filename (_tmp6_, &_tmp7_, &_tmp8_);
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (name);
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	name = _tmp7_;
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (ext);
#line 49 "/home/jens/Source/shotwell/src/util/file.vala"
	ext = _tmp8_;
#line 227 "file.c"
	{
		gint ctr = 0;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
		ctr = 1;
#line 232 "file.c"
		{
			gboolean _tmp9_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp9_ = TRUE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
			while (TRUE) {
#line 239 "file.c"
				gint _tmp11_ = 0;
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* new_name = NULL;
				gchar* _tmp21_ = NULL;
				GFile* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				GFile* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				GFile* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				if (!_tmp9_) {
#line 253 "file.c"
					gint _tmp10_ = 0;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp10_ = ctr;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
					ctr = _tmp10_ + 1;
#line 259 "file.c"
				}
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp9_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp11_ = ctr;
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				if (!(_tmp11_ < G_MAXINT)) {
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
					break;
#line 269 "file.c"
				}
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp13_ = ext;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				if (_tmp13_ != NULL) {
#line 275 "file.c"
					const gchar* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp14_ = name;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp15_ = ctr;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp16_ = ext;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp17_ = g_strdup_printf ("%s_%d.%s", _tmp14_, _tmp15_, _tmp16_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp12_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp12_ = _tmp17_;
#line 292 "file.c"
				} else {
					const gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gchar* _tmp20_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp18_ = name;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp19_ = ctr;
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp20_ = g_strdup_printf ("%s_%d", _tmp18_, _tmp19_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp12_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
					_tmp12_ = _tmp20_;
#line 307 "file.c"
				}
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp21_ = g_strdup (_tmp12_);
#line 53 "/home/jens/Source/shotwell/src/util/file.vala"
				new_name = _tmp21_;
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp22_ = dir;
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp23_ = new_name;
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp24_ = g_file_get_child (_tmp22_, _tmp23_);
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_object_unref0 (file);
#line 55 "/home/jens/Source/shotwell/src/util/file.vala"
				file = _tmp24_;
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp26_ = file;
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp27_ = claim_file (_tmp26_, &_inner_error_);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp25_ = _tmp27_;
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					g_propagate_error (error, _inner_error_);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (new_name);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp12_);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (ext);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (name);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_object_unref0 (file);
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
					return NULL;
#line 345 "file.c"
				}
#line 56 "/home/jens/Source/shotwell/src/util/file.vala"
				if (_tmp25_) {
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					result = file;
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (new_name);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (_tmp12_);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (ext);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					_g_free0 (name);
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					if (collision) {
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
						*collision = _vala_collision;
#line 363 "file.c"
					}
#line 57 "/home/jens/Source/shotwell/src/util/file.vala"
					return result;
#line 367 "file.c"
				}
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_free0 (new_name);
#line 52 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_free0 (_tmp12_);
#line 373 "file.c"
			}
		}
	}
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp28_ = dir;
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp29_ = g_file_get_path (_tmp28_);
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp30_ = _tmp29_;
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp31_ = basename;
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	g_warning ("file.vala:60: generate_unique_filename %s for %s: unable to claim file", _tmp30_, _tmp31_);
#line 60 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (_tmp30_);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	result = NULL;
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (ext);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (name);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (file);
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	if (collision) {
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
		*collision = _vala_collision;
#line 401 "file.c"
	}
#line 62 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 405 "file.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 428 "file.c"
		glong _tmp4_ = 0L;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 436 "file.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 448 "file.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 472 "file.c"
		glong _tmp2_ = 0L;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 478 "file.c"
	} else {
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 482 "file.c"
	}
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 486 "file.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 498 "file.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 508 "file.c"
	}
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 514 "file.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 528 "file.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 538 "file.c"
	}
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 544 "file.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 553 "file.c"
	}
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 573 "file.c"
}


void disassemble_filename (const gchar* basename, gchar** name, gchar** ext) {
	gchar* _vala_name = NULL;
	gchar* _vala_ext = NULL;
	glong offset = 0L;
	const gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail (basename != NULL);
#line 66 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = basename;
#line 66 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = find_last_offset (_tmp0_, '.');
#line 66 "/home/jens/Source/shotwell/src/util/file.vala"
	offset = _tmp1_;
#line 67 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = offset;
#line 67 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp2_ <= ((glong) 0)) {
#line 596 "file.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = basename;
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_name);
#line 68 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_name = _tmp4_;
#line 69 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_ext);
#line 69 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_ext = NULL;
#line 611 "file.c"
	} else {
		const gchar* _tmp5_ = NULL;
		glong _tmp6_ = 0L;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		glong _tmp9_ = 0L;
		gchar* _tmp10_ = NULL;
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = basename;
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = offset;
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp7_ = string_substring (_tmp5_, (glong) 0, _tmp6_);
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_name);
#line 71 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_name = _tmp7_;
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp8_ = basename;
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp9_ = offset;
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp10_ = string_substring (_tmp8_, _tmp9_ + 1, (glong) -1);
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_ext);
#line 72 "/home/jens/Source/shotwell/src/util/file.vala"
		_vala_ext = _tmp10_;
#line 639 "file.c"
	}
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
	if (name) {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		*name = _vala_name;
#line 645 "file.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_name);
#line 649 "file.c"
	}
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
	if (ext) {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		*ext = _vala_ext;
#line 655 "file.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_vala_ext);
#line 659 "file.c"
	}
}


guint64 query_total_file_size (GFile* file_or_dir, GCancellable* cancellable, GError** error) {
	guint64 result = 0ULL;
	GFileType type = 0;
	GFile* _tmp0_ = NULL;
	GFileType _tmp1_ = 0;
	GFileType _tmp2_ = 0;
	GFileEnumerator* enumerator = NULL;
	guint64 total_bytes = 0ULL;
	GFileInfo* info = NULL;
	GError * _inner_error_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file_or_dir), 0ULL);
#line 77 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), 0ULL);
#line 78 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = file_or_dir;
#line 78 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_query_file_type (_tmp0_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
#line 78 "/home/jens/Source/shotwell/src/util/file.vala"
	type = _tmp1_;
#line 79 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = type;
#line 79 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp2_ == G_FILE_TYPE_REGULAR) {
#line 688 "file.c"
		GFileInfo* info = NULL;
		GFileInfo* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
#line 80 "/home/jens/Source/shotwell/src/util/file.vala"
		info = NULL;
#line 694 "file.c"
		{
			GFileInfo* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GCancellable* _tmp5_ = NULL;
			GFileInfo* _tmp6_ = NULL;
			GFileInfo* _tmp7_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp4_ = file_or_dir;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp5_ = cancellable;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp5_, &_inner_error_);
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp3_ = _tmp6_;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 711 "file.c"
				goto __catch1_g_error;
			}
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp7_ = _tmp3_;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp3_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 82 "/home/jens/Source/shotwell/src/util/file.vala"
			info = _tmp7_;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp3_);
#line 724 "file.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp8_ = NULL;
			GFile* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			err = _inner_error_;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			_inner_error_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp8_ = err;
#line 85 "/home/jens/Source/shotwell/src/util/file.vala"
			if (g_error_matches (_tmp8_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 744 "file.c"
				GError* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp9_ = err;
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_inner_error_ = _tmp10_;
#line 86 "/home/jens/Source/shotwell/src/util/file.vala"
				_g_error_free0 (err);
#line 755 "file.c"
				goto __finally1;
			}
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp11_ = file_or_dir;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp12_ = g_file_get_path (_tmp11_);
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp13_ = _tmp12_;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp14_ = err;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp15_ = _tmp14_->message;
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			g_debug ("file.vala:88: Unable to query filesize for %s: %s", _tmp13_, _tmp15_);
#line 88 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_free0 (_tmp13_);
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 90 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 780 "file.c"
		}
		__finally1:
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 785 "file.c"
			guint64 _tmp16_ = 0ULL;
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 81 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp16_;
#line 793 "file.c"
		}
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp17_ = info;
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp18_ = g_file_info_get_size (_tmp17_);
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		result = (guint64) _tmp18_;
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 93 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 805 "file.c"
	} else {
		GFileType _tmp19_ = 0;
#line 94 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp19_ = type;
#line 94 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp19_ != G_FILE_TYPE_DIRECTORY) {
#line 95 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 95 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 816 "file.c"
		}
	}
	{
		GFileEnumerator* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GCancellable* _tmp22_ = NULL;
		GFileEnumerator* _tmp23_ = NULL;
		GFileEnumerator* _tmp24_ = NULL;
		GFileEnumerator* _tmp25_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp21_ = file_or_dir;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp22_ = cancellable;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp23_ = g_file_enumerate_children (_tmp21_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp22_, &_inner_error_);
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp20_ = _tmp23_;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 836 "file.c"
			goto __catch2_g_error;
		}
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp24_ = _tmp20_;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp20_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 100 "/home/jens/Source/shotwell/src/util/file.vala"
		enumerator = _tmp24_;
#line 102 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp25_ = enumerator;
#line 102 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp25_ == NULL) {
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp20_);
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 103 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 859 "file.c"
		}
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp20_);
#line 863 "file.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		gboolean _tmp26_ = FALSE;
		GError* _tmp27_ = NULL;
		GError* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		err = _inner_error_;
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp27_ = err;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
		if (g_error_matches (_tmp27_, G_FILE_ERROR, G_FILE_ERROR_PERM)) {
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp26_ = TRUE;
#line 883 "file.c"
		} else {
			GError* _tmp28_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp28_ = err;
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp26_ = g_error_matches (_tmp28_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED);
#line 890 "file.c"
		}
#line 106 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp26_) {
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			result = (guint64) 0;
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 107 "/home/jens/Source/shotwell/src/util/file.vala"
			return result;
#line 902 "file.c"
		}
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp29_ = err;
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp30_ = _g_error_copy0 (_tmp29_);
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = _tmp30_;
#line 109 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_error_free0 (err);
#line 912 "file.c"
		goto __finally2;
	}
	__finally2:
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 918 "file.c"
		guint64 _tmp31_ = 0ULL;
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 99 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp31_;
#line 926 "file.c"
	}
#line 112 "/home/jens/Source/shotwell/src/util/file.vala"
	total_bytes = (guint64) 0;
#line 114 "/home/jens/Source/shotwell/src/util/file.vala"
	info = NULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 934 "file.c"
		GFileInfo* _tmp32_ = NULL;
		GFileEnumerator* _tmp33_ = NULL;
		GCancellable* _tmp34_ = NULL;
		GFileInfo* _tmp35_ = NULL;
		GFileInfo* _tmp37_ = NULL;
		GFileInfo* _tmp38_ = NULL;
		guint64 _tmp39_ = 0ULL;
		GFile* _tmp40_ = NULL;
		GFileInfo* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		GFile* _tmp43_ = NULL;
		GFile* _tmp44_ = NULL;
		GCancellable* _tmp45_ = NULL;
		guint64 _tmp46_ = 0ULL;
		guint64 _tmp47_ = 0ULL;
		guint64 _tmp49_ = 0ULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp33_ = enumerator;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp34_ = cancellable;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp35_ = g_file_enumerator_next_file (_tmp33_, _tmp34_, &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp32_ = _tmp35_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 961 "file.c"
			guint64 _tmp36_ = 0ULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp36_;
#line 971 "file.c"
		}
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp37_ = _tmp32_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp32_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		info = _tmp37_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp38_ = info;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp38_ != NULL)) {
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp32_);
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 989 "file.c"
		}
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp40_ = file_or_dir;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp41_ = info;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp42_ = g_file_info_get_name (_tmp41_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp43_ = g_file_get_child (_tmp40_, _tmp42_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp44_ = _tmp43_;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp45_ = cancellable;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp46_ = query_total_file_size (_tmp44_, _tmp45_, &_inner_error_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp47_ = _tmp46_;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp44_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp39_ = _tmp47_;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1013 "file.c"
			guint64 _tmp48_ = 0ULL;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp32_);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp48_;
#line 1025 "file.c"
		}
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp49_ = total_bytes;
#line 116 "/home/jens/Source/shotwell/src/util/file.vala"
		total_bytes = _tmp49_ + _tmp39_;
#line 115 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp32_);
#line 1033 "file.c"
	}
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	result = total_bytes;
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 118 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1043 "file.c"
}


void delete_all_files (GFile* dir, GeeSet* exceptions, ProgressMonitor monitor, void* monitor_target, guint64 file_count, GCancellable* cancellable, GError** error) {
	GFileType type = 0;
	GFile* _tmp0_ = NULL;
	GFileType _tmp1_ = 0;
	GFileType _tmp2_ = 0;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp10_ = NULL;
	GCancellable* _tmp11_ = NULL;
	GFileEnumerator* _tmp12_ = NULL;
	GFileInfo* info = NULL;
	guint64 i = 0ULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail ((exceptions == NULL) || GEE_IS_SET (exceptions));
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 127 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = dir;
#line 127 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_query_file_type (_tmp0_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
#line 127 "/home/jens/Source/shotwell/src/util/file.vala"
	type = _tmp1_;
#line 128 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = type;
#line 128 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp2_ != G_FILE_TYPE_DIRECTORY) {
#line 1075 "file.c"
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = dir;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = _tmp4_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = g_strdup_printf ("%s is not a directory", _tmp5_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp7_ = _tmp6_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_DIRECTORY, _tmp7_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp9_ = _tmp8_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_tmp7_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_tmp5_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		_inner_error_ = _tmp9_;
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 129 "/home/jens/Source/shotwell/src/util/file.vala"
		return;
#line 1107 "file.c"
	}
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp10_ = dir;
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp11_ = cancellable;
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp12_ = g_file_enumerate_children (_tmp10_, "standard::name,standard::type", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp11_, &_inner_error_);
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	enumerator = _tmp12_;
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 131 "/home/jens/Source/shotwell/src/util/file.vala"
		return;
#line 1123 "file.c"
	}
#line 133 "/home/jens/Source/shotwell/src/util/file.vala"
	info = NULL;
#line 134 "/home/jens/Source/shotwell/src/util/file.vala"
	i = (guint64) 0;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 1131 "file.c"
		GFileInfo* _tmp13_ = NULL;
		GFileEnumerator* _tmp14_ = NULL;
		GCancellable* _tmp15_ = NULL;
		GFileInfo* _tmp16_ = NULL;
		GFileInfo* _tmp17_ = NULL;
		GFileInfo* _tmp18_ = NULL;
		GFileInfo* _tmp19_ = NULL;
		GFileType _tmp20_ = 0;
		gboolean _tmp21_ = FALSE;
		GeeSet* _tmp22_ = NULL;
		GFile* file = NULL;
		GFile* _tmp27_ = NULL;
		GFileInfo* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GFile* _tmp30_ = NULL;
		gboolean _tmp38_ = FALSE;
		ProgressMonitor _tmp39_ = NULL;
		void* _tmp39__target = NULL;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp14_ = enumerator;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp15_ = cancellable;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp16_ = g_file_enumerator_next_file (_tmp14_, _tmp15_, &_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp13_ = _tmp16_;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			return;
#line 1168 "file.c"
		}
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp17_ = _tmp13_;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp13_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		info = _tmp17_;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp18_ = info;
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp18_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp13_);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 1186 "file.c"
		}
#line 136 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp19_ = info;
#line 136 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp20_ = g_file_info_get_file_type (_tmp19_);
#line 136 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp20_ != G_FILE_TYPE_REGULAR) {
#line 137 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp13_);
#line 137 "/home/jens/Source/shotwell/src/util/file.vala"
			continue;
#line 1198 "file.c"
		}
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp22_ = exceptions;
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp22_ != NULL) {
#line 1204 "file.c"
			GeeSet* _tmp23_ = NULL;
			GFileInfo* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp23_ = exceptions;
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp24_ = info;
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp25_ = g_file_info_get_name (_tmp24_);
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp26_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp25_);
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp21_ = _tmp26_;
#line 1219 "file.c"
		} else {
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp21_ = FALSE;
#line 1223 "file.c"
		}
#line 139 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp21_) {
#line 140 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp13_);
#line 140 "/home/jens/Source/shotwell/src/util/file.vala"
			continue;
#line 1231 "file.c"
		}
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp27_ = dir;
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp28_ = info;
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp29_ = g_file_info_get_name (_tmp28_);
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp30_ = g_file_get_child (_tmp27_, _tmp29_);
#line 142 "/home/jens/Source/shotwell/src/util/file.vala"
		file = _tmp30_;
#line 1243 "file.c"
		{
			GFile* _tmp31_ = NULL;
			GCancellable* _tmp32_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp31_ = file;
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp32_ = cancellable;
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			g_file_delete (_tmp31_, _tmp32_, &_inner_error_);
#line 144 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1255 "file.c"
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* err = NULL;
			GFile* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			GError* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			err = _inner_error_;
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_inner_error_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp33_ = file;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp34_ = g_file_get_path (_tmp33_);
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp35_ = _tmp34_;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp36_ = err;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp37_ = _tmp36_->message;
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			g_warning ("file.vala:146: Unable to delete file %s: %s", _tmp35_, _tmp37_);
#line 146 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_free0 (_tmp35_);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_error_free0 (err);
#line 1288 "file.c"
		}
		__finally3:
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (file);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp13_);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 143 "/home/jens/Source/shotwell/src/util/file.vala"
			return;
#line 1305 "file.c"
		}
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp39_ = monitor;
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp39__target = monitor_target;
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp39_ != NULL) {
#line 1313 "file.c"
			guint64 _tmp40_ = 0ULL;
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp40_ = file_count;
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp38_ = _tmp40_ > ((guint64) 0);
#line 1319 "file.c"
		} else {
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp38_ = FALSE;
#line 1323 "file.c"
		}
#line 149 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp38_) {
#line 1327 "file.c"
			ProgressMonitor _tmp41_ = NULL;
			void* _tmp41__target = NULL;
			guint64 _tmp42_ = 0ULL;
			guint64 _tmp43_ = 0ULL;
			guint64 _tmp44_ = 0ULL;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp41_ = monitor;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp41__target = monitor_target;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp42_ = file_count;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp43_ = i;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			i = _tmp43_ + 1;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp44_ = i;
#line 150 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp41_ (_tmp42_, _tmp44_, TRUE, _tmp41__target);
#line 1347 "file.c"
		}
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (file);
#line 135 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp13_);
#line 1353 "file.c"
	}
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 125 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 1359 "file.c"
}


time_t query_file_modified (GFile* file, GError** error) {
	time_t result = 0;
	GFileInfo* info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GTimeVal _tmp3_ = {0};
	glong _tmp4_ = 0L;
	GError * _inner_error_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = file;
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	info = _tmp1_;
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "file.c"
		time_t _tmp2_ = 0;
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp2_;
#line 1387 "file.c"
	}
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	g_file_info_get_modification_time (info, &_tmp3_);
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = _tmp3_.tv_sec;
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	result = (time_t) _tmp4_;
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 158 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1399 "file.c"
}


gboolean query_is_directory (GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFileType _tmp1_ = 0;
#line 161 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 162 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = file;
#line 162 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_query_file_type (_tmp0_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
#line 162 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp1_ == G_FILE_TYPE_DIRECTORY;
#line 162 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1417 "file.c"
}


gboolean query_is_directory_empty (GFile* dir, GError** error) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFileType _tmp1_ = 0;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp2_ = NULL;
	GFileEnumerator* _tmp3_ = NULL;
	GFileEnumerator* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
	GFileEnumerator* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
	GFileInfo* _tmp10_ = NULL;
	GFileInfo* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (dir), FALSE);
#line 166 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = dir;
#line 166 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_query_file_type (_tmp0_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
#line 166 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp1_ != G_FILE_TYPE_DIRECTORY) {
#line 167 "/home/jens/Source/shotwell/src/util/file.vala"
		result = FALSE;
#line 167 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1448 "file.c"
	}
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = dir;
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::name", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	enumerator = _tmp3_;
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1458 "file.c"
		gboolean _tmp4_ = FALSE;
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 169 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp4_;
#line 1464 "file.c"
	}
#line 171 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp5_ = enumerator;
#line 171 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp5_ == NULL) {
#line 172 "/home/jens/Source/shotwell/src/util/file.vala"
		result = FALSE;
#line 172 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 172 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1476 "file.c"
	}
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp7_ = enumerator;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp6_ = _tmp8_;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1486 "file.c"
		gboolean _tmp9_ = FALSE;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (enumerator);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp9_;
#line 1494 "file.c"
	}
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp10_ = _tmp6_;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp6_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp11_ = _tmp10_;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp12_ = _tmp11_ == NULL;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (_tmp11_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp12_;
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (_tmp6_);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 174 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1514 "file.c"
}


gchar* get_display_pathname (GFile* file) {
	gchar* result = NULL;
	gchar* path = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* home = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 179 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = file;
#line 179 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_get_parse_name (_tmp0_);
#line 179 "/home/jens/Source/shotwell/src/util/file.vala"
	path = _tmp1_;
#line 180 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = g_get_home_dir ();
#line 180 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 180 "/home/jens/Source/shotwell/src/util/file.vala"
	home = _tmp3_;
#line 182 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = path;
#line 182 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp5_ = home;
#line 182 "/home/jens/Source/shotwell/src/util/file.vala"
	if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 1551 "file.c"
		gchar* _tmp6_ = NULL;
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = g_strdup ("~");
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		result = _tmp6_;
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (home);
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (path);
#line 183 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1563 "file.c"
	}
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp7_ = path;
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp8_ = home;
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp9_ = g_str_has_prefix (_tmp7_, _tmp8_);
#line 185 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp9_) {
#line 1573 "file.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp10_ = path;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp11_ = home;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp12_ = strlen (_tmp11_);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp13_ = _tmp12_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp14_ = string_substring (_tmp10_, (glong) _tmp13_, (glong) -1);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp15_ = _tmp14_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp16_ = g_strdup_printf ("~%s", _tmp15_);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp17_ = _tmp16_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (_tmp15_);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		result = _tmp17_;
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (home);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_free0 (path);
#line 186 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1608 "file.c"
	}
#line 188 "/home/jens/Source/shotwell/src/util/file.vala"
	result = path;
#line 188 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (home);
#line 188 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1616 "file.c"
}


gchar* strip_pretty_path (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 192 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = path;
#line 192 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "~");
#line 192 "/home/jens/Source/shotwell/src/util/file.vala"
	if (!_tmp1_) {
#line 1638 "file.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = path;
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		result = _tmp3_;
#line 193 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1649 "file.c"
	}
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp4_ = g_get_home_dir ();
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp5_ = path;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp7_ = _tmp6_;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp9_ = _tmp8_;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_free0 (_tmp7_);
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp9_;
#line 195 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1669 "file.c"
}


gchar* get_file_info_id (GFileInfo* info) {
	gchar* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 198 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), NULL);
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = info;
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = g_file_info_get_attribute_string (_tmp0_, G_FILE_ATTRIBUTE_ID_FILE);
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1690 "file.c"
}


void skip_uint64 (GInputStream* input, guint64 skip_amount, GError** error) {
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_if_fail (G_IS_INPUT_STREAM (input));
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 1700 "file.c"
		guint64 _tmp0_ = 0ULL;
		guint64 _tmp1_ = 0ULL;
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = skip_amount;
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp0_ > ((guint64) 0))) {
#line 204 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 1709 "file.c"
		}
#line 206 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = skip_amount;
#line 206 "/home/jens/Source/shotwell/src/util/file.vala"
		if (_tmp1_ >= ((guint64) G_MAXSSIZE)) {
#line 1715 "file.c"
			GInputStream* _tmp2_ = NULL;
			guint64 _tmp3_ = 0ULL;
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp2_ = input;
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
			g_input_stream_skip (_tmp2_, (gsize) G_MAXSSIZE, NULL, &_inner_error_);
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
				g_propagate_error (error, _inner_error_);
#line 207 "/home/jens/Source/shotwell/src/util/file.vala"
				return;
#line 1728 "file.c"
			}
#line 208 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp3_ = skip_amount;
#line 208 "/home/jens/Source/shotwell/src/util/file.vala"
			skip_amount = _tmp3_ - G_MAXSSIZE;
#line 1734 "file.c"
		} else {
			GInputStream* _tmp4_ = NULL;
			guint64 _tmp5_ = 0ULL;
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp4_ = input;
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
			_tmp5_ = skip_amount;
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
			g_input_stream_skip (_tmp4_, (gsize) _tmp5_, NULL, &_inner_error_);
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
				g_propagate_error (error, _inner_error_);
#line 210 "/home/jens/Source/shotwell/src/util/file.vala"
				return;
#line 1750 "file.c"
			}
#line 211 "/home/jens/Source/shotwell/src/util/file.vala"
			skip_amount = (guint64) 0;
#line 1754 "file.c"
		}
	}
}


guint64 count_files_in_directory (GFile* dir, GError** error) {
	guint64 result = 0ULL;
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint64 count = 0ULL;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp2_ = NULL;
	GFileEnumerator* _tmp3_ = NULL;
	GFileInfo* info = NULL;
	GError * _inner_error_ = NULL;
#line 217 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail (G_IS_FILE (dir), 0ULL);
#line 218 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp0_ = dir;
#line 218 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = query_is_directory (_tmp0_);
#line 218 "/home/jens/Source/shotwell/src/util/file.vala"
	if (!_tmp1_) {
#line 219 "/home/jens/Source/shotwell/src/util/file.vala"
		result = (guint64) 0;
#line 219 "/home/jens/Source/shotwell/src/util/file.vala"
		return result;
#line 1782 "file.c"
	}
#line 221 "/home/jens/Source/shotwell/src/util/file.vala"
	count = (guint64) 0;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = dir;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	enumerator = _tmp3_;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1794 "file.c"
		guint64 _tmp4_ = 0ULL;
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
		g_propagate_error (error, _inner_error_);
#line 222 "/home/jens/Source/shotwell/src/util/file.vala"
		return _tmp4_;
#line 1800 "file.c"
	}
#line 225 "/home/jens/Source/shotwell/src/util/file.vala"
	info = NULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
	while (TRUE) {
#line 1806 "file.c"
		GFileInfo* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
		GFileInfo* _tmp9_ = NULL;
		GFileInfo* _tmp10_ = NULL;
		guint64 _tmp11_ = 0ULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = enumerator;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error_);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = _tmp7_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1821 "file.c"
			guint64 _tmp8_ = 0ULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			g_propagate_error (error, _inner_error_);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (info);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (enumerator);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			return _tmp8_;
#line 1831 "file.c"
		}
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp9_ = _tmp5_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = NULL;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (info);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		info = _tmp9_;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp10_ = info;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		if (!(_tmp10_ != NULL)) {
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			_g_object_unref0 (_tmp5_);
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
			break;
#line 1849 "file.c"
		}
#line 227 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp11_ = count;
#line 227 "/home/jens/Source/shotwell/src/util/file.vala"
		count = _tmp11_ + 1;
#line 226 "/home/jens/Source/shotwell/src/util/file.vala"
		_g_object_unref0 (_tmp5_);
#line 1857 "file.c"
	}
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	result = count;
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (info);
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	_g_object_unref0 (enumerator);
#line 229 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1867 "file.c"
}


gboolean file_equal (GFile* a, GFile* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_ = NULL;
#line 233 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((a == NULL) || G_IS_FILE (a), FALSE);
#line 233 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((b == NULL) || G_IS_FILE (b), FALSE);
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp2_ = a;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp2_ != NULL) {
#line 1884 "file.c"
		GFile* _tmp3_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = b;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 1890 "file.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp1_ = FALSE;
#line 1894 "file.c"
	}
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp1_) {
#line 1898 "file.c"
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp4_ = a;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp5_ = b;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp6_ = g_file_equal (_tmp4_, _tmp5_);
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = _tmp6_;
#line 1910 "file.c"
	} else {
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = FALSE;
#line 1914 "file.c"
	}
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp0_;
#line 234 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1920 "file.c"
}


guint file_hash (GFile* file) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	GFile* _tmp1_ = NULL;
#line 238 "/home/jens/Source/shotwell/src/util/file.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), 0U);
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	_tmp1_ = file;
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	if (_tmp1_ != NULL) {
#line 1934 "file.c"
		GFile* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp2_ = file;
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp3_ = g_file_hash (_tmp2_);
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = _tmp3_;
#line 1943 "file.c"
	} else {
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
		_tmp0_ = (guint) 0;
#line 1947 "file.c"
	}
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	result = _tmp0_;
#line 239 "/home/jens/Source/shotwell/src/util/file.vala"
	return result;
#line 1953 "file.c"
}



