#!/usr/bin/tclsh
# This tests almost everything that the extension implements.
package require inotify

puts Loaded

set num 0
proc handler { fd } {
    global num term
    puts [watch read]
    incr num
    if {$num >= 5} { 
        set term 1 
    }
    return
}

set fd [inotify create "watch" "::handler"]
puts Created

set wd [watch add [pwd] {*}]
puts Added

watch remove [pwd]
puts Removed

set wd [watch add [pwd] {*}]
puts Added

puts "fd: $fd wd: $wd pwd:[pwd]"
puts "watch info:[watch info]"
puts "inotify info:[inotify info]"

after 1000 [list exec echo a > test.txt]
after 2000 [list exec mv test.txt delme.txt]
after 3000 [list exec rm delme.txt]
after 4000 [list exec ls]

set term 0
puts "waiting.."
vwait term

puts "\nexiting.."
rename watch {}
rename inotify {}
puts done
