/*
    inotify - File-system notifications service for Tcl
    A Tcl interface to the Linux kernel's Inotify service.

    Copyright (C) 2008  Alexandros Stergiakis

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _INOTIFY
#define _INOTIFY

#include <tcl.h>

#ifdef OWN_INOTIFY
#include "inotify-nosys.h"
#else
#include <sys/inotify.h>
#endif

/* size of the event structure, not counting name */
#define EVENT_SIZE (sizeof (struct inotify_event))

/* reasonable guess as to size of 32 events */
#define BUF_LEN (32 * (EVENT_SIZE + 16))

/* the number of characters that a string representation of an int takes */
#define INT_LEN (sizeof(int) * 8 + 1)

/* the number of characters the string representation of the event-mask takes */
#define FLAGS_LEN 20

/* the length in bytes that the string representation of an event takes */
#define EVENT_LEN (INT_LEN * 2 + MASK_LEN + 30)

/* the number of times to try to register a watch before giving up */
#define RETRIES 10

Tcl_HashTable Instances;
int Instances_initialized;
Tcl_Mutex InstancesAccess;

struct instance_state {
    int fd;
    char *name;
    char *handler;
    char buf[BUF_LEN];
    int buflen;
    Tcl_Interp *interp;
    Tcl_HashTable Watches;
    int initialized;
};

struct watch_state {
    int wd;
    char *flags;
};

#endif /* _INOTIFY */
