/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CompiledTLex;
import azcheck.engine.CompositeTLex;
import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.EditableTLex;
import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.util.CoreReader;
import azcheck.util.Logger;
import azcheck.util.QuickSort;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DictionaryManager {
    protected String dictPath;
    protected Hashtable dictBindings = new Hashtable();
    protected Hashtable autoLocated = new Hashtable();
    protected Hashtable langInfo = new Hashtable();
    protected Hashtable cdiCache = new Hashtable();
    Logger logger;
    static final String DEFAULT_DICT = "/default";
    static final String LANGUAGE_FILE = "language";
    static final String DICT_ARCHIVE_EXT = ".dar";
    static final String COMPILED_DICT_EXT = ".cdi";
    static final byte[] MULTILINK_MAGIC = new byte[]{64, 109, 117, 108, 116, 105, 108, 105, 110, 107, 58};

    public DictionaryManager() throws IOException {
        this(null);
    }

    public DictionaryManager(String string) throws IOException {
        if (string == null) {
            string = this.dictsDir();
        }
        if (string != null) {
            this.setAccessPath(string);
        } else {
            this.defaultDictionaries();
        }
    }

    public void defineDictionary(String string, URL object) throws IOException {
        Object object2;
        this.log("defineDictionary " + string + " as " + object);
        if (string.indexOf(47) < 0) {
            string = string + DEFAULT_DICT;
        }
        if (object == null) {
            object2 = this.getClass().getResource("/" + string);
            if (object2 == null) {
                throw new IOException("dictionary name '" + string + "' not locatable as a resource");
            }
            object = object2;
        }
        object2 = new DictionaryManagerItem(string);
        ((DictionaryManagerItem)object2).location = object;
        this.dictBindings.put(string, object2);
        DictionaryManagerItem dictionaryManagerItem = (DictionaryManagerItem)this.langInfo.get(DictionaryManager.getLanguage(string));
        if (dictionaryManagerItem != null) {
            ((DictionaryManagerItem)object2).english = dictionaryManagerItem.english;
            ((DictionaryManagerItem)object2).local = dictionaryManagerItem.local;
            ((DictionaryManagerItem)object2).encoding = dictionaryManagerItem.encoding;
        }
    }

    public synchronized void setAccessPath(String string) throws IOException {
        this.log("setAccessPath " + string);
        if (string == null) {
            throw new IllegalArgumentException("dictPath argument must not be null");
        }
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                this.unloadDictionaries();
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.scanArchive(fileArray[i]);
                }
            }
        }
        catch (Exception exception) {
            this.log("setAccessPath: Security!");
        }
        this.defaultDictionaries();
    }

    public void defaultDictionaries() {
        this.defLocate("en", "English", "English", "ISO8859_1");
        this.defLocate("en-CA", "English (CA)", "English (CA)", "ISO8859_1");
        this.defLocate("en-GB", "English (GB)", "English (GB)", "ISO8859_1");
        this.defLocate("en-US", "English (US)", "English (US)", "ISO8859_1");
        this.defLocate("fr", "French", "Fran\u00e7ais", "ISO8859_1");
        this.defLocate("fr-BE", "French (BE)", "Fran\u00e7ais (BE)", "ISO8859_1");
        this.defLocate("fr-CA", "French (CA)", "Fran\u00e7ais (CA)", "ISO8859_1");
        this.defLocate("fr-CH", "French (CH)", "Fran\u00e7ais (CH)", "ISO8859_1");
        this.defLocate("de", "German", "Deutsch", "ISO8859_1");
        this.defLocate("es", "Spanish", "Espa\u00f1ol", "ISO8859_1");
        this.defLocate("it", "Italian", "Italiano", "ISO8859_1");
        this.defLocate("pt", "Portuguese", "Portugu\u00eas", "ISO8859_1");
        this.defLocate("nl", "Dutch", "Nederlands", "ISO8859_1");
        this.defLocate("da", "Danish", "Dansk", "ISO8859_1");
        this.defLocate("fi", "Finnish", "Suomi", "ISO8859_1");
        this.defLocate("no", "Norwegian", "Norsk", "ISO8859_1");
        this.defLocate("sv", "Swedish", "Svensk", "ISO8859_1");
        this.defLocate("cs", "Czech", "Cesko", "ISO8859_2");
        this.defLocate("pl", "Polish", "Polski", "ISO8859_2");
        this.defLocate("ru", "Russian", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "KOI8_R");
    }

    private String dictsDir() {
        try {
            this.dictPath = System.getProperty("java.class.path");
            int n = 0;
            while (n < this.dictPath.length()) {
                int n2 = this.dictPath.indexOf(File.pathSeparatorChar, n);
                if (n2 < 0) {
                    n2 = this.dictPath.length();
                }
                if (n2 != n) {
                    File file;
                    File file2 = new File(this.dictPath.substring(n, n2 - n));
                    if (!file2.isDirectory()) {
                        file2 = file2.getParentFile();
                    }
                    if ((file = new File(file2, "dicts")).isDirectory()) {
                        return file.getCanonicalPath();
                    }
                }
                n = n2 + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void scanArchive(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            URL uRL = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (string.endsWith("/language") || string.endsWith("/") || string.endsWith(COMPILED_DICT_EXT) || string.startsWith("META")) continue;
                this.autoLocated.put(string, new URL(uRL, string));
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void defLocate(String string, String string2, String string3, String string4) {
        DictionaryManagerItem dictionaryManagerItem = new DictionaryManagerItem(string);
        dictionaryManagerItem.english = string2;
        dictionaryManagerItem.local = string3;
        dictionaryManagerItem.encoding = string4;
        this.langInfo.put(string, dictionaryManagerItem);
        String string5 = string + DEFAULT_DICT;
        URL uRL = this.getClass().getResource("/" + string5);
        if (uRL == null) {
            dictionaryManagerItem.location = this.autoLocated.get(string5);
            if (dictionaryManagerItem.location == null) {
                if (this.logger != null) {
                    this.log(string5 + " not located! ");
                }
                return;
            }
            if (this.logger != null) {
                this.log(string5 + " auto: " + dictionaryManagerItem.location);
            }
        } else {
            dictionaryManagerItem.location = uRL;
            if (this.logger != null) {
                this.log(string5 + " as resource: " + uRL);
            }
        }
        this.dictBindings.put(string5, dictionaryManagerItem);
    }

    public synchronized void addAccessPaths(String string) throws IOException {
        int n = string.indexOf(File.pathSeparatorChar);
        if (n > 1) {
            throw new IllegalArgumentException("deprecated method");
        }
        this.setAccessPath(string);
    }

    public String getAccessPath() {
        return this.dictPath;
    }

    public synchronized DictionaryManagerItem[] listLanguages() throws IOException {
        Object[] objectArray = new DictionaryManagerItem[this.dictBindings.size()];
        Enumeration enumeration = this.dictBindings.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = (DictionaryManagerItem)enumeration.nextElement();
        }
        QuickSort.sort(objectArray, new QuickSort.Compare(){

            public int compare(Object object, Object object2) {
                DictionaryManagerItem dictionaryManagerItem = (DictionaryManagerItem)object;
                DictionaryManagerItem dictionaryManagerItem2 = (DictionaryManagerItem)object2;
                return dictionaryManagerItem.local.compareTo(dictionaryManagerItem2.local);
            }
        });
        return objectArray;
    }

    public DictionaryManagerItem getLanguageInfo(String string) {
        return (DictionaryManagerItem)this.langInfo.get(string);
    }

    public synchronized void unloadDictionaries() {
        this.cdiCache = new Hashtable();
    }

    public synchronized void clear() {
        this.unloadDictionaries();
        this.dictBindings = new Hashtable();
        this.dictPath = null;
    }

    public synchronized TLex load(String string, TLex tLex) throws IOException, SpellException {
        DictionaryManagerItem dictionaryManagerItem;
        if (string.indexOf(47) < 0) {
            string = string + DEFAULT_DICT;
        }
        if ((dictionaryManagerItem = (DictionaryManagerItem)this.dictBindings.get(string)) == null) {
            throw new SpellException("undefined dictionary name: " + string);
        }
        TLex tLex2 = this.load((URL)dictionaryManagerItem.location, tLex);
        return tLex2;
    }

    public synchronized TLex load(URL uRL, TLex tLex) throws IOException, SpellException {
        byte[] byArray = this.getDataFromCache(uRL);
        if (byArray != null) {
            CompiledTLex compiledTLex = new CompiledTLex(uRL);
            compiledTLex.setReader(new CoreReader(byArray));
            return compiledTLex;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream == null) {
            throw new IOException("empty or unreachable dictionary: " + uRL);
        }
        byArray = this.readDataBlock(0, inputStream);
        inputStream.close();
        if (byArray.length > 2 && byArray[0] == CompiledTLex.MAGIC[0] && byArray[1] == CompiledTLex.MAGIC[1]) {
            CompiledTLex compiledTLex = new CompiledTLex(uRL);
            compiledTLex.setReader(new CoreReader(byArray));
            Entry entry = new Entry();
            entry.softref = new SoftReference<byte[]>(byArray);
            ++entry.refs;
            entry.data = byArray;
            this.cdiCache.put(uRL, entry);
            return compiledTLex;
        }
        if (byArray[0] == MULTILINK_MAGIC[0] && byArray[1] == MULTILINK_MAGIC[1]) {
            CompositeTLex compositeTLex = new CompositeTLex(uRL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            if (uRL == null) {
                throw new IllegalArgumentException("base URL needed for loading composite dictionaries");
            }
            String string = bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') {
                    if (!string.startsWith("##Copyright: ")) continue;
                    compositeTLex.setCopyright(string.substring(13));
                    continue;
                }
                boolean bl = false;
                if (string.charAt(0) == '?') {
                    bl = true;
                    string = string.substring(1);
                }
                TLex tLex2 = null;
                if (!bl) {
                    tLex2 = this.load(new URL(uRL, string), tLex);
                } else {
                    try {
                        tLex2 = this.load(new URL(uRL, string), tLex);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (tLex2 == null) continue;
                compositeTLex.addMember(tLex2);
                if (tLex != null) continue;
                tLex = tLex2;
            }
            return compositeTLex;
        }
        if (tLex == null) {
            throw new SpellException("cannot load text dictionary without hints");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        EditableTLex editableTLex = new EditableTLex(uRL == null ? "?" : uRL.toString(), tLex);
        editableTLex.load(bufferedReader, true);
        return editableTLex;
    }

    protected synchronized void reloadCompiledDictionary(CompiledTLex compiledTLex) throws IOException, SpellException {
        compiledTLex.setReader(new CoreReader(this.getDataFromCache((URL)compiledTLex.getLocation())));
    }

    byte[] getDataFromCache(URL uRL) throws IOException {
        Entry entry = (Entry)this.cdiCache.get(uRL);
        if (entry == null) {
            return null;
        }
        ++entry.refs;
        byte[] byArray = entry.data;
        if (byArray == null) {
            byte[] byArray2 = byArray = entry.softref == null ? null : (byte[])entry.softref.get();
        }
        if (byArray != null) {
            return byArray;
        }
        InputStream inputStream = uRL.openStream();
        byArray = this.readDataBlock(0, inputStream);
        inputStream.close();
        entry.softref = new SoftReference<byte[]>(byArray);
        entry.data = byArray;
        return byArray;
    }

    synchronized boolean releaseCompiledDictionary(Object object) {
        Entry entry = (Entry)this.cdiCache.get(object);
        if (entry == null || entry.refs == 0) {
            return false;
        }
        if (--entry.refs == 0) {
            entry.data = null;
        }
        return true;
    }

    byte[] readDataBlock(int n, InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray;
        Vector<byte[]> vector = new Vector<byte[]>();
        if (n > 0) {
            vector.add(new byte[n]);
        }
        int n3 = n;
        int n4 = 0;
        while (true) {
            byArray = new byte[65536];
            n2 = 0;
            int n5 = inputStream.read(byArray, n2, byArray.length);
            while (n5 > 0 && (n2 += n5) < byArray.length) {
                n5 = inputStream.read(byArray, n2, byArray.length - n2);
            }
            if (n2 <= 0) break;
            n3 += n2;
            vector.add(byArray);
        }
        byArray = new byte[n3];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            byte[] byArray2 = (byte[])vector.get(n2);
            System.arraycopy(byArray2, 0, byArray, n4, Math.min(n3, byArray2.length));
            n3 -= byArray2.length;
            n4 += byArray2.length;
        }
        return byArray;
    }

    protected boolean checkMagic(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    static String getLanguage(String string) {
        int n = string.indexOf(47);
        return n < 0 ? string : string.substring(0, n);
    }

    private void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private static class Entry {
        int refs;
        byte[] data;
        SoftReference softref;

        private Entry() {
        }
    }
}

