/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.EditableWord;
import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.engine.TLexRules;
import azcheck.util.CharSequence;
import azcheck.util.StringCharSeq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class EditableTLex
extends TLex {
    static final byte E_PLAIN = 0;
    static final byte E_REPLACE = 1;
    static final byte E_SUGGESTIONS = 2;
    static final byte E_BANNED = 3;
    static final byte E_FILEEXT = 4;
    Vector nodes_ = new Vector();

    EditableTLex(String string, TLexRules tLexRules) {
        super(string);
        this.shareRules(tLexRules);
        this.nodes_.add(null);
        this.rootNode_ = 1;
        this.nodes_.add(new Node());
    }

    Entry lookup(CharSequence charSequence, int n, int n2) throws SpellException {
        this.encodeWord(charSequence, n, n2);
        int n3 = this.searchItem(this.rootNode_, this.word_, 0, this.wLength_);
        Node node = this.getNode(n3);
        if (node == null) {
            return null;
        }
        Entry entry = new Entry();
        entry.value = node.value;
        entry.type = node.type;
        return entry;
    }

    int addWord(String string, byte by, String string2) throws SpellException {
        return this.addWord(string, by, string2, true);
    }

    int addWord(String string, byte by, String string2, boolean bl) throws SpellException {
        int n = this.encodeWord(new StringCharSeq(string), 0, string.length());
        int n2 = this.rootNode_;
        for (int i = 0; i < this.wLength_; ++i) {
            n2 = this.haveNode(n2, this.word_[i]);
        }
        Node node = this.getNode(n2);
        if (by == 2 && node.value != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(node.value, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(string2)) continue;
                return n2;
            }
            node.value = node.value + "\t" + string2;
        } else if (bl) {
            node.value = string2;
        }
        if (bl) {
            node.flags = EditableTLex.wordFlags(n);
            node.type = by;
        }
        return n2;
    }

    boolean removeWord(String string) throws SpellException {
        int n = this.encodeWord(new StringCharSeq(string), 0, string.length());
        int n2 = this.rootNode_;
        for (int i = 0; i < this.wLength_ && n2 >= 0; ++i) {
            n2 = this.step(n2, this.word_[i]);
        }
        if (n2 < 0) {
            return false;
        }
        Node node = this.getNode(n2);
        node.value = null;
        node.flags = 0;
        return true;
    }

    void load(BufferedReader bufferedReader, boolean bl) throws IOException, SpellException {
        while (true) {
            String string = bufferedReader.readLine();
            String string2 = null;
            if (string == null) break;
            int n = string.length();
            if (n == 0 || string.charAt(0) == '#') continue;
            int n2 = string.indexOf(9);
            if (n2 < 0) {
                n2 = n;
            }
            byte by = 0;
            if (n2 + 1 < n) {
                switch (string.charAt(n2 + 1)) {
                    case '?': {
                        by = 2;
                        string2 = string.substring(n2 + 2);
                        break;
                    }
                    case '%': {
                        by = 3;
                        break;
                    }
                    case '@': {
                        by = 4;
                        break;
                    }
                    case '!': {
                        by = 1;
                        string2 = string.substring(n2 + 2);
                    }
                }
            }
            this.addWord(string.substring(0, n2), by, string2, bl);
        }
    }

    void save(final BufferedWriter bufferedWriter) throws IOException {
        this.fullVisit(new TLex.Visitor(){

            public void getWord(char[] cArray, int n, int n2, int n3) {
                try {
                    Node node = EditableTLex.this.getNode(n3);
                    for (int i = 0; i < n; ++i) {
                        char c = cArray[i];
                        if (n2 == 2 || i == 0 && n2 == 1) {
                            c = Character.toUpperCase(c);
                        }
                        bufferedWriter.write(c);
                    }
                    bufferedWriter.write(9);
                    switch (node.type) {
                        case 2: {
                            bufferedWriter.write("?");
                            bufferedWriter.write(node.value);
                            break;
                        }
                        case 1: {
                            bufferedWriter.write("!");
                            bufferedWriter.write(node.value);
                            break;
                        }
                        case 3: {
                            bufferedWriter.write("%");
                            break;
                        }
                        case 4: {
                            bufferedWriter.write("@");
                        }
                    }
                    bufferedWriter.write(10);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
            }
        });
    }

    EditableWord[] getEditableWords() throws SpellException {
        final Vector vector = new Vector();
        this.fullVisit(new TLex.Visitor(){

            public void getWord(char[] cArray, int n, int n2, int n3) {
                Node node = EditableTLex.this.getNode(n3);
                EditableWord editableWord = new EditableWord();
                editableWord.word = new String(cArray, 0, n);
                editableWord.type = node.type;
                editableWord.value = node.value;
                vector.add(editableWord);
            }
        });
        return vector.toArray(new EditableWord[0]);
    }

    void fullVisit(TLex.Visitor visitor) {
        char[] cArray = new char[256];
        this.fullVisit(visitor, cArray, 0, this.rootNode_);
    }

    private void fullVisit(TLex.Visitor visitor, char[] cArray, int n, int n2) {
        Node node = this.getNode(n2);
        if (EditableTLex.actualWord(node.flags)) {
            visitor.getWord(cArray, n, EditableTLex.getWordType(node.flags), n2);
        }
        KEnum kEnum = (KEnum)this.newKEnum(n2);
        while (kEnum.next()) {
            cArray[n] = this.decode(kEnum.getCurrentChar());
            int n3 = kEnum.getCurrentNode();
            if (n3 > 0) {
                this.fullVisit(visitor, cArray, n + 1, n3);
                continue;
            }
            if (n3 != 0) continue;
            visitor.getWord(cArray, n + 1, EditableTLex.getWordType(this.getFlags(n3)), n3);
        }
    }

    Node getNode(int n) {
        return n <= 0 ? null : (Node)this.nodes_.get(n);
    }

    int getFlags(int n) {
        Node node = this.getNode(n);
        if (node == null || node.type != 0) {
            return -1;
        }
        return EditableTLex.actualWord(node.flags) ? (int)node.flags : -1;
    }

    int step(int n, byte by) {
        Node node = this.getNode(n);
        int n2 = node.children;
        while (n2 >= 0) {
            node = this.getNode(n2);
            if (node.charCode == by) {
                return n2;
            }
            if (node.charCode > by) {
                return -1;
            }
            n2 = node.next;
        }
        return -1;
    }

    int haveNode(int n, byte by) {
        Node node = this.getNode(n);
        Node node2 = null;
        int n2 = node.children;
        int n3 = -1;
        while (n2 >= 0) {
            node2 = this.getNode(n2);
            if (node2.charCode == by) {
                return n2;
            }
            if (node2.charCode > by) break;
            n3 = n2;
            n2 = node2.next;
        }
        node2 = new Node();
        node2.next = n2;
        node2.charCode = by;
        n2 = this.nodes_.size();
        if (n3 < 0) {
            node.children = n2;
        } else {
            this.getNode((int)n3).next = n2;
        }
        this.nodes_.add(node2);
        return n2;
    }

    TLex.KEnum newKEnum(int n) {
        return new KEnum(n);
    }

    class KEnum
    implements TLex.KEnum {
        int curNode_;
        boolean atStart_ = true;

        KEnum(int n) {
            this.curNode_ = n;
            this.atStart_ = true;
        }

        public boolean next() {
            if (this.atStart_) {
                this.curNode_ = EditableTLex.this.getNode((int)this.curNode_).children;
            } else if (this.curNode_ >= 0) {
                this.curNode_ = EditableTLex.this.getNode((int)this.curNode_).next;
            }
            this.atStart_ = false;
            return this.curNode_ >= 0;
        }

        public int getCurrentNode() {
            return this.curNode_;
        }

        public byte getCurrentChar() {
            return EditableTLex.this.getNode((int)this.curNode_).charCode;
        }
    }

    static class Node {
        byte charCode;
        byte flags = 0;
        byte type;
        int children = -1;
        int next = -1;
        String value;

        Node() {
        }
    }

    static class Entry {
        String value;
        byte type;

        Entry() {
        }
    }
}

