/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.SpellChecker;
import azcheck.engine.SpellException;
import azcheck.engine.Suggestions;
import azcheck.ui.TextSource;
import azcheck.util.CharSequence;
import java.io.IOException;

public class SpellControl
extends SpellChecker {
    TextSource source_;
    CharSequence input_;
    int lastEvent_;
    String failingWord_ = null;
    Suggestions suggestions_;

    SpellControl(String string) throws IOException {
        super(string);
    }

    SpellControl(SpellControl spellControl) {
        super(spellControl);
    }

    public int check(TextSource textSource) throws SpellException {
        this.source_ = textSource;
        this.suggestions_ = null;
        while (true) {
            this.input_ = textSource.getText(this.getCharChecker());
            if (this.input_ == null) {
                this.failingWord_ = null;
                return 0;
            }
            if (this.input_.length() == 0) {
                this.failingWord_ = null;
                return 0;
            }
            this.setInput(this.input_);
            this.lastEvent_ = this.checkNext();
            if (this.lastEvent_ == 0) {
                textSource.highlight(this.input_.length(), 0);
                continue;
            }
            this.failingWord_ = this.getWord();
            if (this.lastEvent_ != 1) break;
            this.source_.replace(this.getPosition(), this.failingWord_.length(), this.getReplacement(this.failingWord_));
        }
        textSource.highlight(this.getPosition(), this.failingWord_.length());
        return this.lastEvent_;
    }

    public String failingWord() {
        return this.failingWord_;
    }

    public Suggestions getSuggestions() throws SpellException {
        if (this.suggestions_ == null) {
            this.suggestions_ = super.getSuggestions();
        }
        return this.suggestions_;
    }

    public void replace(String string, boolean bl) throws SpellException {
        if (this.failingWord_ == null) {
            return;
        }
        int n = this.getPosition();
        int n2 = this.failingWord_.length();
        if (string.length() == 0) {
            if (this.lastEvent_ != 4) {
                return;
            }
            if (Character.isWhitespace(this.inputChar(n - 1))) {
                --n;
                ++n2;
            }
        }
        if (string.length() > 0) {
            if (bl) {
                this.learnAutoReplacement(this.failingWord_, string, "<temporary>");
            } else if (this.suggestions_ != null && !this.suggestions_.contain(string, 2)) {
                this.learnSuggestion(this.failingWord_, string, "<temporary>");
            }
        }
        this.source_.replace(n, n2, string);
    }

    public void add(String string) throws SpellException {
        this.learnWord(string, "<personal>");
    }

    public void ignoreAll(String string) throws SpellException {
        this.learnWord(string, "<temporary>");
    }

    public void stop() {
        try {
            this.savePersonalDictionaries();
        }
        catch (IOException iOException) {
            System.err.println("OOPS: " + iOException.getMessage());
        }
    }

    private char inputChar(int n) {
        return n < 0 || n >= this.input_.length() ? (char)'\u0000' : this.input_.charAt(n);
    }
}

