/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.account;

import com.novell.gw.account.CapAccount;
import com.novell.gw.account.GroupWiseAccount;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.account.Pop3Account;
import com.novell.gw.engine.DataStore;

public abstract class Account {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_POP3 = 1;
    public static final int TYPE_IMAP = 2;
    public static final int TYPE_GROUPWISE = 3;
    public static final int TYPE_NNTP = 4;
    public static final int TYPE_CAP = 7;
    protected int pAccount = 0;
    protected int type = 0;
    protected String fromText;
    protected String name;
    protected String userId;
    private DataStore owner = null;

    private static native int getType(int var0);

    private native boolean canDelete(int var1);

    private native boolean canUploadToMaster(int var1);

    private native String getEmailAddress(int var1);

    private native String getFromText(int var1);

    private native boolean getIncludeInFullRetrieve(int var1);

    private native String getName(int var1);

    private native String getOrganization(int var1);

    private native String getReplyAddress(int var1);

    private native boolean getUploadToMaster(int var1);

    private native String getUserId(int var1);

    private native boolean isDefault(int var1);

    private native void setDefault(int var1);

    private native void setEmailAddress(int var1, String var2);

    private native void setFromText(int var1, String var2);

    private native void setIncludeInFullRetrieve(int var1, boolean var2);

    private native void setName(int var1, String var2);

    private native void setOrganization(int var1, String var2);

    private native void setReplyAddress(int var1, String var2);

    private native void setUploadToMaster(int var1, boolean var2, boolean var3);

    private native void sync(int var1);

    public static native String getLastConnectedMsg();

    public static Account createAccount(int n, DataStore dataStore) {
        if (n == 0) {
            throw new NullPointerException();
        }
        Account account = null;
        switch (Account.getType(n)) {
            case 1: {
                account = new Pop3Account(n, dataStore);
                break;
            }
            case 2: {
                account = new ImapAccount(n, dataStore);
                break;
            }
            case 3: {
                account = new GroupWiseAccount(n, dataStore);
                break;
            }
            case 4: {
                account = new NntpAccount(n, dataStore);
                break;
            }
            case 7: {
                account = new CapAccount(n, dataStore);
            }
        }
        return account;
    }

    Account(int n, DataStore dataStore) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pAccount = n;
        this.owner = dataStore;
    }

    protected Account() {
    }

    public boolean canDelete() {
        return this.canDelete(this.pAccount);
    }

    public boolean canUploadToMaster() {
        return this.canUploadToMaster(this.pAccount);
    }

    public int getPointer() {
        return this.pAccount;
    }

    public String getEmailAddress() {
        return this.getEmailAddress(this.pAccount);
    }

    public String getFromText() {
        if (this.fromText == null) {
            this.fromText = this.getFromText(this.pAccount);
        }
        return this.fromText;
    }

    public boolean getIncludeInFullRetrieve() {
        return this.getIncludeInFullRetrieve(this.pAccount);
    }

    public String getIncomingServer() {
        return "";
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getName(this.pAccount);
        }
        return this.name;
    }

    public String getOrganization() {
        return this.getOrganization(this.pAccount);
    }

    public DataStore getParent() {
        return this.owner;
    }

    public String getReplyAddress() {
        return this.getReplyAddress(this.pAccount);
    }

    public int getType() {
        int n = Account.getType(this.pAccount);
        return n;
    }

    public boolean getUploadToMaster() {
        return this.getUploadToMaster(this.pAccount);
    }

    public String getUserId() {
        if (this.userId == null) {
            this.userId = this.getUserId(this.pAccount);
        }
        return this.userId;
    }

    public boolean isDefault() {
        return this.isDefault(this.pAccount);
    }

    public void setDefault() {
        this.setDefault(this.pAccount);
    }

    public void setEmailAddress(String string) {
        this.setEmailAddress(this.pAccount, string);
    }

    public void setFromText(String string) {
        this.setFromText(this.pAccount, string);
        this.fromText = null;
    }

    public void setIncludeInFullRetrieve(boolean bl) {
        this.setIncludeInFullRetrieve(this.pAccount, bl);
    }

    public void setName(String string) {
        this.setName(this.pAccount, string);
        this.name = null;
    }

    public void setOrganization(String string) {
        this.setOrganization(this.pAccount, string);
    }

    public void setReplyAddress(String string) {
        this.setReplyAddress(this.pAccount, string);
    }

    public void setUploadToMaster(boolean bl, boolean bl2) {
        this.setUploadToMaster(this.pAccount, bl, bl2);
    }

    public void sync() {
        this.sync(this.pAccount);
    }
}

