/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.folder.Folder;
import com.novell.gw.message.Note;
import java.util.Date;

public class Task
extends Note {
    public static final char MIN_CATEGORY = 'A';
    public static final char MAX_CATEGORY = 'Z';
    public static final int MIN_PRIORITY = 1;
    public static final int MAX_PRIORITY = 999;

    private static native int createItem(int var0, int var1) throws EngineException;

    private native long getAssignedDate(int var1);

    private native boolean setDueDate(int var1, long var2);

    private native int getTaskCategory(int var1);

    private native boolean setTaskCategory(int var1, char var2);

    private native int getTaskPriority(int var1);

    private native boolean setTaskPriority(int var1, int var2);

    private native int getNotifyWhenCompleted(int var1);

    private native boolean setNotifyWhenCompleted(int var1, int var2);

    public Task() {
    }

    Task(int n) {
        super(n);
    }

    public Task(DataStore dataStore) throws EngineException {
        this(dataStore, null);
    }

    public Task(DataStore dataStore, Folder folder) throws EngineException {
        this(Task.createItem(dataStore.getPointer(), folder != null ? folder.getPointer() : 0));
    }

    public Date getAssignedDate() {
        long l = this.getAssignedDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public boolean setDueDate(Date date) {
        long l = EngineUtils.DateToFlaimTime(date);
        boolean bl = this.setDueDate(this.pGWItem, l);
        return bl;
    }

    public char getTaskCategory() {
        return (char)this.getTaskCategory(this.pGWItem);
    }

    public boolean setTaskCategory(char c) {
        boolean bl = this.setTaskCategory(this.pGWItem, c);
        return bl;
    }

    public int getTaskPriority() {
        return this.getTaskPriority(this.pGWItem);
    }

    public boolean setTaskPriority(int n) {
        boolean bl = this.setTaskPriority(this.pGWItem, n);
        return bl;
    }

    public int getNotifyWhenCompleted() {
        int n = this.getNotifyWhenCompleted(this.pGWItem);
        return n;
    }

    public boolean setNotifyWhenCompleted(int n) {
        boolean bl = this.setNotifyWhenCompleted(this.pGWItem, n);
        return bl;
    }
}

