/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.notification;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.Item;
import com.novell.gw.folder.Folder;
import com.novell.gw.notification.NotifyEvent;
import com.novell.gw.notification.NotifyItem;
import com.novell.gw.notification.NotifyListener;
import com.novell.gw.util.Debug;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class Notify {
    private int pGWNotify = 0;
    private static Notify notify;
    private int pEvents = 0;
    private EventListenerList listenerList = new EventListenerList();

    private static native void initIds();

    private static native int getInstance(int var0);

    private native void enableNotifications(int var1, boolean var2);

    private native void dispose(int var1, int var2);

    private native int subscribeToEvents(int var1);

    private native void clearAllListItems(int var1);

    private native void clearListItem(int var1, int var2);

    private native boolean deleteItem(int var1, int var2);

    private native int[] getList(int var1);

    private native int readItem(int var1, int var2);

    private native void snoozeItem(int var1, int var2, int var3);

    private native int getNumMessages(int var1);

    private native int getNumAppointments(int var1);

    private native int getNumAlarms(int var1);

    private native int getNumReturnStatus(int var1);

    private native int[] getNotifyFolders(int var1, boolean var2);

    private native boolean setNotifyFolders(int var1, int[] var2);

    private native int getPollInterval(int var1, boolean var2);

    private native boolean isPollIntervalLocked(int var1);

    private native boolean setPollInterval(int var1, int var2);

    private native void setDialogTimeout(int var1, int var2);

    private native int getDialogTimeout(int var1, boolean var2);

    private native boolean isSameSettingsForAllNewItems(int var1, boolean var2);

    private native void setSameSettingsForAllNewItems(int var1, boolean var2);

    private native boolean isShowDialogOnNewItem(int var1, int var2, int var3, boolean var4);

    private native void setShowDialogOnNewItem(int var1, int var2, int var3, boolean var4);

    private native boolean isPlaySoundOnNewItem(int var1, int var2, int var3, boolean var4);

    private native void setPlaySoundOnNewItem(int var1, int var2, int var3, boolean var4);

    private native boolean isLaunchProgramOnNewItem(int var1, int var2, int var3, boolean var4);

    private native void setLaunchProgramOnNewItem(int var1, int var2, int var3, boolean var4);

    private native String getSoundForNewItem(int var1, int var2, int var3, boolean var4);

    private native void setSoundForNewItem(int var1, int var2, int var3, String var4);

    private native String getLaunchProgramForNewItem(int var1, int var2, int var3, boolean var4);

    private native void setLaunchProgramForNewItem(int var1, int var2, int var3, String var4);

    private native boolean isShowDialogOnAlarm(int var1, boolean var2);

    private native void setShowDialogOnAlarm(int var1, boolean var2);

    private native boolean isPlaySoundOnAlarm(int var1, boolean var2);

    private native void setPlaySoundOnAlarm(int var1, boolean var2);

    private native boolean isLaunchProgramOnAlarm(int var1, boolean var2);

    private native void setLaunchProgramOnAlarm(int var1, boolean var2);

    private native String getSoundForAlarm(int var1, boolean var2);

    private native void setSoundForAlarm(int var1, String var2);

    private native String getLaunchProgramForAlarm(int var1, boolean var2);

    private native void setLaunchProgramForAlarm(int var1, String var2);

    private native boolean isSameSettingsForAllStatus(int var1, boolean var2);

    private native void setSameSettingsForAllStatus(int var1, boolean var2);

    public static Notify getInstance(DataStore dataStore) {
        if (notify == null) {
            notify = new Notify(Notify.getInstance(dataStore.getPointer()));
        }
        return notify;
    }

    public void enableNotifications(boolean bl) {
        this.enableNotifications(this.pGWNotify, bl);
    }

    public void addNotifyListener(NotifyListener notifyListener) {
        this.listenerList.add(NotifyListener.class, notifyListener);
    }

    public void removeNotifyListener(NotifyListener notifyListener) {
        this.listenerList.remove(NotifyListener.class, notifyListener);
    }

    private Notify(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWNotify = n;
        this.pEvents = this.subscribeToEvents(n);
    }

    public void clearAllListItems() {
        this.clearAllListItems(this.pGWNotify);
    }

    public void clearListItem(NotifyItem notifyItem) {
        this.clearListItem(this.pGWNotify, notifyItem.getPointer());
    }

    public boolean deleteItem(NotifyItem notifyItem) {
        return this.deleteItem(this.pGWNotify, notifyItem.getPointer());
    }

    public NotifyItem[] getList() {
        int[] nArray = this.getList(this.pGWNotify);
        int n = nArray != null ? nArray.length : 0;
        NotifyItem[] notifyItemArray = new NotifyItem[n];
        for (int i = 0; i < n; ++i) {
            notifyItemArray[i] = new NotifyItem(nArray[i]);
        }
        return notifyItemArray;
    }

    public Item readItem(NotifyItem notifyItem) {
        int n = this.readItem(this.pGWNotify, notifyItem.getPointer());
        return Item.createItem(n);
    }

    public void snoozeItem(NotifyItem notifyItem, int n) {
        this.snoozeItem(this.pGWNotify, notifyItem.getPointer(), n);
    }

    public int getNumMessages() {
        return this.getNumMessages(this.pGWNotify);
    }

    public int getNumAppointments() {
        return this.getNumAppointments(this.pGWNotify);
    }

    public int getNumAlarms() {
        return this.getNumAlarms(this.pGWNotify);
    }

    public int getNumReturnStatus() {
        return this.getNumReturnStatus(this.pGWNotify);
    }

    public Folder[] getNotifyFolders() {
        return this.getNotifyFolders(false);
    }

    public Folder[] getNotifyFolders(boolean bl) {
        int[] nArray = this.getNotifyFolders(this.pGWNotify, bl);
        int n = nArray != null ? nArray.length : 0;
        Folder[] folderArray = new Folder[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                folderArray[i] = DataStore.getFolder(nArray[i]);
            }
        }
        return folderArray;
    }

    public boolean setNotifyFolders(Folder[] folderArray) {
        return this.setNotifyFolders(this.pGWNotify, Folder.getPointers(folderArray));
    }

    public int getPollInterval() {
        return this.getPollInterval(this.pGWNotify, false);
    }

    public int getPollInterval(boolean bl) {
        return this.getPollInterval(this.pGWNotify, bl);
    }

    public boolean isPollIntervalLocked() {
        return this.isPollIntervalLocked(this.pGWNotify);
    }

    public boolean setPollInterval(int n) {
        return this.setPollInterval(this.pGWNotify, n);
    }

    public void setDialogTimeout(int n) {
        this.setDialogTimeout(this.pGWNotify, n);
    }

    public int getDialogTimeout() {
        return this.getDialogTimeout(this.pGWNotify, false);
    }

    public int getDialogTimeout(boolean bl) {
        return this.getDialogTimeout(this.pGWNotify, bl);
    }

    public boolean isSameSettingsForAllNewItems() {
        return this.isSameSettingsForAllNewItems(this.pGWNotify, false);
    }

    public boolean isSameSettingsForAllNewItems(boolean bl) {
        return this.isSameSettingsForAllNewItems(this.pGWNotify, bl);
    }

    public void setSameSettingsForAllNewItems(boolean bl) {
        this.setSameSettingsForAllNewItems(this.pGWNotify, bl);
    }

    public boolean isShowDialogOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType) {
        return this.isShowDialogOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), false);
    }

    public boolean isShowDialogOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        return this.isShowDialogOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public void setShowDialogOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        this.setShowDialogOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public boolean isPlaySoundOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType) {
        return this.isPlaySoundOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), false);
    }

    public boolean isPlaySoundOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        return this.isPlaySoundOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public void setPlaySoundOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        this.setPlaySoundOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public boolean isLaunchProgramOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType) {
        return this.isLaunchProgramOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), false);
    }

    public boolean isLaunchProgramOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        return this.isLaunchProgramOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public void setLaunchProgramOnNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        this.setLaunchProgramOnNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public String getSoundForNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType) {
        return this.getSoundForNewItem(this.pGWNotify, notifyType.value(), statusType.value(), false);
    }

    public String getSoundForNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        return this.getSoundForNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public void setSoundForNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, String string) {
        this.setSoundForNewItem(this.pGWNotify, notifyType.value(), statusType.value(), string);
    }

    public String getLaunchProgramForNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType) {
        return this.getLaunchProgramForNewItem(this.pGWNotify, notifyType.value(), statusType.value(), false);
    }

    public String getLaunchProgramForNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, boolean bl) {
        return this.getLaunchProgramForNewItem(this.pGWNotify, notifyType.value(), statusType.value(), bl);
    }

    public void setLaunchProgramForNewItem(NotifyItem.NotifyType notifyType, NotifyItem.StatusType statusType, String string) {
        this.setLaunchProgramForNewItem(this.pGWNotify, notifyType.value(), statusType.value(), string);
    }

    public boolean isShowDialogOnAlarm() {
        return this.isShowDialogOnAlarm(this.pGWNotify, false);
    }

    public boolean isShowDialogOnAlarm(boolean bl) {
        return this.isShowDialogOnAlarm(this.pGWNotify, bl);
    }

    public void setShowDialogOnAlarm(boolean bl) {
        this.setShowDialogOnAlarm(this.pGWNotify, bl);
    }

    public boolean isPlaySoundOnAlarm() {
        return this.isPlaySoundOnAlarm(this.pGWNotify, false);
    }

    public boolean isPlaySoundOnAlarm(boolean bl) {
        return this.isPlaySoundOnAlarm(this.pGWNotify, bl);
    }

    public void setPlaySoundOnAlarm(boolean bl) {
        this.setPlaySoundOnAlarm(this.pGWNotify, bl);
    }

    public boolean isLaunchProgramOnAlarm() {
        return this.isLaunchProgramOnAlarm(this.pGWNotify, false);
    }

    public boolean isLaunchProgramOnAlarm(boolean bl) {
        return this.isLaunchProgramOnAlarm(this.pGWNotify, bl);
    }

    public void setLaunchProgramOnAlarm(boolean bl) {
        this.setLaunchProgramOnAlarm(this.pGWNotify, bl);
    }

    public String getSoundForAlarm() {
        return this.getSoundForAlarm(this.pGWNotify, false);
    }

    public String getSoundForAlarm(boolean bl) {
        return this.getSoundForAlarm(this.pGWNotify, bl);
    }

    public void setSoundForAlarm(String string) {
        this.setSoundForAlarm(this.pGWNotify, string);
    }

    public String getLaunchProgramForAlarm() {
        return this.getLaunchProgramForAlarm(this.pGWNotify, false);
    }

    public String getLaunchProgramForAlarm(boolean bl) {
        return this.getLaunchProgramForAlarm(this.pGWNotify, bl);
    }

    public void setLaunchProgramForAlarm(String string) {
        this.setLaunchProgramForAlarm(this.pGWNotify, string);
    }

    public boolean isSameSettingsForAllStatus() {
        return this.isSameSettingsForAllStatus(this.pGWNotify, false);
    }

    public boolean isSameSettingsForAllStatus(boolean bl) {
        return this.isSameSettingsForAllStatus(this.pGWNotify, bl);
    }

    public void setSameSettingsForAllStatus(boolean bl) {
        this.setSameSettingsForAllStatus(this.pGWNotify, bl);
    }

    private void notifyEvent(int n, int n2) {
        Debug.trace("NotifyEvent[" + this.pGWNotify + "].NOTIFY_EVENT: " + n + ", pGWNotifyItem: " + n2);
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final NotifyEvent notifyEvent = new NotifyEvent(this, n, n2 != 0 ? new NotifyItem(n2) : null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Notify.this.doNotifyEvent(objectArray, notifyEvent);
                }
            });
        }
    }

    private void doNotifyEvent(Object[] objectArray, NotifyEvent notifyEvent) {
        for (int i = 1; i < objectArray.length; i += 2) {
            NotifyListener notifyListener = (NotifyListener)objectArray[i];
            notifyListener.notification(notifyEvent);
        }
    }

    public void dispose() {
        if (this.pGWNotify != 0 || this.pEvents != 0) {
            this.dispose(this.pGWNotify, this.pEvents);
            this.pGWNotify = 0;
            this.pEvents = 0;
        }
        notify = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    static {
        Notify.initIds();
        notify = null;
    }
}

