/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.notification;

import com.novell.gw.ab.Addressable;
import com.novell.gw.notification.NotifySubscribeEntry;
import java.util.ArrayList;

public class NotifySubscribeList {
    protected ArrayList entryList;
    private int pList = 0;

    private native int add(int var1, String var2, String var3, String var4, String var5, String var6, String var7);

    private native int addEntry(int var1, int var2);

    private native int addAddressable(int var1, int var2);

    private native boolean remove(int var1, int var2);

    private native int get(int var1, int var2);

    private native int getSize(int var1);

    private native void commit(int var1);

    private native void dispose(int var1);

    public NotifySubscribeList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pList = n;
        this.readEntries();
    }

    public int size() {
        if (this.entryList == null) {
            return 0;
        }
        return this.entryList.size();
    }

    public int add(NotifySubscribeEntry notifySubscribeEntry) {
        int n = this.getSize(this.pList);
        int n2 = this.addEntry(this.pList, notifySubscribeEntry.getPointer());
        if (n2 >= 0 && this.getSize(this.pList) > n) {
            this.entryList.add(n2, notifySubscribeEntry);
        }
        return n2;
    }

    public int add(String string, String string2, String string3, String string4, String string5, String string6) {
        int n = this.getSize(this.pList);
        int n2 = this.add(this.pList, string, string2, string3, string4, string5, string6);
        if (n2 >= 0 && this.getSize(this.pList) > n) {
            int n3 = this.get(this.pList, n2);
            NotifySubscribeEntry notifySubscribeEntry = new NotifySubscribeEntry(n3);
            this.entryList.add(n2, notifySubscribeEntry);
        }
        return n2;
    }

    public int add(Addressable addressable) {
        int n = this.getSize(this.pList);
        int n2 = this.addAddressable(this.pList, addressable.getAddressablePointer());
        if (n2 >= 0 && this.getSize(this.pList) > n) {
            int n3 = this.get(this.pList, n2);
            NotifySubscribeEntry notifySubscribeEntry = new NotifySubscribeEntry(n3);
            this.entryList.add(n2, notifySubscribeEntry);
        }
        return n2;
    }

    public boolean remove(int n) {
        boolean bl = this.remove(this.pList, n);
        if (bl) {
            this.entryList.remove(n);
        }
        return bl;
    }

    public NotifySubscribeEntry get(int n) {
        if (n < this.entryList.size()) {
            return (NotifySubscribeEntry)this.entryList.get(n);
        }
        return null;
    }

    private void readEntries() {
        if (this.entryList == null) {
            int n = 0;
            NotifySubscribeEntry notifySubscribeEntry = null;
            int n2 = this.getSize(this.pList);
            this.entryList = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                n = this.get(this.pList, i);
                notifySubscribeEntry = n != 0 ? new NotifySubscribeEntry(n) : null;
                this.entryList.add(i, notifySubscribeEntry);
            }
        }
    }

    public void commit() {
        this.commit(this.pList);
    }

    public void cancel() {
        this.dispose();
    }

    public void dispose() {
        this.entryList = null;
        this.dispose(this.pList);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

