/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ab;

import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.AddressBookEvent;
import com.novell.gw.ab.AddressBookEventListener;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.ab.SystemAddressBook;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ItemList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class AddressBookManager {
    private int pGWAddressBookManager;
    private int pEventSink;
    private SystemAddressBook sab;
    private PABArrayList pabs;
    private HashMap pabCache = new HashMap();
    private EventListenerList listenerList = new EventListenerList();

    private native String buildDisplayName(int var1, String var2, String var3, int var4);

    private native int createAddressBook(int var1, String var2) throws EngineException;

    private native void deleteAddressBook(int var1, int var2) throws EngineException;

    private native void dispose(int var1, int var2);

    private native void disposeNativePABArray(int[] var1);

    private native int findContactByEmail(int var1, String var2) throws EngineException;

    private native int findContactByName(int var1, String var2) throws EngineException;

    private native int findContactsByName(int var1, String var2) throws EngineException;

    private native int getContact(int var1, int var2, int var3);

    private native int getFrequentContactsBook(int var1);

    private native int getPersonalAddressBook(int var1, int var2);

    private native int[] getPersonalAddressBooks(int var1);

    private native int[] getSearchOrder(int var1);

    private native int getSystemAddressBook(int var1);

    private native int registerForEvents(int var1);

    private native void setSearchOrder(int var1, int[] var2);

    private native void setNameFormat(int var1, int var2) throws EngineException;

    public static native String getPropertyLabel(int var0);

    public static native int getPropertyType(int var0);

    public AddressBookManager(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWAddressBookManager = n;
        this.pEventSink = this.registerForEvents(n);
    }

    private void initPersonalAddressBooks() {
        int[] nArray;
        if (this.pabs == null && (nArray = this.getPersonalAddressBooks(this.pGWAddressBookManager)) != null) {
            this.pabs = new PABArrayList(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                this.pabs.add(new Integer(nArray[i]));
            }
        }
    }

    private AddressBook getCachedAB(int n) {
        AddressBook addressBook = null;
        if (n != 0 && (addressBook = (AddressBook)this.pabCache.get(new Integer(n))) == null) {
            if (AddressBook.isSystemBook(n)) {
                addressBook = this.getSystemAddressBook();
            } else {
                addressBook = new PersonalAddressBook(n);
                if (addressBook != null) {
                    this.pabCache.put(new Integer(n), addressBook);
                }
            }
        }
        return addressBook;
    }

    public void addAddressBookEventListener(AddressBookEventListener addressBookEventListener) {
        this.listenerList.add(AddressBookEventListener.class, addressBookEventListener);
    }

    public void removeAddressBookEventListener(AddressBookEventListener addressBookEventListener) {
        this.listenerList.remove(AddressBookEventListener.class, addressBookEventListener);
    }

    private void fireEvent(int n, int n2) {
        switch (n) {
            case 1: {
                this.bookCreated(n2);
                break;
            }
            case 2: {
                this.bookDeleted(n2);
            }
        }
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final AddressBookEvent addressBookEvent = new AddressBookEvent(this, n, n2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddressBookManager.this.doFireEvent(objectArray, addressBookEvent);
                }
            });
        }
    }

    private void doFireEvent(Object[] objectArray, AddressBookEvent addressBookEvent) {
        for (int i = 1; i < objectArray.length; i += 2) {
            AddressBookEventListener addressBookEventListener = (AddressBookEventListener)objectArray[i];
            addressBookEventListener.bookChanged(addressBookEvent);
        }
    }

    private void bookCreated(int n) {
        this.pabs = null;
    }

    private void bookDeleted(int n) {
        this.pabs = null;
    }

    public int getPointer() {
        return this.pGWAddressBookManager;
    }

    public SystemAddressBook getSystemAddressBook() {
        int n;
        if (this.sab == null && (n = this.getSystemAddressBook(this.pGWAddressBookManager)) != 0) {
            this.sab = new SystemAddressBook(n);
        }
        return this.sab;
    }

    public PersonalAddressBook[] getPersonalAddressBooks() {
        this.initPersonalAddressBooks();
        PersonalAddressBook[] personalAddressBookArray = null;
        if (this.pabs != null) {
            personalAddressBookArray = new PersonalAddressBook[this.pabs.size()];
            for (int i = 0; i < personalAddressBookArray.length; ++i) {
                personalAddressBookArray[i] = (PersonalAddressBook)this.getCachedAB((Integer)this.pabs.get(i));
            }
        }
        return personalAddressBookArray;
    }

    public int getPersonalAddressBooksCount() {
        int n = 0;
        for (PersonalAddressBook personalAddressBook : this.pabs) {
            ++n;
        }
        return n;
    }

    public Iterator getPersonalAddressBooksIterator() {
        this.initPersonalAddressBooks();
        return this.pabs.iterator();
    }

    public PersonalAddressBook getPersonalAddressBook(int n) {
        this.initPersonalAddressBooks();
        PersonalAddressBook personalAddressBook = null;
        int n2 = this.getPersonalAddressBook(this.pGWAddressBookManager, n);
        if (n2 != 0) {
            personalAddressBook = (PersonalAddressBook)this.getCachedAB(n2);
        }
        return personalAddressBook;
    }

    public PersonalAddressBook getFrequentContactsBook() {
        this.initPersonalAddressBooks();
        PersonalAddressBook personalAddressBook = null;
        int n = this.getFrequentContactsBook(this.pGWAddressBookManager);
        if (n != 0) {
            personalAddressBook = (PersonalAddressBook)this.getCachedAB(n);
        }
        return personalAddressBook;
    }

    public AddressBook getAddressBook(int n) {
        AddressBook addressBook = null;
        addressBook = n == 0 ? this.getSystemAddressBook() : this.getPersonalAddressBook(n);
        return addressBook;
    }

    public PersonalAddressBook createAddressBook(String string) throws EngineException {
        PersonalAddressBook personalAddressBook = null;
        int n = this.createAddressBook(this.pGWAddressBookManager, string);
        if (n != 0) {
            personalAddressBook = (PersonalAddressBook)this.getCachedAB(n);
        }
        return personalAddressBook;
    }

    public void deleteAddressBook(PersonalAddressBook personalAddressBook) throws EngineException {
        if (personalAddressBook != null) {
            this.deleteAddressBook(this.pGWAddressBookManager, personalAddressBook.getPointer());
        }
    }

    public Contact getContact(int n, int n2) throws EngineException {
        Contact contact = null;
        int n3 = this.getContact(this.pGWAddressBookManager, n, n2);
        if (n3 != 0) {
            contact = Contact.createContact(n3);
        }
        return contact;
    }

    public AddressBook[] getSearchOrder() {
        AddressBook[] addressBookArray = null;
        int[] nArray = this.getSearchOrder(this.pGWAddressBookManager);
        if (nArray != null && nArray.length > 0) {
            addressBookArray = new AddressBook[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                addressBookArray[i] = this.getCachedAB(nArray[i]);
                if (!(addressBookArray[i] instanceof SystemAddressBook)) continue;
                nArray[i] = 0;
            }
        }
        this.disposeNativePABArray(nArray);
        return addressBookArray;
    }

    public void setSearchOrder(AddressBook[] addressBookArray) {
        int[] nArray = null;
        if (addressBookArray != null && addressBookArray.length > 0) {
            nArray = new int[addressBookArray.length];
            for (int i = 0; i < addressBookArray.length; ++i) {
                nArray[i] = addressBookArray[i].getPointer();
            }
        }
        this.setSearchOrder(this.pGWAddressBookManager, nArray);
    }

    public ItemList findContactsByName(String string) throws EngineException {
        ItemList itemList = null;
        int n = this.findContactsByName(this.pGWAddressBookManager, string);
        if (n != 0) {
            itemList = ItemList.createItemList(n);
        }
        return itemList;
    }

    public Contact findContactByName(String string) throws EngineException {
        Contact contact = null;
        int n = this.findContactByName(this.pGWAddressBookManager, string);
        if (n != 0) {
            contact = Contact.createContact(n);
        }
        return contact;
    }

    public Contact findContactByEmail(String string) throws EngineException {
        Contact contact = null;
        int n = this.findContactByEmail(this.pGWAddressBookManager, string);
        if (n != 0) {
            contact = Contact.createContact(n);
        }
        return contact;
    }

    public String buildDisplayName(String string, String string2) {
        return this.buildDisplayName(string, string2, 0);
    }

    public String buildDisplayName(String string, String string2, int n) {
        return this.buildDisplayName(this.pGWAddressBookManager, string, string2, n);
    }

    public void setNameFormat(int n) throws EngineException {
        this.setNameFormat(this.pGWAddressBookManager, n);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.pGWAddressBookManager != 0) {
            this.dispose(this.pGWAddressBookManager, this.pEventSink);
            this.pGWAddressBookManager = 0;
            this.pEventSink = 0;
        }
    }

    private class PABArrayList
    extends ArrayList {
        public PABArrayList(int n) {
            super(n);
        }

        public Iterator iterator() {
            return new PABIterator();
        }

        static /* synthetic */ int access$100(PABArrayList pABArrayList) {
            return pABArrayList.modCount;
        }

        private class PABIterator
        implements Iterator {
            int cursor = 0;
            int lastRet = -1;
            int expectedModCount = PABArrayList.access$100(PABArrayList.this);

            private PABIterator() {
            }

            public boolean hasNext() {
                return this.cursor != PABArrayList.this.size();
            }

            public Object next() {
                this.checkForComodification();
                try {
                    AddressBook addressBook = AddressBookManager.this.getCachedAB((Integer)PABArrayList.this.get(this.cursor));
                    this.lastRet = this.cursor++;
                    return addressBook;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    PABArrayList.this.remove(this.lastRet);
                    if (this.lastRet < this.cursor) {
                        --this.cursor;
                    }
                    this.lastRet = -1;
                    this.expectedModCount = PABArrayList.this.modCount;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new ConcurrentModificationException();
                }
            }

            final void checkForComodification() {
                if (PABArrayList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }
}

