/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.account;

import com.novell.gw.account.AccountFolderEvent;
import com.novell.gw.account.AccountFolderListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class AccountFolderList {
    private int pList = 0;
    private int pEvents = 0;
    private EventListenerList listenerList = new EventListenerList();

    private static native void initIds();

    private native String getFolderName(int var1, int var2);

    private native String getFolderShortName(int var1, int var2);

    private native int getNumFolders(int var1);

    private native int getSize(int var1, int var2);

    private native boolean isPostingAllowed(int var1, int var2);

    private native boolean isSubscribed(int var1, int var2);

    private native void setVisibleRange(int var1, int var2, int var3);

    private native void releaseEvents(int var1, int var2);

    private native boolean subscribe(int var1, int var2, int var3);

    private native int subscribeToEvents(int var1);

    private native boolean unsubscribe(int var1, int var2);

    private native void dispose(int var1);

    AccountFolderList(int n) {
        this.pList = n;
        this.pEvents = this.subscribeToEvents(n);
    }

    public void addAccountFolderListener(AccountFolderListener accountFolderListener) {
        this.listenerList.add(AccountFolderListener.class, accountFolderListener);
    }

    public void removeAccountFolderListener(AccountFolderListener accountFolderListener) {
        this.listenerList.remove(AccountFolderListener.class, accountFolderListener);
    }

    public String getFolderName(int n) {
        return this.getFolderName(this.pList, n);
    }

    public String getFolderShortName(int n) {
        return this.getFolderShortName(this.pList, n);
    }

    public int getNumFolders() {
        int n = this.getNumFolders(this.pList);
        return n;
    }

    public int getSize(int n) {
        int n2 = this.getSize(this.pList, n);
        return n2;
    }

    public boolean isPostingAllowed(int n) {
        return this.isPostingAllowed(this.pList, n);
    }

    public boolean isSubscribed(int n) {
        return this.isSubscribed(this.pList, n);
    }

    public void setVisibleRange(int n, int n2) {
        this.setVisibleRange(this.pList, n, n2);
    }

    public boolean subscribe(int n, int n2) {
        return this.subscribe(this.pList, n, n2);
    }

    public boolean unsubscribe(int n) {
        return this.unsubscribe(this.pList, n);
    }

    public void dispose() {
        this.releaseEvents(this.pList, this.pEvents);
        this.dispose(this.pList);
        this.pEvents = 0;
        this.pList = 0;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void updateSize(int n) {
        this.fireAccountFolderEvent(n);
    }

    private void fireAccountFolderEvent(int n) {
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final AccountFolderEvent accountFolderEvent = new AccountFolderEvent(this, 0, n);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AccountFolderList.this.doFireFolderEvent(objectArray, accountFolderEvent);
                }
            });
        }
    }

    private void doFireFolderEvent(Object[] objectArray, AccountFolderEvent accountFolderEvent) {
        for (int i = 1; i < objectArray.length; i += 2) {
            AccountFolderListener accountFolderListener = (AccountFolderListener)objectArray[i];
            accountFolderListener.updateSize(accountFolderEvent);
        }
    }

    static {
        AccountFolderList.initIds();
    }
}

