/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.engine.Category;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.ItemListFilter;
import java.util.Date;

public class Filter {
    public static final int ROW_OP_AND = 0;
    public static final int ROW_OP_OR = 1;
    public static final int ROW_OP_END = 2;
    public static final int ROW_OP_NEW_GROUP = 3;
    public static final int GROUP_OP_AND = 0;
    public static final int GROUP_OP_OR = 1;
    public static final int VALUE_TYPE_CONSTANTS_LIST = 1;
    public static final int VALUE_TYPE_STRING = 2;
    public static final int VALUE_TYPE_DATE = 3;
    public static final int VALUE_TYPE_RELATIVE_DATE = 4;
    public static final int VALUE_TYPE_RELATIVE_DATE2 = 5;
    public static final int VALUE_TYPE_CATEGORY = 7;
    private int pGWFilter = 0;
    private int iTmpId = 0;
    private long lTmpDate = 0L;
    private int iTmpDateOffset = 0;
    private String sTmpStrValue = null;
    private int iTmpValueType = -1;
    private int iTmp_pGWCategory = 0;

    private static native void initIds();

    private static native int create(int var0, boolean var1);

    private static native int create(int var0, int var1, boolean var2);

    private native void dispose(int var1);

    private native int addRow(int var1, int var2, int var3, int var4, int var5, long var6, int var8, String var9, int var10, int var11);

    private native int addRowGroup(int var1, int var2);

    private native int getAllValidFields(int var1);

    private native int getGroupOperator(int var1, int var2);

    private native int getRecentlyUsedFields(int var1);

    private native int getRowCount(int var1);

    private native boolean getRowField(int var1, int var2);

    private native boolean getFieldOperator(int var1, int var2);

    private native boolean getRowValue(int var1, int var2);

    private native int getRowOperator(int var1, int var2);

    private native int getValidOperators(int var1, int var2);

    private native int getValidValueType(int var1, int var2, int var3);

    private native boolean isGroup(int var1, int var2);

    private native String generateDescription(int var1);

    private native void render(int var1);

    private native boolean canShowAsSimple(int var1, int var2);

    private native String fdGetDisplayText(int var1);

    private native int fdGetId(int var1);

    private native void fdlDispose(int var1);

    private native int[] fdlGetItems(int var1);

    public Filter() {
    }

    public Filter(DataStore dataStore) {
        this(dataStore, false);
    }

    public Filter(DataStore dataStore, boolean bl) {
        this(Filter.create(dataStore != null ? dataStore.getPointer() : 0, bl));
    }

    public Filter(DataStore dataStore, ItemListFilter itemListFilter, boolean bl) {
        this(Filter.create(dataStore != null ? dataStore.getPointer() : 0, itemListFilter != null ? itemListFilter.getPointer() : 0, bl));
    }

    public Filter(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWFilter = n;
    }

    public int addRow(int n, int n2, int n3, FilterValue filterValue, int n4) {
        Category category = filterValue.getCategory();
        return this.addRow(this.pGWFilter, n, n2, n3, filterValue.getId(), EngineUtils.DateToFlaimTime(filterValue.getDate()), filterValue.getDateOffset(), filterValue.getStringValue(), category != null ? category.getPointer() : 0, n4);
    }

    public int addRow(RowInfo rowInfo) {
        return this.addRow(rowInfo.getField().getId(), rowInfo.getOperator().getId(), rowInfo.getValue().getType(), rowInfo.getValue().getValue(), rowInfo.getRowOperator());
    }

    public int addRowGroup(int n) {
        return this.addRowGroup(this.pGWFilter, n);
    }

    public int getRowCount() {
        return this.getRowCount(this.pGWFilter);
    }

    public RowInfo getRow(int n) {
        RowInfo rowInfo = null;
        FilterData filterData = null;
        FilterData filterData2 = null;
        ValueInfo valueInfo = null;
        int n2 = -1;
        filterData = this.getRowField(n);
        if (filterData != null) {
            filterData2 = this.getFieldOperator(n);
        }
        if (filterData2 != null) {
            valueInfo = this.getRowValue(n);
        }
        if (valueInfo != null) {
            n2 = this.getRowOperator(n);
        }
        if (n2 != -1) {
            rowInfo = new RowInfo(filterData, filterData2, valueInfo, n2);
        }
        return rowInfo;
    }

    public FilterData getRowField(int n) {
        FilterData filterData = null;
        this.iTmpId = 0;
        this.sTmpStrValue = null;
        boolean bl = this.getRowField(this.pGWFilter, n);
        if (bl) {
            filterData = new FilterData(this.iTmpId, this.sTmpStrValue);
        }
        return filterData;
    }

    public FilterData getFieldOperator(int n) {
        FilterData filterData = null;
        this.iTmpId = 0;
        this.sTmpStrValue = null;
        boolean bl = this.getFieldOperator(this.pGWFilter, n);
        if (bl) {
            filterData = new FilterData(this.iTmpId, this.sTmpStrValue);
        }
        return filterData;
    }

    public ValueInfo getRowValue(int n) {
        ValueInfo valueInfo = null;
        this.iTmpId = 0;
        this.lTmpDate = 0L;
        this.iTmpDateOffset = 0;
        this.sTmpStrValue = null;
        this.iTmpValueType = 0;
        this.iTmp_pGWCategory = 0;
        boolean bl = this.getRowValue(this.pGWFilter, n);
        if (bl) {
            valueInfo = new ValueInfo(this.iTmpValueType, new FilterValue(this.iTmpId, EngineUtils.flaimTimeToDate(this.lTmpDate), this.iTmpDateOffset, this.sTmpStrValue, Category.create(this.iTmp_pGWCategory)));
        }
        return valueInfo;
    }

    public int getRowOperator(int n) {
        return this.getRowOperator(this.pGWFilter, n);
    }

    public int getGroupOperator(int n) {
        return this.getGroupOperator(this.pGWFilter, n);
    }

    public boolean isGroup(int n) {
        return this.isGroup(this.pGWFilter, n);
    }

    private FilterData[] fillList(int n) {
        FilterData[] filterDataArray = null;
        if (n != 0) {
            int[] nArray = this.fdlGetItems(n);
            if (nArray != null && nArray.length > 0) {
                filterDataArray = new FilterData[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    filterDataArray[i] = new FilterData(nArray[i]);
                }
            }
            this.fdlDispose(n);
        }
        return filterDataArray;
    }

    public FilterData[] getAllValidFields() {
        return this.fillList(this.getAllValidFields(this.pGWFilter));
    }

    public FilterData[] getRecentlyUsedFields() {
        return this.fillList(this.getRecentlyUsedFields(this.pGWFilter));
    }

    public FilterData[] getValidOperators(int n) {
        return this.fillList(this.getValidOperators(this.pGWFilter, n));
    }

    public ValidValueType getValidValueType(int n, int n2) {
        ValidValueType validValueType = null;
        this.iTmpValueType = -1;
        FilterData[] filterDataArray = this.fillList(this.getValidValueType(this.pGWFilter, n, n2));
        if (this.iTmpValueType != -1) {
            validValueType = new ValidValueType(this.iTmpValueType, filterDataArray);
        }
        return validValueType;
    }

    public String generateDescription() {
        String string = this.generateDescription(this.pGWFilter);
        return string;
    }

    public boolean canShowAsSimple(DataStore dataStore) {
        int n = dataStore.getPointer();
        return this.canShowAsSimple(this.pGWFilter, n);
    }

    public void render() {
        this.render(this.pGWFilter);
    }

    public int getPointer() {
        return this.pGWFilter;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.pGWFilter != 0) {
            this.dispose(this.pGWFilter);
            this.pGWFilter = 0;
        }
    }

    static {
        Filter.initIds();
    }

    public class RowInfo {
        private FilterData field = null;
        private FilterData operator = null;
        private ValueInfo value = null;
        private int rowOperator = 0;

        public RowInfo() {
        }

        public RowInfo(FilterData filterData, FilterData filterData2, ValueInfo valueInfo, int n) {
            this.field = filterData;
            this.operator = filterData2;
            this.value = valueInfo;
            this.rowOperator = n;
        }

        public FilterData getField() {
            return this.field;
        }

        public FilterData getOperator() {
            return this.operator;
        }

        public ValueInfo getValue() {
            return this.value;
        }

        public int getRowOperator() {
            return this.rowOperator;
        }
    }

    public class ValueInfo {
        private int type = 0;
        private FilterValue value = null;

        public ValueInfo() {
        }

        public ValueInfo(int n, FilterValue filterValue) {
            this.type = n;
            this.value = filterValue;
        }

        public int getType() {
            return this.type;
        }

        public FilterValue getValue() {
            return this.value;
        }
    }

    public class ValidValueType {
        private int type = 0;
        private FilterData[] validValues = null;

        public ValidValueType() {
        }

        private ValidValueType(int n, FilterData[] filterDataArray) {
            this.type = n;
            this.validValues = filterDataArray;
        }

        public int getType() {
            return this.type;
        }

        public FilterData[] getValidValues() {
            return this.validValues;
        }
    }

    public class FilterValue {
        private int id = 0;
        private Date date = null;
        private int dateOffset = 0;
        private String stringValue = null;
        private Category category = null;

        public FilterValue() {
        }

        private FilterValue(int n, Date date, int n2, String string, Category category) {
            this.id = n;
            this.date = date;
            this.dateOffset = n2;
            this.stringValue = string;
            this.category = category;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int n) {
            this.id = n;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public int getDateOffset() {
            return this.dateOffset;
        }

        public void setDateOffset(int n) {
            this.dateOffset = n;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String string) {
            this.stringValue = string;
        }

        public Category getCategory() {
            return this.category;
        }

        public void setCategory(Category category) {
            this.category = category;
        }
    }

    public class FilterData {
        private int id = 0;
        private String displayText = null;

        public FilterData() {
        }

        public FilterData(int n, String string) {
            this.id = n;
            this.displayText = string;
        }

        private FilterData(int n) {
            if (n == 0) {
                throw new NullPointerException();
            }
            this.id = Filter.this.fdGetId(n);
            this.displayText = Filter.this.fdGetDisplayText(n);
        }

        public int getId() {
            return this.id;
        }

        public void setId(int n) {
            this.id = n;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void setDisplayText(String string) {
            this.displayText = string;
        }
    }
}

