/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.folder;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;
import com.novell.gw.folder.FolderAccessRights;

public class FolderSharedEntry {
    private int pGWFolderSharedEntry = 0;
    private Addressable addressable;
    private FolderAccessRights accessRights;

    private static native int create(int var0, int var1);

    private native void dispose(int var1);

    private native int getAccessRights(int var1);

    private native int getAddressable(int var1);

    private native String getName(int var1);

    private native String getStatus(int var1);

    public FolderSharedEntry() {
        this.addressable = null;
        this.accessRights = null;
    }

    public FolderSharedEntry(Addressable addressable, FolderAccessRights folderAccessRights) {
        this(FolderSharedEntry.create(addressable.getAddressablePointer(), folderAccessRights.getPointer()));
        if (!(addressable instanceof Address)) {
            this.addressable = addressable;
        }
    }

    FolderSharedEntry(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWFolderSharedEntry = n;
    }

    public FolderAccessRights getAccessRights() {
        if (this.accessRights == null) {
            this.accessRights = new FolderAccessRights(this.pGWFolderSharedEntry, this.getAccessRights(this.pGWFolderSharedEntry));
        }
        return this.accessRights;
    }

    public Addressable getAddressable() {
        if (this.addressable == null) {
            this.addressable = new Address(this.getAddressable(this.pGWFolderSharedEntry));
        }
        return this.addressable;
    }

    public String getName() {
        return this.getName(this.pGWFolderSharedEntry);
    }

    public int getPointer() {
        return this.pGWFolderSharedEntry;
    }

    public String getStatus() {
        return this.getStatus(this.pGWFolderSharedEntry);
    }

    public void dispose() {
        if (this.pGWFolderSharedEntry != 0) {
            this.dispose(this.pGWFolderSharedEntry);
            this.pGWFolderSharedEntry = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

