/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.engine.EngineUtils;
import com.novell.gw.message.MessageAttachment;
import java.io.File;
import java.util.Date;

public class Attachment {
    public static final int ATTACHED_TYPE_NONE = 0;
    public static final int ATTACHED_TYPE_FILE = 1;
    public static final int ATTACHED_TYPE_MESSAGE_BODY = 2;
    public static final int ATTACHED_TYPE_OLE = 3;
    public static final int ATTACHED_TYPE_MESSAGE = 4;
    public static final int ATTACHED_TYPE_DOCUMENT = 5;
    public static final int ATTACHED_TYPE_MIME_EMBEDDED = 6;
    public static final int DOWNLOAD_STATE_DOWNLOADED = 0;
    public static final int DOWNLOAD_STATE_NOT_DOWNLOADED = 1;
    public static final int DOWNLOAD_STATE_QUEUED_FOR_DOWNLOAD = 2;
    private int pAttachment;
    private int type = 0;
    private int drn = 0;
    private long size = -1L;
    private String displayName;
    private Boolean realAttachment;
    private Boolean systemAttachment;
    private Boolean bodyTextisHTML;

    private static native int getType(int var0);

    private static native int getDownloadState(int var0);

    private static native boolean checkDownloadStateAndStartRetrieve(int var0);

    static Attachment createAttachment(int n) {
        int n2 = Attachment.getType(n);
        switch (n2) {
            case 4: {
                return new MessageAttachment(n);
            }
        }
        return new Attachment(n);
    }

    private native void dispose(int var1);

    private native boolean canImportAsCalendar(int var1);

    private native long getDate(int var1);

    private native String getDisplayName(int var1);

    private native String getDisplayType(int var1);

    private native String getDisplaySize(int var1);

    private native String getFileName(int var1);

    private native String getOriginalFileName(int var1);

    private native int getId(int var1);

    private native int getSize(int var1);

    private native boolean isRealAttachment(int var1);

    private native boolean isSystemAttachment(int var1);

    private native boolean isHTMLMessageBodyText(int var1);

    private native boolean saveToFile(int var1, String var2, boolean var3);

    private native String saveToTempFile(int var1);

    protected Attachment(int n) {
        this.pAttachment = n;
    }

    public int getPointer() {
        return this.pAttachment;
    }

    public boolean canImportAsCalendar() {
        return this.canImportAsCalendar(this.pAttachment);
    }

    public Date getDate() {
        long l = this.getDate(this.pAttachment);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getDisplayName(this.pAttachment);
        }
        return this.displayName;
    }

    public String getDisplayType() {
        return this.getDisplayType(this.pAttachment);
    }

    public String getDisplaySize() {
        return this.getDisplaySize(this.pAttachment);
    }

    public String getFileName() {
        return this.getFileName(this.pAttachment);
    }

    public String getOriginalFileName() {
        return this.getOriginalFileName(this.pAttachment);
    }

    public int getId() {
        if (this.drn == 0) {
            this.drn = this.getId(this.pAttachment);
        }
        return this.drn;
    }

    public long getSize() {
        if (this.size == -1L) {
            this.size = this.getSize(this.pAttachment);
        }
        return this.size;
    }

    public int getType() {
        if (this.type == 0) {
            this.type = Attachment.getType(this.pAttachment);
        }
        return this.type;
    }

    public boolean saveToFile(File file) {
        return this.saveToFile(file.getPath());
    }

    public boolean isRealAttachment() {
        if (this.realAttachment == null) {
            this.realAttachment = new Boolean(this.isRealAttachment(this.pAttachment));
        }
        return this.realAttachment;
    }

    public boolean isSystemAttachment() {
        if (this.systemAttachment == null) {
            this.systemAttachment = new Boolean(this.isSystemAttachment(this.pAttachment));
        }
        return this.systemAttachment;
    }

    public boolean isHTMLMessageBodyText() {
        if (this.bodyTextisHTML == null) {
            this.bodyTextisHTML = new Boolean(this.isHTMLMessageBodyText(this.pAttachment));
        }
        return this.bodyTextisHTML;
    }

    public boolean saveToFile(String string) {
        boolean bl = this.saveToFile(string, true);
        return bl;
    }

    public boolean saveToFile(String string, boolean bl) {
        boolean bl2 = this.saveToFile(this.pAttachment, string, bl);
        return bl2;
    }

    public String saveToTempFile() {
        String string = this.saveToTempFile(this.pAttachment);
        return string;
    }

    public void dispose() {
        if (this.pAttachment != 0) {
            this.dispose(this.pAttachment);
            this.pAttachment = 0;
        }
    }

    public int getDownloadState() {
        return Attachment.getDownloadState(this.pAttachment);
    }

    public boolean checkDownloadStateAndStartRetrieve() {
        return Attachment.checkDownloadStateAndStartRetrieve(this.pAttachment);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

