/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.notification;

import com.novell.gw.engine.EngineUtils;
import java.util.Date;

public class NotifyItem {
    private static final int NT_GENERAL = 100;
    private static final int NT_NEW_MAIL = 101;
    private static final int NT_NEW_APPT = 102;
    private static final int NT_NEW_TASK = 103;
    private static final int NT_NEW_NOTE = 104;
    private static final int NT_NEW_ALARM = 105;
    private static final int NT_NEW_PHONE = 106;
    private static final int NT_NEW_STATUS = 107;
    private static final int NT_COMMON_NEW_ITEM = 108;
    private static final int NT_MAIL_STATUS = 109;
    private static final int NT_APPT_STATUS = 110;
    private static final int NT_TASK_STATUS = 111;
    private static final int NT_NOTE_STATUS = 112;
    private static final int NT_COMMON_STATUS = 113;
    private static final int NT_NTYPE_UNSET = 114;
    private static final int NT_NTYPE_ERROR = 115;
    private static final int ST_OPENED = 200;
    private static final int ST_ACCEPTED = 201;
    private static final int ST_COMPLETED = 202;
    private static final int ST_DELETED = 203;
    private static final int ST_UNDELIVERABLE = 204;
    private static final int ST_LOW_PRIORITY = 205;
    private static final int ST_STANDARD_PRIORITY = 206;
    private static final int ST_HIGH_PRIORITY = 207;
    private static final int ST_STYPE_UNSET = 208;
    private static final int ST_STYPE_ERROR = 209;
    private int pGWNotifyItem = 0;

    private native void dispose(int var1);

    private native boolean isAlarmSet(int var1);

    private native String getFrom(int var1);

    private native String getTo(int var1);

    private native String getSubject(int var1);

    private native String getLocation(int var1);

    private native long getAlarmTime(int var1);

    private native long getApptStartTime(int var1);

    private native long getApptEndTime(int var1);

    private native String getLaunchProgram(int var1);

    private native int getPriority(int var1);

    private native boolean isSnoozed(int var1);

    private native boolean isDeleteProtected(int var1);

    private native boolean isProxy(int var1);

    private native String getUserID(int var1);

    private native String getMsgID(int var1);

    private native int getStatusType(int var1);

    private native int getNotifyType(int var1);

    private native boolean isEqual(int var1, int var2);

    private native boolean canDeleteItem(int var1);

    private native boolean canReadItem(int var1);

    NotifyItem(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWNotifyItem = n;
    }

    int getPointer() {
        return this.pGWNotifyItem;
    }

    public boolean isAlarmSet() {
        return this.isAlarmSet(this.pGWNotifyItem);
    }

    public String getFrom() {
        return this.getFrom(this.pGWNotifyItem);
    }

    public String getTo() {
        return this.getTo(this.pGWNotifyItem);
    }

    public String getSubject() {
        String string = this.getSubject(this.pGWNotifyItem);
        return string;
    }

    public String getLocation() {
        return this.getLocation(this.pGWNotifyItem);
    }

    public Date getAlarmTime() {
        long l = this.getAlarmTime(this.pGWNotifyItem);
        return EngineUtils.flaimTimeToDate(l);
    }

    public Date getApptStartTime() {
        long l = this.getApptStartTime(this.pGWNotifyItem);
        return EngineUtils.flaimTimeToDate(l);
    }

    public Date getApptEndTime() {
        long l = this.getApptEndTime(this.pGWNotifyItem);
        return EngineUtils.flaimTimeToDate(l);
    }

    public String getLaunchProgram() {
        return this.getLaunchProgram(this.pGWNotifyItem);
    }

    public StatusType getPriority() {
        int n = this.getPriority(this.pGWNotifyItem);
        return this.mapStatusType(n);
    }

    public boolean isSnoozed() {
        return this.isSnoozed(this.pGWNotifyItem);
    }

    public boolean isDeleteProtected() {
        return this.isDeleteProtected(this.pGWNotifyItem);
    }

    public boolean isProxy() {
        return this.isProxy(this.pGWNotifyItem);
    }

    public String getUserID() {
        return this.getUserID(this.pGWNotifyItem);
    }

    public String getMsgID() {
        return this.getMsgID(this.pGWNotifyItem);
    }

    public StatusType getStatusType() {
        int n = this.getStatusType(this.pGWNotifyItem);
        return this.mapStatusType(n);
    }

    private StatusType mapStatusType(int n) {
        StatusType statusType;
        switch (n) {
            case 200: {
                statusType = StatusType.OPENED;
                break;
            }
            case 201: {
                statusType = StatusType.ACCEPTED;
                break;
            }
            case 202: {
                statusType = StatusType.COMPLETED;
                break;
            }
            case 203: {
                statusType = StatusType.DELETED;
                break;
            }
            case 204: {
                statusType = StatusType.UNDELIVERABLE;
                break;
            }
            case 205: {
                statusType = StatusType.LOW_PRIORITY;
                break;
            }
            case 206: {
                statusType = StatusType.STANDARD_PRIORITY;
                break;
            }
            case 207: {
                statusType = StatusType.HIGH_PRIORITY;
                break;
            }
            case 208: {
                statusType = StatusType.STYPE_UNSET;
                break;
            }
            case 209: {
                statusType = StatusType.STYPE_ERROR;
                break;
            }
            default: {
                statusType = null;
            }
        }
        return statusType;
    }

    public NotifyType getNotifyType() {
        int n = this.getNotifyType(this.pGWNotifyItem);
        return this.mapNotifyType(n);
    }

    private NotifyType mapNotifyType(int n) {
        NotifyType notifyType;
        switch (n) {
            case 100: {
                notifyType = NotifyType.GENERAL;
                break;
            }
            case 101: {
                notifyType = NotifyType.NEW_MAIL;
                break;
            }
            case 102: {
                notifyType = NotifyType.NEW_APPT;
                break;
            }
            case 103: {
                notifyType = NotifyType.NEW_TASK;
                break;
            }
            case 104: {
                notifyType = NotifyType.NEW_NOTE;
                break;
            }
            case 105: {
                notifyType = NotifyType.NEW_ALARM;
                break;
            }
            case 106: {
                notifyType = NotifyType.NEW_PHONE;
                break;
            }
            case 107: {
                notifyType = NotifyType.NEW_STATUS;
                break;
            }
            case 108: {
                notifyType = NotifyType.COMMON_NEW_ITEM;
                break;
            }
            case 109: {
                notifyType = NotifyType.MAIL_STATUS;
                break;
            }
            case 110: {
                notifyType = NotifyType.APPT_STATUS;
                break;
            }
            case 111: {
                notifyType = NotifyType.TASK_STATUS;
                break;
            }
            case 112: {
                notifyType = NotifyType.NOTE_STATUS;
                break;
            }
            case 113: {
                notifyType = NotifyType.COMMON_STATUS;
                break;
            }
            case 114: {
                notifyType = NotifyType.NTYPE_UNSET;
                break;
            }
            case 115: {
                notifyType = NotifyType.NTYPE_ERROR;
                break;
            }
            default: {
                notifyType = null;
            }
        }
        return notifyType;
    }

    public boolean isEqual(NotifyItem notifyItem) {
        return this.isEqual(this.getPointer(), notifyItem.getPointer());
    }

    public boolean canDeleteItem() {
        return this.canDeleteItem(this.pGWNotifyItem);
    }

    public boolean canReadItem() {
        return this.canReadItem(this.pGWNotifyItem);
    }

    public void dispose() {
        if (this.pGWNotifyItem != 0) {
            this.dispose(this.pGWNotifyItem);
            this.pGWNotifyItem = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusType {
        OPENED(200),
        ACCEPTED(201),
        COMPLETED(202),
        DELETED(203),
        UNDELIVERABLE(204),
        LOW_PRIORITY(205),
        STANDARD_PRIORITY(206),
        HIGH_PRIORITY(207),
        STYPE_UNSET(208),
        STYPE_ERROR(209);

        private int value;

        private StatusType(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NotifyType {
        GENERAL(100),
        NEW_MAIL(101),
        NEW_APPT(102),
        NEW_TASK(103),
        NEW_NOTE(104),
        NEW_ALARM(105),
        NEW_PHONE(106),
        NEW_STATUS(107),
        COMMON_NEW_ITEM(108),
        MAIL_STATUS(109),
        APPT_STATUS(110),
        TASK_STATUS(111),
        NOTE_STATUS(112),
        COMMON_STATUS(113),
        NTYPE_UNSET(114),
        NTYPE_ERROR(115);

        private int value;

        private NotifyType(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }
}

