/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.rules;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.Filter;
import com.novell.gw.folder.Folder;
import com.novell.gw.rules.RuleActionList;

public class Rule {
    public static final int EVENT_EXECUTION_TYPE_STARTUP = 1;
    public static final int EVENT_EXECUTION_TYPE_EXIT = 2;
    public static final int EVENT_EXECUTION_TYPE_FOLDER_CLOSE = 3;
    public static final int EVENT_EXECUTION_TYPE_FOLDER_OPEN = 4;
    public static final int EVENT_EXECUTION_TYPE_NEW_ITEM = 5;
    public static final int EVENT_EXECUTION_TYPE_USER = 9;
    public static final int EVENT_EXECUTION_TYPE_FOLDER_NEW = 10;
    public static final int EVENT_EXECUTION_TYPE_COMPLETE = 19;
    public static final int APPOINTMENT_CONFLICT_DOES_NOT_MATTER = 0;
    public static final int APPOINTMENT_CONFLICT_YES = 1;
    public static final int APPOINTMENT_CONFLICT_NO = 2;
    private int pRule = 0;

    private static native int createRule(int var0);

    private native void dispose(int var1);

    private native int getActionList(int var1);

    private native int getBoxType(int var1);

    private native int getConflict(int var1);

    private native int getFilter(int var1);

    private native String getFilterDescription(int var1, int var2);

    private native int getFolder(int var1);

    private native String getFolderName(int var1);

    private native int getItemType(int var1);

    private native int getRuleEvent(int var1);

    private native String getRuleName(int var1);

    private native boolean isEnabled(int var1);

    private native boolean saveRule(int var1);

    private native void setActionList(int var1, int var2);

    private native void setBoxType(int var1, int var2);

    private native void setConflict(int var1, int var2);

    private native void setFilter(int var1, int var2);

    private native void setFolder(int var1, int var2);

    private native void setItemType(int var1, int var2);

    private native void setRuleEvent(int var1, int var2);

    private native void setRuleName(int var1, String var2);

    public Rule() {
    }

    Rule(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pRule = n;
    }

    public Rule(DataStore dataStore) {
        this(Rule.createRule(dataStore.getPointer()));
    }

    public RuleActionList getActionList() {
        RuleActionList ruleActionList = null;
        int n = this.getActionList(this.pRule);
        if (n != 0) {
            ruleActionList = new RuleActionList(n);
        }
        return ruleActionList;
    }

    public void setActionList(RuleActionList ruleActionList) {
        this.setActionList(this.pRule, ruleActionList == null ? 0 : ruleActionList.getPointer());
    }

    public int getBoxTypeMask() {
        return this.getBoxType(this.pRule);
    }

    public void setBoxTypeMask(int n) {
        this.setBoxType(this.pRule, n);
    }

    public int getConflict() {
        return this.getConflict(this.pRule);
    }

    public void setConflict(int n) {
        this.setConflict(this.pRule, n);
    }

    public int getEventExecutionType() {
        return this.getRuleEvent(this.pRule);
    }

    public void setEventExecutionType(int n) {
        this.setRuleEvent(this.pRule, n);
    }

    public String getFilterDescription(int n) {
        String string = this.getFilterDescription(this.pRule, n);
        return string;
    }

    public Filter getFilter() {
        Filter filter = null;
        int n = this.getFilter(this.pRule);
        if (n != 0) {
            filter = new Filter(n);
        }
        return filter;
    }

    public void setFilter(Filter filter) {
        this.setFilter(this.pRule, filter == null ? 0 : filter.getPointer());
    }

    public Folder getFolder() {
        Folder folder = null;
        int n = this.getFolder(this.pRule);
        if (n != 0) {
            folder = DataStore.getFolder(n);
        }
        return folder;
    }

    public String getFolderName() {
        return this.getFolderName(this.pRule);
    }

    public void setFolder(Folder folder) {
        this.setFolder(this.pRule, folder == null ? 0 : folder.getPointer());
    }

    public int getItemTypeMask() {
        return this.getItemType(this.pRule);
    }

    public void setItemTypeMask(int n) {
        this.setItemType(this.pRule, n);
    }

    public String getName() {
        return this.getRuleName(this.pRule);
    }

    public void setName(String string) {
        this.setRuleName(this.pRule, string);
    }

    public int getPointer() {
        return this.pRule;
    }

    public boolean isEnabled() {
        return this.isEnabled(this.pRule);
    }

    public boolean save() {
        return this.saveRule(this.pRule);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.pRule != 0) {
            this.dispose(this.pRule);
            this.pRule = 0;
        }
    }
}

