/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.rules;

import com.novell.gw.rules.RuleAction;

public class RuleActionList {
    private int pActionList = 0;
    private RuleAction[] actions;

    private native boolean addAction(int var1, int var2, int var3);

    private native boolean deleteAction(int var1, int var2);

    private native void dispose(int var1);

    private native int getAction(int var1, int var2);

    private native int getSize(int var1);

    public RuleActionList() {
    }

    RuleActionList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pActionList = n;
        int n2 = this.getSize(n);
        this.actions = new RuleAction[n2];
    }

    public boolean addAction(RuleAction ruleAction, int n) {
        boolean bl = this.addAction(this.pActionList, ruleAction == null ? 0 : ruleAction.getPointer(), n);
        return bl;
    }

    public boolean deleteAction(int n) {
        boolean bl = this.deleteAction(this.pActionList, n);
        return bl;
    }

    public RuleAction getActionAt(int n) {
        RuleAction ruleAction = null;
        if (this.actions.length > 0 && (ruleAction = this.actions[n]) == null) {
            this.actions[n] = ruleAction = RuleAction.createRuleAction(this.getAction(this.pActionList, n));
        }
        return ruleAction;
    }

    public int getPointer() {
        return this.pActionList;
    }

    public int getSize() {
        int n = 0;
        if (this.actions != null) {
            n = this.actions.length;
        }
        return n;
    }

    public void dispose() {
        if (this.pActionList != 0) {
            this.dispose(this.pActionList);
            this.pActionList = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

