/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.ExtendedAction;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.componentrelated.ComponentRelatedAction;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppAction<T>
extends ExtendedAction
implements MVCView<MVCController, T> {
    protected ActionList actionList;
    protected T mvcModel;
    private boolean selected = false;
    private final String ACTION_KEY = "action key";
    private ActionType type = ActionType.NORMAL;

    public AppAction(ActionList actionList, ActionKey actionKey) {
        this(actionList, actionKey, actionKey.toString(), null);
    }

    public AppAction(ActionList actionList, ActionKey actionKey, String name) {
        this(actionList, actionKey, name, null);
    }

    public AppAction(ActionList actionList, ActionKey actionKey, String name, boolean b) {
        this(actionList, actionKey, name, null);
    }

    public AppAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(name, icon);
        this.actionList = actionList;
        this.setActionKey(actionKey);
        if (!OS.isMacOS()) {
            this.setMnemonicKey(KeyStroke.getKeyStroke((int)StringResources.getMnemonic(name), 401).getKeyCode());
        }
        this.registerListeners();
    }

    public ActionList getActionList() {
        return this.actionList;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean showWithText() {
        return true;
    }

    @Override
    public void setController(MVCController theController) {
        if (theController instanceof ApplicationFrameActionList) {
            this.actionList = (ApplicationFrameActionList)theController;
        }
    }

    @Override
    public MVCController getController() {
        return this.actionList;
    }

    @Override
    public void setMVCModel(T model) {
        this.mvcModel = model;
    }

    @Override
    public T getMVCModel() {
        return this.mvcModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            this.performAction(e);
        }
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = OS.createMenuItem(this);
        menuItem.setSelected(this.isSelected());
        return menuItem;
    }

    public JMenuItem getPopupMenuItem() {
        return this.getMenuItem();
    }

    public JComponent getToolBarComponent() {
        return this.createActionButton();
    }

    public void disposeAction() {
        this.actionList = null;
        this.mvcModel = null;
    }

    protected void performAction(ActionEvent e) {
        JOptionPane.showMessageDialog(null, "This action is not implemented yet", "", 1);
    }

    protected void registerListeners() {
    }

    public void addListenerDescriptor(AppEventListenerDescriptor theListenerDescriptor) {
        this.getController().addListenerDescriptor(theListenerDescriptor);
    }

    public void removeListenerDescriptor(AppEventListenerDescriptor theListenerDescriptor) {
        this.getController().removeListenerDescriptor(theListenerDescriptor);
    }

    protected String getUserGuid() {
        Component ownerComponent = this.actionList.getOwnerComponent();
        if (ownerComponent instanceof ApplicationFrame) {
            return ((ApplicationFrame)ownerComponent).getUserGuid();
        }
        return ControlsUtils.getUserGuid(this.actionList);
    }

    protected AbstractButton createActionButton() {
        AbstractButton button = OS.createToolBarButton(this);
        button.setToolTipText(this.getToolTipText());
        return button;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AppAction)) {
            return false;
        }
        AppAction action = (AppAction)obj;
        return action.getName().equals(this.getName());
    }

    @Override
    public void setAccelerator(KeyStroke newValue) {
        KeyStroke oldValue = this.getAccelerator();
        super.setAccelerator(newValue);
        if (newValue != null && newValue.equals(oldValue) || newValue == oldValue) {
            return;
        }
        this.applyAccelerator(oldValue, newValue);
    }

    protected void applyAccelerator(KeyStroke oldValue, KeyStroke newValue) {
        MVCController controller = this.getController();
        if (this instanceof ComponentRelatedAction) {
            this.applyAccelerator(controller, oldValue, newValue);
        } else {
            controller.bindActionKey(this, oldValue, this.getAccelerator());
        }
    }

    private void applyAccelerator(MVCController controller, KeyStroke oldValue, KeyStroke newValue) {
        if (controller == null) {
            return;
        }
        AppAction action = this;
        Class<ComponentRelatedAction> type = controller.getType();
        if (type != null && type.isInstance(action)) {
            controller.bindActionKey(action, oldValue, newValue);
        }
        for (Level children : controller.getLevel().getChildren()) {
            this.applyAccelerator(ControllerManager.getInstance().get(children), oldValue, newValue);
        }
    }

    public ActionKey getActionKey() {
        return (ActionKey)((Object)this.getValue("action key"));
    }

    protected void setActionKey(ActionKey actionKey) {
        this.putValue("action key", (Object)actionKey);
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public boolean isCheckable() {
        return ActionType.CHECKABLE.equals((Object)this.type);
    }

    public boolean isRadio() {
        return ActionType.RADIO.equals((Object)this.type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ActionType {
        CHECKABLE,
        NORMAL,
        RADIO;

    }
}

