/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components;

import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ArrayIcon
extends ImageIcon {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 2;
    private Icon[] icons;
    private int width = -1;
    private int height = -1;
    private int hgap;
    private int valign;
    private BufferedImage bufferedImage;

    public ArrayIcon(Icon[] theIcons) {
        this(theIcons, 1, 2);
    }

    public ArrayIcon(Icon[] theIcons, int theHgap) {
        this(theIcons, theHgap, 2);
    }

    public ArrayIcon(Icon[] theIcons, int theHgap, int theValign) {
        this.icons = theIcons;
        this.hgap = theHgap;
        this.valign = theValign;
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
    }

    public int getIconHeight() {
        if (this.height < 0) {
            this.height = 0;
            for (int i = 0; i < this.icons.length; ++i) {
                this.height = Math.max(this.height, this.icons[i].getIconHeight());
            }
        }
        return this.height;
    }

    public int getIconWidth() {
        if (this.width < 0) {
            this.width = (this.icons.length - 1) * this.hgap;
            for (int i = 0; i < this.icons.length; ++i) {
                this.width += this.icons[i].getIconWidth();
            }
        }
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        Graphics2D gr = this.bufferedImage.createGraphics();
        gr.setColor(g.getColor());
        int xoffset = 0;
        int yoffset = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            switch (this.valign) {
                case 1: {
                    yoffset = 0;
                    break;
                }
                case 0: {
                    yoffset = (this.height - this.icons[i].getIconHeight()) / 2;
                    break;
                }
                default: {
                    yoffset = this.height - this.icons[i].getIconHeight();
                }
            }
            this.icons[i].paintIcon(c, gr, xoffset, yoffset);
            xoffset += this.icons[i].getIconWidth() + this.hgap;
        }
        g.drawImage(this.getImage(), x, y, this.getImageObserver());
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JLabel comp = new JLabel();
        comp.setBackground(Color.GREEN);
        comp.setIcon(ImageResources.ICON_UPDATING_CACHING);
        comp.setIcon(new ArrayIcon(new Icon[]{ImageResources.ICON_UPDATING_CACHING, ImageResources.ACT_CALENDAR_MONTHLY, ImageResources.ICON_ITEM_DELEGATED_FORWARDED, ImageResources.ICON_QUICKVIEWER, ImageResources.MSEXCEL_DOCUMENT, ImageResources.ICON_ITEM_DELEGATED_FORWARDED, ImageResources.ICON_STATUS_ALARM}, 15));
        frame.getContentPane().add(comp);
        frame.setSize(840, 350);
        frame.show();
    }
}

