/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components;

import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

public class ComponentBorder
extends TitledBorder {
    private JComponent component;

    public ComponentBorder(JComponent theComponent) {
        super(BorderFactory.createTitledBorder(""), null, 3, 5, null, null);
        this.component = theComponent;
    }

    public Insets getBorderInsets(Component c) {
        Insets borderInsets = super.getBorderInsets(c);
        borderInsets.top = PLAFChanger.getFontSize();
        return borderInsets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Rectangle borderRect = new Rectangle(x, y + 2, width, height - 4);
        Dimension d = c.getSize();
        d.width -= 4;
        d.width = Math.min(this.component.getPreferredSize().width, d.width - 35);
        d.height = this.component.getPreferredSize().height;
        this.component.setSize(d);
        Dimension componentDim = this.component.getSize();
        Rectangle componentRect = c.getComponentOrientation().isLeftToRight() ? new Rectangle(15, 0, componentDim.width, componentDim.height) : new Rectangle(borderRect.width - componentDim.width - 15, 0, componentDim.width, componentDim.height);
        borderRect.y = this.component.getSize().height / 2;
        borderRect.height += 2 - this.component.getSize().height / 2;
        this.border.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
        Color col = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(componentRect.x, componentRect.y, componentRect.width, componentRect.height);
        g.setColor(col);
        this.component.setBounds(componentRect);
        this.component.validate();
    }
}

