/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class GWBorder {
    public static final Border NO_BORDER = new EmptyBorder(5, 5, 5, 5);
    public static final Border LOWERED_BORDER = new LoweredBorder();
    public static final Border RAISED_BORDER = new RaisedBorder();
    private static Color darkColor;

    private static Color getDarkColor() {
        if (darkColor == null) {
            darkColor = (Color)UIManager.getDefaults().get("Button.background");
            darkColor = darkColor == null ? Color.DARK_GRAY : darkColor.darker();
        }
        return darkColor;
    }

    public static class LoweredBorder
    extends AbstractBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(Color.WHITE);
            g.drawLine(x + width - 1, y + height - 1, x + width - 1, y);
            g.drawLine(x + width - 1, y + height - 1, x, y + height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 5;
            insets.right = 5;
            insets.top = 5;
            insets.left = 5;
            return insets;
        }
    }

    public static class RaisedBorder
    extends AbstractBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.WHITE);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(GWBorder.getDarkColor());
            g.drawLine(x + width - 1, y + height - 1, x + width - 1, y);
            g.drawLine(x + width - 1, y + height - 1, x, y + height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 5;
            insets.right = 5;
            insets.top = 5;
            insets.left = 5;
            return insets;
        }
    }
}

