/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.components.customizedbutton.SmartFilter;
import com.appframework.components.customizedbutton.ToolBarColorButton;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ToolBarColorToggleButton
extends ToolBarToggleButton {
    private static final Logger logger = Logger.getLogger(ToolBarColorButton.class);

    public ToolBarColorToggleButton(ImageIcon theImageIcon) {
        super(theImageIcon);
        this.initGUI();
    }

    public ToolBarColorToggleButton(Action a) {
        super(a);
        this.initGUI();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.updateDisableIcon();
    }

    public void setIcon(Icon newIcon) {
        super.setIcon(newIcon);
        this.updateDisableIcon();
    }

    private void initGUI() {
        this.setContentAreaFilled(false);
    }

    public void paint(Graphics g) {
        if (this.skinnableDelegate.isSkinabilityEnabled()) {
            this.setBorderPainted(false);
            if (this.getModel().isRollover() || this.getModel().isSelected() || this.isAlwaysPressed()) {
                this.setForeground((Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR));
            } else {
                this.setForeground((Color)this.getClientProperty((Object)SkinProperty.TOOLBAR_TEXT_COLOR));
            }
            if (this.getModel().isRollover() || this.getModel().isSelected() || this.isAlwaysPressed()) {
                UIUtils.paintGradient(g, this, "both", true, this.getModel().isSelected() || this.isAlwaysPressed());
            }
        }
        super.paint(g);
    }

    private void updateDisableIcon() {
        if (this.getIcon() != null) {
            this.setDisabledIcon(new ImageIcon(SmartFilter.createDisabledImage(this, (ImageIcon)this.getIcon())));
        }
    }
}

