/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton.listpopuppane;

import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.AbstractPopupPane;
import com.appframework.components.customizedbutton.ActionWithSepName;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class ListPopupPane
extends AbstractPopupPane {
    private static Logger logger = Logger.getLogger(ListPopupPane.class);

    public ListPopupPane(Action a) {
        super(a, (String)a.getValue("Name"));
    }

    public ListPopupPane(Action a, String theText) {
        super(a, theText);
    }

    public void setDefaultAction(Action a, String theDisplayName) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (this.defaultAction != null) {
            this.defaultAction.getAction().removePropertyChangeListener(this.propertyListener);
        }
        a.addPropertyChangeListener(this.propertyListener);
        this.defaultAction = new ActionWithSepName(a, theDisplayName);
        this.iconNormal = (Icon)a.getValue("SmallIcon");
        this.btnLeft.setAction(a);
        this.btnLeft.setText(this.defaultAction.getDisplayName());
        this.isEnabled = a.isEnabled();
        this.btnRight.setEnabled(this.isEnabled);
    }

    protected void processEvent(int buttonID) {
        this.pumActions = null;
        if (this.isEnabled) {
            if (buttonID == 16) {
                if (!this.isPopupShowed) {
                    this.changeState(8);
                }
            } else if (buttonID == 20 && !this.isPopupShowed) {
                this.btnRight.setBorder(GWBorder.LOWERED_BORDER);
                this.btnLeft.setBorder(GWBorder.RAISED_BORDER);
                if (this.enable) {
                    this.chooseAction();
                }
            }
        }
    }

    protected void performDefaultAction() {
        if (this.defaultAction != null) {
            this.defaultAction.getAction().actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    private void chooseAction() {
        if (!this.actionsList.isEmpty()) {
            try {
                int max_width = 0;
                int height = 0;
                Font f = (Font)UIManager.get("MenuItem.font");
                FontMetrics fm = this.btnLeft.getGraphics().getFontMetrics(f);
                this.pumActions = new GWPopupMenu();
                this.pumActions.setBorderPainted(true);
                this.pumActions.setBorder(GWBorder.RAISED_BORDER);
                this.pumActions.addPopupMenuListener(new ActionsPopupListener());
                for (int i = 0; i < this.actionsList.size(); ++i) {
                    ActionWithSepName next = (ActionWithSepName)this.actionsList.get(i);
                    if (next.getAction() == null) {
                        this.pumActions.addSeparator();
                        continue;
                    }
                    JMenuItem mi = this.createPopupItem(next);
                    this.pumActions.add(mi);
                    Icon icon = mi.getIcon();
                    int length = (icon == null ? 0 : icon.getIconWidth()) + fm.stringWidth(mi.getText());
                    if (max_width >= length) continue;
                    max_width = length;
                }
                if ((max_width += 20) < this.getWidth()) {
                    max_width = this.getWidth();
                }
                if (this.actionsList.size() == 1) {
                    this.pumActions.setPopupSize(max_width, fm.getHeight() + 8);
                } else {
                    height = this.actionsList.size() * (fm.getHeight() + 3);
                }
                if (UIUtils.getComponentOrientation().isLeftToRight()) {
                    this.pumActions.show(this.btnLeft, 0, this.btnLeft.getHeight());
                } else {
                    this.pumActions.show(this.btnLeft, this.btnLeft.getPreferredSize().width - this.getWidth(), this.btnLeft.getHeight());
                }
                this.isPopupShowed = true;
            }
            catch (Exception e) {
                logger.debug((Object)e, (Throwable)e);
                logger.error((Object)e);
            }
        } else {
            logger.debug((Object)"no actions");
        }
    }

    protected class ActionsPopupListener
    implements PopupMenuListener {
        protected ActionsPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ListPopupPane.this.isPopupShowed = false;
            ListPopupPane.this.restoreState();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

