/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.CustomFont;
import com.appframework.components.htmleditor.RTFDocument;
import com.appframework.utils.OS;
import java.awt.Font;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.rtf.RTFEditorKit;

public class GwRTFEditorKit
extends RTFEditorKit {
    private int mode;
    private static final ViewFactory defaultFactory = new GwViewFactory();

    public GwRTFEditorKit(int mode) {
        this.mode = mode;
    }

    public Document createDefaultDocument() {
        return new RTFDocument(this.mode);
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    private static class GwViewFactory
    implements ViewFactory {
        private GwViewFactory() {
        }

        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new GwLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new GwLabelView(elem);
        }
    }

    private static class GwLabelView
    extends LabelView {
        private Font labelFont;

        public GwLabelView(Element elem) {
            super(elem);
            this.updateFont();
        }

        private void updateFont() {
            this.labelFont = super.getFont();
            if ((OS.isLinuxOS() || OS.isWinOS()) && this.labelFont != null && !(this.labelFont instanceof CustomFont)) {
                this.labelFont = new CustomFont(this.labelFont.getFontName(), this.labelFont.getStyle(), this.labelFont.getSize());
            }
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            super.changedUpdate(e, a, f);
            this.updateFont();
        }

        public Font getFont() {
            return this.labelFont;
        }
    }
}

