/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import java.net.URL;
import java.util.Locale;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;

public class HTMLStyledDocument
extends HTMLDocument {
    private static Logger logger = Logger.getLogger(HTMLStyledDocument.class);
    private boolean editMode = false;
    private boolean inBody;

    public HTMLStyledDocument(StyleSheet theStyles, boolean editMode) {
        super(theStyles);
        this.editMode = editMode;
    }

    public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        return new HTMLStyledReader(pos, popDepth, pushDepth, insertTag);
    }

    public HTMLEditorKit.ParserCallback getReader(int pos) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        return new HTMLStyledReader(pos);
    }

    public Style getLogicalStyle(int p) {
        return super.getLogicalStyle(p);
    }

    private void setDefaultFont(AttributeSet a) {
        if (a.getAttribute(StyleConstants.FontFamily) == null && a.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.CONTENT)) {
            String fontName = HTMLConstants.getDefaultFontName(1, this.editMode);
            StyleConstants.setFontFamily((MutableAttributeSet)a, fontName);
        }
    }

    protected Element createLeafElement(Element parent, AttributeSet a, int p0, int p1) {
        Element leafElement = super.createLeafElement(parent, a, p0, p1);
        this.setDefaultFont(a);
        return leafElement;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        attributes.addAttribute(StyleConstants.NameAttribute, HTML.Tag.HTML);
        if (Locale.getDefault().getLanguage().equals("iw") || Locale.getDefault().getLanguage().equals("ar")) {
            attributes.addAttribute("dir", "rtl");
        }
        HTMLDocument.BlockElement html = new HTMLDocument.BlockElement(this, null, attributes.copyAttributes());
        attributes.removeAttributes(attributes);
        attributes.addAttribute(StyleConstants.NameAttribute, HTML.Tag.BODY);
        HTMLDocument.BlockElement body = new HTMLDocument.BlockElement(this, (Element)html, attributes.copyAttributes());
        attributes.removeAttributes(attributes);
        attributes.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        HTMLDocument.BlockElement paragraph = new HTMLDocument.BlockElement(this, (Element)body, attributes.copyAttributes());
        attributes.removeAttributes(attributes);
        attributes.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        HTMLDocument.RunElement brk = new HTMLDocument.RunElement(this, (Element)paragraph, (AttributeSet)attributes, 0, 1);
        Element[] buff = new Element[]{brk};
        paragraph.replace(0, 0, buff);
        buff[0] = paragraph;
        body.replace(0, 0, buff);
        buff[0] = body;
        html.replace(0, 0, buff);
        this.writeUnlock();
        return html;
    }

    protected Element createBranchElement(Element parent, AttributeSet a) {
        if (a.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.BODY)) {
            this.inBody = true;
        }
        if (a.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.IMPLIED) && this.inBody) {
            ((MutableAttributeSet)a).addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        }
        Element branchElement = super.createBranchElement(parent, a);
        this.setDefaultFont(a);
        return branchElement;
    }

    public class HTMLStyledReader
    extends HTMLDocument.HTMLReader {
        public HTMLStyledReader(int offset) {
            super(HTMLStyledDocument.this, offset);
        }

        public HTMLStyledReader(int offset, int popDepth, int pushDepth, HTML.Tag insertTag) {
            super(HTMLStyledDocument.this, offset, popDepth, pushDepth, insertTag);
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            HTMLUtils.correctSimpleTag(t, a, pos);
            super.handleSimpleTag(t, a, pos);
        }
    }
}

