/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;

public class HTMLStyledWriter
extends HTMLWriter {
    Logger logger = Logger.getLogger(HTMLStyledWriter.class);
    private boolean doReplaceEntities = false;
    private boolean inBody = false;
    private boolean inEmptyParagraph = false;
    private StyleSheet css;

    public HTMLStyledWriter(Writer w, HTMLDocument doc) {
        this(w, doc, 0, doc.getLength(), null);
    }

    public HTMLStyledWriter(Writer w, HTMLDocument doc, int pos, int len, StyleSheet theCSS) {
        super(w, doc, pos, len);
        this.setLineLength(Integer.MAX_VALUE);
        this.css = new StyleSheet();
        if (theCSS != null) {
            this.css.addStyleSheet(theCSS);
        }
    }

    private boolean isParagraph(Element theElement) {
        return theElement != null && this.inBody && theElement.getName().equals(HTML.Tag.P.toString());
    }

    private boolean isEmptyParagraph(Element theElement) throws BadLocationException {
        boolean result = false;
        if (this.isParagraph(theElement)) {
            String elementText = this.getText(theElement);
            return elementText.length() == 0 || elementText.equals(Utils.LINE_SEPARATOR);
        }
        return result;
    }

    protected void startTag(Element elem) throws IOException, BadLocationException {
        if (this.isEmptyParagraph(elem)) {
            this.inEmptyParagraph = true;
            this.write("<" + HTML.Tag.BR + '>');
        } else {
            if (elem.getName().equals(HTML.Tag.BODY.toString())) {
                this.inBody = true;
            }
            super.startTag(elem);
        }
    }

    protected void writeAttributes(AttributeSet attr) throws IOException {
        Style tagRule;
        SimpleAttributeSet attributes = new SimpleAttributeSet(attr);
        Object tag = attr.getAttribute(StyleConstants.NameAttribute);
        if (tag instanceof HTML.Tag && (tagRule = this.css.getRule(tag.toString())) != null) {
            attributes.addAttributes(tagRule);
        }
        this.doWriteAttributes(attributes);
    }

    private void doWriteAttributes(AttributeSet attr) throws IOException {
        SimpleAttributeSet convAttr = new SimpleAttributeSet();
        HTMLStyledWriter.convertAttributes(attr, convAttr);
        Enumeration<?> names = convAttr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG) continue;
            this.write(" " + name + "=\"" + convAttr.getAttribute(name) + '\"');
        }
    }

    private static void convertAttributes(AttributeSet fromAttributes, MutableAttributeSet convAttr) {
        StringBuffer value = new StringBuffer();
        Enumeration<?> names = fromAttributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name instanceof CSS.Attribute) {
                if (value.length() > 0) {
                    value.append("; ");
                }
                value.append(name);
                value.append(": ");
                value.append(fromAttributes.getAttribute(name));
                continue;
            }
            convAttr.addAttribute(name, fromAttributes.getAttribute(name));
        }
        if (value.length() > 0) {
            convAttr.addAttribute(HTML.Attribute.STYLE, value.toString());
        }
    }

    protected void endTag(Element elem) throws IOException {
        try {
            if (this.isEmptyParagraph(elem)) {
                this.inEmptyParagraph = false;
            } else {
                super.endTag(elem);
            }
        }
        catch (BadLocationException e) {
            this.logger.error((Object)e);
            this.logger.debug((Object)e, (Throwable)e);
        }
    }

    protected void writeEmbeddedTags(AttributeSet attr) throws IOException {
        if (!this.inEmptyParagraph) {
            super.writeEmbeddedTags(attr);
        }
    }

    public void write() throws IOException, BadLocationException {
        this.doReplaceEntities = false;
        super.write();
    }

    protected void output(char[] chars, int start, int length) throws IOException {
        if (!this.doReplaceEntities) {
            if (length > 0) {
                this.doOutput(chars, start, length);
            }
            return;
        }
        boolean doReplaceSpaces = false;
        length += start;
        StringBuffer result = new StringBuffer();
        block8: for (int counter = start; counter < length; ++counter) {
            char aChar = chars[counter];
            switch (aChar) {
                case ' ': {
                    if (doReplaceSpaces) {
                        result.append("&nbsp;");
                        continue block8;
                    }
                    if (counter == start) {
                        result.append("&nbsp;");
                    } else {
                        result.append(' ');
                    }
                    doReplaceSpaces = true;
                    continue block8;
                }
                case '<': {
                    doReplaceSpaces = false;
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    doReplaceSpaces = false;
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    doReplaceSpaces = false;
                    result.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    doReplaceSpaces = false;
                    result.append("&quot;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    doReplaceSpaces = false;
                    continue block8;
                }
                default: {
                    BitSet dontNeedEncoding = ControlsUtils.getDontNeedEncoding();
                    if (!dontNeedEncoding.get(aChar)) {
                        result.append("&#");
                        result.append(String.valueOf((int)aChar));
                        result.append(';');
                    } else {
                        result.append(aChar);
                    }
                    doReplaceSpaces = false;
                }
            }
        }
        String fixed = HTMLUtils.fixSpacesBTWUTFCharCodes(result.toString());
        this.output(fixed);
    }

    private void output(String string) throws IOException {
        int length = string.length();
        char[] tempChars = new char[length];
        string.getChars(0, length, tempChars, 0);
        this.doOutput(tempChars, 0, length);
    }

    private void doOutput(char[] theChars, int theStart, int theLenth) throws IOException {
        this.getWriter().write(theChars, theStart, theLenth);
        this.setCurrentLineLength(this.getCurrentLineLength() + theLenth);
    }

    protected void indent() throws IOException {
        boolean oldReplace = this.doReplaceEntities;
        this.doReplaceEntities = false;
        super.indent();
        this.doReplaceEntities = oldReplace;
    }

    protected void text(Element elem) throws BadLocationException, IOException {
        if (!this.inEmptyParagraph) {
            this.doReplaceEntities = true;
            super.text(elem);
            this.doReplaceEntities = false;
        }
    }
}

