/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.components.htmleditor.HistoryTracker;
import com.appframework.components.htmleditor.ProxyConfiguration;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.novell.gw.jclient.application.actions.edit.text.TextZoomer;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public abstract class HTMLTextComponent
extends HTMLViewer {
    private static Logger logger = Logger.getLogger(HTMLTextComponent.class);
    protected HTMLTextPane htmlTextPane;
    protected DirtyStateManager dirtyStateManager;
    protected boolean browserState = false;
    protected ProxyConfiguration proxyConfiguration;
    private HistoryTracker historyTracker = new HistoryTracker();

    public HTMLTextComponent(DirtyStateManager theDirtyStateManager) {
        this.dirtyStateManager = theDirtyStateManager;
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.htmlTextPane = new ViewHTMLTextPane();
        this.add((Component)new EditableTextComponent(this.htmlTextPane, null), "Center");
    }

    public String getStyledText() {
        String result = "";
        try {
            Document doc = this.htmlTextPane.getDocument();
            Object oProp = doc.getProperty("title");
            if (oProp == null) {
                doc.putProperty("title", "Default Title");
            }
            result = this.htmlTextPane.getStyledText();
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        return result;
    }

    public void setStyledText(String theStyledText) {
        this.htmlTextPane.setStyledText(theStyledText);
    }

    public void clear() {
        this.htmlTextPane.setPlainText("");
    }

    public String getPlainText() {
        return this.htmlTextPane.getPlainText();
    }

    public void setPlainText(String thePlainText) {
        this.htmlTextPane.setPlainText(thePlainText);
        this.htmlTextPane.insertLinks();
    }

    public void setPage(URL url) {
        try {
            if (this.browserState) {
                if (this.proxyConfiguration != null && this.proxyConfiguration.isProxyEnabled() && !this.proxyConfiguration.isProxyAutoConfigured() && !this.proxyConfiguration.getProxyBypassAddressList().contains(url.toExternalForm())) {
                    Properties props = System.getProperties();
                    props.setProperty("proxySet", "true");
                    props.setProperty("proxyHost", this.proxyConfiguration.getProxyManualConfigurationServer());
                    props.setProperty("proxyPort", Integer.toString(this.proxyConfiguration.getProxyManualConfigurationPort()));
                } else {
                    System.getProperties().setProperty("proxySet", "false");
                }
                logger.debug((Object)("URL: " + url.toExternalForm()));
                this.htmlTextPane.setWebPage(url);
            } else {
                this.htmlTextPane.setPage(url);
                this.htmlTextPane.insertLinks();
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
            String warning = e.getLocalizedMessage();
            logger.debug((Object)("warning: " + warning));
            warning = StringResources.formatString(StringResources.CANT_FIND_FILE, warning);
            this.htmlTextPane.setText(warning);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        if (this.browserState) {
            this.historyTracker.urlLoaded(url);
            logger.debug((Object)("history: " + this.historyTracker.toString()));
        }
    }

    public int getMode() {
        return this.htmlTextPane.getMode();
    }

    public void setMode(int theMode) {
        this.htmlTextPane.setMode(theMode);
    }

    public void zoom(boolean isZoomIn) {
        TextZoomer.zoom(this.htmlTextPane, isZoomIn);
    }

    public void resetZoom() {
    }

    public void setDragEnabled(boolean b) {
        this.htmlTextPane.setDragEnabled(b);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.htmlTextPane.addHyperlinkListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.htmlTextPane.setEnabled(enabled);
    }

    public synchronized void addKeyListener(KeyListener l) {
        this.htmlTextPane.addKeyListener(l);
    }

    public boolean isEnabled() {
        return this.htmlTextPane.isEnabled();
    }

    public int getCaretPosition() {
        return this.htmlTextPane.getCaretPosition();
    }

    public void setCaretPosition(int thePosition) {
        this.htmlTextPane.setCaretPosition(thePosition);
    }

    public void setEditable(boolean theEdit) {
        this.htmlTextPane.setEditable(theEdit);
    }

    public Document getDocument() {
        return this.htmlTextPane.getDocument();
    }

    public JTextComponent getTextComponent() {
        return this.htmlTextPane;
    }

    public void grabFocus() {
        this.htmlTextPane.grabFocus();
    }

    public boolean isBrowserState() {
        return this.browserState;
    }

    public void setBrowserState(boolean browserState) {
        this.browserState = browserState;
    }

    public boolean isJavascriptEnabled() {
        return false;
    }

    public void setJavascriptEnabled(boolean enabled) {
        logger.warn((Object)"this component does not support Javascript");
    }

    public void print(boolean showPrintSetupDialog) {
        throw new UnsupportedOperationException("this component does not support printing");
    }

    public boolean canGoBack() {
        return this.historyTracker.canGetPreviousUrl();
    }

    public boolean canGoForward() {
        return this.historyTracker.canGetNextUrl();
    }

    public void goBack() {
        this.setPage(this.historyTracker.getPreviousUrl());
    }

    public void goForward() {
        this.setPage(this.historyTracker.getNextUrl());
    }

    public void reload() {
        URL currentPage = this.historyTracker.getCurrentUrl();
        logger.debug((Object)("current page: " + currentPage));
        Document doc = this.htmlTextPane.getDocument();
        doc.putProperty("stream", null);
        this.setPage(currentPage);
    }

    public void setProxyConfiguration(ProxyConfiguration configuration) {
        this.proxyConfiguration = configuration;
    }

    public void setLoadPopupWindowInBrowser(boolean flag) {
    }

    public void enableImages(boolean enable) {
    }

    public void addTextComponentPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.htmlTextPane.addPropertyChangeListener(propertyName, listener);
    }

    public void release() {
    }

    public String getSelectedText() {
        return this.htmlTextPane.getSelectedText();
    }
}

