/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLTextComponent;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.InputAttributesChangeListener;
import com.appframework.components.htmleditor.InsertLinkDialog;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.textcomponent.EditableDocumentListener;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;

public class HTMLTextEditor
extends HTMLTextComponent {
    private static Logger logger = Logger.getLogger(HTMLTextEditor.class);
    protected JToolBar pnlHeader;
    private MVCController controller;
    private ToolBarToggleButton tbtnBold;
    private ToolBarToggleButton tbtnItalic;
    private ToolBarToggleButton tbtnUnderline;
    private JComboBox cmbFontNames;
    private JComboBox cmbFontSizes;
    private AbstractButton btnShowAlign;
    private AbstractButton btnInsertPopUp;
    protected AbstractButton btnUndo;
    protected AbstractButton btnRedo;
    private ActionUndo actionUndo;
    private ActionRedo actionRedo;
    private UndoManager undoManager;
    private UnderlineAction underlineAction;
    private boolean fontActionDisabled = false;
    private int oldPos = -1;

    public HTMLTextEditor(int theMode, DirtyStateManager theDirtyStateManager) {
        super(theDirtyStateManager);
        this.setEditable(true);
        this.setMode(theMode);
        this.setEnableShortCuts(true);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    public String getName() {
        return "HTMLTextEditor";
    }

    protected void buildUI() {
        super.buildUI();
        this.undoManager = new UndoManager();
        this.actionUndo = new ActionUndo();
        this.actionRedo = new ActionRedo();
        this.htmlTextPane.setEditableDocumentListener(new EditableDocumentListener(this.htmlTextPane, this.dirtyStateManager));
        this.htmlTextPane.setUndoableListener(new UndoChangeListener());
        this.htmlTextPane.addCaretListener(new CaretChangeListener());
        this.htmlTextPane.addInputAttributesChangeListener(new InputAttributesChangeListener(){

            public void stateChanged(ChangeEvent e) {
                HTMLTextPane editorHTMLTextPane = HTMLTextEditor.this.htmlTextPane;
                if (e.getSource() instanceof JTextPane && e.getSource().equals(editorHTMLTextPane)) {
                    MutableAttributeSet inputAttributes = editorHTMLTextPane.getInputAttributes();
                    HTMLTextEditor.this.selectFont(StyleConstants.getFontFamily(inputAttributes), StyleConstants.getFontSize(inputAttributes));
                    HTMLTextEditor.this.tbtnBold.setSelected(StyleConstants.isBold(inputAttributes));
                    HTMLTextEditor.this.tbtnItalic.setSelected(StyleConstants.isItalic(inputAttributes));
                    HTMLTextEditor.this.tbtnUnderline.setSelected(StyleConstants.isUnderline(inputAttributes));
                    HTMLTextEditor.this.updateButtons(editorHTMLTextPane.getCaretPosition());
                }
            }
        });
        KeyStroke ksUndo = KeyStroke.getKeyStroke(90, OS.getMetaKey());
        KeyStroke ksRedo = KeyStroke.getKeyStroke(90, OS.getMetaKey() | 0x40);
        this.htmlTextPane.registerKeyboardAction(this.actionUndo, ksUndo, 0);
        this.htmlTextPane.registerKeyboardAction(this.actionRedo, ksRedo, 0);
        this.buildHeaderPanel();
        this.add((Component)this.pnlHeader, "North");
    }

    private void buildHeaderPanel() {
        this.pnlHeader = new GWToolBar();
        this.pnlHeader.setLayout(new FlowLayout(3));
        this.pnlHeader.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.btnUndo = HTMLTextEditor.createButton(this.actionUndo, ImageResources.ACT_UNDO, null);
        this.pnlHeader.add(this.btnUndo);
        this.btnRedo = HTMLTextEditor.createButton(this.actionRedo, ImageResources.ACT_REDO, null);
        this.pnlHeader.add(this.btnRedo);
        this.pnlHeader.addSeparator();
        List<String> fontNames = Arrays.asList(UIUtils.getSystemFonts());
        this.cmbFontNames = new OrientableComboBox((Vector)new Vector<String>(fontNames));
        this.cmbFontNames.setSelectedItem(fontNames.get(0));
        this.cmbFontNames.setAction(new ActionFontName());
        this.cmbFontNames.addPopupMenuListener(new HTMLPopupMenuListener());
        this.cmbFontNames.addKeyListener(new FontNameKL());
        this.pnlHeader.add(this.cmbFontNames);
        this.cmbFontSizes = new OrientableComboBox(FontOptions.SIZES_HTML);
        this.cmbFontSizes.setAction(new ActionFontSize());
        this.cmbFontSizes.setSelectedItem(HTMLConstants.getDefaultFontSize(this.getMode()));
        this.cmbFontSizes.addPopupMenuListener(new HTMLPopupMenuListener());
        this.cmbFontSizes.addKeyListener(new FontNameKL());
        this.pnlHeader.add(this.cmbFontSizes);
        BoldAction boldAction = new BoldAction();
        this.tbtnBold = new ToolBarToggleButton(boldAction);
        this.tbtnBold.setSkinabilityEnabled(false);
        this.tbtnBold.setToolTipText(StringResources.BOLD);
        this.tbtnBold.setText("<html><body><b>" + StringResources.BOLD_BUTTON + "</b></body></html>");
        this.pnlHeader.add(this.tbtnBold);
        ItalicAction italicAction = new ItalicAction();
        this.tbtnItalic = new ToolBarToggleButton(italicAction);
        this.tbtnItalic.setSkinabilityEnabled(false);
        this.tbtnItalic.setText("<html><body><i>" + StringResources.ITALIC_BUTTON + "</i></body></html>");
        this.tbtnItalic.setToolTipText(StringResources.ITALIC);
        this.pnlHeader.add(this.tbtnItalic);
        this.underlineAction = new UnderlineAction();
        this.tbtnUnderline = new ToolBarToggleButton(this.underlineAction);
        this.tbtnUnderline.setSkinabilityEnabled(false);
        this.tbtnUnderline.setText("<html><body><u>" + StringResources.UNDERLINE_BUTTON + "</u></body></html>");
        this.pnlHeader.add(this.tbtnUnderline);
        this.tbtnUnderline.setToolTipText(StringResources.UNDERLINE);
        this.pnlHeader.addSeparator();
        AbstractButton btnForeground = HTMLTextEditor.createButton(new ActionForeground(), ImageResources.ACT_FONT_COLOR, StringResources.FONT_COLOR);
        this.pnlHeader.add(btnForeground);
        this.pnlHeader.addSeparator();
        AbstractAction emptyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.btnShowAlign = HTMLTextEditor.createButton(emptyAction, ImageResources.ACT_ALIGN_LEFT, StringResources.TEXT_ALIGNMENT);
        this.btnShowAlign.addMouseListener(new AlignmentPopupMouseListener());
        this.pnlHeader.add(this.btnShowAlign);
        this.pnlHeader.addSeparator();
        this.btnInsertPopUp = HTMLTextEditor.createButton(emptyAction, ImageResources.ACT_INSERT_POPUP, StringResources.INSERT_A_HORIZONTAL_LINE_OR_LINK);
        this.btnInsertPopUp.addMouseListener(new ActionInsertPopup());
        this.pnlHeader.add(this.btnInsertPopUp);
        this.pnlHeader.setFocusable(false);
    }

    public boolean isTextChangedByUser() {
        return this.htmlTextPane.isTextChangedByUser();
    }

    public void setTextChangedByUser(boolean isTextChangedByUser) {
        this.htmlTextPane.setTextChangedByUser(isTextChangedByUser);
    }

    private static AbstractButton createButton(Action theAction, Icon theIcon, String theToolTip) {
        ToolBarButton button = new ToolBarButton(theAction);
        if (theIcon != null) {
            button.setIcon(theIcon);
        }
        if (theToolTip != null) {
            ((JComponent)button).setToolTipText(theToolTip);
        }
        button.setFocusable(false);
        return button;
    }

    public void setHTMLButtonsEnabled(boolean isHTML) {
        if (this.btnInsertPopUp != null) {
            this.btnInsertPopUp.setEnabled(isHTML);
        }
        if (this.btnShowAlign != null) {
            this.btnShowAlign.setEnabled(isHTML);
        }
    }

    private MVCController getParentController() {
        Window window;
        if (this.controller == null && (window = SwingUtilities.getWindowAncestor(this)) instanceof FrameCompose) {
            this.controller = ((FrameCompose)window).getController();
        }
        return this.controller;
    }

    private void updateUndo() {
        if (this.undoManager.canUndo()) {
            this.actionUndo.setEnabled(true);
        } else {
            this.actionUndo.setEnabled(false);
        }
        if (this.undoManager.canRedo()) {
            this.actionRedo.setEnabled(true);
        } else {
            this.actionRedo.setEnabled(false);
        }
    }

    public void showHeaderPanel(boolean showPanel) {
        if (showPanel) {
            this.add((Component)this.pnlHeader, "North");
        } else {
            this.remove(this.pnlHeader);
        }
    }

    public void setHeaderBackground(Color theColor) {
        this.pnlHeader.setBackground(theColor);
        Component[] comp = this.pnlHeader.getComponents();
        int n = comp.length;
        for (int i = 0; i < n; ++i) {
            comp[i].setBackground(theColor);
        }
    }

    public void setHeaderForeground(Color theColor) {
        this.pnlHeader.setForeground(theColor);
        Component[] comp = this.pnlHeader.getComponents();
        int n = comp.length;
        for (int i = 0; i < n; ++i) {
            comp[i].setForeground(theColor);
        }
    }

    public void setHeaderBorder(Border theBorder) {
        this.pnlHeader.setBorder(theBorder);
        Component[] comp = this.pnlHeader.getComponents();
        int n = comp.length;
        for (int i = 0; i < n; ++i) {
            if (!(comp[i] instanceof JComponent)) continue;
            JComponent jc = (JComponent)comp[i];
            jc.setBorder(theBorder);
        }
        this.pnlHeader.updateUI();
    }

    public void setEnableShortCuts(boolean enable) {
        if (enable) {
            BoldAction boldAction = new BoldAction();
            this.htmlTextPane.getInputMap().put(KeyStroke.getKeyStroke(66, OS.getMetaKey(), false), "BoldAction");
            this.htmlTextPane.getActionMap().put("BoldAction", boldAction);
            StyledEditorKit.ItalicAction italicAction = new StyledEditorKit.ItalicAction();
            this.htmlTextPane.getInputMap().put(KeyStroke.getKeyStroke(73, OS.getMetaKey(), false), "ItalicAction");
            this.htmlTextPane.getActionMap().put("ItalicAction", italicAction);
            StyledEditorKit.UnderlineAction underlineAction = new StyledEditorKit.UnderlineAction();
            this.htmlTextPane.getInputMap().put(KeyStroke.getKeyStroke(85, OS.getMetaKey(), false), "UnderlineAction");
            this.htmlTextPane.getActionMap().put("UnderlineAction", underlineAction);
        } else {
            this.htmlTextPane.getActionMap().put("BoldAction", null);
            this.htmlTextPane.getActionMap().put("ItalicAction", null);
            this.htmlTextPane.getActionMap().put("UnderlineAction", null);
        }
    }

    public void setEnabled(boolean enabled) {
        int n = this.pnlHeader.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.pnlHeader.getComponent(i).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    private void updateButtons(int pos) {
        boolean underline;
        boolean italic;
        String fontName;
        if (pos == this.oldPos) {
            return;
        }
        this.oldPos = pos;
        if (!this.htmlTextPane.isEditable() || !this.htmlTextPane.isEnabled()) {
            return;
        }
        this.fontActionDisabled = true;
        StyledDocument styledDocument = (StyledDocument)this.htmlTextPane.getDocument();
        AttributeSet a = pos < styledDocument.getLength() ? styledDocument.getCharacterElement(pos).getAttributes() : this.htmlTextPane.getInputAttributes();
        String family = (String)a.getAttribute(StyleConstants.FontFamily);
        int fontSize = StyleConstants.getFontSize(a);
        if (family == null) {
            this.htmlTextPane.getDefaultFontName();
            fontName = this.getFont().getFamily();
        } else {
            fontName = new Font(family, 0, fontSize).getFamily();
        }
        this.selectFont(fontName, fontSize);
        boolean bold = StyleConstants.isBold(a);
        AttributeSet resolveParent = a.getResolveParent();
        if (resolveParent != null) {
            bold |= resolveParent.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.STRONG;
        }
        if (bold != this.tbtnBold.isSelected()) {
            this.tbtnBold.setSelected(bold);
        }
        if ((italic = StyleConstants.isItalic(a)) != this.tbtnItalic.isSelected()) {
            this.tbtnItalic.setSelected(italic);
        }
        if ((underline = StyleConstants.isUnderline(a)) != this.tbtnUnderline.isSelected()) {
            this.tbtnUnderline.setSelected(underline);
        }
        int al = StyleConstants.ParagraphConstants.getAlignment(a);
        switch (al) {
            case 0: {
                this.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_LEFT);
                break;
            }
            case 1: {
                this.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_CENTER);
                break;
            }
            case 2: {
                this.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_RIGHT);
            }
        }
        this.fontActionDisabled = false;
    }

    private void selectFont(String fontName, int fontSize) {
        Object selectedItem = this.cmbFontNames.getSelectedItem();
        if (!selectedItem.equals(fontName)) {
            this.cmbFontNames.setSelectedItem(fontName);
        }
        if (!(selectedItem = this.cmbFontSizes.getSelectedItem()).equals(fontSize)) {
            this.cmbFontSizes.setSelectedItem(fontSize);
        }
    }

    public void setDefaultFont() {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        int fontSize = this.htmlTextPane.getDefaultFontSize();
        StyleConstants.setFontSize(attr, fontSize);
        String fontName = this.htmlTextPane.getDefaultFontName();
        StyleConstants.setFontFamily(attr, fontName);
        this.htmlTextPane.setCharacterAttributes(attr, true);
        this.selectFont(fontName, fontSize);
    }

    private JFrame getApplicationFrame(Component component) {
        Container parent = component.getParent();
        if (parent instanceof JFrame) {
            return (JFrame)parent;
        }
        return this.getApplicationFrame(parent);
    }

    public void setMode(int newMode) {
        this.setMode(newMode, false);
    }

    public void setMode(int mode, boolean skipDocumentConversion) {
        int oldMode = this.getMode();
        String oldPlainText = this.getPlainText();
        int oldCaretPosition = this.htmlTextPane.getCaretPosition();
        Document oldDocument = this.getDocument();
        super.setMode(mode);
        this.dirtyStateManager.setDirty(this.dirtyStateManager.isDirty(), false);
        this.undoManager.discardAllEdits();
        this.updateUndo();
        this.setHTMLButtonsEnabled(mode == 1);
        int newMode = this.getMode();
        if (newMode != oldMode && (newMode == 1 || newMode == 2 || newMode == 3)) {
            if (oldPlainText.trim().length() != 0 && !skipDocumentConversion) {
                Document newDocument = this.getDocument();
                HTMLUtils.convertDocument(oldMode, oldDocument, newMode, newDocument, (StyledEditorKit)this.htmlTextPane.getEditorKit());
                this.htmlTextPane.setCaretPosition(oldCaretPosition);
            }
            DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(newMode == 1 ? FontOptions.SIZES_HTML : FontOptions.SIZES_PLAINTEXT);
            this.cmbFontSizes.setModel(model);
            this.oldPos = -1;
            this.updateButtons(this.htmlTextPane.getCaretPosition());
        }
    }

    public void setStyledText(String theHTMLPageText) {
        this.oldPos = -1;
        this.htmlTextPane.setStyledText(theHTMLPageText);
    }

    public JComponent getComponent() {
        return this.htmlTextPane;
    }

    public void makeNormal() {
        StyledEditorKit.StyledTextAction ba;
        if (this.fontActionDisabled) {
            return;
        }
        boolean bIsSelected = this.tbtnBold.isSelected();
        if (bIsSelected) {
            ba = new StyledEditorKit.BoldAction();
            ((StyledEditorKit.BoldAction)ba).actionPerformed(null);
            this.tbtnBold.getModel().setSelected(false);
        }
        if (bIsSelected = this.tbtnItalic.isSelected()) {
            ba = new StyledEditorKit.ItalicAction();
            ((StyledEditorKit.ItalicAction)ba).actionPerformed(null);
            this.tbtnItalic.getModel().setSelected(false);
        }
        if (bIsSelected = this.tbtnUnderline.isSelected()) {
            ba = new StyledEditorKit.UnderlineAction();
            ((StyledEditorKit.UnderlineAction)ba).actionPerformed(null);
            this.tbtnUnderline.getModel().setSelected(false);
        }
        if (!this.htmlTextPane.isFocusOwner()) {
            this.htmlTextPane.grabFocus();
        }
    }

    public void toggleBold() {
        if (this.fontActionDisabled) {
            return;
        }
        StyledEditorKit.BoldAction ba = new StyledEditorKit.BoldAction();
        ba.actionPerformed(null);
        boolean bIsSelected = this.tbtnBold.isSelected();
        this.tbtnBold.getModel().setSelected(!bIsSelected);
        if (!this.htmlTextPane.isFocusOwner()) {
            this.htmlTextPane.grabFocus();
        }
    }

    public void toggleItalic() {
        if (this.fontActionDisabled) {
            return;
        }
        StyledEditorKit.ItalicAction action = new StyledEditorKit.ItalicAction();
        action.actionPerformed(null);
        boolean bIsSelected = this.tbtnItalic.isSelected();
        this.tbtnItalic.getModel().setSelected(!bIsSelected);
        if (!this.htmlTextPane.isFocusOwner()) {
            this.htmlTextPane.grabFocus();
        }
    }

    public void toggleUnderline() {
        if (this.fontActionDisabled) {
            return;
        }
        StyledEditorKit.UnderlineAction action = new StyledEditorKit.UnderlineAction();
        action.actionPerformed(null);
        boolean bIsSelected = this.tbtnUnderline.isSelected();
        this.tbtnUnderline.getModel().setSelected(!bIsSelected);
        if (!this.htmlTextPane.isFocusOwner()) {
            this.htmlTextPane.grabFocus();
        }
    }

    public HTMLTextPane getHTMLTextPane() {
        return this.htmlTextPane;
    }

    private class HTMLPopupMenuListener
    implements PopupMenuListener {
        private HTMLPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            HTMLTextEditor.this.htmlTextPane.requestFocus();
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    class UndoChangeListener
    implements UndoableEditListener {
        UndoChangeListener() {
        }

        public void undoableEditHappened(UndoableEditEvent uee) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            editor.undoManager.addEdit(uee.getEdit());
            editor.updateUndo();
            HTMLTextEditor.this.getParentController().processCommand(new GlobalCommand(1910, editor.undoManager));
        }
    }

    class ActionInsertPopup
    extends MouseAdapter {
        ActionInsertPopup() {
        }

        public void mouseClicked(MouseEvent e) {
            Component c = (Component)e.getSource();
            if (!c.isEnabled()) {
                return;
            }
            GWPopupMenu pop = new GWPopupMenu();
            pop.add(OS.createMenuItemForAction(new ActionInsertLine(StringResources.INSERT_HORIZONTAL_LINE, ImageResources.ACT_INSERT_LINE)));
            pop.add(OS.createMenuItemForAction(new ActionInsertLink(StringResources.INSERT_HYPERLINK_TO_WEB_PAGE, ImageResources.ACT_LINK_HTML, false)));
            pop.add(OS.createMenuItemForAction(new ActionInsertLink(StringResources.INSERT_HYPERLINK_TO_EKMAIL, ImageResources.ACT_LINK_MAILTO, true)));
            pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class AlignmentPopupMouseListener
    extends MouseAdapter {
        AlignmentPopupMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Component c = (Component)e.getSource();
            if (!c.isEnabled()) {
                return;
            }
            GWPopupMenu pop = new GWPopupMenu();
            ((JPopupMenu)pop).add(new ActionAlignParagraph(StringResources.ALIGN_LEFT, ImageResources.ACT_ALIGN_LEFT, 0));
            ((JPopupMenu)pop).add(new ActionAlignParagraph(StringResources.ALIGN_CENTER, ImageResources.ACT_ALIGN_CENTER, 1));
            ((JPopupMenu)pop).add(new ActionAlignParagraph(StringResources.ALIGN_RIGHT, ImageResources.ACT_ALIGN_RIGHT, 2));
            pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class ActionAlignParagraph
    extends AbstractAction {
        StyledEditorKit.AlignmentAction alignAction;
        int type;

        public ActionAlignParagraph(String name, Icon icon, int type) {
            super(name, icon);
            this.alignAction = new StyledEditorKit.AlignmentAction(name, type);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            editor.htmlTextPane.grabFocus();
            e.setSource(editor.htmlTextPane);
            this.alignAction.actionPerformed(e);
            switch (this.type) {
                case 0: {
                    editor.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_LEFT);
                    break;
                }
                case 1: {
                    editor.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_CENTER);
                    break;
                }
                case 2: {
                    editor.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_RIGHT);
                }
            }
        }
    }

    class ActionInsertLink
    extends AbstractAction {
        boolean isMailto;

        public ActionInsertLink(String name, Icon icon, boolean theMailto) {
            super(name, icon);
            this.isMailto = false;
            this.isMailto = theMailto;
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            editor.htmlTextPane.grabFocus();
            e.setSource(editor.htmlTextPane);
            String selectedText = editor.htmlTextPane.getSelectedText();
            boolean selectionWasEmpty = selectedText == null || selectedText.equals("");
            int xStart = editor.htmlTextPane.getSelectionStart();
            int xEnd = -1;
            InsertLinkDialog dialog = null;
            dialog = this.isMailto ? new InsertLinkDialog(editor.getApplicationFrame(editor), true, InsertLinkDialog.MAILTO) : new InsertLinkDialog(editor.getApplicationFrame(editor), true);
            if (!selectionWasEmpty) {
                dialog.setLinkText(selectedText);
                xEnd = xStart + selectedText.length();
            }
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
            dialog.setVisible(true);
            if (!dialog.isActionCompleteSuccessfully()) {
                return;
            }
            AttributeSet a = ((HTMLDocument)editor.htmlTextPane.getDocument()).getCharacterElement(xStart).getAttributes();
            try {
                if (!selectionWasEmpty) {
                    editor.htmlTextPane.getDocument().remove(xStart, selectedText.length());
                }
                selectedText = dialog.getLinkText();
                xEnd = xStart + selectedText.length();
                editor.htmlTextPane.getDocument().insertString(xStart, selectedText + ' ', a);
            }
            catch (BadLocationException be) {
                logger.debug((Object)be);
            }
            SimpleAttributeSet htmlAttribs = new SimpleAttributeSet();
            htmlAttribs.addAttribute("href", dialog.getLink());
            SimpleAttributeSet insertedTagAttributes = new SimpleAttributeSet();
            insertedTagAttributes.addAttribute(HTML.Tag.A, htmlAttribs);
            insertedTagAttributes.addAttribute(StyleConstants.Foreground, Color.BLUE);
            insertedTagAttributes.addAttribute(StyleConstants.Italic, Boolean.TRUE);
            insertedTagAttributes.addAttribute(StyleConstants.Underline, Boolean.TRUE);
            editor.htmlTextPane.setSelectionStart(xStart);
            editor.htmlTextPane.setSelectionEnd(xEnd);
            editor.htmlTextPane.setCharacterAttributes(insertedTagAttributes, false);
            editor.htmlTextPane.select(xEnd + 1, xEnd + 1);
        }
    }

    private static class FontNameKL
    extends KeyAdapter {
        private FontNameKL() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                Action action = ((JComboBox)e.getSource()).getAction();
                action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "", 16));
            }
        }
    }

    class ActionInsertLine
    extends AbstractAction {
        private Hashtable actions;

        public ActionInsertLine(String name, Icon icon) {
            Action[] actionsArray;
            super(name, icon);
            this.actions = new Hashtable();
            HTMLTextEditor editor = HTMLTextEditor.this;
            for (Action a : actionsArray = editor.htmlTextPane.getActions()) {
                this.actions.put(a.getValue("Name"), a);
            }
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            editor.htmlTextPane.grabFocus();
            e.setSource(editor.htmlTextPane);
            ((Action)this.actions.get("InsertHR")).actionPerformed(e);
            editor.htmlTextPane.applyHTMLParagraphAttributes();
        }
    }

    class ActionRedo
    extends AbstractAction {
        ActionRedo() {
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            if (!editor.undoManager.canRedo()) {
                return;
            }
            try {
                editor.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                logger.debug((Object)ex);
            }
            editor.updateUndo();
        }
    }

    class ActionUndo
    extends AbstractAction {
        ActionUndo() {
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            if (!editor.undoManager.canUndo()) {
                return;
            }
            try {
                editor.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                logger.debug((Object)ex);
            }
            editor.updateUndo();
        }
    }

    class ActionFontSize
    extends StyledEditorKit.FontSizeAction {
        String name;

        public ActionFontSize() {
            super("", HTMLConstants.getDefaultFontSize(HTMLTextEditor.this.getMode()));
            this.name = "font size";
        }

        public void actionPerformed(ActionEvent e) {
            if ((long)e.getModifiers() == 16L) {
                HTMLTextEditor editor = HTMLTextEditor.this;
                if (editor.fontActionDisabled) {
                    return;
                }
                int size = (Integer)editor.cmbFontSizes.getSelectedItem();
                String fontName = (String)editor.cmbFontNames.getSelectedItem();
                new StyledEditorKit.FontSizeAction(this.name, size).actionPerformed(e);
                editor.htmlTextPane.setDefaultFont(fontName, size);
            }
        }
    }

    class ActionFontName
    extends StyledEditorKit.StyledTextAction {
        String name;

        public ActionFontName() {
            super("");
            this.name = "font face";
        }

        public void actionPerformed(ActionEvent e) {
            if ((long)e.getModifiers() == 16L) {
                HTMLTextEditor editor = HTMLTextEditor.this;
                if (editor.fontActionDisabled) {
                    return;
                }
                String fontName = (String)editor.cmbFontNames.getSelectedItem();
                int size = (Integer)editor.cmbFontSizes.getSelectedItem();
                new StyledEditorKit.FontFamilyAction(this.name, fontName).actionPerformed(e);
                editor.htmlTextPane.setDefaultFont(fontName, size);
            }
        }
    }

    class ActionForeground
    extends StyledEditorKit.StyledTextAction {
        String name;

        public ActionForeground() {
            super("");
            this.name = "foreground color";
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            if (editor.fontActionDisabled) {
                return;
            }
            if (!editor.htmlTextPane.isFocusOwner()) {
                editor.htmlTextPane.grabFocus();
            }
            e.setSource(editor.htmlTextPane);
            JColorChooser cc = new JColorChooser();
            cc.setVisible(true);
            Color color = JColorChooser.showDialog(editor, StringResources.FONT_COLOR, Color.black);
            if (color == null) {
                return;
            }
            new StyledEditorKit.ForegroundAction(this.name, color).actionPerformed(e);
        }
    }

    class UnderlineAction
    extends AbstractAction {
        StyledEditorKit.UnderlineAction ua = new StyledEditorKit.UnderlineAction();

        UnderlineAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            if (editor.fontActionDisabled) {
                return;
            }
            if (!editor.htmlTextPane.isFocusOwner()) {
                editor.htmlTextPane.grabFocus();
            }
            if (!(e.getSource() instanceof ToolBarToggleButton)) {
                boolean bIsSelected = HTMLTextEditor.this.tbtnUnderline.isSelected();
                HTMLTextEditor.this.tbtnUnderline.getModel().setSelected(!bIsSelected);
            }
            e.setSource(editor.htmlTextPane);
            this.ua.actionPerformed(e);
        }
    }

    class ItalicAction
    extends AbstractAction {
        StyledEditorKit.ItalicAction ia = new StyledEditorKit.ItalicAction();

        ItalicAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            if (editor.fontActionDisabled) {
                return;
            }
            if (!editor.htmlTextPane.isFocusOwner()) {
                editor.htmlTextPane.grabFocus();
            }
            if (!(e.getSource() instanceof ToolBarToggleButton)) {
                boolean bIsSelected = HTMLTextEditor.this.tbtnItalic.isSelected();
                HTMLTextEditor.this.tbtnItalic.getModel().setSelected(!bIsSelected);
            }
            e.setSource(editor.htmlTextPane);
            this.ia.actionPerformed(e);
        }
    }

    class BoldAction
    extends AbstractAction {
        StyledEditorKit.BoldAction ba = new StyledEditorKit.BoldAction();

        BoldAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HTMLTextEditor editor = HTMLTextEditor.this;
            if (editor.fontActionDisabled) {
                return;
            }
            if (!editor.htmlTextPane.isFocusOwner()) {
                editor.htmlTextPane.grabFocus();
            }
            if (!(e.getSource() instanceof ToolBarToggleButton)) {
                boolean bIsSelected = HTMLTextEditor.this.tbtnBold.isSelected();
                HTMLTextEditor.this.tbtnBold.getModel().setSelected(!bIsSelected);
            }
            e.setSource(editor.htmlTextPane);
            this.ba.actionPerformed(e);
        }
    }

    class CaretChangeListener
    implements CaretListener {
        CaretChangeListener() {
        }

        public void caretUpdate(CaretEvent e) {
            HTMLTextEditor.this.updateButtons(e.getDot());
        }
    }
}

